/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.responses.models;

import com.azure.ai.openai.responses.implementation.accesshelpers.CreateResponsesRequestAccessHelper;
import com.azure.ai.openai.responses.models.CreateResponsesRequestIncludable;
import com.azure.ai.openai.responses.models.CreateResponsesRequestModel;
import com.azure.ai.openai.responses.models.ResponseTextOptions;
import com.azure.ai.openai.responses.models.ResponseTruncation;
import com.azure.ai.openai.responses.models.ResponsesMessage;
import com.azure.ai.openai.responses.models.ResponsesReasoningConfiguration;
import com.azure.ai.openai.responses.models.ResponsesTool;
import com.azure.core.util.BinaryData;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CreateResponsesRequest
implements JsonSerializable<CreateResponsesRequest> {
    private final CreateResponsesRequestModel model;
    private Map<String, String> metadata;
    private Double temperature;
    private Double topP;
    private String previousResponseId;
    private ResponsesReasoningConfiguration reasoning;
    private Integer maxOutputTokens;
    private String instructions;
    private ResponseTextOptions text;
    private List<ResponsesTool> tools;
    private BinaryData toolChoice;
    private ResponseTruncation truncation;
    private String user;
    private final BinaryData input;
    private List<CreateResponsesRequestIncludable> include;
    private Boolean parallelToolCalls;
    private Boolean store;
    private Boolean stream;

    private CreateResponsesRequest(CreateResponsesRequestModel model, BinaryData input) {
        this.model = model;
        this.input = input;
    }

    public CreateResponsesRequest(CreateResponsesRequestModel model, String input) {
        this.model = model;
        this.input = BinaryData.fromString((String)input);
    }

    public CreateResponsesRequest(CreateResponsesRequestModel model, List<ResponsesMessage> input) {
        this.model = model;
        this.input = BinaryData.fromObject(input);
    }

    public CreateResponsesRequestModel getModel() {
        return this.model;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public CreateResponsesRequest setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Double getTemperature() {
        return this.temperature;
    }

    public CreateResponsesRequest setTemperature(Double temperature) {
        this.temperature = temperature;
        return this;
    }

    public Double getTopP() {
        return this.topP;
    }

    public CreateResponsesRequest setTopP(Double topP) {
        this.topP = topP;
        return this;
    }

    public String getPreviousResponseId() {
        return this.previousResponseId;
    }

    public CreateResponsesRequest setPreviousResponseId(String previousResponseId) {
        this.previousResponseId = previousResponseId;
        return this;
    }

    public ResponsesReasoningConfiguration getReasoning() {
        return this.reasoning;
    }

    public CreateResponsesRequest setReasoning(ResponsesReasoningConfiguration reasoning) {
        this.reasoning = reasoning;
        return this;
    }

    public Integer getMaxOutputTokens() {
        return this.maxOutputTokens;
    }

    public CreateResponsesRequest setMaxOutputTokens(Integer maxOutputTokens) {
        this.maxOutputTokens = maxOutputTokens;
        return this;
    }

    public String getInstructions() {
        return this.instructions;
    }

    public CreateResponsesRequest setInstructions(String instructions) {
        this.instructions = instructions;
        return this;
    }

    public ResponseTextOptions getText() {
        return this.text;
    }

    public CreateResponsesRequest setText(ResponseTextOptions text) {
        this.text = text;
        return this;
    }

    public List<ResponsesTool> getTools() {
        return this.tools;
    }

    public CreateResponsesRequest setTools(List<ResponsesTool> tools) {
        this.tools = tools;
        return this;
    }

    public BinaryData getToolChoice() {
        return this.toolChoice;
    }

    public CreateResponsesRequest setToolChoice(BinaryData toolChoice) {
        this.toolChoice = toolChoice;
        return this;
    }

    public ResponseTruncation getTruncation() {
        return this.truncation;
    }

    public CreateResponsesRequest setTruncation(ResponseTruncation truncation) {
        this.truncation = truncation;
        return this;
    }

    public String getUser() {
        return this.user;
    }

    public CreateResponsesRequest setUser(String user) {
        this.user = user;
        return this;
    }

    public BinaryData getInput() {
        return this.input;
    }

    public List<CreateResponsesRequestIncludable> getInclude() {
        return this.include;
    }

    public CreateResponsesRequest setInclude(List<CreateResponsesRequestIncludable> include) {
        this.include = include;
        return this;
    }

    public Boolean isParallelToolCalls() {
        return this.parallelToolCalls;
    }

    public CreateResponsesRequest setParallelToolCalls(Boolean parallelToolCalls) {
        this.parallelToolCalls = parallelToolCalls;
        return this;
    }

    public Boolean isStore() {
        return this.store;
    }

    public CreateResponsesRequest setStore(Boolean store) {
        this.store = store;
        return this;
    }

    public Boolean isStream() {
        return this.stream;
    }

    private CreateResponsesRequest setStream(Boolean stream) {
        this.stream = stream;
        return this;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("model", this.model == null ? null : this.model.toString());
        jsonWriter.writeFieldName("input");
        this.input.writeTo(jsonWriter);
        jsonWriter.writeMapField("metadata", this.metadata, (writer, element) -> writer.writeString(element));
        jsonWriter.writeNumberField("temperature", (Number)this.temperature);
        jsonWriter.writeNumberField("top_p", (Number)this.topP);
        jsonWriter.writeStringField("previous_response_id", this.previousResponseId);
        jsonWriter.writeJsonField("reasoning", (JsonSerializable)this.reasoning);
        jsonWriter.writeNumberField("max_output_tokens", (Number)this.maxOutputTokens);
        jsonWriter.writeStringField("instructions", this.instructions);
        jsonWriter.writeJsonField("text", (JsonSerializable)this.text);
        jsonWriter.writeArrayField("tools", this.tools, (writer, element) -> writer.writeJson((JsonSerializable)element));
        if (this.toolChoice != null) {
            jsonWriter.writeFieldName("tool_choice");
            this.toolChoice.writeTo(jsonWriter);
        }
        jsonWriter.writeStringField("truncation", this.truncation == null ? null : this.truncation.toString());
        jsonWriter.writeStringField("user", this.user);
        jsonWriter.writeArrayField("include", this.include, (writer, element) -> writer.writeString(element == null ? null : element.toString()));
        jsonWriter.writeBooleanField("parallel_tool_calls", this.parallelToolCalls);
        jsonWriter.writeBooleanField("store", this.store);
        jsonWriter.writeBooleanField("stream", this.stream);
        return jsonWriter.writeEndObject();
    }

    public static CreateResponsesRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateResponsesRequest)jsonReader.readObject(reader -> {
            CreateResponsesRequestModel model = null;
            BinaryData input = null;
            Map metadata = null;
            Double temperature = null;
            Double topP = null;
            String previousResponseId = null;
            ResponsesReasoningConfiguration reasoning = null;
            Integer maxOutputTokens = null;
            String instructions = null;
            ResponseTextOptions text = null;
            List tools = null;
            BinaryData toolChoice = null;
            ResponseTruncation truncation = null;
            String user = null;
            List include = null;
            Boolean parallelToolCalls = null;
            Boolean store = null;
            Boolean stream = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("model".equals(fieldName)) {
                    model = CreateResponsesRequestModel.fromString(reader.getString());
                    continue;
                }
                if ("input".equals(fieldName)) {
                    input = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("metadata".equals(fieldName)) {
                    metadata = reader.readMap(reader1 -> reader1.getString());
                    continue;
                }
                if ("temperature".equals(fieldName)) {
                    temperature = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("top_p".equals(fieldName)) {
                    topP = (Double)reader.getNullable(JsonReader::getDouble);
                    continue;
                }
                if ("previous_response_id".equals(fieldName)) {
                    previousResponseId = reader.getString();
                    continue;
                }
                if ("reasoning".equals(fieldName)) {
                    reasoning = ResponsesReasoningConfiguration.fromJson(reader);
                    continue;
                }
                if ("max_output_tokens".equals(fieldName)) {
                    maxOutputTokens = (Integer)reader.getNullable(JsonReader::getInt);
                    continue;
                }
                if ("instructions".equals(fieldName)) {
                    instructions = reader.getString();
                    continue;
                }
                if ("text".equals(fieldName)) {
                    text = ResponseTextOptions.fromJson(reader);
                    continue;
                }
                if ("tools".equals(fieldName)) {
                    tools = reader.readArray(reader1 -> ResponsesTool.fromJson(reader1));
                    continue;
                }
                if ("tool_choice".equals(fieldName)) {
                    toolChoice = (BinaryData)reader.getNullable(nonNullReader -> BinaryData.fromObject((Object)nonNullReader.readUntyped()));
                    continue;
                }
                if ("truncation".equals(fieldName)) {
                    truncation = ResponseTruncation.fromString(reader.getString());
                    continue;
                }
                if ("user".equals(fieldName)) {
                    user = reader.getString();
                    continue;
                }
                if ("include".equals(fieldName)) {
                    include = reader.readArray(reader1 -> CreateResponsesRequestIncludable.fromString(reader1.getString()));
                    continue;
                }
                if ("parallel_tool_calls".equals(fieldName)) {
                    parallelToolCalls = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("store".equals(fieldName)) {
                    store = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                if ("stream".equals(fieldName)) {
                    stream = (Boolean)reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            CreateResponsesRequest deserializedCreateResponsesRequest = new CreateResponsesRequest(model, input);
            deserializedCreateResponsesRequest.metadata = metadata;
            deserializedCreateResponsesRequest.temperature = temperature;
            deserializedCreateResponsesRequest.topP = topP;
            deserializedCreateResponsesRequest.previousResponseId = previousResponseId;
            deserializedCreateResponsesRequest.reasoning = reasoning;
            deserializedCreateResponsesRequest.maxOutputTokens = maxOutputTokens;
            deserializedCreateResponsesRequest.instructions = instructions;
            deserializedCreateResponsesRequest.text = text;
            deserializedCreateResponsesRequest.tools = tools;
            deserializedCreateResponsesRequest.toolChoice = toolChoice;
            deserializedCreateResponsesRequest.truncation = truncation;
            deserializedCreateResponsesRequest.user = user;
            deserializedCreateResponsesRequest.include = include;
            deserializedCreateResponsesRequest.parallelToolCalls = parallelToolCalls;
            deserializedCreateResponsesRequest.store = store;
            deserializedCreateResponsesRequest.stream = stream;
            return deserializedCreateResponsesRequest;
        });
    }

    static {
        CreateResponsesRequestAccessHelper.setAccessor(new CreateResponsesRequestAccessHelper.CreateResponsesRequestAccessor(){

            @Override
            public void setStream(CreateResponsesRequest options, boolean stream) {
                options.setStream(stream);
            }
        });
    }
}

