/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.CreateUploadRequestPurpose;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class CreateUploadRequest
implements JsonSerializable<CreateUploadRequest> {
    private final String filename;
    private final CreateUploadRequestPurpose purpose;
    private final int bytes;
    private final String mimeType;

    public CreateUploadRequest(String filename, CreateUploadRequestPurpose purpose, int bytes, String mimeType) {
        this.filename = filename;
        this.purpose = purpose;
        this.bytes = bytes;
        this.mimeType = mimeType;
    }

    public String getFilename() {
        return this.filename;
    }

    public CreateUploadRequestPurpose getPurpose() {
        return this.purpose;
    }

    public int getBytes() {
        return this.bytes;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("filename", this.filename);
        jsonWriter.writeStringField("purpose", this.purpose == null ? null : this.purpose.toString());
        jsonWriter.writeIntField("bytes", this.bytes);
        jsonWriter.writeStringField("mime_type", this.mimeType);
        return jsonWriter.writeEndObject();
    }

    public static CreateUploadRequest fromJson(JsonReader jsonReader) throws IOException {
        return (CreateUploadRequest)jsonReader.readObject(reader -> {
            String filename = null;
            CreateUploadRequestPurpose purpose = null;
            int bytes = 0;
            String mimeType = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("filename".equals(fieldName)) {
                    filename = reader.getString();
                    continue;
                }
                if ("purpose".equals(fieldName)) {
                    purpose = CreateUploadRequestPurpose.fromString(reader.getString());
                    continue;
                }
                if ("bytes".equals(fieldName)) {
                    bytes = reader.getInt();
                    continue;
                }
                if ("mime_type".equals(fieldName)) {
                    mimeType = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            return new CreateUploadRequest(filename, purpose, bytes, mimeType);
        });
    }
}

