/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public final class CompletionsLogProbabilityModel
implements JsonSerializable<CompletionsLogProbabilityModel> {
    private final List<String> tokens;
    private final List<Double> tokenLogProbabilities;
    private final List<Map<String, Double>> topLogProbabilities;
    private final List<Integer> textOffsets;

    private CompletionsLogProbabilityModel(List<String> tokens, List<Double> tokenLogProbabilities, List<Map<String, Double>> topLogProbabilities, List<Integer> textOffsets) {
        this.tokens = tokens;
        this.tokenLogProbabilities = tokenLogProbabilities;
        this.topLogProbabilities = topLogProbabilities;
        this.textOffsets = textOffsets;
    }

    public List<String> getTokens() {
        return this.tokens;
    }

    public List<Double> getTokenLogProbabilities() {
        return this.tokenLogProbabilities;
    }

    public List<Map<String, Double>> getTopLogProbabilities() {
        return this.topLogProbabilities;
    }

    public List<Integer> getTextOffsets() {
        return this.textOffsets;
    }

    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeArrayField("tokens", this.tokens, (writer, element) -> writer.writeString(element));
        jsonWriter.writeArrayField("token_logprobs", this.tokenLogProbabilities, (writer, element) -> writer.writeDouble(element.doubleValue()));
        jsonWriter.writeArrayField("top_logprobs", this.topLogProbabilities, (writer, element) -> writer.writeMap(element, (writer1, element1) -> writer1.writeNumber((Number)element1)));
        jsonWriter.writeArrayField("text_offset", this.textOffsets, (writer, element) -> writer.writeInt(element.intValue()));
        return jsonWriter.writeEndObject();
    }

    public static CompletionsLogProbabilityModel fromJson(JsonReader jsonReader) throws IOException {
        return (CompletionsLogProbabilityModel)jsonReader.readObject(reader -> {
            List tokens = null;
            List tokenLogProbabilities = null;
            List topLogProbabilities = null;
            List textOffsets = null;
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("tokens".equals(fieldName)) {
                    tokens = reader.readArray(reader1 -> reader1.getString());
                    continue;
                }
                if ("token_logprobs".equals(fieldName)) {
                    tokenLogProbabilities = reader.readArray(reader1 -> reader1.getDouble());
                    continue;
                }
                if ("top_logprobs".equals(fieldName)) {
                    topLogProbabilities = reader.readArray(reader1 -> reader1.readMap(reader2 -> (Double)reader2.getNullable(JsonReader::getDouble)));
                    continue;
                }
                if ("text_offset".equals(fieldName)) {
                    textOffsets = reader.readArray(reader1 -> reader1.getInt());
                    continue;
                }
                reader.skipChildren();
            }
            return new CompletionsLogProbabilityModel(tokens, tokenLogProbabilities, topLogProbabilities, textOffsets);
        });
    }
}

