/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.models;

import com.azure.ai.openai.models.ChatMessageContentItem;
import com.azure.ai.openai.models.InputAudioContent;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class ChatMessageAudioContentItem
extends ChatMessageContentItem {
    private String type = "input_audio";
    private final InputAudioContent inputAudio;

    public ChatMessageAudioContentItem(InputAudioContent inputAudio) {
        this.inputAudio = inputAudio;
    }

    @Override
    public String getType() {
        return this.type;
    }

    public InputAudioContent getInputAudio() {
        return this.inputAudio;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeJsonField("input_audio", (JsonSerializable)this.inputAudio);
        jsonWriter.writeStringField("type", this.type);
        return jsonWriter.writeEndObject();
    }

    public static ChatMessageAudioContentItem fromJson(JsonReader jsonReader) throws IOException {
        return (ChatMessageAudioContentItem)jsonReader.readObject(reader -> {
            InputAudioContent inputAudio = null;
            String type = "input_audio";
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("input_audio".equals(fieldName)) {
                    inputAudio = InputAudioContent.fromJson(reader);
                    continue;
                }
                if ("type".equals(fieldName)) {
                    type = reader.getString();
                    continue;
                }
                reader.skipChildren();
            }
            ChatMessageAudioContentItem deserializedChatMessageAudioContentItem = new ChatMessageAudioContentItem(inputAudio);
            deserializedChatMessageAudioContentItem.type = type;
            return deserializedChatMessageAudioContentItem;
        });
    }
}

