/*
 * Decompiled with CFR 0.152.
 */
package com.azure.ai.openai.implementation;

import com.azure.core.util.serializer.JsonSerializer;
import com.azure.core.util.serializer.JsonSerializerProviders;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonProviders;
import com.azure.json.JsonReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import reactor.core.publisher.Flux;
import reactor.core.scheduler.Schedulers;

public final class OpenAIServerSentEvents<T> {
    private static final List<String> STREAM_COMPLETION_EVENT = Arrays.asList("data: [DONE]", "data:[DONE]");
    private final Flux<ByteBuffer> source;
    private final Class<T> type;
    private ByteArrayOutputStream outStream;
    private static final JsonSerializer SERIALIZER = JsonSerializerProviders.createInstance((boolean)true);

    public OpenAIServerSentEvents(Flux<ByteBuffer> source, Class<T> type) {
        this.source = source;
        this.type = type;
        this.outStream = new ByteArrayOutputStream();
    }

    public Flux<T> getEvents() {
        return this.mapByteBuffersToEvents();
    }

    private Flux<T> mapByteBuffersToEvents() {
        return this.source.publishOn(Schedulers.boundedElastic()).concatMap(byteBuffer -> {
            byte[] byteArray;
            ArrayList values = new ArrayList();
            for (byte currentByte : byteArray = byteBuffer.array()) {
                if (currentByte == 10 || currentByte == 13) {
                    try {
                        this.handleCurrentLine(this.outStream.toString(StandardCharsets.UTF_8.name()), values);
                    }
                    catch (UncheckedIOException | UnsupportedEncodingException e) {
                        return Flux.error((Throwable)e);
                    }
                    this.outStream = new ByteArrayOutputStream();
                    continue;
                }
                this.outStream.write(currentByte);
            }
            try {
                this.handleCurrentLine(this.outStream.toString(StandardCharsets.UTF_8.name()), values);
                this.outStream = new ByteArrayOutputStream();
            }
            catch (UncheckedIOException | IllegalStateException e) {
                return Flux.fromIterable(values);
            }
            catch (UnsupportedEncodingException e) {
                return Flux.error((Throwable)e);
            }
            return Flux.fromIterable(values);
        }).cache();
    }

    private void handleCurrentLine(String currentLine, List<T> values) throws UncheckedIOException {
        if (currentLine.isEmpty() || STREAM_COMPLETION_EVENT.contains(currentLine)) {
            return;
        }
        String[] split = currentLine.split(":", 2);
        if (split.length != 2) {
            throw new IllegalStateException("Invalid data format " + currentLine);
        }
        String dataValue = split[1];
        if (split[1].startsWith(" ")) {
            dataValue = split[1].substring(1);
        }
        if (!OpenAIServerSentEvents.isValidJson(dataValue)) {
            throw new IllegalStateException("Invalid Json format " + dataValue);
        }
        Object value = SERIALIZER.deserializeFromBytes(dataValue.getBytes(StandardCharsets.UTF_8), TypeReference.createInstance(this.type));
        if (value == null) {
            throw new IllegalStateException("Failed to deserialize the data value " + dataValue);
        }
        values.add(value);
    }

    private static boolean isValidJson(String jsonString) {
        boolean bl;
        block8: {
            JsonReader jsonReader = JsonProviders.createReader((String)jsonString);
            try {
                jsonReader.readUntyped();
                bl = true;
                if (jsonReader == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (jsonReader != null) {
                        try {
                            jsonReader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException ignored) {
                    return false;
                }
            }
            jsonReader.close();
        }
        return bl;
    }
}

