/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.utils;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.google.common.collect.Table;
import java.util.AbstractMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ImmutableCollectors {
    public static <E> ImmutableListCollector<E> toList() {
        return new ImmutableListCollector();
    }

    public static <E> ImmutableSetCollector<E> toSet() {
        return new ImmutableSetCollector();
    }

    public static <E> ImmutableMultisetCollector<E> toMultiset() {
        return new ImmutableMultisetCollector();
    }

    public static <T, K, U> Collector<T, ?, ImmutableMap<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(ImmutableMap::builder, (builder, e) -> builder.put(keyMapper.apply(e), valueMapper.apply(e)), (builder1, builder2) -> builder1.putAll((Map)builder2.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, U> Collector<T, ?, ImmutableMap<K, U>> toMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collector.of(Maps::newHashMap, (m, e) -> m.merge(keyMapper.apply(e), valueMapper.apply(e), mergeFunction), ImmutableCollectors.mapMerger(mergeFunction), ImmutableMap::copyOf, Collector.Characteristics.UNORDERED);
    }

    private static <K, U> BinaryOperator<Map<K, U>> mapMerger(BinaryOperator<U> mergeFunction) {
        return (m1, m2) -> {
            for (Map.Entry e : m2.entrySet()) {
                m1.merge(e.getKey(), e.getValue(), mergeFunction);
            }
            return m1;
        };
    }

    public static <T extends Map.Entry<K, U>, K, U> Collector<T, ?, ImmutableMap<K, U>> toMap() {
        return Collector.of(ImmutableMap::builder, ImmutableMap.Builder::put, (builder1, builder2) -> builder1.putAll((Map)builder2.build()), ImmutableMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, U> Collector<T, ?, ImmutableBiMap<K, U>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(ImmutableBiMap::builder, (builder, e) -> builder.put(keyMapper.apply(e), valueMapper.apply(e)), (builder1, builder2) -> builder1.putAll((Map)builder2.build()), ImmutableBiMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, U> Collector<T, ?, ImmutableBiMap<K, U>> toBiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper, BinaryOperator<U> mergeFunction) {
        return Collector.of(Maps::newHashMap, (m, e) -> m.merge(keyMapper.apply(e), valueMapper.apply(e), mergeFunction), ImmutableCollectors.mapMerger(mergeFunction), ImmutableBiMap::copyOf, Collector.Characteristics.UNORDERED);
    }

    public static <T extends Map.Entry<K, U>, K, U> Collector<T, ?, ImmutableBiMap<K, U>> toBiMap() {
        return Collector.of(ImmutableBiMap::builder, ImmutableBiMap.Builder::put, (builder1, builder2) -> builder1.putAll((Map)builder2.build()), ImmutableBiMap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T extends Table.Cell<R, C, U>, R, C, U> Collector<T, ?, ImmutableTable<R, C, U>> toTable() {
        return Collector.of(ImmutableTable::builder, ImmutableTable.Builder::put, (builder1, builder2) -> builder1.putAll((Table)builder2.build()), ImmutableTable.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T, K, U> Collector<T, ?, ImmutableMultimap<K, U>> toMultimap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collector.of(ImmutableMultimap::builder, (builder, e) -> builder.put(keyMapper.apply(e), valueMapper.apply(e)), (builder1, builder2) -> builder1.putAll((Multimap)builder2.build()), ImmutableMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T extends Map.Entry<K, U>, K, U> Collector<T, ?, ImmutableMultimap<K, U>> toMultimap() {
        return Collector.of(ImmutableMultimap::builder, ImmutableMultimap.Builder::put, (builder1, builder2) -> builder1.putAll((Multimap)builder2.build()), ImmutableMultimap.Builder::build, Collector.Characteristics.UNORDERED);
    }

    public static <T> Collector<T, ?, ImmutableMap<Boolean, ImmutableList<T>>> partitioningBy(Predicate<? super T> predicate) {
        return ImmutableCollectors.partitioningBy(predicate, ImmutableCollectors.toList());
    }

    public static <T, A, D> Collector<T, ?, ImmutableMap<Boolean, D>> partitioningBy(Predicate<? super T> predicate, Collector<T, A, D> innerCollector) {
        Supplier<Partition> supplier = () -> new Partition(innerCollector.supplier().get(), innerCollector.supplier().get());
        BiConsumer downstreamAccumulator = innerCollector.accumulator();
        BiConsumer<Partition, Object> accumulator = (result, t) -> downstreamAccumulator.accept(predicate.test(t) ? result.forTrue : result.forFalse, t);
        BinaryOperator op = innerCollector.combiner();
        BinaryOperator combiner = (left, right) -> new Partition(op.apply(left.forTrue, right.forTrue), op.apply(left.forFalse, right.forFalse));
        Function<Partition, ImmutableMap> finisher = par -> ImmutableMap.of((Object)true, innerCollector.finisher().apply(par.forTrue), (Object)false, innerCollector.finisher().apply(par.forFalse));
        return Collector.of(supplier, accumulator, combiner, finisher, Collector.Characteristics.UNORDERED);
    }

    private static final class Partition<T>
    extends AbstractMap<Boolean, T>
    implements Map<Boolean, T> {
        final T forTrue;
        final T forFalse;

        Partition(T forTrue, T forFalse) {
            this.forTrue = forTrue;
            this.forFalse = forFalse;
        }

        @Override
        public Set<Map.Entry<Boolean, T>> entrySet() {
            return ImmutableSet.of(new AbstractMap.SimpleImmutableEntry<Boolean, T>(false, this.forFalse), new AbstractMap.SimpleImmutableEntry<Boolean, T>(true, this.forTrue));
        }
    }

    private static class ImmutableListCollector<T>
    extends ImmutableCollectionCollector<T, ImmutableList.Builder<T>, ImmutableList<T>> {
        private ImmutableListCollector() {
        }

        @Override
        public Supplier<ImmutableList.Builder<T>> supplier() {
            return ImmutableList::builder;
        }
    }

    private static class ImmutableMultisetCollector<T>
    extends ImmutableCollectionCollector<T, ImmutableMultiset.Builder<T>, ImmutableMultiset<T>> {
        private ImmutableMultisetCollector() {
        }

        @Override
        public Supplier<ImmutableMultiset.Builder<T>> supplier() {
            return ImmutableMultiset::builder;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED});
        }
    }

    private static class ImmutableSetCollector<T>
    extends ImmutableCollectionCollector<T, ImmutableSet.Builder<T>, ImmutableSet<T>> {
        private ImmutableSetCollector() {
        }

        @Override
        public Supplier<ImmutableSet.Builder<T>> supplier() {
            return ImmutableSet::builder;
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT, Collector.Characteristics.UNORDERED});
        }
    }

    private static abstract class ImmutableCollectionCollector<T, A extends ImmutableCollection.Builder<T>, R extends ImmutableCollection<T>>
    implements Collector<T, A, R> {
        private ImmutableCollectionCollector() {
        }

        @Override
        public BiConsumer<A, T> accumulator() {
            return ImmutableCollection.Builder::add;
        }

        @Override
        public BinaryOperator<A> combiner() {
            return (c1, c2) -> c1.addAll((Iterator)c2.build().iterator());
        }

        @Override
        public Function<A, R> finisher() {
            return bl -> bl.build();
        }

        @Override
        public Set<Collector.Characteristics> characteristics() {
            return Sets.newHashSet((Object[])new Collector.Characteristics[]{Collector.Characteristics.CONCURRENT});
        }
    }
}

