/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.substitution;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonConstantTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionBasicOperations;
import it.unibz.inf.ontop.substitution.SubstitutionOperations;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;

public interface SubstitutionFactory {
    public <T extends ImmutableTerm> Collector<Map.Entry<Variable, ? extends T>, ?, Substitution<T>> toSubstitution();

    public <T extends ImmutableTerm> Collector<Variable, ?, Substitution<T>> toSubstitution(Function<Variable, ? extends T> var1);

    public Collector<Variable, ?, InjectiveSubstitution<Variable>> toFreshRenamingSubstitution(VariableGenerator var1);

    public <T extends ImmutableTerm, U> Collector<U, ?, Substitution<T>> toSubstitution(Function<U, Variable> var1, Function<U, ? extends T> var2);

    public <T extends ImmutableTerm> Collector<Map.Entry<Variable, ? extends T>, ?, Substitution<T>> toSubstitutionSkippingIdentityEntries();

    public <T extends ImmutableTerm, U> Collector<U, ?, Substitution<T>> toSubstitutionSkippingIdentityEntries(Function<U, Variable> var1, Function<U, ? extends T> var2);

    public <T extends ImmutableTerm> Substitution<T> getSubstitution();

    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable var1, T var2);

    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable var1, T var2, Variable var3, T var4);

    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable var1, T var2, Variable var3, T var4, Variable var5, T var6);

    public <T extends ImmutableTerm> Substitution<T> getSubstitution(Variable var1, T var2, Variable var3, T var4, Variable var5, T var6, Variable var7, T var8);

    public <T extends ImmutableTerm> Substitution<T> getSubstitution(ImmutableList<Variable> var1, ImmutableList<? extends T> var2);

    public <T extends ImmutableTerm, U, E extends Throwable> Substitution<T> getSubstitutionThrowsExceptions(Collection<U> var1, Function<U, Variable> var2, FunctionThrowsExceptions<U, T, E> var3) throws E;

    public InjectiveSubstitution<Variable> extractAnInjectiveVar2VarSubstitutionFromInverseOf(Substitution<Variable> var1);

    public InjectiveSubstitution<Variable> generateNotConflictingRenaming(VariableGenerator var1, ImmutableSet<Variable> var2);

    default public Substitution<ImmutableTerm> rename(InjectiveSubstitution<Variable> renaming, Substitution<?> substitution) {
        return this.onImmutableTerms().rename(renaming, substitution);
    }

    default public Variable apply(Substitution<Variable> substitution, Variable var) {
        return this.onVariables().apply(substitution, var);
    }

    default public ImmutableList<Variable> apply(Substitution<Variable> substitution, ImmutableList<Variable> list) {
        return this.onVariables().apply(substitution, list);
    }

    default public ImmutableSet<Variable> apply(Substitution<Variable> substitution, ImmutableSet<Variable> set) {
        return this.onVariables().apply(substitution, set);
    }

    public <T extends ImmutableTerm> Substitution<T> union(Substitution<? extends T> var1, Substitution<? extends T> var2);

    public <T extends ImmutableTerm> Substitution<T> covariantCast(Substitution<? extends T> var1);

    default public Optional<Substitution<ImmutableTerm>> unify(ImmutableTerm t1, ImmutableTerm t2) {
        return this.onImmutableTerms().unify(t1, t2);
    }

    public InjectiveSubstitution<Variable> getPrioritizingRenaming(Substitution<?> var1, ImmutableSet<Variable> var2);

    public SubstitutionOperations<NonFunctionalTerm> onNonFunctionalTerms();

    public SubstitutionOperations<VariableOrGroundTerm> onVariableOrGroundTerms();

    public SubstitutionOperations<Variable> onVariables();

    public SubstitutionBasicOperations<NonGroundTerm> onNonGroundTerms();

    public SubstitutionBasicOperations<NonConstantTerm> onNonConstantTerms();

    public SubstitutionOperations<ImmutableTerm> onImmutableTerms();

    public SubstitutionBasicOperations<NonVariableTerm> onNonVariableTerms();

    public SubstitutionBasicOperations<ImmutableFunctionalTerm> onImmutableFunctionalTerms();

    @FunctionalInterface
    public static interface FunctionThrowsExceptions<U, T, E extends Throwable> {
        public T apply(U var1) throws E;
    }
}

