/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.lexical;

import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.lexical.LexicalSpace;
import java.util.Optional;
import java.util.regex.Pattern;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;

public class DefaultLexicalSpaces {
    private static final Pattern UUID_PATTERN = Pattern.compile("^[0-9a-fA-F]{8}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{4}\\b-[0-9a-fA-F]{12}$");

    public static LexicalSpace getDefaultSpace(DBTermType.Category category) {
        switch (category) {
            case STRING: {
                return DefaultLexicalSpaces::everything;
            }
            case INTEGER: {
                return DefaultLexicalSpaces::isValidInteger;
            }
            case DECIMAL: {
                return DefaultLexicalSpaces::isValidDecimal;
            }
            case FLOAT_DOUBLE: {
                return DefaultLexicalSpaces::isValidDouble;
            }
            case UUID: {
                return DefaultLexicalSpaces::isValidUUID;
            }
        }
        return DefaultLexicalSpaces::unknown;
    }

    public static Optional<Boolean> everything(String lexicalValue) {
        return Optional.of(true);
    }

    public static Optional<Boolean> isValidInteger(String lexicalValue) {
        return Optional.of(XMLDatatypeUtil.isValidInteger((String)lexicalValue));
    }

    public static Optional<Boolean> isValidDecimal(String lexicalValue) {
        if (XMLDatatypeUtil.isValidDecimal((String)lexicalValue)) {
            return Optional.of(true);
        }
        if (XMLDatatypeUtil.isValidDouble((String)lexicalValue)) {
            return Optional.empty();
        }
        return Optional.of(false);
    }

    public static Optional<Boolean> isValidDouble(String lexicalValue) {
        return Optional.of(XMLDatatypeUtil.isValidDouble((String)lexicalValue));
    }

    public static Optional<Boolean> isValidUUID(String lexicalValue) {
        return Optional.of(UUID_PATTERN.matcher(lexicalValue).matches());
    }

    public static Optional<Boolean> unknown(String lexicalValue) {
        return Optional.empty();
    }
}

