/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.type.impl;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeAncestry;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.type.impl.NonStringNonNumberNonBooleanNonDatetimeDBTermType;
import it.unibz.inf.ontop.model.type.impl.NumberDBTermType;
import it.unibz.inf.ontop.model.type.impl.UUIDDBTermType;
import java.util.Optional;

public class MockupDBTypeFactory
implements DBTypeFactory {
    private final NonStringNonNumberNonBooleanNonDatetimeDBTermType rootDBType;
    private final TypeFactory typeFactory;
    private final TermTypeAncestry rootAncestry;

    @AssistedInject
    private MockupDBTypeFactory(@Assisted TermType rootTermType, @Assisted TypeFactory typeFactory) {
        this.rootDBType = new NonStringNonNumberNonBooleanNonDatetimeDBTermType("AbstractDBType", rootTermType.getAncestry(), true);
        this.typeFactory = typeFactory;
        this.rootAncestry = this.rootDBType.getAncestry();
    }

    @Override
    public DBTermType getDBStringType() {
        return this.getDBTermType("STRING");
    }

    @Override
    public DBTermType getDBLargeIntegerType() {
        return new NumberDBTermType("LARGE_INT", this.rootAncestry, this.typeFactory.getXsdIntegerDatatype(), DBTermType.Category.INTEGER);
    }

    @Override
    public DBTermType getDBDecimalType() {
        return this.getDBTermType("DEC");
    }

    @Override
    public DBTermType getDBBooleanType() {
        return this.getDBTermType("BOOL");
    }

    @Override
    public DBTermType getDBDateType() {
        return this.getDBTermType("DATE");
    }

    @Override
    public DBTermType getDBTimeType() {
        return this.getDBTermType("TIME");
    }

    @Override
    public DBTermType getDBDateTimestampType() {
        return this.getDBTermType("TIMESTAMP");
    }

    @Override
    public DBTermType getDBDoubleType() {
        return this.getDBTermType("DOUBLE");
    }

    @Override
    public DBTermType getDBGeometryType() {
        return this.getDBTermType("GEOMETRY");
    }

    @Override
    public DBTermType getDBGeographyType() {
        return this.getDBTermType("GEOGRAPHY");
    }

    @Override
    public boolean supportsDBGeometryType() {
        return false;
    }

    @Override
    public boolean supportsDBGeographyType() {
        return false;
    }

    @Override
    public boolean supportsDBDistanceSphere() {
        return false;
    }

    @Override
    public boolean supportsJson() {
        return false;
    }

    @Override
    public boolean supportsArrayType() {
        return false;
    }

    @Override
    public DBTermType getDBHexBinaryType() {
        return this.getDBTermType("HEXBINARY");
    }

    @Override
    public DBTermType getDBArrayType() {
        return this.getDBTermType("ARRAY");
    }

    @Override
    public DBTermType getDBArrayType(DBTermType baseType) {
        return this.getDBArrayType();
    }

    @Override
    public DBTermType getDBJsonType() {
        throw new UnsupportedOperationException("No JSON datatype supported");
    }

    @Override
    public DBTermType getAbstractRootDBType() {
        return this.rootDBType;
    }

    @Override
    public DBTermType getDBTermType(String typeName) {
        switch (typeName) {
            case "UUID": {
                return new UUIDDBTermType("UUID", this.rootAncestry, this.typeFactory.getXsdStringDatatype());
            }
        }
        return new NonStringNonNumberNonBooleanNonDatetimeDBTermType(typeName, this.rootAncestry, false);
    }

    @Override
    public DBTermType getDBTermType(String typeName, int columnSize) {
        return new NonStringNonNumberNonBooleanNonDatetimeDBTermType(typeName, this.rootAncestry, false);
    }

    @Override
    public String getDBTrueLexicalValue() {
        return "TRUE";
    }

    @Override
    public String getDBFalseLexicalValue() {
        return "FALSE";
    }

    @Override
    public String getNullLexicalValue() {
        return "NULL";
    }

    @Override
    public Optional<String> getDBNaNLexicalValue() {
        return Optional.of("NaN");
    }
}

