/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBMathBinaryOperator;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.FunctionSymbolFactoryImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.AbstractGeofDoubleFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.DistanceUnit;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeoUtils;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.WKTLiteralValue;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.TermType;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.apache.commons.rdf.api.IRI;

public class GeofDistanceFunctionSymbolImpl
extends AbstractGeofDoubleFunctionSymbolImpl {
    protected final FunctionSymbolFactory functionSymbolFactory;

    public GeofDistanceFunctionSymbolImpl(@Nonnull IRI functionIRI, RDFDatatype wktLiteralType, ObjectRDFType iriType, RDFDatatype xsdDoubleType, FunctionSymbolFactoryImpl functionSymbolFactory) {
        super("GEOF_DISTANCE", functionIRI, (ImmutableList<TermType>)ImmutableList.of((Object)wktLiteralType, (Object)wktLiteralType, (Object)iriType), xsdDoubleType);
        this.functionSymbolFactory = functionSymbolFactory;
    }

    @Override
    protected ImmutableTerm computeDBTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory) {
        List wktLiteralValues = subLexicalTerms.subList(0, 2).stream().map(term -> GeoUtils.extractWKTLiteralValue(termFactory, term)).collect(Collectors.toList());
        IRI srid0 = ((WKTLiteralValue)wktLiteralValues.get(0)).getSRID();
        IRI srid1 = ((WKTLiteralValue)wktLiteralValues.get(1)).getSRID();
        ImmutableTerm geom0 = ((WKTLiteralValue)wktLiteralValues.get(0)).getGeometry();
        ImmutableTerm geom1 = ((WKTLiteralValue)wktLiteralValues.get(1)).getGeometry();
        DistanceUnit inputUnit = GeoUtils.getUnitFromSRID(srid0.getIRIString());
        DistanceUnit outputUnit = DistanceUnit.findByIRI(((DBConstant)subLexicalTerms.get(2)).getValue());
        DBFunctionSymbolFactory dbFunctionSymbolFactory = termFactory.getDBFunctionSymbolFactory();
        DBTypeFactory dbTypeFactory = termFactory.getTypeFactory().getDBTypeFactory();
        DBMathBinaryOperator divides = dbFunctionSymbolFactory.getDBMathBinaryOperator("/", dbTypeFactory.getDBDoubleType());
        if (inputUnit == DistanceUnit.METRE && outputUnit == DistanceUnit.METRE) {
            return termFactory.getDBSTDistance(geom0, geom1).simplify();
        }
        if (inputUnit == DistanceUnit.METRE && outputUnit == DistanceUnit.RADIAN) {
            ImmutableTerm distanceInMetre = termFactory.getDBSTDistance(geom0, geom1).simplify();
            DBConstant radiusConstant = termFactory.getDBConstant(String.valueOf(6370986.0), dbTypeFactory.getDBDoubleType());
            return termFactory.getImmutableFunctionalTerm((FunctionSymbol)divides, distanceInMetre, radiusConstant);
        }
        if (inputUnit == DistanceUnit.METRE && outputUnit == DistanceUnit.DEGREE) {
            ImmutableTerm distanceInMetre = termFactory.getDBSTDistance(geom0, geom1).simplify();
            DBConstant ratioConstant = termFactory.getDBConstant(String.valueOf(111194.68229846346), dbTypeFactory.getDBDoubleType());
            return termFactory.getImmutableFunctionalTerm((FunctionSymbol)divides, distanceInMetre, ratioConstant);
        }
        if (inputUnit == DistanceUnit.DEGREE && outputUnit == DistanceUnit.DEGREE) {
            ImmutableTerm distanceInMetre = termFactory.getDBSTDistanceSphere(geom0, geom1).simplify();
            DBConstant ratioConstant = termFactory.getDBConstant(String.valueOf(111194.68229846346), dbTypeFactory.getDBDoubleType());
            return termFactory.getImmutableFunctionalTerm((FunctionSymbol)divides, distanceInMetre, ratioConstant);
        }
        if (inputUnit == DistanceUnit.DEGREE && outputUnit == DistanceUnit.RADIAN) {
            ImmutableTerm distanceInMetre = termFactory.getDBSTDistanceSphere(geom0, geom1).simplify();
            DBConstant ratioConstant = termFactory.getDBConstant(String.valueOf(6370986.0), dbTypeFactory.getDBDoubleType());
            return termFactory.getImmutableFunctionalTerm((FunctionSymbol)divides, distanceInMetre, ratioConstant);
        }
        if (inputUnit == DistanceUnit.DEGREE && outputUnit == DistanceUnit.METRE) {
            return termFactory.getDBSTDistanceSphere(geom0, geom1).simplify();
        }
        throw new IllegalArgumentException(String.format("Unsupported combination of units for distance. input: %s, output: %s", new Object[]{inputUnit, outputUnit}));
    }
}

