/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl.geof;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBConcatFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.DefaultSimpleDBCastFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.DistanceUnit;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.WKTLiteralValue;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import org.apache.commons.rdf.api.IRI;
import org.apache.commons.rdf.api.RDF;
import org.apache.commons.rdf.simple.SimpleRDF;
import org.locationtech.proj4j.CRSFactory;
import org.locationtech.proj4j.CoordinateReferenceSystem;
import org.locationtech.proj4j.units.Unit;

public class GeoUtils {
    static final double EARTH_MEAN_RADIUS_METER = 6370986.0;
    private static final RDF rdfFactory = new SimpleRDF();
    public static final IRI defaultSRID = rdfFactory.createIRI("http://www.opengis.net/def/crs/OGC/1.3/CRS84");

    static WKTLiteralValue extractWKTLiteralValue(TermFactory termFactory, ImmutableTerm wktLiteralTerm) {
        IRI srid = GeoUtils.tryExtractSRIDFromDbConstant(Optional.of(wktLiteralTerm)).orElseGet(() -> GeoUtils.tryExtractSRIDFromTemplate(wktLiteralTerm).orElse(defaultSRID));
        ImmutableTerm geometry = GeoUtils.tryExtractGeometryFromConstant(wktLiteralTerm, termFactory, srid).orElseGet(() -> GeoUtils.tryExtractGeometryFromTemplate(termFactory, wktLiteralTerm).orElseGet(() -> GeoUtils.tryExtractNestedGeoSPARQLExpression(wktLiteralTerm).orElse(wktLiteralTerm)));
        return new WKTLiteralValue(srid, geometry);
    }

    static Optional<IRI> tryExtractSRIDFromDbConstant(Optional<ImmutableTerm> immutableTerm) {
        return immutableTerm.filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).filter(v -> v.startsWith("<") && v.indexOf(">") > 0).map(v -> v.substring(1, v.indexOf(">"))).map(arg_0 -> ((RDF)rdfFactory).createIRI(arg_0));
    }

    private static Optional<IRI> tryExtractSRIDFromTemplate(ImmutableTerm wktLiteralTerm) {
        Optional<ImmutableTerm> firstTermFromTemplate = Optional.of(wktLiteralTerm).filter(t -> t instanceof NonGroundFunctionalTerm).map(t -> (NonGroundFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBConcatFunctionSymbol).map(t -> t.getTerm(0));
        return GeoUtils.tryExtractSRIDFromDbConstant(firstTermFromTemplate);
    }

    static Optional<ImmutableTerm> tryExtractGeometryFromConstant(ImmutableTerm immutableTerm, TermFactory termFactory, IRI srid) {
        String EPSG_PREFIX = "EPSG:";
        String sridProj4j = GeoUtils.toProj4jName(srid.getIRIString());
        DBConstant newEPSG = sridProj4j.equals("CRS:84") ? termFactory.getDBStringConstant("4326") : termFactory.getDBStringConstant(sridProj4j.substring("EPSG:".length()));
        return Optional.of(immutableTerm).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).map(v -> termFactory.getDBStringConstant(v.substring(v.indexOf(">") + 1).trim())).map(termFactory::getDBSTGeomFromText).map(v -> termFactory.getDBSTSetSRID((ImmutableTerm)v, newEPSG)).map(termFactory::getDBAsText);
    }

    private static Optional<ImmutableTerm> tryExtractGeometryFromTemplate(TermFactory termFactory, ImmutableTerm wktLiteralTerm) {
        return Optional.of(wktLiteralTerm).filter(t -> t instanceof NonGroundFunctionalTerm).map(t -> (NonGroundFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DBConcatFunctionSymbol).map(t -> {
            if (!GeoUtils.templateStartsWithSRID(t.getTerm(0))) {
                return wktLiteralTerm;
            }
            if (t.getTerms().size() == 2) {
                return t.getTerm(1);
            }
            return termFactory.getNullRejectingDBConcatFunctionalTerm((ImmutableList<? extends ImmutableTerm>)((ImmutableList)t.getTerms().stream().map(subterm -> subterm.toString().contains("<") ? GeoUtils.extractConstantWKTLiteralValue(termFactory, subterm).get() : subterm).collect(ImmutableCollectors.toList())));
        });
    }

    private static Optional<ImmutableTerm> tryExtractNestedGeoSPARQLExpression(ImmutableTerm wktLiteralTerm) {
        return Optional.of(wktLiteralTerm).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol() instanceof DefaultSimpleDBCastFunctionSymbol).filter(t -> t.getTerms().size() == 1).map(t -> t.getTerm(0)).filter(t -> t instanceof ImmutableFunctionalTerm).map(t -> (ImmutableFunctionalTerm)t).filter(t -> t.getFunctionSymbol().toString().startsWith("ST_ASTEXT")).map(t -> t.getTerm(0));
    }

    private static boolean templateStartsWithSRID(ImmutableTerm immutableTerm) {
        return Optional.of(immutableTerm).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).filter(v -> v.startsWith("<") && v.indexOf(">") > 0).isPresent();
    }

    static Optional<ImmutableTerm> extractConstantWKTLiteralValue(TermFactory termFactory, ImmutableTerm immutableTerm) {
        return Optional.of(immutableTerm).filter(t -> t instanceof DBConstant).map(t -> (DBConstant)t).map(Constant::getValue).map(v -> termFactory.getDBStringConstant(v.substring(v.indexOf(">") + 1).trim()));
    }

    static String toProj4jName(String sridIRIString) {
        String CRS_PREFIX = "http://www.opengis.net/def/crs/OGC/1.3/CRS";
        String EPSG_PREFIX = "http://www.opengis.net/def/crs/EPSG/0/";
        if (sridIRIString.startsWith("http://www.opengis.net/def/crs/OGC/1.3/CRS")) {
            return "CRS:" + sridIRIString.substring("http://www.opengis.net/def/crs/OGC/1.3/CRS".length());
        }
        if (sridIRIString.startsWith("http://www.opengis.net/def/crs/EPSG/0/")) {
            return "EPSG:" + sridIRIString.substring("http://www.opengis.net/def/crs/EPSG/0/".length());
        }
        throw new IllegalArgumentException("Unknown SRID IRI: " + sridIRIString);
    }

    public static DistanceUnit getUnitFromSRID(String sridIRIString) {
        String csName = GeoUtils.toProj4jName(sridIRIString);
        if (csName.equals("CRS:84")) {
            return DistanceUnit.DEGREE;
        }
        if (csName.startsWith("CRS:")) {
            throw new IllegalArgumentException("Unknown SRID IRI: " + sridIRIString);
        }
        CRSFactory csFactory = new CRSFactory();
        CoordinateReferenceSystem crs = csFactory.createFromName(csName);
        Unit proj4JUnit = crs.getProjection().getUnits();
        return DistanceUnit.findByName(proj4JUnit.name);
    }
}

