/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReduciblePositiveAritySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.model.type.TypeFactory;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import java.util.function.Function;
import java.util.regex.Pattern;
import org.apache.commons.rdf.api.IRI;

public class SPARQLCastFunctionSymbolImpl
extends ReduciblePositiveAritySPARQLFunctionSymbolImpl {
    private final RDFTermType targetType;
    private final DBTypeFactory dbTypeFactory;
    private final Pattern numericPattern = Pattern.compile("-?\\d+(\\.\\d+)?");
    private final ImmutableList<String> booleanPattern = ImmutableList.of((Object)"true", (Object)"false", (Object)"t", (Object)"f", (Object)"1", (Object)"0");
    private final Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct;

    public SPARQLCastFunctionSymbolImpl(String functionSymbolName, IRI iriFunctionName, RDFDatatype targetDataType, TypeFactory typeFactory, Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        super(functionSymbolName, iriFunctionName, (ImmutableList<TermType>)ImmutableList.of((Object)typeFactory.getAbstractRDFTermType()));
        this.targetType = targetDataType;
        this.dbTypeFactory = typeFactory.getDBTypeFactory();
        this.dbFunctionSymbolFct = dbFunctionSymbolFct;
    }

    @Override
    protected ImmutableTerm computeLexicalTerm(ImmutableList<ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, ImmutableTerm returnedTypeTerm) {
        DBTermType targetTypeClosestDBType = this.targetType.getClosestDBType(this.dbTypeFactory);
        if (typeTerms.size() > 0 && typeTerms.get(0) instanceof RDFTermTypeConstant) {
            RDFTermTypeConstant inputRDFType = (RDFTermTypeConstant)typeTerms.get(0);
            if (inputRDFType.equals(returnedTypeTerm)) {
                return (ImmutableTerm)subLexicalTerms.get(0);
            }
            if (!this.checkTermConversionConsistency(inputRDFType.getRDFTermType(), termFactory, targetTypeClosestDBType, (ImmutableTerm)subLexicalTerms.get(0))) {
                return termFactory.getNullConstant();
            }
            DBTermType inputDBType = inputRDFType.getRDFTermType().getClosestDBType(this.dbTypeFactory);
            return this.dbFunctionSymbolFct.apply(inputDBType).isPresent() ? termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFct.apply(inputDBType).get(), (ImmutableTerm)subLexicalTerms.get(0)) : termFactory.getNullConstant();
        }
        return termFactory.getImmutableFunctionalTerm((FunctionSymbol)this.dbFunctionSymbolFct.apply(this.dbTypeFactory.getDBStringType()).get(), (ImmutableTerm)subLexicalTerms.get(0));
    }

    @Override
    protected ImmutableTerm computeTypeTerm(ImmutableList<? extends ImmutableTerm> subLexicalTerms, ImmutableList<ImmutableTerm> typeTerms, TermFactory termFactory, VariableNullability variableNullability) {
        return termFactory.getRDFTermTypeConstant(this.targetType);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public Optional<TermTypeInference> inferType(ImmutableList<? extends ImmutableTerm> terms) {
        return Optional.of(TermTypeInference.declareTermType(this.targetType));
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return false;
    }

    protected boolean checkTermConversionConsistency(RDFTermType rdfTermType, TermFactory termFactory, DBTermType targetType2, ImmutableTerm term) {
        DBTermType.Category inputType = rdfTermType.getClosestDBType(termFactory.getTypeFactory().getDBTypeFactory()).getCategory();
        if (targetType2.getNaturalRDFDatatype().isPresent()) {
            switch (targetType2.getCategory()) {
                case DATE: {
                    if (rdfTermType instanceof ConcreteNumericRDFDatatype) {
                        return false;
                    }
                    if (!inputType.equals((Object)DBTermType.Category.STRING) || !(term instanceof DBConstant)) break;
                    try {
                        LocalDate.parse(((DBConstant)term).getValue());
                        return true;
                    }
                    catch (DateTimeParseException e) {
                        return false;
                    }
                }
                case DATETIME: {
                    if (rdfTermType instanceof ConcreteNumericRDFDatatype) {
                        return false;
                    }
                    if (!inputType.equals((Object)DBTermType.Category.STRING) || !(term instanceof DBConstant)) break;
                    try {
                        String targetDate = ((DBConstant)term).getValue().replace("Z", "");
                        if (targetDate.chars().filter(ch -> ch == 58).count() == 3L) {
                            LocalDateTime.parse(targetDate.substring(0, targetDate.length() - 6));
                            return ImmutableList.of((Object)"00", (Object)"30", (Object)"45").contains((Object)targetDate.substring(targetDate.length() - 2)) && ImmutableList.of((Object)"-", (Object)"+").contains((Object)String.valueOf(targetDate.charAt(targetDate.length() - 6))) && Integer.parseInt(targetDate.substring(targetDate.length() - 5, targetDate.length() - 3)) < 15;
                        }
                        LocalDateTime.parse(targetDate);
                        return true;
                    }
                    catch (DateTimeParseException e) {
                        return false;
                    }
                }
                case FLOAT_DOUBLE: 
                case DECIMAL: 
                case INTEGER: {
                    if (inputType.equals((Object)DBTermType.Category.DATE) || inputType.equals((Object)DBTermType.Category.DATETIME)) {
                        return false;
                    }
                    if (!inputType.equals((Object)DBTermType.Category.STRING) || !(term instanceof DBConstant)) break;
                    if (term.isNull()) {
                        return false;
                    }
                    return this.numericPattern.matcher(((DBConstant)term).getValue()).matches();
                }
                case BOOLEAN: {
                    if (inputType.equals((Object)DBTermType.Category.DATE) || inputType.equals((Object)DBTermType.Category.DATETIME)) {
                        return false;
                    }
                    if (!inputType.equals((Object)DBTermType.Category.STRING) || !(term instanceof DBConstant)) break;
                    if (term.isNull()) {
                        return false;
                    }
                    return this.booleanPattern.contains((Object)((DBConstant)term).getValue());
                }
            }
        }
        return true;
    }
}

