/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.impl;

import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableTable;
import com.google.inject.Inject;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.BooleanFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.InequalityLabel;
import it.unibz.inf.ontop.model.term.functionsymbol.NotYetTypedEqualityFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLAggregationFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.SPARQLFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.AreCompatibleRDFStringFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.AvgSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BinaryLatelyTypedFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BinaryNumericLexicalFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.BoundSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.CoalesceSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.CommonDenominatorFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.CommonPropagatedOrSubstitutedNumericTypeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ConcatSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ContainsSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.CountSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.DatatypeSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.DateTruncSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.DivideSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.EBVSPARQLLikeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.EndsWithSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ExtractLexicalTermFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.GreaterThanSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.GroupConcatSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IdentityFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IfSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IriSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IsARDFTermTypeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IsBlankSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IsIRISPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IsLiteralSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.IsNumericSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LangMatchesSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LangSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LangTagFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LcaseSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LessThanSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LexicalEBVFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LexicalInequalityFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LexicalLangMatchesFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LexicalNonStrictEqualityFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LogicalAndSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.LogicalOrSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Md5SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.MinOrMaxOrSampleSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.MultitypedInputUnarySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.NonStrictEqSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.NotSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.NotYetTypedEqualityFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.NowSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.NumericBinarySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RDF2DBBooleanFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RDFDatatypeStringFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RDFTermFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RDFTermTypeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RandSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.RegexSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ReplaceSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SPARQLCastFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SameTermSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Sha1SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Sha256SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Sha384SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.Sha512SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SimpleUnarySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StartsWithSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StdevSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StrAfterSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StrBeforeSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StrSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StrUUIDSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.StrlenSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SubStr2SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SubStr3SPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.SumSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UUIDSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UcaseSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryBnodeSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryLatelyTypedFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryLexicalFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.UnaryNumericSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.VarianceSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ZeroAryBnodeSPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofBoundaryFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofBufferFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofConvexHullFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofDifferenceFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofDistanceFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhContainsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhCoveredByFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhCoversFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhDisjointFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhEqualsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhInsideFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhMeetFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEhOverlapFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofEnvelopeFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofGetSRIDFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofIntersectionFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8DcFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8EcFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8EqFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8NtppFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8NtppiFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8PoFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8TppFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRcc8TppiFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRelateFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofRelateMFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfContainsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfCrossesFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfDisjointFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfEqualsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfIntersectsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfOverlapsFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfTouchesFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSfWithinFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofSymDifferenceFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.geof.GeofUnionFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ofn.OfnMultitypedInputBinarySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.term.functionsymbol.impl.ofn.OfnSimpleBinarySPARQLFunctionSymbolImpl;
import it.unibz.inf.ontop.model.type.ConcreteNumericRDFDatatype;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.DBTypeFactory;
import it.unibz.inf.ontop.model.type.MetaRDFTermType;
import it.unibz.inf.ontop.model.type.ObjectRDFType;
import it.unibz.inf.ontop.model.type.RDFDatatype;
import it.unibz.inf.ontop.model.type.RDFTermType;
import it.unibz.inf.ontop.model.type.TypeFactory;
import it.unibz.inf.ontop.model.vocabulary.GEOF;
import it.unibz.inf.ontop.model.vocabulary.OFN;
import it.unibz.inf.ontop.model.vocabulary.Ontop;
import it.unibz.inf.ontop.model.vocabulary.XPathFunction;
import it.unibz.inf.ontop.model.vocabulary.XSD;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.commons.rdf.api.IRI;

public class FunctionSymbolFactoryImpl
implements FunctionSymbolFactory {
    private final TypeFactory typeFactory;
    private final RDFTermFunctionSymbol rdfTermFunctionSymbol;
    private final BooleanFunctionSymbol areCompatibleRDFStringFunctionSymbol;
    private final BooleanFunctionSymbol lexicalNonStrictEqualityFunctionSymbol;
    private final NotYetTypedEqualityFunctionSymbol notYetTypedEqualityFunctionSymbol;
    private final BooleanFunctionSymbol lexicalEBVFunctionSymbol;
    private final DBFunctionSymbolFactory dbFunctionSymbolFactory;
    private final Map<Integer, FunctionSymbol> commonDenominatorMap;
    private final Map<Integer, SPARQLFunctionSymbol> concatMap;
    private final Map<Integer, SPARQLFunctionSymbol> coalesceMap;
    private final Map<String, SPARQLAggregationFunctionSymbol> distinctSparqlGroupConcatMap;
    private final Map<String, SPARQLAggregationFunctionSymbol> nonDistinctSparqlGroupConcatMap;
    private final Map<IRI, SPARQLFunctionSymbol> sparqlIRIMap;
    private final Map<RDFTermType, BooleanFunctionSymbol> isAMap;
    private final Map<InequalityLabel, BooleanFunctionSymbol> lexicalInequalityFunctionSymbolMap;
    private final BooleanFunctionSymbol rdf2DBBooleanFunctionSymbol;
    private final FunctionSymbol langTypeFunctionSymbol;
    private final FunctionSymbol rdfDatatypeFunctionSymbol;
    private final BooleanFunctionSymbol lexicalLangMatchesFunctionSymbol;
    private final FunctionSymbol commonNumericTypeFunctionSymbol;
    private final FunctionSymbol EBVSPARQLLikeFunctionSymbol;
    private final FunctionSymbol extractLexicalTermFunctionSymbol;
    private final MetaRDFTermType metaRDFType;
    private final DBTermType dbBooleanType;
    private final DBTermType dbStringType;
    private final SPARQLFunctionSymbol iriNoBaseFunctionSymbol;
    private final FunctionSymbol identityFunctionSymbol;
    private ImmutableTable<String, Integer, SPARQLFunctionSymbol> regularSparqlFunctionTable;
    private ImmutableTable<String, Integer, SPARQLFunctionSymbol> distinctSparqlAggregateFunctionTable;

    @Inject
    private FunctionSymbolFactoryImpl(TypeFactory typeFactory, DBFunctionSymbolFactory dbFunctionSymbolFactory) {
        this.typeFactory = typeFactory;
        this.rdfTermFunctionSymbol = new RDFTermFunctionSymbolImpl(typeFactory.getDBTypeFactory().getDBStringType(), typeFactory.getMetaRDFTermType());
        this.dbFunctionSymbolFactory = dbFunctionSymbolFactory;
        DBTypeFactory dbTypeFactory = typeFactory.getDBTypeFactory();
        this.dbStringType = dbTypeFactory.getDBStringType();
        this.dbBooleanType = dbTypeFactory.getDBBooleanType();
        this.metaRDFType = typeFactory.getMetaRDFTermType();
        this.commonDenominatorMap = new ConcurrentHashMap<Integer, FunctionSymbol>();
        this.concatMap = new ConcurrentHashMap<Integer, SPARQLFunctionSymbol>();
        this.coalesceMap = new ConcurrentHashMap<Integer, SPARQLFunctionSymbol>();
        this.distinctSparqlGroupConcatMap = new ConcurrentHashMap<String, SPARQLAggregationFunctionSymbol>();
        this.nonDistinctSparqlGroupConcatMap = new ConcurrentHashMap<String, SPARQLAggregationFunctionSymbol>();
        this.sparqlIRIMap = new ConcurrentHashMap<IRI, SPARQLFunctionSymbol>();
        this.isAMap = new ConcurrentHashMap<RDFTermType, BooleanFunctionSymbol>();
        this.lexicalInequalityFunctionSymbolMap = new ConcurrentHashMap<InequalityLabel, BooleanFunctionSymbol>();
        this.areCompatibleRDFStringFunctionSymbol = new AreCompatibleRDFStringFunctionSymbolImpl(this.metaRDFType, this.dbBooleanType);
        this.rdf2DBBooleanFunctionSymbol = new RDF2DBBooleanFunctionSymbolImpl(typeFactory.getXsdBooleanDatatype(), this.dbBooleanType, this.dbStringType);
        this.lexicalNonStrictEqualityFunctionSymbol = new LexicalNonStrictEqualityFunctionSymbolImpl(this.metaRDFType, typeFactory.getXsdBooleanDatatype(), typeFactory.getXsdDatetimeDatatype(), typeFactory.getXsdStringDatatype(), this.dbStringType, this.dbBooleanType, typeFactory.getDatatype(XSD.DATETIMESTAMP), typeFactory.getDatatype(XSD.DATE));
        this.langTypeFunctionSymbol = new LangTagFunctionSymbolImpl(this.metaRDFType, this.dbStringType);
        this.rdfDatatypeFunctionSymbol = new RDFDatatypeStringFunctionSymbolImpl(this.metaRDFType, this.dbStringType);
        this.lexicalLangMatchesFunctionSymbol = new LexicalLangMatchesFunctionSymbolImpl(this.dbStringType, this.dbBooleanType);
        this.commonNumericTypeFunctionSymbol = new CommonPropagatedOrSubstitutedNumericTypeFunctionSymbolImpl(this.metaRDFType);
        this.EBVSPARQLLikeFunctionSymbol = new EBVSPARQLLikeFunctionSymbolImpl(typeFactory.getAbstractRDFSLiteral(), typeFactory.getXsdBooleanDatatype());
        this.lexicalEBVFunctionSymbol = new LexicalEBVFunctionSymbolImpl(this.dbStringType, this.metaRDFType, this.dbBooleanType);
        this.notYetTypedEqualityFunctionSymbol = new NotYetTypedEqualityFunctionSymbolImpl(dbTypeFactory.getAbstractRootDBType(), this.dbBooleanType);
        this.iriNoBaseFunctionSymbol = new IriSPARQLFunctionSymbolImpl(typeFactory.getAbstractRDFTermType(), typeFactory.getXsdStringDatatype(), typeFactory.getIRITermType());
        this.extractLexicalTermFunctionSymbol = new ExtractLexicalTermFunctionSymbolImpl(typeFactory.getAbstractRDFTermType(), this.dbStringType);
        this.identityFunctionSymbol = new IdentityFunctionSymbol(dbTypeFactory.getAbstractRootDBType());
    }

    @Inject
    protected void init() {
        this.regularSparqlFunctionTable = this.createSPARQLFunctionSymbolTable();
        this.distinctSparqlAggregateFunctionTable = this.createDistinctSPARQLAggregationFunctionSymbolTable();
    }

    protected ImmutableTable<String, Integer, SPARQLFunctionSymbol> createSPARQLFunctionSymbolTable() {
        RDFDatatype xsdString = this.typeFactory.getXsdStringDatatype();
        RDFDatatype xsdBoolean = this.typeFactory.getXsdBooleanDatatype();
        ConcreteNumericRDFDatatype xsdDecimal = this.typeFactory.getXsdDecimalDatatype();
        ConcreteNumericRDFDatatype xsdInteger = this.typeFactory.getXsdIntegerDatatype();
        ConcreteNumericRDFDatatype xsdLong = this.typeFactory.getXsdLongDatatype();
        ConcreteNumericRDFDatatype xsdDouble = this.typeFactory.getXsdDoubleDatatype();
        ConcreteNumericRDFDatatype xsdFloat = this.typeFactory.getXsdFloatDatatype();
        RDFDatatype wktLiteral = this.typeFactory.getWktLiteralDatatype();
        RDFDatatype xsdAnyUri = this.typeFactory.getXsdAnyUri();
        RDFDatatype xsdAnySimpleType = this.typeFactory.getXsdAnyUri();
        RDFDatatype rdfsLiteral = this.typeFactory.getAbstractRDFSLiteral();
        RDFTermType abstractRDFType = this.typeFactory.getAbstractRDFTermType();
        ObjectRDFType bnodeType = this.typeFactory.getBlankNodeType();
        ObjectRDFType iriType = this.typeFactory.getIRITermType();
        RDFDatatype xsdDatetime = this.typeFactory.getXsdDatetimeDatatype();
        RDFDatatype xsdDate = this.typeFactory.getXsdDate();
        RDFDatatype abstractNumericType = this.typeFactory.getAbstractOntopNumericDatatype();
        RDFDatatype dateOrDatetime = this.typeFactory.getAbstractOntopDateOrDatetimeDatatype();
        DBTypeFactory dbTypeFactory = this.typeFactory.getDBTypeFactory();
        DBTermType dbBoolean = dbTypeFactory.getDBBooleanType();
        DBTermType dbInteger = dbTypeFactory.getDBLargeIntegerType();
        DBTermType dbTimestamp = dbTypeFactory.getDBDateTimestampType();
        DBTermType dbDate = dbTypeFactory.getDBDateType();
        Object[] objectArray = new SPARQLFunctionSymbol[119];
        objectArray[0] = new SubStr2SPARQLFunctionSymbolImpl(xsdString, xsdInteger);
        objectArray[1] = new SubStr3SPARQLFunctionSymbolImpl(xsdString, xsdInteger);
        objectArray[2] = new StrlenSPARQLFunctionSymbolImpl(xsdString, xsdInteger);
        objectArray[3] = new LangSPARQLFunctionSymbolImpl(rdfsLiteral, xsdString);
        objectArray[4] = new LangMatchesSPARQLFunctionSymbolImpl(xsdString, xsdBoolean);
        objectArray[5] = new StrSPARQLFunctionSymbolImpl(abstractRDFType, xsdString, bnodeType);
        objectArray[6] = new DatatypeSPARQLFunctionSymbolImpl(rdfsLiteral, iriType);
        objectArray[7] = new IsIRISPARQLFunctionSymbolImpl(iriType, abstractRDFType, xsdBoolean);
        objectArray[8] = new IsBlankSPARQLFunctionSymbolImpl(bnodeType, abstractRDFType, xsdBoolean);
        objectArray[9] = new IsLiteralSPARQLFunctionSymbolImpl(rdfsLiteral, abstractRDFType, xsdBoolean);
        objectArray[10] = new IsNumericSPARQLFunctionSymbolImpl(abstractNumericType, abstractRDFType, xsdBoolean);
        objectArray[11] = new ReplaceSPARQLFunctionSymbolImpl(3, xsdString);
        objectArray[12] = new ReplaceSPARQLFunctionSymbolImpl(4, xsdString);
        objectArray[13] = new RegexSPARQLFunctionSymbolImpl(2, xsdString, xsdBoolean);
        objectArray[14] = new RegexSPARQLFunctionSymbolImpl(3, xsdString, xsdBoolean);
        objectArray[15] = new StrBeforeSPARQLFunctionSymbolImpl(xsdString);
        objectArray[16] = new StrAfterSPARQLFunctionSymbolImpl(xsdString);
        objectArray[17] = new NotSPARQLFunctionSymbolImpl(xsdBoolean);
        objectArray[18] = new LogicalOrSPARQLFunctionSymbolImpl(xsdBoolean);
        objectArray[19] = new LogicalAndSPARQLFunctionSymbolImpl(xsdBoolean);
        objectArray[20] = new BoundSPARQLFunctionSymbolImpl(abstractRDFType, xsdBoolean);
        objectArray[21] = new Md5SPARQLFunctionSymbolImpl(xsdString);
        objectArray[22] = new Sha1SPARQLFunctionSymbolImpl(xsdString);
        objectArray[23] = new Sha256SPARQLFunctionSymbolImpl(xsdString);
        objectArray[24] = new Sha384SPARQLFunctionSymbolImpl(xsdString);
        objectArray[25] = new Sha512SPARQLFunctionSymbolImpl(xsdString);
        objectArray[26] = new NumericBinarySPARQLFunctionSymbolImpl("SP_MULTIPLY", "*", abstractNumericType);
        objectArray[27] = new NumericBinarySPARQLFunctionSymbolImpl("SP_ADD", "+", abstractNumericType);
        objectArray[28] = new NumericBinarySPARQLFunctionSymbolImpl("SP_SUBSTRACT", "-", abstractNumericType);
        objectArray[29] = new DivideSPARQLFunctionSymbolImpl(abstractNumericType, xsdDecimal);
        objectArray[30] = new NonStrictEqSPARQLFunctionSymbolImpl(abstractRDFType, xsdBoolean, dbBoolean);
        objectArray[31] = new LessThanSPARQLFunctionSymbolImpl(abstractRDFType, xsdBoolean, dbBoolean);
        objectArray[32] = new GreaterThanSPARQLFunctionSymbolImpl(abstractRDFType, xsdBoolean, dbBoolean);
        objectArray[33] = new SameTermSPARQLFunctionSymbolImpl(abstractRDFType, xsdBoolean);
        objectArray[34] = new UnaryNumericSPARQLFunctionSymbolImpl("SP_ABS", XPathFunction.NUMERIC_ABS, abstractNumericType, this.dbFunctionSymbolFactory::getAbs);
        objectArray[35] = new UnaryNumericSPARQLFunctionSymbolImpl("SP_CEIL", XPathFunction.NUMERIC_CEIL, abstractNumericType, this.dbFunctionSymbolFactory::getCeil);
        objectArray[36] = new UnaryNumericSPARQLFunctionSymbolImpl("SP_FLOOR", XPathFunction.NUMERIC_FLOOR, abstractNumericType, this.dbFunctionSymbolFactory::getFloor);
        objectArray[37] = new UnaryNumericSPARQLFunctionSymbolImpl("SP_ROUND", XPathFunction.NUMERIC_ROUND, abstractNumericType, this.dbFunctionSymbolFactory::getRound);
        objectArray[38] = new MultitypedInputUnarySPARQLFunctionSymbolImpl("SP_YEAR", "YEAR", (RDFTermType)dateOrDatetime, (RDFTermType)xsdInteger, false, dbTypeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBYearFromDatetime());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBYearFromDate());
            }
            return Optional.empty();
        });
        objectArray[39] = new MultitypedInputUnarySPARQLFunctionSymbolImpl("SP_MONTH", "MONTH", (RDFTermType)dateOrDatetime, (RDFTermType)xsdInteger, false, dbTypeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBMonthFromDatetime());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBMonthFromDate());
            }
            return Optional.empty();
        });
        objectArray[40] = new MultitypedInputUnarySPARQLFunctionSymbolImpl("SP_DAY", "DAY", (RDFTermType)dateOrDatetime, (RDFTermType)xsdInteger, false, dbTypeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBDayFromDatetime());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBDayFromDate());
            }
            return Optional.empty();
        });
        objectArray[41] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_HOURS", XPathFunction.HOURS_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBHours);
        objectArray[42] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_MINUTES", XPathFunction.MINUTES_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBMinutes);
        objectArray[43] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_WEEK", Ontop.WEEK_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBWeek);
        objectArray[44] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_QUARTER", Ontop.QUARTER_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBQuarter);
        objectArray[45] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_DECADE", Ontop.DECADE_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBDecade);
        objectArray[46] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_CENTURY", Ontop.CENTURY_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBCentury);
        objectArray[47] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_MILLENNIUM", Ontop.MILLENNIUM_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBMillennium);
        objectArray[48] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_MILLISECONDS", Ontop.MILLISECONDS_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdDecimal, false, TermFactory::getDBMilliseconds);
        objectArray[49] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_MICROSECONDS", Ontop.MICROSECONDS_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdInteger, false, TermFactory::getDBMicroseconds);
        objectArray[50] = new DateTruncSPARQLFunctionSymbolImpl(xsdDatetime, xsdString, t -> this.dbFunctionSymbolFactory.getDBDateTrunc((String)t));
        objectArray[51] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_SECONDS", XPathFunction.SECONDS_FROM_DATETIME, (RDFTermType)xsdDatetime, (RDFTermType)xsdDecimal, false, TermFactory::getDBSeconds);
        objectArray[52] = new SimpleUnarySPARQLFunctionSymbolImpl("SP_TZ", "TZ", (RDFTermType)xsdDatetime, (RDFTermType)xsdString, false, TermFactory::getDBTz);
        objectArray[53] = new UnaryBnodeSPARQLFunctionSymbolImpl(xsdString, bnodeType);
        objectArray[54] = new NowSPARQLFunctionSymbolImpl(xsdDatetime);
        objectArray[55] = new IfSPARQLFunctionSymbolImpl(xsdBoolean, abstractRDFType);
        objectArray[56] = new CountSPARQLFunctionSymbolImpl(abstractRDFType, xsdInteger, false);
        objectArray[57] = new CountSPARQLFunctionSymbolImpl(xsdInteger, false);
        objectArray[58] = new SumSPARQLFunctionSymbolImpl(false, abstractRDFType);
        objectArray[59] = new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.MIN);
        objectArray[60] = new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.MAX);
        objectArray[61] = new AvgSPARQLFunctionSymbolImpl(abstractRDFType, false);
        objectArray[62] = new StdevSPARQLFunctionSymbolImpl(abstractRDFType, false, false);
        objectArray[63] = new StdevSPARQLFunctionSymbolImpl(abstractRDFType, true, false);
        objectArray[64] = new StdevSPARQLFunctionSymbolImpl(abstractRDFType, false);
        objectArray[65] = new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, false, false);
        objectArray[66] = new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, true, false);
        objectArray[67] = new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, false);
        objectArray[68] = new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.SAMPLE);
        objectArray[69] = new GeofSfEqualsFunctionSymbolImpl(GEOF.SF_EQUALS, wktLiteral, xsdBoolean);
        objectArray[70] = new GeofSfDisjointFunctionSymbolImpl(GEOF.SF_DISJOINT, wktLiteral, xsdBoolean);
        objectArray[71] = new GeofSfIntersectsFunctionSymbolImpl(GEOF.SF_INTERSECTS, wktLiteral, xsdBoolean);
        objectArray[72] = new GeofSfTouchesFunctionSymbolImpl(GEOF.SF_TOUCHES, wktLiteral, xsdBoolean);
        objectArray[73] = new GeofSfCrossesFunctionSymbolImpl(GEOF.SF_CROSSES, wktLiteral, xsdBoolean);
        objectArray[74] = new GeofSfWithinFunctionSymbolImpl(GEOF.SF_WITHIN, wktLiteral, xsdBoolean);
        objectArray[75] = new GeofSfContainsFunctionSymbolImpl(GEOF.SF_CONTAINS, wktLiteral, xsdBoolean);
        objectArray[76] = new GeofSfOverlapsFunctionSymbolImpl(GEOF.SF_OVERLAPS, wktLiteral, xsdBoolean);
        objectArray[77] = new GeofEhEqualsFunctionSymbolImpl(GEOF.EH_EQUALS, wktLiteral, xsdBoolean);
        objectArray[78] = new GeofEhDisjointFunctionSymbolImpl(GEOF.EH_DISJOINT, wktLiteral, xsdBoolean);
        objectArray[79] = new GeofEhMeetFunctionSymbolImpl(GEOF.EH_MEET, wktLiteral, xsdBoolean);
        objectArray[80] = new GeofEhOverlapFunctionSymbolImpl(GEOF.EH_OVERLAP, wktLiteral, xsdBoolean);
        objectArray[81] = new GeofEhCoversFunctionSymbolImpl(GEOF.EH_COVERS, wktLiteral, xsdBoolean);
        objectArray[82] = new GeofEhCoveredByFunctionSymbolImpl(GEOF.EH_COVEREDBY, wktLiteral, xsdBoolean);
        objectArray[83] = new GeofEhInsideFunctionSymbolImpl(GEOF.EH_INSIDE, wktLiteral, xsdBoolean);
        objectArray[84] = new GeofEhContainsFunctionSymbolImpl(GEOF.EH_CONTAINS, wktLiteral, xsdBoolean);
        objectArray[85] = new GeofRcc8EqFunctionSymbolImpl(GEOF.RCC8_EQ, wktLiteral, xsdBoolean);
        objectArray[86] = new GeofRcc8DcFunctionSymbolImpl(GEOF.RCC8_DC, wktLiteral, xsdBoolean);
        objectArray[87] = new GeofRcc8EcFunctionSymbolImpl(GEOF.RCC8_EC, wktLiteral, xsdBoolean);
        objectArray[88] = new GeofRcc8PoFunctionSymbolImpl(GEOF.RCC8_PO, wktLiteral, xsdBoolean);
        objectArray[89] = new GeofRcc8TppFunctionSymbolImpl(GEOF.RCC8_TPP, wktLiteral, xsdBoolean);
        objectArray[90] = new GeofRcc8TppiFunctionSymbolImpl(GEOF.RCC8_TPPI, wktLiteral, xsdBoolean);
        objectArray[91] = new GeofRcc8NtppFunctionSymbolImpl(GEOF.RCC8_NTPP, wktLiteral, xsdBoolean);
        objectArray[92] = new GeofRcc8NtppiFunctionSymbolImpl(GEOF.RCC8_NTPPI, wktLiteral, xsdBoolean);
        objectArray[93] = new GeofDistanceFunctionSymbolImpl(GEOF.DISTANCE, wktLiteral, iriType, xsdDouble, this);
        objectArray[94] = new GeofBufferFunctionSymbolImpl(GEOF.BUFFER, wktLiteral, xsdDecimal, iriType);
        objectArray[95] = new GeofIntersectionFunctionSymbolImpl(GEOF.INTERSECTION, wktLiteral);
        objectArray[96] = new GeofBoundaryFunctionSymbolImpl(GEOF.BOUNDARY, wktLiteral);
        objectArray[97] = new GeofConvexHullFunctionSymbolImpl(GEOF.CONVEXHULL, wktLiteral);
        objectArray[98] = new GeofDifferenceFunctionSymbolImpl(GEOF.DIFFERENCE, wktLiteral);
        objectArray[99] = new GeofEnvelopeFunctionSymbolImpl(GEOF.ENVELOPE, wktLiteral);
        objectArray[100] = new GeofGetSRIDFunctionSymbolImpl(GEOF.GETSRID, wktLiteral, xsdAnyUri);
        objectArray[101] = new GeofSymDifferenceFunctionSymbolImpl(GEOF.SYMDIFFERENCE, wktLiteral, iriType);
        objectArray[102] = new GeofUnionFunctionSymbolImpl(GEOF.UNION, wktLiteral, iriType);
        objectArray[103] = new GeofRelateFunctionSymbolImpl(GEOF.RELATE, wktLiteral, xsdString, xsdBoolean);
        objectArray[104] = new GeofRelateMFunctionSymbolImpl(GEOF.RELATEM, wktLiteral, xsdString);
        objectArray[105] = new OfnMultitypedInputBinarySPARQLFunctionSymbolImpl("OFN_WEEKS_BETWEEN", OFN.WEEKS_BETWEEN, (RDFTermType)dateOrDatetime, (RDFTermType)xsdLong, false, dbTypeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBWeeksBetweenFromDateTime());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBWeeksBetweenFromDate());
            }
            return Optional.empty();
        });
        objectArray[106] = new OfnMultitypedInputBinarySPARQLFunctionSymbolImpl("OFN_DAYS_BETWEEN", OFN.DAYS_BETWEEN, (RDFTermType)dateOrDatetime, (RDFTermType)xsdLong, false, dbTypeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBDaysBetweenFromDateTime());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBDaysBetweenFromDate());
            }
            return Optional.empty();
        });
        objectArray[107] = new OfnSimpleBinarySPARQLFunctionSymbolImpl("OFN_HOURS_BETWEEN", OFN.HOURS_BETWEEN, (RDFTermType)xsdDatetime, (RDFTermType)xsdLong, false, TermFactory::getDBHoursBetweenFromDateTime);
        objectArray[108] = new OfnSimpleBinarySPARQLFunctionSymbolImpl("OFN_MINUTES_BETWEEN", OFN.MINUTES_BETWEEN, (RDFTermType)xsdDatetime, (RDFTermType)xsdLong, false, TermFactory::getDBMinutesBetweenFromDateTime);
        objectArray[109] = new OfnSimpleBinarySPARQLFunctionSymbolImpl("OFN_SECONDS_BETWEEN", OFN.SECONDS_BETWEEN, (RDFTermType)xsdDatetime, (RDFTermType)xsdLong, false, TermFactory::getDBSecondsBetweenFromDateTime);
        objectArray[110] = new OfnSimpleBinarySPARQLFunctionSymbolImpl("OFN_MILLIS_BETWEEN", OFN.MILLIS_BETWEEN, (RDFTermType)xsdDatetime, (RDFTermType)xsdLong, false, TermFactory::getDBMillisBetweenFromDateTime);
        objectArray[111] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_STRING", XSD.STRING, xsdString, this.typeFactory, t -> Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(this.dbStringType)));
        objectArray[112] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_BOOLEAN", XSD.BOOLEAN, xsdBoolean, this.typeFactory, t -> {
            if (t.isA(dbTypeFactory.getDBDecimalType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBDoubleType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBLargeIntegerType())) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertBoolean());
            }
            if (t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertBooleanFromString());
            }
            if (t.isA(this.dbBooleanType)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(this.dbBooleanType));
            }
            return Optional.empty();
        });
        objectArray[113] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_INTEGER", XSD.INTEGER, xsdInteger, this.typeFactory, t -> {
            if (t.isA(dbTypeFactory.getDBDecimalType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBDoubleType()) || t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertInteger());
            }
            if (t.isA(this.dbBooleanType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertIntegerFromBoolean());
            }
            if (t.isA(dbInteger)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(dbInteger));
            }
            return Optional.empty();
        });
        objectArray[114] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_DECIMAL", XSD.DECIMAL, xsdDecimal, this.typeFactory, t -> {
            if (t.isA(dbTypeFactory.getDBDecimalType())) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(dbTypeFactory.getDBDecimalType()));
            }
            if (t.isA(this.typeFactory.getDBTypeFactory().getDBLargeIntegerType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBDoubleType()) || t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDecimal());
            }
            if (t.isA(this.dbBooleanType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDecimalFromBoolean());
            }
            return Optional.empty();
        });
        objectArray[115] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_DOUBLE", XSD.DOUBLE, xsdDouble, this.typeFactory, t -> {
            if (t.isA(dbTypeFactory.getDBDecimalType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBLargeIntegerType()) || t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDouble());
            }
            if (t.isA(this.dbBooleanType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertFloatFromBoolean());
            }
            if (t.isA(dbTypeFactory.getDBDoubleType())) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(dbTypeFactory.getDBDoubleType()));
            }
            return Optional.empty();
        });
        objectArray[116] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_FLOAT", XSD.FLOAT, xsdFloat, this.typeFactory, t -> {
            if (t.isA(dbTypeFactory.getDBDecimalType()) || t.isA(this.typeFactory.getDBTypeFactory().getDBLargeIntegerType())) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertFloatFromNonFPNumeric());
            }
            if (t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertFloat());
            }
            if (t.isA(this.dbBooleanType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertFloatFromBoolean());
            }
            if (t.isA(dbTypeFactory.getDBDoubleType())) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertFloatFromDouble());
            }
            return Optional.empty();
        });
        objectArray[117] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_DATE", XSD.DATE, xsdDate, this.typeFactory, t -> {
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDateFromDatetime());
            }
            if (t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDateFromString());
            }
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(dbDate));
            }
            return Optional.empty();
        });
        objectArray[118] = new SPARQLCastFunctionSymbolImpl("XSD_CAST_DATETIME", XSD.DATETIME, xsdDatetime, this.typeFactory, t -> {
            if (t.isA(dbDate)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDateTimeFromDate());
            }
            if (t.isA(this.dbStringType)) {
                return Optional.of(this.dbFunctionSymbolFactory.checkAndConvertDateTimeFromString());
            }
            if (t.isA(dbTimestamp)) {
                return Optional.of(this.dbFunctionSymbolFactory.getDBCastFunctionSymbol(this.typeFactory.getDBTypeFactory().getDBDateTimestampType()));
            }
            return Optional.empty();
        });
        ImmutableSet functionSymbols = ImmutableSet.of((Object)new UcaseSPARQLFunctionSymbolImpl(xsdString), (Object)new LcaseSPARQLFunctionSymbolImpl(xsdString), (Object)new SimpleUnarySPARQLFunctionSymbolImpl("SP_ENCODE_FOR_URI", XPathFunction.ENCODE_FOR_URI, (RDFTermType)xsdString, (RDFTermType)xsdString, true, TermFactory::getDBEncodeForURI), (Object)new StartsWithSPARQLFunctionSymbolImpl(xsdString, xsdBoolean), (Object)new EndsWithSPARQLFunctionSymbolImpl(xsdString, xsdBoolean), (Object)new ContainsSPARQLFunctionSymbolImpl(xsdString, xsdBoolean), (Object[])objectArray);
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        for (SPARQLFunctionSymbol functionSymbol : functionSymbols) {
            tableBuilder.put((Object)functionSymbol.getOfficialName(), (Object)functionSymbol.getArity(), (Object)functionSymbol);
        }
        return tableBuilder.build();
    }

    private ImmutableTable<String, Integer, SPARQLFunctionSymbol> createDistinctSPARQLAggregationFunctionSymbolTable() {
        RDFDatatype xsdString = this.typeFactory.getXsdStringDatatype();
        ConcreteNumericRDFDatatype xsdInteger = this.typeFactory.getXsdIntegerDatatype();
        RDFTermType abstractRDFType = this.typeFactory.getAbstractRDFTermType();
        ImmutableSet functionSymbols = ImmutableSet.of((Object)new CountSPARQLFunctionSymbolImpl(abstractRDFType, xsdInteger, true), (Object)new CountSPARQLFunctionSymbolImpl(xsdInteger, true), (Object)new SumSPARQLFunctionSymbolImpl(true, abstractRDFType), (Object)new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.MIN), (Object)new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.MIN), (Object)new MinOrMaxOrSampleSPARQLFunctionSymbolImpl(this.typeFactory, MinOrMaxOrSampleSPARQLFunctionSymbolImpl.MinMaxSampleType.SAMPLE), (Object[])new SPARQLFunctionSymbol[]{new AvgSPARQLFunctionSymbolImpl(abstractRDFType, true), new StdevSPARQLFunctionSymbolImpl(abstractRDFType, true, true), new StdevSPARQLFunctionSymbolImpl(abstractRDFType, false, true), new StdevSPARQLFunctionSymbolImpl(abstractRDFType, true), new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, true, true), new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, false, true), new VarianceSPARQLFunctionSymbolImpl(abstractRDFType, true)});
        ImmutableTable.Builder tableBuilder = ImmutableTable.builder();
        for (SPARQLFunctionSymbol functionSymbol : functionSymbols) {
            tableBuilder.put((Object)functionSymbol.getOfficialName(), (Object)functionSymbol.getArity(), (Object)functionSymbol);
        }
        return tableBuilder.build();
    }

    @Override
    public RDFTermFunctionSymbol getRDFTermFunctionSymbol() {
        return this.rdfTermFunctionSymbol;
    }

    @Override
    public DBFunctionSymbolFactory getDBFunctionSymbolFactory() {
        return this.dbFunctionSymbolFactory;
    }

    @Override
    public BooleanFunctionSymbol getIsARDFTermTypeFunctionSymbol(RDFTermType rdfTermType) {
        return this.isAMap.computeIfAbsent(rdfTermType, t -> new IsARDFTermTypeFunctionSymbolImpl(this.metaRDFType, this.dbBooleanType, (RDFTermType)t));
    }

    @Override
    public BooleanFunctionSymbol getAreCompatibleRDFStringFunctionSymbol() {
        return this.areCompatibleRDFStringFunctionSymbol;
    }

    @Override
    public BooleanFunctionSymbol getLexicalNonStrictEqualityFunctionSymbol() {
        return this.lexicalNonStrictEqualityFunctionSymbol;
    }

    @Override
    public NotYetTypedEqualityFunctionSymbol getNotYetTypedEquality() {
        return this.notYetTypedEqualityFunctionSymbol;
    }

    @Override
    public BooleanFunctionSymbol getLexicalInequalityFunctionSymbol(InequalityLabel inequalityLabel) {
        return this.lexicalInequalityFunctionSymbolMap.computeIfAbsent(inequalityLabel, this::createLexicalInequalityFunctionSymbol);
    }

    @Override
    public BooleanFunctionSymbol getLexicalEBVFunctionSymbol() {
        return this.lexicalEBVFunctionSymbol;
    }

    protected BooleanFunctionSymbol createLexicalInequalityFunctionSymbol(InequalityLabel inequalityLabel) {
        return new LexicalInequalityFunctionSymbolImpl(inequalityLabel, this.metaRDFType, this.typeFactory.getXsdBooleanDatatype(), this.typeFactory.getXsdDatetimeDatatype(), this.typeFactory.getXsdStringDatatype(), this.dbStringType, this.dbBooleanType, this.typeFactory.getDatatype(XSD.DATETIMESTAMP), this.typeFactory.getDatatype(XSD.DATE));
    }

    @Override
    public BooleanFunctionSymbol getRDF2DBBooleanFunctionSymbol() {
        return this.rdf2DBBooleanFunctionSymbol;
    }

    @Override
    public RDFTermTypeFunctionSymbol getRDFTermTypeFunctionSymbol(TypeConstantDictionary dictionary, ImmutableSet<RDFTermTypeConstant> possibleConstants, boolean isSimplifiable) {
        ImmutableBiMap<DBConstant, RDFTermTypeConstant> conversionMap = dictionary.createConversionMap((Collection<RDFTermTypeConstant>)possibleConstants);
        return new RDFTermTypeFunctionSymbolImpl(this.typeFactory, dictionary, conversionMap, isSimplifiable);
    }

    @Override
    public Optional<SPARQLFunctionSymbol> getSPARQLFunctionSymbol(String officialName, int arity) {
        switch (officialName) {
            case "http://www.w3.org/2005/xpath-functions#concat": {
                return this.getSPARQLConcatFunctionSymbol(arity);
            }
            case "RAND": {
                return Optional.of(this.createSPARQLRandFunctionSymbol());
            }
            case "UUID": {
                return Optional.of(this.createSPARQLUUIDFunctionSymbol());
            }
            case "STRUUID": {
                return Optional.of(this.createSPARQLStrUUIDFunctionSymbol());
            }
            case "COALESCE": {
                return this.getSPARQLCoalesceFunctionSymbol(arity);
            }
            case "BNODE": {
                if (arity != 0) break;
                return Optional.of(this.createZeroArySPARQLBnodeFunctionSymbol());
            }
        }
        return Optional.ofNullable((SPARQLFunctionSymbol)this.regularSparqlFunctionTable.get((Object)officialName, (Object)arity));
    }

    @Override
    public Optional<SPARQLFunctionSymbol> getSPARQLDistinctAggregateFunctionSymbol(String officialName, int arity) {
        return Optional.ofNullable((SPARQLFunctionSymbol)this.distinctSparqlAggregateFunctionTable.get((Object)officialName, (Object)arity));
    }

    @Override
    public SPARQLAggregationFunctionSymbol getSPARQLGroupConcatFunctionSymbol(String separator, boolean isDistinct) {
        return isDistinct ? this.distinctSparqlGroupConcatMap.computeIfAbsent(separator, s -> this.createSPARQLGroupConcat((String)s, true)) : this.nonDistinctSparqlGroupConcatMap.computeIfAbsent(separator, s -> this.createSPARQLGroupConcat((String)s, false));
    }

    @Override
    public synchronized SPARQLFunctionSymbol getIRIFunctionSymbol(IRI baseIRI) {
        return this.sparqlIRIMap.computeIfAbsent(baseIRI, b -> new IriSPARQLFunctionSymbolImpl((IRI)b, this.typeFactory.getAbstractRDFTermType(), this.typeFactory.getXsdStringDatatype(), this.typeFactory.getIRITermType()));
    }

    @Override
    public SPARQLFunctionSymbol getIRIFunctionSymbol() {
        return this.iriNoBaseFunctionSymbol;
    }

    protected SPARQLAggregationFunctionSymbol createSPARQLGroupConcat(String separator, boolean isDistinct) {
        return new GroupConcatSPARQLFunctionSymbolImpl(this.typeFactory.getXsdStringDatatype(), separator, isDistinct);
    }

    @Override
    public FunctionSymbol getSPARQLEffectiveBooleanValueFunctionSymbol() {
        return this.EBVSPARQLLikeFunctionSymbol;
    }

    private Optional<SPARQLFunctionSymbol> getSPARQLConcatFunctionSymbol(int arity) {
        return arity < 2 ? Optional.empty() : Optional.of(this.concatMap.computeIfAbsent(arity, a -> new ConcatSPARQLFunctionSymbolImpl((int)a, this.typeFactory.getXsdStringDatatype())));
    }

    private Optional<SPARQLFunctionSymbol> getSPARQLCoalesceFunctionSymbol(int arity) {
        return arity < 1 ? Optional.empty() : Optional.of(this.coalesceMap.computeIfAbsent(arity, a -> new CoalesceSPARQLFunctionSymbolImpl((int)a, this.typeFactory.getAbstractRDFTermType())));
    }

    private SPARQLFunctionSymbol createZeroArySPARQLBnodeFunctionSymbol() {
        return new ZeroAryBnodeSPARQLFunctionSymbolImpl(UUID.randomUUID(), this.typeFactory.getBlankNodeType());
    }

    protected SPARQLFunctionSymbol createSPARQLRandFunctionSymbol() {
        return new RandSPARQLFunctionSymbolImpl(UUID.randomUUID(), this.typeFactory.getXsdDoubleDatatype());
    }

    protected SPARQLFunctionSymbol createSPARQLUUIDFunctionSymbol() {
        return new UUIDSPARQLFunctionSymbolImpl(UUID.randomUUID(), this.typeFactory.getIRITermType());
    }

    protected SPARQLFunctionSymbol createSPARQLStrUUIDFunctionSymbol() {
        return new StrUUIDSPARQLFunctionSymbolImpl(UUID.randomUUID(), this.typeFactory.getXsdStringDatatype());
    }

    @Override
    public FunctionSymbol getCommonDenominatorFunctionSymbol(int arity) {
        if (arity < 2) {
            throw new IllegalArgumentException("Expected arity >= 2 for a common denominator");
        }
        return this.commonDenominatorMap.computeIfAbsent(arity, a -> new CommonDenominatorFunctionSymbolImpl((int)a, this.typeFactory.getMetaRDFTermType()));
    }

    @Override
    public FunctionSymbol getCommonPropagatedOrSubstitutedNumericTypeFunctionSymbol() {
        return this.commonNumericTypeFunctionSymbol;
    }

    @Override
    public FunctionSymbol getRDFDatatypeStringFunctionSymbol() {
        return this.rdfDatatypeFunctionSymbol;
    }

    @Override
    public FunctionSymbol getLangTagFunctionSymbol() {
        return this.langTypeFunctionSymbol;
    }

    @Override
    public BooleanFunctionSymbol getLexicalLangMatches() {
        return this.lexicalLangMatchesFunctionSymbol;
    }

    @Override
    public FunctionSymbol getBinaryNumericLexicalFunctionSymbol(String dbNumericOperationName) {
        return new BinaryNumericLexicalFunctionSymbolImpl(dbNumericOperationName, this.dbStringType, this.metaRDFType);
    }

    @Override
    public FunctionSymbol getUnaryLatelyTypedFunctionSymbol(Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct, DBTermType targetType) {
        return new UnaryLatelyTypedFunctionSymbolImpl(this.dbStringType, this.metaRDFType, targetType, dbFunctionSymbolFct);
    }

    @Override
    public FunctionSymbol getUnaryLexicalFunctionSymbol(Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct) {
        return new UnaryLexicalFunctionSymbolImpl(this.dbStringType, this.metaRDFType, dbFunctionSymbolFct);
    }

    @Override
    public FunctionSymbol getBinaryLatelyTypedFunctionSymbol(Function<DBTermType, Optional<DBFunctionSymbol>> dbFunctionSymbolFct, DBTermType targetType) {
        return new BinaryLatelyTypedFunctionSymbolImpl(this.dbStringType, this.dbStringType, this.metaRDFType, this.metaRDFType, targetType, dbFunctionSymbolFct);
    }

    @Override
    public FunctionSymbol getExtractLexicalTermFromRDFTerm() {
        return this.extractLexicalTermFunctionSymbol;
    }

    @Override
    public FunctionSymbol getIdentity() {
        return this.identityFunctionSymbol;
    }
}

