/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.model.term.functionsymbol.db.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.tools.TypeConstantDictionary;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.IncrementalEvaluation;
import it.unibz.inf.ontop.model.term.RDFTermTypeConstant;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.RDFTermTypeFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBCoalesceFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBFunctionSymbolSerializer;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIfElseNullFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBIsNullOrNotFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.AbstractArgDependentTypedDBFunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.db.impl.Nullifiers;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.IntStream;
import java.util.stream.Stream;

public abstract class AbstractDBCoalesceFunctionSymbol
extends AbstractArgDependentTypedDBFunctionSymbol
implements DBCoalesceFunctionSymbol {
    private final DBFunctionSymbolSerializer serializer;

    protected AbstractDBCoalesceFunctionSymbol(String nameInDialect, int arity, DBTermType rootDBTermType, DBFunctionSymbolSerializer serializer) {
        super(nameInDialect + arity, (ImmutableList<TermType>)((ImmutableList)IntStream.range(0, arity).mapToObj(i -> rootDBTermType).collect(ImmutableCollectors.toList())));
        this.serializer = serializer;
    }

    @Override
    protected boolean tolerateNulls() {
        return true;
    }

    @Override
    protected boolean mayReturnNullWithoutNullArguments() {
        return false;
    }

    @Override
    protected Stream<? extends ImmutableTerm> extractPossibleValues(ImmutableList<? extends ImmutableTerm> terms) {
        return terms.stream();
    }

    @Override
    public boolean isPreferringToBePostProcessedOverBeingBlocked() {
        return false;
    }

    @Override
    public String getNativeDBString(ImmutableList<? extends ImmutableTerm> terms, Function<ImmutableTerm, String> termConverter, TermFactory termFactory) {
        return this.serializer.getNativeDBString(terms, termConverter, termFactory);
    }

    @Override
    public boolean isAlwaysInjectiveInTheAbsenceOfNonInjectiveFunctionalTerms() {
        return false;
    }

    @Override
    public boolean canBePostProcessed(ImmutableList<? extends ImmutableTerm> arguments) {
        return true;
    }

    @Override
    protected ImmutableTerm buildTermAfterEvaluation(ImmutableList<ImmutableTerm> newTerms, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList flattenedTerms = (ImmutableList)newTerms.stream().flatMap(t -> t instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)t).getFunctionSymbol() instanceof DBCoalesceFunctionSymbol ? ((ImmutableFunctionalTerm)t).getTerms().stream() : Stream.of(t)).collect(ImmutableCollectors.toList());
        ImmutableList remainingTerms = (ImmutableList)flattenedTerms.stream().filter(t -> !t.isNull()).collect(ImmutableCollectors.toList());
        switch (remainingTerms.size()) {
            case 0: {
                return termFactory.getNullConstant();
            }
            case 1: {
                return (ImmutableTerm)remainingTerms.get(0);
            }
        }
        Optional<ImmutableFunctionalTerm> optionalLiftedOptionalTerm = this.tryToLift((ImmutableList<ImmutableTerm>)remainingTerms, termFactory);
        if (optionalLiftedOptionalTerm.isPresent()) {
            return optionalLiftedOptionalTerm.get().simplify(variableNullability);
        }
        ImmutableTerm firstRemainingTerm = (ImmutableTerm)remainingTerms.get(0);
        ImmutableList termsAfterNullConstraintPropagation = (ImmutableList)this.propagateNullConstraints(firstRemainingTerm, (ImmutableList<ImmutableTerm>)remainingTerms.subList(1, remainingTerms.size()), variableNullability, termFactory).collect(ImmutableCollectors.toList());
        ImmutableList<ImmutableTerm> simplifiedTerms = this.furtherSimplify(this.mergeIfElseNulls((ImmutableList<ImmutableTerm>)termsAfterNullConstraintPropagation, variableNullability, termFactory), variableNullability, termFactory);
        switch (simplifiedTerms.size()) {
            case 0: {
                return termFactory.getNullConstant();
            }
            case 1: {
                return (ImmutableTerm)simplifiedTerms.get(0);
            }
        }
        return this.createCoalesce(simplifiedTerms, termFactory);
    }

    protected ImmutableList<ImmutableTerm> furtherSimplify(ImmutableList<ImmutableTerm> terms, VariableNullability variableNullability, TermFactory termFactory) {
        return terms;
    }

    protected abstract ImmutableFunctionalTerm createCoalesce(ImmutableList<ImmutableTerm> var1, TermFactory var2);

    protected Optional<ImmutableFunctionalTerm> tryToLift(ImmutableList<ImmutableTerm> terms, TermFactory termFactory) {
        return this.tryToLiftRDFTermTypeFunctions(terms, termFactory);
    }

    private Optional<ImmutableFunctionalTerm> tryToLiftRDFTermTypeFunctions(ImmutableList<ImmutableTerm> terms, TermFactory termFactory) {
        if (terms.stream().allMatch(t -> t instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)t).getFunctionSymbol() instanceof RDFTermTypeFunctionSymbol)) {
            ImmutableSet functionSymbols = (ImmutableSet)terms.stream().map(t -> (ImmutableFunctionalTerm)t).map(t -> (RDFTermTypeFunctionSymbol)t.getFunctionSymbol()).collect(ImmutableCollectors.toSet());
            ImmutableSet dictionaries = (ImmutableSet)functionSymbols.stream().map(RDFTermTypeFunctionSymbol::getDictionary).collect(ImmutableCollectors.toSet());
            if (dictionaries.size() != 1) {
                throw new MinorOntopInternalBugException("All the RDFTermTypeFunctionSymbol were expected to use the same dictionary");
            }
            TypeConstantDictionary dictionary = (TypeConstantDictionary)dictionaries.stream().findAny().get();
            ImmutableSet possibleConstants = (ImmutableSet)functionSymbols.stream().flatMap(f -> f.getConversionMap().values().stream()).collect(ImmutableCollectors.toSet());
            ImmutableFunctionalTerm newCoalesce = termFactory.getDBCoalesce((ImmutableList<ImmutableTerm>)((ImmutableList)terms.stream().map(t -> (ImmutableFunctionalTerm)t).map(t -> t.getTerm(0)).collect(ImmutableCollectors.toList())));
            return Optional.of(termFactory.getRDFTermTypeFunctionalTerm(newCoalesce, dictionary, (ImmutableSet<RDFTermTypeConstant>)possibleConstants, false));
        }
        return Optional.empty();
    }

    private Stream<ImmutableTerm> propagateNullConstraints(ImmutableTerm term, ImmutableList<ImmutableTerm> followingTerms, VariableNullability variableNullability, TermFactory termFactory) {
        if (followingTerms.isEmpty()) {
            return Stream.of(term);
        }
        IncrementalEvaluation evaluation = term.evaluateIsNotNull(variableNullability);
        switch (evaluation.getStatus()) {
            case IS_NULL: {
                throw new MinorOntopInternalBugException("evaluateIsNotNull can evaluate to NULL");
            }
            case IS_FALSE: {
                return this.propagateNullConstraints((ImmutableTerm)followingTerms.get(0), (ImmutableList<ImmutableTerm>)followingTerms.subList(1, followingTerms.size()), variableNullability, termFactory);
            }
            case IS_TRUE: {
                return Stream.of(term);
            }
        }
        Optional nullifyingTerm = evaluation.getNewExpression().map(Optional::of).map(oe -> oe.filter(e -> e.getFunctionSymbol() instanceof DBIsNullOrNotFunctionSymbol && !((DBIsNullOrNotFunctionSymbol)e.getFunctionSymbol()).isTrueWhenNull()).map(e -> e.getTerm(0))).orElseGet(() -> Optional.of(term));
        ImmutableList<ImmutableTerm> substitutedFollowingTerms = nullifyingTerm.map(termToSubstitute -> (ImmutableList)followingTerms.stream().map(t -> Nullifiers.nullify(t, termToSubstitute, termFactory)).map(t -> t.simplify(variableNullability)).collect(ImmutableCollectors.toList())).orElse(followingTerms);
        return Stream.concat(Stream.of(term), this.propagateNullConstraints((ImmutableTerm)substitutedFollowingTerms.get(0), (ImmutableList<ImmutableTerm>)substitutedFollowingTerms.subList(1, substitutedFollowingTerms.size()), variableNullability, termFactory));
    }

    private ImmutableList<ImmutableTerm> mergeIfElseNulls(ImmutableList<ImmutableTerm> terms, VariableNullability variableNullability, TermFactory termFactory) {
        if (terms.size() != 2) {
            return terms;
        }
        ImmutableTerm firstTerm = (ImmutableTerm)terms.get(0);
        ImmutableTerm secondTerm = (ImmutableTerm)terms.get(1);
        if (firstTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)firstTerm).getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol) {
            ImmutableFunctionalTerm firstFunctionalTerm = (ImmutableFunctionalTerm)firstTerm;
            ImmutableExpression firstCondition = (ImmutableExpression)firstFunctionalTerm.getTerm(0);
            ImmutableTerm thenValueFirstTerm = firstFunctionalTerm.getTerm(1);
            if (secondTerm instanceof ImmutableFunctionalTerm && ((ImmutableFunctionalTerm)secondTerm).getFunctionSymbol() instanceof DBIfElseNullFunctionSymbol) {
                ImmutableFunctionalTerm secondFunctionalTerm = (ImmutableFunctionalTerm)secondTerm;
                ImmutableExpression secondCondition = (ImmutableExpression)secondFunctionalTerm.getTerm(0);
                ImmutableTerm thenValueSecondTerm = secondFunctionalTerm.getTerm(1);
                if (firstCondition.equals(secondCondition)) {
                    ImmutableTerm mergedTerm = termFactory.getIfElseNull(firstCondition, this.createCoalesce((ImmutableList<ImmutableTerm>)ImmutableList.of((Object)thenValueFirstTerm, (Object)thenValueSecondTerm), termFactory)).simplify(variableNullability);
                    return ImmutableList.of((Object)mergedTerm);
                }
                if (thenValueFirstTerm.equals(thenValueSecondTerm)) {
                    ImmutableTerm mergedTerm = termFactory.getIfElseNull(termFactory.getDisjunction(firstCondition, secondCondition), thenValueFirstTerm).simplify(variableNullability);
                    return ImmutableList.of((Object)mergedTerm);
                }
            } else if (!thenValueFirstTerm.isNullable(variableNullability.getNullableVariables())) {
                ImmutableTerm mergedTerm = termFactory.getIfThenElse(firstCondition, thenValueFirstTerm, secondTerm).simplify(variableNullability);
                return ImmutableList.of((Object)mergedTerm);
            }
        }
        return terms;
    }

    @Override
    public IncrementalEvaluation evaluateIsNotNull(ImmutableList<? extends ImmutableTerm> terms, TermFactory termFactory, VariableNullability variableNullability) {
        Optional<ImmutableExpression> disjunction = termFactory.getDisjunction(terms.stream().map(termFactory::getDBIsNotNull));
        return disjunction.map(IncrementalEvaluation::declareSimplifiedExpression).orElseGet(IncrementalEvaluation::declareIsFalse);
    }

    @Override
    public IncrementalEvaluation evaluateStrictEq(ImmutableList<? extends ImmutableTerm> terms, ImmutableTerm otherTerm, TermFactory termFactory, VariableNullability variableNullability) {
        ImmutableList newSubTerms = (ImmutableList)terms.stream().map(t -> termFactory.getStrictEquality((ImmutableTerm)t, otherTerm, new ImmutableTerm[0])).collect(ImmutableCollectors.toList());
        return termFactory.getDBBooleanCoalesce((ImmutableList<ImmutableTerm>)newSubTerms).evaluate(variableNullability, true);
    }
}

