/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.type.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.type.NotYetTypedEqualityTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.type.impl.AbstractExpressionTransformer;
import it.unibz.inf.ontop.model.term.DBConstant;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.model.term.functionsymbol.NotYetTypedEqualityFunctionSymbol;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;

public class NotYetTypedEqualityTransformerImpl
implements NotYetTypedEqualityTransformer {
    private final IQTreeTransformer expressionTransformer;

    @Inject
    protected NotYetTypedEqualityTransformerImpl(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
        this.expressionTransformer = new ExpressionTransformer(iqFactory, typeExtractor, termFactory);
    }

    @Override
    public IQTree transform(IQTree tree) {
        return this.expressionTransformer.transform(tree);
    }

    protected static class ExpressionTransformer
    extends AbstractExpressionTransformer {
        protected ExpressionTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
            super(iqFactory, typeExtractor, termFactory);
        }

        @Override
        protected boolean isFunctionSymbolToReplace(FunctionSymbol functionSymbol) {
            return functionSymbol instanceof NotYetTypedEqualityFunctionSymbol;
        }

        @Override
        protected ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol functionSymbol, ImmutableList<ImmutableTerm> newTerms, IQTree tree) {
            if (newTerms.size() != 2) {
                throw new MinorOntopInternalBugException("Was expecting the not yet typed equalities to be binary");
            }
            ImmutableTerm term1 = (ImmutableTerm)newTerms.get(0);
            ImmutableTerm term2 = (ImmutableTerm)newTerms.get(1);
            ImmutableList extractedTypes = (ImmutableList)newTerms.stream().map(t -> this.typeExtractor.extractSingleTermType((ImmutableTerm)t, tree)).collect(ImmutableCollectors.toList());
            if (extractedTypes.stream().allMatch(type -> type.filter(t -> t instanceof DBTermType).isPresent())) {
                DBTermType type2;
                ImmutableList types = (ImmutableList)extractedTypes.stream().map(Optional::get).map(t -> (DBTermType)t).collect(ImmutableCollectors.toList());
                DBTermType type1 = (DBTermType)types.get(0);
                return type1.equals(type2 = (DBTermType)types.get(1)) ? this.transformSameTypeEquality(type1, term1, term2, tree) : this.transformDifferentTypesEquality(type1, type2, term1, term2);
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        private ImmutableExpression transformSameTypeEquality(DBTermType type, ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            if (type.areEqualitiesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            if (this.areIndependentFromConstants(term1, term2, tree) && type.areEqualitiesBetweenTwoDBAttributesStrict()) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            switch (type.getCategory()) {
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                }
                case DATETIME: {
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected ImmutableExpression transformDifferentTypesEquality(DBTermType type1, DBTermType type2, ImmutableTerm term1, ImmutableTerm term2) {
            if (this.areCompatibleForStrictEq(type1, type2)) {
                return this.termFactory.getStrictEquality(term1, term2, new ImmutableTerm[0]);
            }
            DBTermType.Category category1 = type1.getCategory();
            DBTermType.Category category2 = type2.getCategory();
            switch (category1) {
                case INTEGER: 
                case STRING: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DECIMAL: 
                case FLOAT_DOUBLE: {
                    switch (category2) {
                        case DECIMAL: 
                        case FLOAT_DOUBLE: 
                        case INTEGER: {
                            return this.termFactory.getDBNonStrictNumericEquality(term1, term2);
                        }
                    }
                    break;
                }
                case DATETIME: {
                    if (category2 != DBTermType.Category.DATETIME) break;
                    return this.termFactory.getDBNonStrictDatetimeEquality(term1, term2);
                }
            }
            return this.termFactory.getDBNonStrictDefaultEquality(term1, term2);
        }

        protected boolean areIndependentFromConstants(ImmutableTerm term1, ImmutableTerm term2, IQTree tree) {
            return !(term1 instanceof DBConstant) && !(term2 instanceof DBConstant);
        }

        private boolean areCompatibleForStrictEq(DBTermType type1, DBTermType type2) {
            return Stream.of(type1.areEqualitiesStrict(type2), type2.areEqualitiesStrict(type1)).filter(Optional::isPresent).map(Optional::get).reduce((b1, b2) -> b1 != false && b2 != false).orElse(false);
        }
    }
}

