/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.type.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtendedProjectionNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.NativeNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.type.DBTermType;
import it.unibz.inf.ontop.model.type.TermType;
import it.unibz.inf.ontop.model.type.TermTypeInference;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

@Singleton
public class BasicSingleTermTypeExtractor
implements SingleTermTypeExtractor {
    private final TermFactory termFactory;

    @Inject
    private BasicSingleTermTypeExtractor(TermFactory termFactory) {
        this.termFactory = termFactory;
    }

    @Override
    public Optional<TermType> extractSingleTermType(ImmutableTerm term, IQTree subTree) {
        return term instanceof Variable ? this.extractTypeFromVariable((Variable)term, subTree) : this.extractType((NonVariableTerm)term, subTree);
    }

    private Optional<TermType> extractTypeFromVariable(Variable variable, IQTree subTree) {
        return subTree.acceptVisitor(new TermTypeVariableVisitor(variable, this));
    }

    private Optional<TermType> extractType(NonVariableTerm nonVariableTerm, IQTree subTree) {
        return nonVariableTerm.inferType().or(() -> this.inferByInjectingSubTermType(nonVariableTerm, subTree)).flatMap(i -> i.getTermType().or(() -> i.getRedirectionVariable().flatMap(v -> this.extractTypeFromVariable((Variable)v, subTree))));
    }

    private Optional<TermTypeInference> inferByInjectingSubTermType(NonVariableTerm nonVariableTerm, IQTree subTree) {
        ImmutableList newTerms;
        if (!(nonVariableTerm instanceof ImmutableFunctionalTerm) || !((ImmutableFunctionalTerm)nonVariableTerm).getFunctionSymbol().canDeriveTypeFromInputTypes()) {
            return Optional.empty();
        }
        ImmutableFunctionalTerm functionalTerm = (ImmutableFunctionalTerm)nonVariableTerm;
        ImmutableList<? extends ImmutableTerm> terms = functionalTerm.getTerms();
        if (terms.equals((Object)(newTerms = (ImmutableList)functionalTerm.getTerms().stream().map(t -> this.extractSingleTermType((ImmutableTerm)t, subTree).filter(tp -> tp instanceof DBTermType).map(tp -> this.termFactory.getDBCastFunctionalTerm((DBTermType)tp, (ImmutableTerm)t)).orElse((ImmutableTerm)t)).collect(ImmutableCollectors.toList())))) {
            return Optional.empty();
        }
        return this.termFactory.getImmutableFunctionalTerm(functionalTerm.getFunctionSymbol(), (ImmutableList<? extends ImmutableTerm>)newTerms).inferType();
    }

    protected static class TermTypeVariableVisitor
    implements IQVisitor<Optional<TermType>> {
        protected final Variable variable;
        protected final SingleTermTypeExtractor typeExtractor;

        protected TermTypeVariableVisitor(Variable variable, SingleTermTypeExtractor typeExtractor) {
            this.variable = variable;
            this.typeExtractor = typeExtractor;
        }

        @Override
        public Optional<TermType> visitIntensionalData(IntensionalDataNode dataNode) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitExtensionalData(ExtensionalDataNode dataNode) {
            RelationDefinition relationDefinition = dataNode.getRelationDefinition();
            return dataNode.getArgumentMap().entrySet().stream().filter(e -> ((VariableOrGroundTerm)e.getValue()).equals(this.variable)).map(e -> relationDefinition.getAttribute((Integer)e.getKey() + 1)).map(Attribute::getTermType).map(o -> o).filter(o -> !o.isAbstract()).findAny();
        }

        @Override
        public Optional<TermType> visitEmpty(EmptyNode node) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitTrue(TrueNode node) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitNative(NativeNode nativeNode) {
            return Optional.ofNullable((TermType)nativeNode.getTypeMap().get((Object)this.variable));
        }

        @Override
        public Optional<TermType> visitValues(ValuesNode valuesNode) {
            ImmutableSet termTypes = (ImmutableSet)valuesNode.getValueStream(this.variable).flatMap(c -> c.getOptionalType().stream()).collect(ImmutableCollectors.toSet());
            return termTypes.stream().findAny();
        }

        @Override
        public Optional<TermType> visitNonStandardLeafNode(LeafIQTree leafNode) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitConstruction(ConstructionNode rootNode, IQTree child) {
            return this.visitExtendedProjection(rootNode, child);
        }

        @Override
        public Optional<TermType> visitAggregation(AggregationNode rootNode, IQTree child) {
            return this.visitExtendedProjection(rootNode, child);
        }

        protected Optional<TermType> visitExtendedProjection(ExtendedProjectionNode rootNode, IQTree child) {
            return this.typeExtractor.extractSingleTermType(rootNode.getSubstitution().apply(this.variable), child);
        }

        @Override
        public Optional<TermType> visitFilter(FilterNode rootNode, IQTree child) {
            return child.acceptVisitor(this);
        }

        @Override
        public Optional<TermType> visitFlatten(FlattenNode flattenNode, IQTree child) {
            if (this.variable.equals(flattenNode.getOutputVariable())) {
                return flattenNode.inferOutputType(Optional.of(flattenNode.getFlattenedType()));
            }
            if (flattenNode.getIndexVariable().isPresent() && this.variable.equals(flattenNode.getIndexVariable().get())) {
                return flattenNode.getIndexVariableType();
            }
            return child.acceptVisitor(this);
        }

        @Override
        public Optional<TermType> visitDistinct(DistinctNode rootNode, IQTree child) {
            return child.acceptVisitor(this);
        }

        @Override
        public Optional<TermType> visitSlice(SliceNode sliceNode, IQTree child) {
            return child.acceptVisitor(this);
        }

        @Override
        public Optional<TermType> visitOrderBy(OrderByNode rootNode, IQTree child) {
            return child.acceptVisitor(this);
        }

        @Override
        public Optional<TermType> visitNonStandardUnaryNode(UnaryOperatorNode rootNode, IQTree child) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitLeftJoin(LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            if (leftChild.getVariables().contains((Object)this.variable)) {
                return leftChild.acceptVisitor(this);
            }
            if (rightChild.getVariables().contains((Object)this.variable)) {
                return rightChild.acceptVisitor(this);
            }
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitNonStandardBinaryNonCommutativeNode(BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            return Optional.empty();
        }

        @Override
        public Optional<TermType> visitInnerJoin(InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return children.stream().map(c -> c.acceptVisitor(this)).filter(Optional::isPresent).findAny().orElse(Optional.empty());
        }

        @Override
        public Optional<TermType> visitUnion(UnionNode rootNode, ImmutableList<IQTree> children) {
            ImmutableSet termTypes = (ImmutableSet)children.stream().map(c -> c.acceptVisitor(this)).flatMap(Optional::stream).collect(ImmutableCollectors.toSet());
            return termTypes.stream().findAny();
        }

        @Override
        public Optional<TermType> visitNonStandardNaryNode(NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            return Optional.empty();
        }
    }
}

