/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.type.impl;

import com.google.common.collect.ImmutableList;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.transform.impl.DefaultRecursiveIQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.type.SingleTermTypeExtractor;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonGroundTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.functionsymbol.FunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public abstract class AbstractExpressionTransformer
extends DefaultRecursiveIQTreeVisitingTransformer {
    protected final SingleTermTypeExtractor typeExtractor;
    protected final TermFactory termFactory;

    protected AbstractExpressionTransformer(IntermediateQueryFactory iqFactory, SingleTermTypeExtractor typeExtractor, TermFactory termFactory) {
        super(iqFactory);
        this.typeExtractor = typeExtractor;
        this.termFactory = termFactory;
    }

    @Override
    public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        Substitution<ImmutableTerm> initialSubstitution = rootNode.getSubstitution();
        Substitution<ImmutableTerm> newSubstitution = initialSubstitution.transform((T t) -> this.transformTerm((ImmutableTerm)t, child));
        return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(rootNode.getVariables(), newSubstitution), newChild);
    }

    @Override
    public IQTree transformAggregation(IQTree tree, AggregationNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        Substitution<ImmutableFunctionalTerm> initialSubstitution = rootNode.getSubstitution();
        Substitution<ImmutableFunctionalTerm> newSubstitution = initialSubstitution.transform((T t) -> this.transformFunctionalTerm((ImmutableFunctionalTerm)t, child));
        return newChild.equals(child) && newSubstitution.equals(initialSubstitution) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createAggregationNode(rootNode.getGroupingVariables(), newSubstitution), newChild);
    }

    @Override
    public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        ImmutableExpression initialExpression = rootNode.getFilterCondition();
        ImmutableExpression newExpression = this.transformExpression(initialExpression, tree);
        FilterNode newFilterNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeFilterCondition(newExpression);
        return newFilterNode.equals(rootNode) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(newFilterNode, newChild);
    }

    @Override
    public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
        IQTree newChild = this.transform(child);
        ImmutableList<OrderByNode.OrderComparator> initialComparators = rootNode.getComparators();
        ImmutableList newComparators = (ImmutableList)initialComparators.stream().map(c -> this.iqFactory.createOrderComparator(this.transformNonGroundTerm(c.getTerm(), tree), c.isAscending())).collect(ImmutableCollectors.toList());
        return newComparators.equals(initialComparators) && newChild.equals(child) ? tree : this.iqFactory.createUnaryIQTree(this.iqFactory.createOrderByNode((ImmutableList<OrderByNode.OrderComparator>)newComparators), newChild);
    }

    @Override
    public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
        IQTree newLeftChild = this.transform(leftChild);
        IQTree newRightChild = this.transform(rightChild);
        Optional<ImmutableExpression> initialExpression = rootNode.getOptionalFilterCondition();
        Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
        LeftJoinNode newLeftJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition((Optional)newExpression);
        return newLeftJoinNode.equals(rootNode) && newLeftChild.equals(leftChild) && newRightChild.equals(rightChild) ? tree : this.iqFactory.createBinaryNonCommutativeIQTree(newLeftJoinNode, newLeftChild, newRightChild);
    }

    @Override
    public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
        ImmutableList newChildren = (ImmutableList)children.stream().map(this::transform).collect(ImmutableCollectors.toList());
        Optional<ImmutableExpression> initialExpression = rootNode.getOptionalFilterCondition();
        Optional<ImmutableExpression> newExpression = initialExpression.map(e -> this.transformExpression((ImmutableExpression)e, tree));
        InnerJoinNode newJoinNode = newExpression.equals(initialExpression) ? rootNode : rootNode.changeOptionalFilterCondition((Optional)newExpression);
        return newJoinNode.equals(rootNode) && newChildren.equals(children) ? tree : this.iqFactory.createNaryIQTree(newJoinNode, (ImmutableList<IQTree>)newChildren);
    }

    protected ImmutableTerm transformTerm(ImmutableTerm term, IQTree tree) {
        return term instanceof ImmutableFunctionalTerm ? this.transformFunctionalTerm((ImmutableFunctionalTerm)term, tree) : term;
    }

    protected NonGroundTerm transformNonGroundTerm(NonGroundTerm term, IQTree tree) {
        return term instanceof ImmutableFunctionalTerm ? (NonGroundTerm)((Object)this.transformFunctionalTerm((ImmutableFunctionalTerm)((Object)term), tree)) : term;
    }

    protected ImmutableExpression transformExpression(ImmutableExpression expression, IQTree tree) {
        return (ImmutableExpression)this.transformFunctionalTerm(expression, tree);
    }

    protected ImmutableFunctionalTerm transformFunctionalTerm(ImmutableFunctionalTerm functionalTerm, IQTree tree) {
        ImmutableList<? extends ImmutableTerm> initialTerms = functionalTerm.getTerms();
        ImmutableList newTerms = (ImmutableList)initialTerms.stream().map(t -> this.transformTerm((ImmutableTerm)t, tree)).collect(ImmutableCollectors.toList());
        FunctionSymbol functionSymbol = functionalTerm.getFunctionSymbol();
        if (this.isFunctionSymbolToReplace(functionSymbol)) {
            return this.replaceFunctionSymbol(functionSymbol, (ImmutableList<ImmutableTerm>)newTerms, tree);
        }
        return newTerms.equals(initialTerms) ? functionalTerm : this.termFactory.getImmutableFunctionalTerm(functionSymbol, (ImmutableList<? extends ImmutableTerm>)newTerms);
    }

    protected abstract boolean isFunctionSymbolToReplace(FunctionSymbol var1);

    protected abstract ImmutableFunctionalTerm replaceFunctionSymbol(FunctionSymbol var1, ImmutableList<ImmutableTerm> var2, IQTree var3);
}

