/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.transform.impl;

import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.impl.QueryNodeRenamer;
import it.unibz.inf.ontop.iq.transform.QueryRenamer;
import it.unibz.inf.ontop.iq.transform.impl.HomogeneousIQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DistinctVariableOnlyDataAtom;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;

public class QueryRenamerImpl
implements QueryRenamer {
    private final InjectiveSubstitution<Variable> renamingSubstitution;
    private final IntermediateQueryFactory iqFactory;
    private final AtomFactory atomFactory;
    private final SubstitutionFactory substitutionFactory;

    @AssistedInject
    private QueryRenamerImpl(@Assisted InjectiveSubstitution<Variable> injectiveVar2VarSubstitution, IntermediateQueryFactory iqFactory, AtomFactory atomFactory, SubstitutionFactory substitutionFactory) {
        this.renamingSubstitution = injectiveVar2VarSubstitution;
        this.iqFactory = iqFactory;
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public IQ transform(IQ originalQuery) {
        if (this.renamingSubstitution.isEmpty()) {
            return originalQuery;
        }
        HomogeneousIQTreeVisitingTransformer iqTransformer = this.getIQTransformer();
        IQTree newIQTree = originalQuery.getTree().acceptTransformer(iqTransformer);
        DistinctVariableOnlyDataAtom atom = originalQuery.getProjectionAtom();
        ImmutableList<Variable> newArguments = this.substitutionFactory.apply(this.renamingSubstitution, atom.getArguments());
        DistinctVariableOnlyDataAtom newProjectionAtom = this.atomFactory.getDistinctVariableOnlyDataAtom((AtomPredicate)atom.getPredicate(), newArguments);
        return this.iqFactory.createIQ(newProjectionAtom, newIQTree);
    }

    @Override
    public IQTree transform(IQTree originalTree) {
        if (this.renamingSubstitution.isEmpty()) {
            return originalTree;
        }
        HomogeneousIQTreeVisitingTransformer iqTransformer = this.getIQTransformer();
        return originalTree.acceptTransformer(iqTransformer);
    }

    private HomogeneousIQTreeVisitingTransformer getIQTransformer() {
        QueryNodeRenamer nodeTransformer = new QueryNodeRenamer(this.iqFactory, this.renamingSubstitution, this.atomFactory, this.substitutionFactory);
        return new HomogeneousIQTreeVisitingTransformer(nodeTransformer, this.iqFactory);
    }
}

