/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.request.impl;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import javax.annotation.Nullable;

public class VariableNonRequirementImpl
implements VariableNonRequirement {
    private @Nullable ImmutableSet<Variable> nonRequiredVariables;
    private final ImmutableMap<Variable, ImmutableSet<Variable>> conditions;

    public VariableNonRequirementImpl(ImmutableMap<Variable, ImmutableSet<Variable>> conditions) {
        this.conditions = conditions;
    }

    public VariableNonRequirementImpl(ImmutableSet<Variable> variables) {
        this(variables.stream().collect(ImmutableCollectors.toMap(v -> v, v -> ImmutableSet.of())));
    }

    @Override
    public synchronized ImmutableSet<Variable> getNotRequiredVariables() {
        if (this.nonRequiredVariables == null) {
            this.nonRequiredVariables = this.conditions.keySet();
        }
        return this.nonRequiredVariables;
    }

    @Override
    public ImmutableSet<Variable> getCondition(Variable variable) {
        return (ImmutableSet)this.conditions.getOrDefault((Object)variable, (Object)ImmutableSet.of());
    }

    @Override
    public VariableNonRequirement filter(BiPredicate<Variable, ImmutableSet<Variable>> predicate) {
        return new VariableNonRequirementImpl(this.conditions.entrySet().stream().filter((? super T e) -> predicate.test((Variable)e.getKey(), (ImmutableSet)e.getValue())).collect(ImmutableCollectors.toMap()));
    }

    @Override
    public VariableNonRequirement rename(InjectiveSubstitution<Variable> renamingSubstitution, SubstitutionFactory substitutionFactory) {
        return new VariableNonRequirementImpl(this.conditions.entrySet().stream().collect(ImmutableCollectors.toMap(e -> substitutionFactory.apply((Substitution<Variable>)renamingSubstitution, (Variable)e.getKey()), e -> substitutionFactory.apply((Substitution<Variable>)renamingSubstitution, (ImmutableSet<Variable>)((ImmutableSet)e.getValue())))));
    }

    @Override
    public ImmutableSet<Variable> computeVariablesToRemove(ImmutableSet<Variable> projectedVariables, ImmutableSet<Variable> requiredVariables) {
        ImmutableSet variablesToKeep;
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        HashSet variablesToRemove = Sets.newHashSet((Iterable)Sets.intersection((Set)Sets.difference(projectedVariables, requiredVariables), this.getNotRequiredVariables()));
        while (!(variablesToKeep = (ImmutableSet)variablesToRemove.stream().filter((? super T v) -> !variablesToRemove.containsAll((Collection<?>)this.getCondition((Variable)v))).collect(ImmutableCollectors.toSet())).isEmpty()) {
            variablesToRemove.removeAll((Collection<?>)variablesToKeep);
        }
        return ImmutableSet.copyOf((Collection)variablesToRemove);
    }

    @Override
    public boolean isEmpty() {
        return this.conditions.isEmpty();
    }

    @Override
    public VariableNonRequirement transformConditions(BiFunction<Variable, ImmutableSet<Variable>, ImmutableSet<Variable>> fct) {
        return new VariableNonRequirementImpl(this.conditions.entrySet().stream().collect(ImmutableCollectors.toMap(Map.Entry::getKey, e -> (ImmutableSet)fct.apply((Variable)e.getKey(), (ImmutableSet)e.getValue()))));
    }
}

