/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.injection.CoreSingletons;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.LeafIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.BinaryNonCommutativeOperatorNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.NaryOperatorNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.node.normalization.ConstructionSubstitutionNormalizer;
import it.unibz.inf.ontop.iq.node.normalization.NotRequiredVariableRemover;
import it.unibz.inf.ontop.iq.transform.IQTreeTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.model.term.Constant;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Set;
import java.util.stream.IntStream;

@Singleton
public class NotRequiredVariableRemoverImpl
implements NotRequiredVariableRemover {
    private final CoreSingletons coreSingletons;
    private final IQTreeTools iqTreeTools;

    @Inject
    protected NotRequiredVariableRemoverImpl(CoreSingletons coreSingletons, IQTreeTools iqTreeTools) {
        this.coreSingletons = coreSingletons;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQTree optimize(IQTree tree, ImmutableSet<Variable> requiredVariables, VariableGenerator variableGenerator) {
        ImmutableSet<Variable> variables = tree.getVariables();
        if (variables.equals(requiredVariables)) {
            return tree;
        }
        ImmutableSet<Variable> variablesToRemove = tree.getVariableNonRequirement().computeVariablesToRemove(variables, requiredVariables);
        return this.removeNonRequiredVariables(tree, variablesToRemove, variableGenerator);
    }

    protected IQTree removeNonRequiredVariables(IQTree tree, ImmutableSet<Variable> variablesToRemove, VariableGenerator variableGenerator) {
        return new VariableRemoverTransformer(variablesToRemove, variableGenerator).transform(tree);
    }

    protected class VariableRemoverTransformer
    implements IQTreeVisitingTransformer {
        protected final ImmutableSet<Variable> variablesToRemove;
        protected final IntermediateQueryFactory iqFactory;
        protected final SubstitutionFactory substitutionFactory;
        protected final VariableGenerator variableGenerator;
        protected final ConstructionSubstitutionNormalizer substitutionNormalizer;

        public VariableRemoverTransformer(ImmutableSet<Variable> variablesToRemove, VariableGenerator variableGenerator) {
            this.variablesToRemove = variablesToRemove;
            this.variableGenerator = variableGenerator;
            this.iqFactory = NotRequiredVariableRemoverImpl.this.coreSingletons.getIQFactory();
            this.substitutionFactory = NotRequiredVariableRemoverImpl.this.coreSingletons.getSubstitutionFactory();
            this.substitutionNormalizer = NotRequiredVariableRemoverImpl.this.coreSingletons.getConstructionSubstitutionNormalizer();
        }

        protected IQTreeTransformer createNewTransformer(ImmutableSet<Variable> variablesToRemove) {
            return new VariableRemoverTransformer(variablesToRemove, this.variableGenerator);
        }

        @Override
        public IQTree transformIntensionalData(IntensionalDataNode rootNode) {
            return rootNode;
        }

        @Override
        public IQTree transformExtensionalData(ExtensionalDataNode rootNode) {
            ImmutableMap newArgumentMap = rootNode.getArgumentMap().entrySet().stream().filter(e -> !this.variablesToRemove.contains(e.getValue())).collect(ImmutableCollectors.toMap());
            return this.iqFactory.createExtensionalDataNode(rootNode.getRelationDefinition(), newArgumentMap);
        }

        @Override
        public IQTree transformEmpty(EmptyNode rootNode) {
            return this.iqFactory.createEmptyNode((ImmutableSet<Variable>)Sets.difference(rootNode.getVariables(), this.variablesToRemove).immutableCopy());
        }

        @Override
        public IQTree transformTrue(TrueNode rootNode) {
            return rootNode;
        }

        @Override
        public IQTree transformValues(ValuesNode valuesNode) {
            ImmutableList<Variable> orderedVariables = valuesNode.getOrderedVariables();
            int arity = orderedVariables.size();
            ImmutableList indexesToRemove = (ImmutableList)IntStream.range(0, arity).filter(i -> this.variablesToRemove.contains(orderedVariables.get(i))).boxed().collect(ImmutableCollectors.toList());
            ImmutableList newOrderedVariables = (ImmutableList)IntStream.range(0, arity).filter(i -> !indexesToRemove.contains((Object)i)).mapToObj(arg_0 -> orderedVariables.get(arg_0)).collect(ImmutableCollectors.toList());
            ImmutableList newValues = (ImmutableList)valuesNode.getValues().stream().map(t -> (ImmutableList)IntStream.range(0, arity).filter(i -> !indexesToRemove.contains((Object)i)).mapToObj(arg_0 -> t.get(arg_0)).collect(ImmutableCollectors.toList())).collect(ImmutableCollectors.toList());
            return this.iqFactory.createValuesNode((ImmutableList<Variable>)newOrderedVariables, (ImmutableList<ImmutableList<Constant>>)newValues);
        }

        @Override
        public IQTree transformNonStandardLeafNode(LeafIQTree rootNode) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformConstruction(IQTree tree, ConstructionNode rootNode, IQTree child) {
            ImmutableSet variablesToKeep = Sets.difference(tree.getVariables(), this.variablesToRemove).immutableCopy();
            ConstructionSubstitutionNormalizer.ConstructionSubstitutionNormalization normalization = this.substitutionNormalizer.normalizeSubstitution(rootNode.getSubstitution(), (ImmutableSet<Variable>)variablesToKeep);
            ConstructionNode newConstructionNode = this.iqFactory.createConstructionNode((ImmutableSet<Variable>)variablesToKeep, normalization.getNormalizedSubstitution());
            IQTree newChild = normalization.updateChild(child, this.variableGenerator);
            return this.iqFactory.createUnaryIQTree(newConstructionNode, newChild).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformAggregation(IQTree tree, AggregationNode aggregationNode, IQTree child) {
            AggregationNode newAggregationNode = this.iqFactory.createAggregationNode(aggregationNode.getGroupingVariables(), aggregationNode.getSubstitution().removeFromDomain((Set<Variable>)this.variablesToRemove));
            return this.iqFactory.createUnaryIQTree(newAggregationNode, child).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformFilter(IQTree tree, FilterNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformFlatten(IQTree tree, FlattenNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformDistinct(IQTree tree, DistinctNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformSlice(IQTree tree, SliceNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformOrderBy(IQTree tree, OrderByNode rootNode, IQTree child) {
            return this.iqFactory.createUnaryIQTree(rootNode, this.transform(child));
        }

        @Override
        public IQTree transformNonStandardUnaryNode(IQTree tree, UnaryOperatorNode rootNode, IQTree child) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformLeftJoin(IQTree tree, LeftJoinNode rootNode, IQTree leftChild, IQTree rightChild) {
            if (rootNode.getOptionalFilterCondition().filter(c -> c.getVariableStream().anyMatch(arg_0 -> this.variablesToRemove.contains(arg_0))).isPresent()) {
                return this.transformNonUniqueChild(leftChild);
            }
            return this.iqFactory.createBinaryNonCommutativeIQTree(rootNode, this.transformNonUniqueChild(leftChild), this.transformNonUniqueChild(rightChild));
        }

        private IQTree transformNonUniqueChild(IQTree child) {
            ImmutableSet childVariablesToRemove = Sets.intersection(child.getVariables(), this.variablesToRemove).immutableCopy();
            return childVariablesToRemove.isEmpty() ? child : (childVariablesToRemove.equals(this.variablesToRemove) ? this.transform(child) : this.createNewTransformer((ImmutableSet<Variable>)childVariablesToRemove).transform(child));
        }

        @Override
        public IQTree transformNonStandardBinaryNonCommutativeNode(IQTree tree, BinaryNonCommutativeOperatorNode rootNode, IQTree leftChild, IQTree rightChild) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }

        @Override
        public IQTree transformInnerJoin(IQTree tree, InnerJoinNode rootNode, ImmutableList<IQTree> children) {
            return this.iqFactory.createNaryIQTree(rootNode, (ImmutableList<IQTree>)((ImmutableList)children.stream().map(this::transformNonUniqueChild).collect(ImmutableCollectors.toList())));
        }

        @Override
        public IQTree transformUnion(IQTree tree, UnionNode rootNode, ImmutableList<IQTree> children) {
            ImmutableSet newVariables = Sets.difference(rootNode.getVariables(), this.variablesToRemove).immutableCopy();
            UnionNode newUnionNode = this.iqFactory.createUnionNode((ImmutableSet<Variable>)newVariables);
            if (rootNode.equals(newUnionNode)) {
                return tree.normalizeForOptimization(this.variableGenerator);
            }
            ImmutableList newChildren = (ImmutableList)children.stream().map(c -> NotRequiredVariableRemoverImpl.this.iqTreeTools.createConstructionNodeTreeIfNontrivial((IQTree)c, (ImmutableSet<Variable>)newVariables)).collect(ImmutableCollectors.toList());
            return this.iqFactory.createNaryIQTree(newUnionNode, (ImmutableList<IQTree>)newChildren).normalizeForOptimization(this.variableGenerator);
        }

        @Override
        public IQTree transformNonStandardNaryNode(IQTree tree, NaryOperatorNode rootNode, ImmutableList<IQTree> children) {
            throw new RuntimeException("No generic method for non-standard nodes. Please extend this class");
        }
    }
}

