/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.IQTreeCache;
import it.unibz.inf.ontop.iq.NaryIQTree;
import it.unibz.inf.ontop.iq.UnaryIQTree;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.QueryNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.FilterNormalizer;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Optional;
import java.util.stream.Stream;

@Singleton
public class FilterNormalizerImpl
implements FilterNormalizer {
    private static final int MAX_NORMALIZATION_ITERATIONS = 10000;
    private final IntermediateQueryFactory iqFactory;
    private final TermFactory termFactory;
    private final ConditionSimplifier conditionSimplifier;
    private final IQTreeTools iqTreeTools;

    @Inject
    private FilterNormalizerImpl(IntermediateQueryFactory iqFactory, TermFactory termFactory, ConditionSimplifier conditionSimplifier, IQTreeTools iqTreeTools) {
        this.iqFactory = iqFactory;
        this.termFactory = termFactory;
        this.conditionSimplifier = conditionSimplifier;
        this.iqTreeTools = iqTreeTools;
    }

    @Override
    public IQTree normalizeForOptimization(FilterNode initialFilterNode, IQTree initialChild, VariableGenerator variableGenerator, IQTreeCache treeCache) {
        State state = new State(initialFilterNode, initialChild).normalizeChild(variableGenerator);
        for (int i = 0; i < 10000; ++i) {
            State stateBeforeSimplification = state.liftBindingsAndDistinct().mergeWithChild();
            State newState = stateBeforeSimplification.simplifyAndPropagateDownConstraint(variableGenerator).normalizeChild(variableGenerator);
            if (newState.child.equals(state.child)) {
                return newState.createNormalizedTree(variableGenerator, treeCache);
            }
            state = newState;
        }
        throw new MinorOntopInternalBugException("Bug: FilterNode.normalizeForOptimization() did not converge after 10000 iterations");
    }

    protected class State {
        private final ImmutableSet<Variable> projectedVariables;
        private final ImmutableList<UnaryOperatorNode> ancestors;
        private final Optional<ImmutableExpression> condition;
        private final IQTree child;

        protected State(FilterNode initialFilterNode, IQTree initialChild) {
            this.projectedVariables = initialChild.getVariables();
            this.ancestors = ImmutableList.of();
            this.condition = Optional.of(initialFilterNode.getFilterCondition());
            this.child = initialChild;
        }

        protected State(ImmutableSet<Variable> projectedVariables, ImmutableList<UnaryOperatorNode> ancestors, Optional<ImmutableExpression> condition, IQTree child) {
            this.projectedVariables = projectedVariables;
            this.ancestors = ancestors;
            this.condition = condition;
            this.child = child;
        }

        private State updateChild(IQTree newChild) {
            return new State(this.projectedVariables, this.ancestors, this.condition, newChild);
        }

        private State updateParentChildAndCondition(UnaryOperatorNode newParent, ImmutableExpression newCondition, IQTree newChild) {
            ImmutableList<UnaryOperatorNode> newAncestors = this.extendAncestors(newParent);
            return new State(this.projectedVariables, newAncestors, Optional.of(newCondition), newChild);
        }

        private State addParentRemoveConditionAndUpdateChild(UnaryOperatorNode newParent, IQTree newChild) {
            ImmutableList<UnaryOperatorNode> newAncestors = this.extendAncestors(newParent);
            return new State(this.projectedVariables, newAncestors, Optional.empty(), newChild);
        }

        private ImmutableList<UnaryOperatorNode> extendAncestors(UnaryOperatorNode newNode) {
            return (ImmutableList)Stream.concat(Stream.of(newNode), this.ancestors.stream()).collect(ImmutableCollectors.toList());
        }

        private State liftChildAsParent(UnaryIQTree formerChildTree) {
            ImmutableList<UnaryOperatorNode> newAncestors = this.extendAncestors((UnaryOperatorNode)formerChildTree.getRootNode());
            IQTree newChild = formerChildTree.getChild();
            return new State(this.projectedVariables, newAncestors, this.condition, newChild);
        }

        private State updateConditionAndChild(ImmutableExpression newCondition, IQTree newChild) {
            return new State(this.projectedVariables, this.ancestors, Optional.of(newCondition), newChild);
        }

        private State removeConditionAndUpdateChild(IQTree newChild) {
            return new State(this.projectedVariables, this.ancestors, Optional.empty(), newChild);
        }

        private State createEmptyState() {
            return new State(this.projectedVariables, (ImmutableList<UnaryOperatorNode>)ImmutableList.of(), Optional.empty(), FilterNormalizerImpl.this.iqFactory.createEmptyNode(this.projectedVariables));
        }

        public State normalizeChild(VariableGenerator variableGenerator) {
            return this.updateChild(this.child.normalizeForOptimization(variableGenerator));
        }

        public IQTree createNormalizedTree(VariableGenerator variableGenerator, IQTreeCache treeCache) {
            if (this.child.isDeclaredAsEmpty()) {
                return FilterNormalizerImpl.this.iqFactory.createEmptyNode(this.projectedVariables);
            }
            IQTree filterLevelTree = this.condition.map(FilterNormalizerImpl.this.iqFactory::createFilterNode).map(n -> FilterNormalizerImpl.this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, this.child, treeCache.declareAsNormalizedForOptimizationWithEffect())).orElse(this.child);
            if (this.ancestors.isEmpty()) {
                return filterLevelTree;
            }
            return FilterNormalizerImpl.this.iqTreeTools.createAncestorsUnaryIQTree(this.ancestors, filterLevelTree).normalizeForOptimization(variableGenerator);
        }

        public State liftBindingsAndDistinct() {
            QueryNode childRoot = this.child.getRootNode();
            if (childRoot instanceof ConstructionNode) {
                ConstructionNode constructionNode = (ConstructionNode)childRoot;
                UnaryIQTree childTree = (UnaryIQTree)this.child;
                return this.condition.map(e -> constructionNode.getSubstitution().apply((ImmutableExpression)e)).map(e -> this.updateParentChildAndCondition(constructionNode, (ImmutableExpression)e, childTree.getChild())).orElseGet(() -> this.liftChildAsParent(childTree)).liftBindingsAndDistinct();
            }
            if (childRoot instanceof DistinctNode) {
                UnaryIQTree childTree = (UnaryIQTree)this.child;
                return this.condition.map(e -> this.updateParentChildAndCondition((DistinctNode)childRoot, (ImmutableExpression)e, childTree.getChild())).orElseGet(() -> this.liftChildAsParent(childTree)).liftBindingsAndDistinct();
            }
            return this;
        }

        public State mergeWithChild() {
            if (this.condition.isPresent()) {
                QueryNode childRoot = this.child.getRootNode();
                if (childRoot instanceof FilterNode) {
                    FilterNode filterChild = (FilterNode)childRoot;
                    ImmutableExpression newCondition = FilterNormalizerImpl.this.termFactory.getConjunction(this.condition.get(), filterChild.getFilterCondition());
                    return this.updateConditionAndChild(newCondition, ((UnaryIQTree)this.child).getChild());
                }
                if (childRoot instanceof InnerJoinNode) {
                    ImmutableExpression newJoiningCondition = ((InnerJoinNode)childRoot).getOptionalFilterCondition().map(c -> FilterNormalizerImpl.this.termFactory.getConjunction(this.condition.get(), (ImmutableExpression)c)).orElse(this.condition.get());
                    NaryIQTree newChild = FilterNormalizerImpl.this.iqFactory.createNaryIQTree(FilterNormalizerImpl.this.iqFactory.createInnerJoinNode(newJoiningCondition), this.child.getChildren());
                    return this.removeConditionAndUpdateChild(newChild);
                }
            }
            return this;
        }

        public State simplifyAndPropagateDownConstraint(VariableGenerator variableGenerator) {
            if (!this.condition.isPresent()) {
                return this;
            }
            try {
                VariableNullability childVariableNullability = this.child.getVariableNullability();
                ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults = FilterNormalizerImpl.this.conditionSimplifier.simplifyCondition(this.condition.get(), (ImmutableList<IQTree>)ImmutableList.of((Object)this.child), childVariableNullability);
                Optional<ImmutableExpression> downConstraint = FilterNormalizerImpl.this.conditionSimplifier.computeDownConstraint(Optional.empty(), conditionSimplificationResults, childVariableNullability);
                IQTree newChild = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> this.child.applyDescendingSubstitution((Substitution<? extends VariableOrGroundTerm>)s, downConstraint, variableGenerator)).orElseGet(() -> downConstraint.map(c -> this.child.propagateDownConstraint((ImmutableExpression)c, variableGenerator)).orElse(this.child));
                Optional<ConstructionNode> parentConstructionNode = Optional.of(conditionSimplificationResults.getSubstitution()).filter(s -> !s.isEmpty()).map(s -> FilterNormalizerImpl.this.iqFactory.createConstructionNode(this.child.getVariables(), (Substitution<? extends ImmutableTerm>)s));
                return conditionSimplificationResults.getOptionalExpression().map(e -> parentConstructionNode.map(p -> this.updateParentChildAndCondition((UnaryOperatorNode)p, (ImmutableExpression)e, newChild)).orElseGet(() -> this.updateConditionAndChild((ImmutableExpression)e, newChild))).orElseGet(() -> parentConstructionNode.map(p -> this.addParentRemoveConditionAndUpdateChild((UnaryOperatorNode)p, newChild)).orElseGet(() -> this.removeConditionAndUpdateChild(newChild)));
            }
            catch (UnsatisfiableConditionException e2) {
                return this.createEmptyState();
            }
        }
    }
}

