/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.normalization.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.UnsatisfiableConditionException;
import it.unibz.inf.ontop.iq.node.normalization.ConditionSimplifier;
import it.unibz.inf.ontop.iq.node.normalization.impl.ExpressionAndSubstitutionImpl;
import it.unibz.inf.ontop.model.term.GroundFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.NonFunctionalTerm;
import it.unibz.inf.ontop.model.term.TermFactory;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.model.term.functionsymbol.db.DBStrictEqFunctionSymbol;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Collection;
import java.util.Comparator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;

@Singleton
public class ConditionSimplifierImpl
implements ConditionSimplifier {
    private final SubstitutionFactory substitutionFactory;
    private final TermFactory termFactory;

    @Inject
    private ConditionSimplifierImpl(SubstitutionFactory substitutionFactory, TermFactory termFactory) {
        this.substitutionFactory = substitutionFactory;
        this.termFactory = termFactory;
    }

    @Override
    public ConditionSimplifier.ExpressionAndSubstitution simplifyCondition(ImmutableExpression expression, ImmutableList<IQTree> children, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        return this.simplifyCondition(Optional.of(expression), (ImmutableSet<Variable>)ImmutableSet.of(), children, variableNullability);
    }

    @Override
    public ConditionSimplifier.ExpressionAndSubstitution simplifyCondition(Optional<ImmutableExpression> nonOptimizedExpression, ImmutableSet<Variable> nonLiftableVariables, ImmutableList<IQTree> children, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        if (nonOptimizedExpression.isPresent()) {
            Optional<ImmutableExpression> optionalExpression = this.evaluateCondition(nonOptimizedExpression.get(), variableNullability);
            if (optionalExpression.isPresent()) {
                return this.convertIntoExpressionAndSubstitution(optionalExpression.get(), nonLiftableVariables, children, variableNullability);
            }
            return new ExpressionAndSubstitutionImpl(Optional.empty(), this.substitutionFactory.getSubstitution());
        }
        return new ExpressionAndSubstitutionImpl(Optional.empty(), this.substitutionFactory.getSubstitution());
    }

    private Optional<ImmutableExpression> evaluateCondition(ImmutableExpression expression, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        ImmutableExpression.Evaluation results = expression.evaluate2VL(variableNullability);
        if (results.isEffectiveFalse()) {
            throw new UnsatisfiableConditionException();
        }
        return results.getExpression();
    }

    private ConditionSimplifier.ExpressionAndSubstitution convertIntoExpressionAndSubstitution(ImmutableExpression expression, ImmutableSet<Variable> nonLiftableVariables, ImmutableList<IQTree> children, VariableNullability variableNullability) throws UnsatisfiableConditionException {
        ImmutableSet expressions = (ImmutableSet)expression.flattenAND().collect(ImmutableCollectors.toSet());
        ImmutableSet functionFreeEqualities = (ImmutableSet)expressions.stream().filter(e -> e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).filter(e -> e.getTerms().stream().allMatch(t -> t instanceof NonFunctionalTerm)).collect(ImmutableCollectors.toSet());
        Substitution normalizedUnifier = this.substitutionFactory.onNonFunctionalTerms().unifierBuilder().unify(functionFreeEqualities.stream(), eq -> (NonFunctionalTerm)eq.getTerm(0), eq -> (NonFunctionalTerm)eq.getTerm(1)).build().map(u -> this.substitutionFactory.onNonFunctionalTerms().compose((Substitution<NonFunctionalTerm>)this.substitutionFactory.getPrioritizingRenaming((Substitution<?>)u, nonLiftableVariables), (Substitution<NonFunctionalTerm>)u)).orElseThrow(UnsatisfiableConditionException::new);
        ImmutableSet rejectedByChildrenVariablesEqToConstant = (ImmutableSet)normalizedUnifier.getDomain().stream().filter(v -> children.stream().filter(c -> c.getVariables().contains(v)).allMatch(c -> c.getRootNode().wouldKeepDescendingGroundTermInFilterAbove((Variable)v, true))).collect(ImmutableCollectors.toSet());
        Sets.SetView variablesToRemainInEqualities = Sets.union(nonLiftableVariables, (Set)rejectedByChildrenVariablesEqToConstant);
        Optional<ImmutableExpression> partiallySimplifiedExpression = this.termFactory.getConjunction(Stream.concat(expressions.stream().filter(e -> !functionFreeEqualities.contains(e)).map(normalizedUnifier::apply), normalizedUnifier.builder().restrictDomainTo((Set<Variable>)variablesToRemainInEqualities).toStream((x$0, x$1) -> this.termFactory.getStrictEquality((ImmutableTerm)x$0, (ImmutableTerm)x$1, new ImmutableTerm[0])).sorted(Comparator.comparing(eq -> (Variable)eq.getTerm(0)))));
        Optional groundFunctionalSubstitution = partiallySimplifiedExpression.flatMap(e -> this.extractGroundFunctionalSubstitution(expression, children));
        Optional<ImmutableExpression> newExpression = groundFunctionalSubstitution.isPresent() ? this.evaluateCondition(((Substitution)groundFunctionalSubstitution.get()).apply(partiallySimplifiedExpression.get()), variableNullability) : partiallySimplifiedExpression;
        Substitution<VariableOrGroundTerm> ascendingSubstitution = this.substitutionFactory.union(normalizedUnifier.removeFromDomain((Set<Variable>)variablesToRemainInEqualities), groundFunctionalSubstitution.orElseGet(this.substitutionFactory::getSubstitution));
        return new ExpressionAndSubstitutionImpl(newExpression, ascendingSubstitution);
    }

    @Override
    public Optional<ImmutableExpression> computeDownConstraint(Optional<ImmutableExpression> optionalConstraint, ConditionSimplifier.ExpressionAndSubstitution conditionSimplificationResults, VariableNullability childVariableNullability) throws UnsatisfiableConditionException {
        if (optionalConstraint.isPresent()) {
            ImmutableExpression substitutedConstraint = conditionSimplificationResults.getSubstitution().apply(optionalConstraint.get());
            ImmutableExpression combinedExpression = conditionSimplificationResults.getOptionalExpression().flatMap(e -> this.termFactory.getConjunction(Stream.of(e, substitutedConstraint))).orElse(substitutedConstraint);
            ImmutableExpression.Evaluation evaluationResults = combinedExpression.evaluate2VL(childVariableNullability);
            if (evaluationResults.isEffectiveFalse()) {
                throw new UnsatisfiableConditionException();
            }
            return evaluationResults.getExpression();
        }
        return conditionSimplificationResults.getOptionalExpression();
    }

    private Optional<Substitution<GroundFunctionalTerm>> extractGroundFunctionalSubstitution(ImmutableExpression expression, ImmutableList<IQTree> children) {
        ImmutableMultimap binaryEqualitiesSubset = expression.flattenAND().filter(e -> e.getFunctionSymbol() instanceof DBStrictEqFunctionSymbol).map(ImmutableFunctionalTerm::getTerms).filter(args -> args.stream().anyMatch(t -> t instanceof Variable) && args.stream().anyMatch(t -> t instanceof GroundFunctionalTerm) && args.stream().allMatch(t -> t instanceof Variable || t instanceof GroundFunctionalTerm)).flatMap(args -> args.stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).flatMap(v -> args.stream().filter(t -> t instanceof GroundFunctionalTerm).map(t -> (GroundFunctionalTerm)t).map(g -> Maps.immutableEntry((Object)v, (Object)g)))).collect(ImmutableCollectors.toMultimap());
        return Optional.of(binaryEqualitiesSubset).map(m -> m.asMap().entrySet().stream().filter(e -> children.stream().filter(c -> c.getVariables().contains(e.getKey())).anyMatch(c -> !c.getRootNode().wouldKeepDescendingGroundTermInFilterAbove((Variable)e.getKey(), false))).collect(this.substitutionFactory.toSubstitution(Map.Entry::getKey, e -> (GroundFunctionalTerm)((Collection)e.getValue()).iterator().next()))).filter(s -> !s.isEmpty());
    }
}

