/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.node.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import it.unibz.inf.ontop.dbschema.Attribute;
import it.unibz.inf.ontop.dbschema.FunctionalDependency;
import it.unibz.inf.ontop.dbschema.Lens;
import it.unibz.inf.ontop.dbschema.RelationDefinition;
import it.unibz.inf.ontop.dbschema.UniqueConstraint;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.injection.QueryTransformerFactory;
import it.unibz.inf.ontop.iq.IQ;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.exception.InvalidIntermediateQueryException;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.impl.IQTreeTools;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.QueryNodeVisitor;
import it.unibz.inf.ontop.iq.node.VariableNullability;
import it.unibz.inf.ontop.iq.node.impl.LeafIQTreeImpl;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.iq.request.VariableNonRequirement;
import it.unibz.inf.ontop.iq.transform.IQTreeExtendedTransformer;
import it.unibz.inf.ontop.iq.transform.IQTreeVisitingTransformer;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.iq.visit.IQVisitor;
import it.unibz.inf.ontop.model.term.NonVariableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class ExtensionalDataNodeImpl
extends LeafIQTreeImpl
implements ExtensionalDataNode {
    private static final String EXTENSIONAL_NODE_STR = "EXTENSIONAL";
    private final RelationDefinition relationDefinition;
    private final ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap;
    private @Nullable ImmutableSet<Variable> variables;
    private @Nullable VariableNonRequirement variableNonRequirement;
    private @Nullable VariableNullability variableNullability;
    private @Nullable ImmutableSet<ImmutableSet<Variable>> uniqueConstraints;
    private @Nullable Boolean isDistinct;
    private final CoreUtilsFactory coreUtilsFactory;
    private final SubstitutionFactory substitutionFactory;
    private final QueryTransformerFactory queryTransformerFactory;

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted RelationDefinition relationDefinition, @Assisted ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, SubstitutionFactory substitutionFactory, QueryTransformerFactory queryTransformerFactory) {
        this(relationDefinition, argumentMap, null, iqTreeTools, iqFactory, coreUtilsFactory, substitutionFactory, queryTransformerFactory);
    }

    @AssistedInject
    private ExtensionalDataNodeImpl(@Assisted RelationDefinition relationDefinition, @Assisted ImmutableMap<Integer, ? extends VariableOrGroundTerm> argumentMap, @Assisted @Nullable VariableNullability variableNullability, IQTreeTools iqTreeTools, IntermediateQueryFactory iqFactory, CoreUtilsFactory coreUtilsFactory, SubstitutionFactory substitutionFactory, QueryTransformerFactory queryTransformerFactory) {
        super(iqTreeTools, iqFactory);
        this.coreUtilsFactory = coreUtilsFactory;
        this.relationDefinition = relationDefinition;
        this.argumentMap = argumentMap;
        this.variableNullability = variableNullability;
        this.substitutionFactory = substitutionFactory;
        this.queryTransformerFactory = queryTransformerFactory;
    }

    @Override
    public RelationDefinition getRelationDefinition() {
        return this.relationDefinition;
    }

    @Override
    public ImmutableMap<Integer, ? extends VariableOrGroundTerm> getArgumentMap() {
        return this.argumentMap;
    }

    @Override
    public void acceptVisitor(QueryNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public ExtensionalDataNode acceptNodeTransformer(HomogeneousQueryNodeTransformer transformer) throws QueryNodeTransformationException {
        return transformer.transform(this);
    }

    @Override
    public IQTree applyDescendingSubstitutionWithoutOptimizing(Substitution<? extends VariableOrGroundTerm> descendingSubstitution, VariableGenerator variableGenerator) {
        ImmutableMap<Integer, ? extends VariableOrGroundTerm> newArguments = this.substitutionFactory.onVariableOrGroundTerms().applyToTerms(descendingSubstitution, this.argumentMap);
        return this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArguments);
    }

    @Override
    public IQTree acceptTransformer(IQTreeVisitingTransformer transformer) {
        return transformer.transformExtensionalData(this);
    }

    @Override
    public <T> IQTree acceptTransformer(IQTreeExtendedTransformer<T> transformer, T context) {
        return transformer.transformExtensionalData(this, context);
    }

    @Override
    public synchronized boolean isDistinct() {
        if (this.isDistinct == null) {
            this.isDistinct = this.relationDefinition.getUniqueConstraints().stream().map(FunctionalDependency::getDeterminants).anyMatch(this::areDeterminantsPresentAndNotNull);
        }
        return this.isDistinct;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean areDeterminantsPresentAndNotNull(ImmutableSet<Attribute> determinants) {
        ImmutableList arguments = (ImmutableList)determinants.stream().map(this::getArgument).collect(ImmutableCollectors.toList());
        VariableNullability variableNullability = this.getVariableNullability();
        if (!arguments.stream().allMatch(Optional::isPresent)) return false;
        if (!ExtensionalDataNodeImpl.getVariableStreamFrom((ImmutableList<Optional<? extends VariableOrGroundTerm>>)arguments).noneMatch(variableNullability::isPossiblyNullable)) return false;
        return true;
    }

    private Optional<? extends VariableOrGroundTerm> getArgument(Attribute a) {
        return Optional.ofNullable((VariableOrGroundTerm)this.argumentMap.get((Object)(a.getIndex() - 1)));
    }

    @Override
    public <T> T acceptVisitor(IQVisitor<T> visitor) {
        return visitor.visitExtensionalData(this);
    }

    @Override
    public IQTree applyFreshRenaming(InjectiveSubstitution<Variable> freshRenamingSubstitution) {
        ImmutableMap<Integer, ? extends VariableOrGroundTerm> newArgumentMap = this.substitutionFactory.onVariableOrGroundTerms().applyToTerms(freshRenamingSubstitution, this.argumentMap);
        return this.variableNullability == null ? this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArgumentMap) : this.iqFactory.createExtensionalDataNode(this.relationDefinition, newArgumentMap, this.variableNullability.applyFreshRenaming(freshRenamingSubstitution));
    }

    @Override
    public synchronized VariableNullability getVariableNullability() {
        if (this.variableNullability == null) {
            ImmutableMultiset argMultiset = ImmutableMultiset.copyOf((Iterable)this.argumentMap.values());
            ImmutableSet nullableGroups = (ImmutableSet)this.argumentMap.entrySet().stream().filter(e -> e.getValue() instanceof Variable).filter(e -> this.relationDefinition.getAttribute((Integer)e.getKey() + 1).isNullable()).map(Map.Entry::getValue).map(a -> (Variable)a).filter(a -> argMultiset.count(a) < 2).map(ImmutableSet::of).collect(ImmutableCollectors.toSet());
            this.variableNullability = this.coreUtilsFactory.createVariableNullability((ImmutableSet<ImmutableSet<Variable>>)nullableGroups, this.getVariables());
        }
        return this.variableNullability;
    }

    @Override
    public void validate() throws InvalidIntermediateQueryException {
    }

    @Override
    public synchronized ImmutableSet<ImmutableSet<Variable>> inferUniqueConstraints() {
        if (this.uniqueConstraints == null) {
            this.uniqueConstraints = (ImmutableSet)this.relationDefinition.getUniqueConstraints().stream().map(this::convertUniqueConstraint).flatMap(Optional::stream).collect(ImmutableCollectors.toSet());
        }
        return this.uniqueConstraints;
    }

    private Optional<ImmutableSet<Variable>> convertUniqueConstraint(UniqueConstraint uniqueConstraint) {
        ImmutableList arguments = (ImmutableList)uniqueConstraint.getDeterminants().stream().map(this::getArgument).collect(ImmutableCollectors.toList());
        if (!arguments.stream().allMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        return Optional.of(ExtensionalDataNodeImpl.getVariableSetFrom((ImmutableList<Optional<? extends VariableOrGroundTerm>>)arguments));
    }

    @Override
    public synchronized FunctionalDependencies inferFunctionalDependencies() {
        return this.relationDefinition.getOtherFunctionalDependencies().stream().map(this::convertFunctionalDependency).flatMap(Optional::stream).collect(FunctionalDependencies.toFunctionalDependencies()).concat(FunctionalDependencies.fromUniqueConstraints(this.inferUniqueConstraints(), this.getLocalVariables()));
    }

    private Optional<Map.Entry<ImmutableSet<Variable>, ImmutableSet<Variable>>> convertFunctionalDependency(FunctionalDependency functionalDependency) {
        ImmutableList determinants = (ImmutableList)functionalDependency.getDeterminants().stream().map(this::getArgument).collect(ImmutableCollectors.toList());
        ImmutableList dependents = (ImmutableList)functionalDependency.getDependents().stream().map(this::getArgument).collect(ImmutableCollectors.toList());
        if (!determinants.stream().allMatch(Optional::isPresent) || dependents.stream().noneMatch(Optional::isPresent)) {
            return Optional.empty();
        }
        return Optional.of(Maps.immutableEntry(ExtensionalDataNodeImpl.getVariableSetFrom((ImmutableList<Optional<? extends VariableOrGroundTerm>>)determinants), ExtensionalDataNodeImpl.getVariableSetFrom((ImmutableList<Optional<? extends VariableOrGroundTerm>>)dependents)));
    }

    private static ImmutableSet<Variable> getVariableSetFrom(ImmutableList<Optional<? extends VariableOrGroundTerm>> list) {
        return (ImmutableSet)ExtensionalDataNodeImpl.getVariableStreamFrom(list).collect(ImmutableCollectors.toSet());
    }

    private static Stream<Variable> getVariableStreamFrom(ImmutableList<Optional<? extends VariableOrGroundTerm>> list) {
        return list.stream().flatMap(Optional::stream).filter(t -> t instanceof Variable).map(v -> (Variable)v);
    }

    @Override
    public synchronized VariableNonRequirement getVariableNonRequirement() {
        if (this.variableNonRequirement == null) {
            ImmutableMultiset multiset = (ImmutableMultiset)this.argumentMap.values().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toMultiset());
            this.variableNonRequirement = VariableNonRequirement.of((ImmutableSet<Variable>)((ImmutableSet)multiset.entrySet().stream().filter(e -> e.getCount() == 1).map(Multiset.Entry::getElement).collect(ImmutableCollectors.toSet())));
        }
        return this.variableNonRequirement;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o instanceof ExtensionalDataNodeImpl) {
            ExtensionalDataNodeImpl that = (ExtensionalDataNodeImpl)o;
            return this.relationDefinition.equals(that.relationDefinition) && this.argumentMap.equals(that.argumentMap);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relationDefinition, this.argumentMap);
    }

    public String toString() {
        return String.format("%s %s(%s)", EXTENSIONAL_NODE_STR, this.relationDefinition.getAtomPredicate().getName(), this.argumentMap.entrySet().stream().map(e -> e.getKey() + ":" + e.getValue()).collect(Collectors.joining(",")));
    }

    @Override
    public ImmutableSet<Variable> getVariables() {
        return this.getLocalVariables();
    }

    @Override
    public synchronized ImmutableSet<Variable> getLocalVariables() {
        if (this.variables == null) {
            this.variables = (ImmutableSet)this.argumentMap.values().stream().filter(t -> t instanceof Variable).map(t -> (Variable)t).collect(ImmutableCollectors.toSet());
        }
        return this.variables;
    }

    @Override
    public ImmutableSet<Variable> getLocallyRequiredVariables() {
        return ImmutableSet.of();
    }

    @Override
    public ImmutableSet<Variable> getLocallyDefinedVariables() {
        return this.getLocalVariables();
    }

    @Override
    public ImmutableSet<Variable> getKnownVariables() {
        return this.getLocalVariables();
    }

    @Override
    public boolean isDeclaredAsEmpty() {
        return false;
    }

    @Override
    public ImmutableSet<Substitution<NonVariableTerm>> getPossibleVariableDefinitions() {
        if (this.relationDefinition instanceof Lens) {
            IQ iq = ((Lens)this.relationDefinition).getIQ();
            IQTree renamedTree = ExtensionalDataNodeImpl.merge(this, iq, this.coreUtilsFactory.createVariableGenerator((Collection<Variable>)this.getKnownVariables()), this.substitutionFactory, this.queryTransformerFactory, this.iqFactory);
            return renamedTree.getPossibleVariableDefinitions();
        }
        return ImmutableSet.of();
    }

    public static IQTree merge(ExtensionalDataNode dataNode, IQ definition, VariableGenerator variableGenerator, SubstitutionFactory substitutionFactory, QueryTransformerFactory transformerFactory, IntermediateQueryFactory iqFactory) {
        InjectiveSubstitution<Variable> renamingSubstitution = substitutionFactory.generateNotConflictingRenaming(variableGenerator, definition.getTree().getKnownVariables());
        IQ renamedDefinition = transformerFactory.createRenamer(renamingSubstitution).transform(definition);
        ImmutableList<Variable> sourceAtomArguments = substitutionFactory.apply(renamingSubstitution, renamedDefinition.getProjectionAtom().getArguments());
        Substitution<VariableOrGroundTerm> descendingSubstitution = dataNode.getArgumentMap().entrySet().stream().collect(substitutionFactory.toSubstitutionSkippingIdentityEntries(e -> (Variable)sourceAtomArguments.get(((Integer)e.getKey()).intValue()), Map.Entry::getValue));
        IQTree substitutedDefinition = renamedDefinition.getTree().applyDescendingSubstitution(descendingSubstitution, Optional.empty(), variableGenerator);
        return iqFactory.createUnaryIQTree(iqFactory.createConstructionNode(dataNode.getVariables()), substitutedDefinition).normalizeForOptimization(variableGenerator);
    }
}

