/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.exception.QueryNodeTransformationException;
import it.unibz.inf.ontop.iq.node.AggregationNode;
import it.unibz.inf.ontop.iq.node.ConstructionNode;
import it.unibz.inf.ontop.iq.node.DistinctNode;
import it.unibz.inf.ontop.iq.node.EmptyNode;
import it.unibz.inf.ontop.iq.node.ExtensionalDataNode;
import it.unibz.inf.ontop.iq.node.FilterNode;
import it.unibz.inf.ontop.iq.node.FlattenNode;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.IntensionalDataNode;
import it.unibz.inf.ontop.iq.node.LeftJoinNode;
import it.unibz.inf.ontop.iq.node.OrderByNode;
import it.unibz.inf.ontop.iq.node.SliceNode;
import it.unibz.inf.ontop.iq.node.TrueNode;
import it.unibz.inf.ontop.iq.node.UnionNode;
import it.unibz.inf.ontop.iq.node.ValuesNode;
import it.unibz.inf.ontop.iq.transform.node.HomogeneousQueryNodeTransformer;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.substitution.SubstitutionFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;

public class QueryNodeRenamer
implements HomogeneousQueryNodeTransformer {
    private final IntermediateQueryFactory iqFactory;
    private final InjectiveSubstitution<Variable> renamingSubstitution;
    private final AtomFactory atomFactory;
    private final SubstitutionFactory substitutionFactory;

    public QueryNodeRenamer(IntermediateQueryFactory iqFactory, InjectiveSubstitution<Variable> renamingSubstitution, AtomFactory atomFactory, SubstitutionFactory substitutionFactory) {
        this.iqFactory = iqFactory;
        this.renamingSubstitution = renamingSubstitution;
        this.atomFactory = atomFactory;
        this.substitutionFactory = substitutionFactory;
    }

    @Override
    public FilterNode transform(FilterNode filterNode) {
        ImmutableExpression booleanExpression = filterNode.getFilterCondition();
        return this.iqFactory.createFilterNode(this.renamingSubstitution.apply(booleanExpression));
    }

    @Override
    public ExtensionalDataNode transform(ExtensionalDataNode extensionalDataNode) {
        return this.iqFactory.createExtensionalDataNode(extensionalDataNode.getRelationDefinition(), this.substitutionFactory.onVariableOrGroundTerms().applyToTerms(this.renamingSubstitution, extensionalDataNode.getArgumentMap()));
    }

    @Override
    public LeftJoinNode transform(LeftJoinNode leftJoinNode) {
        Optional<ImmutableExpression> optionalExpression = leftJoinNode.getOptionalFilterCondition();
        return this.iqFactory.createLeftJoinNode(optionalExpression.map(this.renamingSubstitution::apply));
    }

    @Override
    public UnionNode transform(UnionNode unionNode) {
        return this.iqFactory.createUnionNode(this.substitutionFactory.apply(this.renamingSubstitution, unionNode.getVariables()));
    }

    @Override
    public IntensionalDataNode transform(IntensionalDataNode intensionalDataNode) {
        DataAtom<AtomPredicate> atom = intensionalDataNode.getProjectionAtom();
        return this.iqFactory.createIntensionalDataNode(this.atomFactory.getDataAtom(atom.getPredicate(), this.substitutionFactory.onVariableOrGroundTerms().applyToTerms(this.renamingSubstitution, atom.getArguments())));
    }

    @Override
    public InnerJoinNode transform(InnerJoinNode innerJoinNode) {
        Optional<ImmutableExpression> optionalExpression = innerJoinNode.getOptionalFilterCondition();
        return this.iqFactory.createInnerJoinNode(optionalExpression.map(this.renamingSubstitution::apply));
    }

    @Override
    public ConstructionNode transform(ConstructionNode constructionNode) {
        Substitution<ImmutableTerm> substitution = constructionNode.getSubstitution();
        return this.iqFactory.createConstructionNode(this.substitutionFactory.apply(this.renamingSubstitution, constructionNode.getVariables()), this.substitutionFactory.rename(this.renamingSubstitution, substitution));
    }

    @Override
    public AggregationNode transform(AggregationNode aggregationNode) throws QueryNodeTransformationException {
        Substitution<ImmutableFunctionalTerm> substitution = aggregationNode.getSubstitution();
        return this.iqFactory.createAggregationNode(this.substitutionFactory.apply(this.renamingSubstitution, aggregationNode.getGroupingVariables()), this.substitutionFactory.onImmutableFunctionalTerms().rename(this.renamingSubstitution, substitution));
    }

    @Override
    public FlattenNode transform(FlattenNode flattenNode) {
        return this.iqFactory.createFlattenNode(this.substitutionFactory.apply(this.renamingSubstitution, flattenNode.getOutputVariable()), this.substitutionFactory.apply(this.renamingSubstitution, flattenNode.getFlattenedVariable()), flattenNode.getIndexVariable().map(v -> this.substitutionFactory.apply((Substitution<Variable>)this.renamingSubstitution, (Variable)v)), flattenNode.getFlattenedType());
    }

    @Override
    public EmptyNode transform(EmptyNode emptyNode) {
        ImmutableSet<Variable> newVariables = this.substitutionFactory.apply(this.renamingSubstitution, emptyNode.getVariables());
        return this.iqFactory.createEmptyNode(newVariables);
    }

    @Override
    public TrueNode transform(TrueNode trueNode) {
        return this.iqFactory.createTrueNode();
    }

    @Override
    public ValuesNode transform(ValuesNode valuesNode) throws QueryNodeTransformationException {
        return this.iqFactory.createValuesNode(this.substitutionFactory.apply(this.renamingSubstitution, valuesNode.getOrderedVariables()), valuesNode.getValues());
    }

    @Override
    public DistinctNode transform(DistinctNode distinctNode) {
        return this.iqFactory.createDistinctNode();
    }

    @Override
    public SliceNode transform(SliceNode sliceNode) {
        return sliceNode.getLimit().map(l -> this.iqFactory.createSliceNode(sliceNode.getOffset(), (long)l)).orElseGet(() -> this.iqFactory.createSliceNode(sliceNode.getOffset()));
    }

    @Override
    public OrderByNode transform(OrderByNode orderByNode) {
        ImmutableList newComparators = (ImmutableList)orderByNode.getComparators().stream().map(c -> this.iqFactory.createOrderComparator(this.substitutionFactory.onNonGroundTerms().rename(this.renamingSubstitution, c.getTerm()), c.isAscending())).collect(ImmutableCollectors.toList());
        return this.iqFactory.createOrderByNode((ImmutableList<OrderByNode.OrderComparator>)newComparators);
    }
}

