/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.iq.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import it.unibz.inf.ontop.exception.MinorOntopInternalBugException;
import it.unibz.inf.ontop.injection.IntermediateQueryFactory;
import it.unibz.inf.ontop.iq.IQTree;
import it.unibz.inf.ontop.iq.node.InnerJoinNode;
import it.unibz.inf.ontop.iq.node.UnaryOperatorNode;
import it.unibz.inf.ontop.iq.request.FunctionalDependencies;
import it.unibz.inf.ontop.model.term.ImmutableExpression;
import it.unibz.inf.ontop.model.term.ImmutableFunctionalTerm;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.substitution.InjectiveSubstitution;
import it.unibz.inf.ontop.substitution.Substitution;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
public class IQTreeTools {
    private final IntermediateQueryFactory iqFactory;

    @Inject
    private IQTreeTools(IntermediateQueryFactory iqFactory) {
        this.iqFactory = iqFactory;
    }

    public static ImmutableSet<Variable> computeStrictDependentsFromFunctionalDependencies(IQTree tree) {
        FunctionalDependencies functionalDependencies = tree.inferFunctionalDependencies();
        ImmutableSet dependents = (ImmutableSet)functionalDependencies.stream().flatMap(e -> ((ImmutableSet)e.getValue()).stream()).collect(ImmutableCollectors.toSet());
        ImmutableSet determinants = (ImmutableSet)functionalDependencies.stream().flatMap(e -> ((ImmutableSet)e.getKey()).stream()).collect(ImmutableCollectors.toSet());
        return Sets.difference((Set)dependents, (Set)determinants).immutableCopy();
    }

    public Optional<Substitution<? extends VariableOrGroundTerm>> normalizeDescendingSubstitution(IQTree tree, Substitution<? extends VariableOrGroundTerm> descendingSubstitution) throws UnsatisfiableDescendingSubstitutionException {
        Substitution<? extends VariableOrGroundTerm> reducedSubstitution = descendingSubstitution.restrictDomainTo((Set<Variable>)tree.getVariables());
        if (reducedSubstitution.isEmpty()) {
            return Optional.empty();
        }
        if (reducedSubstitution.rangeAnyMatch(ImmutableTerm::isNull)) {
            throw new UnsatisfiableDescendingSubstitutionException();
        }
        return Optional.of(reducedSubstitution);
    }

    public ImmutableSet<Variable> computeNewProjectedVariables(Substitution<? extends ImmutableTerm> descendingSubstitution, ImmutableSet<Variable> projectedVariables) {
        ImmutableSet<Variable> newVariables = descendingSubstitution.restrictDomainTo((Set<Variable>)projectedVariables).getRangeVariables();
        return Sets.union(newVariables, (Set)Sets.difference(projectedVariables, descendingSubstitution.getDomain())).immutableCopy();
    }

    public IQTree createConstructionNodeTreeIfNontrivial(IQTree child, Substitution<?> substitution, Supplier<ImmutableSet<Variable>> projectedVariables) {
        return substitution.isEmpty() ? child : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(projectedVariables.get(), substitution), child);
    }

    public IQTree createConstructionNodeTreeIfNontrivial(IQTree child, ImmutableSet<Variable> variables) {
        return child.getVariables().equals(variables) ? child : this.iqFactory.createUnaryIQTree(this.iqFactory.createConstructionNode(variables), child);
    }

    public ImmutableSet<Variable> getChildrenVariables(ImmutableList<IQTree> children) {
        return (ImmutableSet)children.stream().flatMap(c -> c.getVariables().stream()).collect(ImmutableCollectors.toSet());
    }

    public ImmutableSet<Variable> getChildrenVariables(IQTree leftChild, IQTree rightChild) {
        return Sets.union(leftChild.getVariables(), rightChild.getVariables()).immutableCopy();
    }

    public ImmutableSet<Variable> getChildrenVariables(IQTree child, Variable newVariable) {
        return Sets.union(child.getVariables(), (Set)ImmutableSet.of((Object)newVariable)).immutableCopy();
    }

    public ImmutableSet<Variable> extractChildVariables(ImmutableSet<Variable> groupingVariables, Substitution<ImmutableFunctionalTerm> substitution) {
        return Sets.union(groupingVariables, substitution.getRangeVariables()).immutableCopy();
    }

    public IQTree createOptionalUnaryIQTree(Optional<? extends UnaryOperatorNode> optionalNode, IQTree tree) {
        return optionalNode.map(n -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)n, tree)).orElse(tree);
    }

    public IQTree createAncestorsUnaryIQTree(ImmutableList<? extends UnaryOperatorNode> ancestors, IQTree tree) {
        return ancestors.stream().reduce(tree, (t, a) -> this.iqFactory.createUnaryIQTree((UnaryOperatorNode)a, (IQTree)t), (t1, t2) -> {
            throw new MinorOntopInternalBugException("No merge was expected");
        });
    }

    public ImmutableList<IQTree> createUnaryOperatorChildren(UnaryOperatorNode node, IQTree child) {
        return (ImmutableList)child.getChildren().stream().map(c -> this.iqFactory.createUnaryIQTree(node, (IQTree)c)).collect(ImmutableCollectors.toList());
    }

    public InnerJoinNode createInnerJoinNode(Optional<ImmutableExpression> optionalExpression) {
        return optionalExpression.map(this.iqFactory::createInnerJoinNode).orElseGet(this.iqFactory::createInnerJoinNode);
    }

    public Optional<InjectiveSubstitution<Variable>> extractFreshRenaming(Substitution<? extends ImmutableTerm> descendingSubstitution, ImmutableSet<Variable> projectedVariables) {
        Substitution<Variable> var2VarFragment = descendingSubstitution.restrictRangeTo(Variable.class);
        int size = descendingSubstitution.getDomain().size();
        if (var2VarFragment.getDomain().size() != size || Sets.difference(var2VarFragment.getRangeSet(), projectedVariables).size() != size) {
            return Optional.empty();
        }
        return Optional.of(var2VarFragment.injective());
    }

    public static class UnsatisfiableDescendingSubstitutionException
    extends Exception {
    }
}

