/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import it.unibz.inf.ontop.constraints.Homomorphism;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.LinearInclusionDependencies;
import it.unibz.inf.ontop.constraints.impl.AbstractLinearInclusionDependencies;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.model.term.ImmutableTerm;
import it.unibz.inf.ontop.model.term.Variable;
import it.unibz.inf.ontop.model.term.VariableOrGroundTerm;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import it.unibz.inf.ontop.utils.ImmutableCollectors;
import it.unibz.inf.ontop.utils.VariableGenerator;
import java.util.Collection;
import java.util.stream.Stream;

public class LinearInclusionDependenciesImpl<P extends AtomPredicate>
extends AbstractLinearInclusionDependencies<P> {
    protected final AtomFactory atomFactory;
    protected final HomomorphismFactory homomorphismFactory;
    protected final ImmutableList<LinearInclusionDependency<P>> dependencies;
    private final VariableGenerator variableGenerator;

    protected LinearInclusionDependenciesImpl(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory, HomomorphismFactory homomorphismFactory, ImmutableList<LinearInclusionDependency<P>> dependencies) {
        this.atomFactory = atomFactory;
        this.homomorphismFactory = homomorphismFactory;
        this.dependencies = dependencies;
        this.variableGenerator = coreUtilsFactory.createVariableGenerator((Collection<Variable>)ImmutableSet.of());
    }

    @Override
    protected Stream<DataAtom<P>> chase(DataAtom<P> atom) {
        return this.dependencies.stream().flatMap(id -> this.chase((LinearInclusionDependency<P>)id, atom));
    }

    private Stream<DataAtom<P>> chase(LinearInclusionDependency<P> id, DataAtom<P> atom) {
        if (!id.getBody().getPredicate().equals(atom.getPredicate())) {
            return Stream.empty();
        }
        Homomorphism.Builder builder = this.homomorphismFactory.getHomomorphismBuilder();
        if (!builder.extend(id.getBody().getArguments(), atom.getArguments()).isValid()) {
            return Stream.empty();
        }
        Homomorphism h = this.extendWithLabelledNulls(id, builder.build());
        ImmutableList newArguments = (ImmutableList)id.getHead().getArguments().stream().map(h::apply).collect(ImmutableCollectors.toList());
        return Stream.of(this.atomFactory.getDataAtom(id.getHead().getPredicate(), (ImmutableList<? extends VariableOrGroundTerm>)newArguments));
    }

    @Override
    protected void registerVariables(DataAtom<P> atom) {
        this.variableGenerator.registerAdditionalVariables((Collection<Variable>)atom.getVariables());
    }

    protected Homomorphism extendWithLabelledNulls(LinearInclusionDependency<P> id, Homomorphism h) {
        Homomorphism.Builder builder = h.builder();
        ImmutableSet<Variable> bodyVariables = id.getBody().getVariables();
        id.getHead().getVariables().stream().filter(v -> !bodyVariables.contains(v)).forEach(v -> builder.extend((ImmutableTerm)v, this.variableGenerator.generateNewVariableFromVar((Variable)v)));
        return builder.build();
    }

    public String toString() {
        return this.dependencies.toString();
    }

    static class Builder<P extends AtomPredicate>
    implements LinearInclusionDependencies.Builder<P> {
        protected final ImmutableList.Builder<LinearInclusionDependency<P>> builder = ImmutableList.builder();
        protected final CoreUtilsFactory coreUtilsFactory;
        protected final AtomFactory atomFactory;
        protected final HomomorphismFactory homomorphismFactory;

        protected Builder(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory, HomomorphismFactory homomorphismFactory) {
            this.coreUtilsFactory = coreUtilsFactory;
            this.atomFactory = atomFactory;
            this.homomorphismFactory = homomorphismFactory;
        }

        @Override
        public Builder<P> add(DataAtom<P> head, DataAtom<P> body) {
            this.builder.add(new LinearInclusionDependency<P>(head, body));
            return this;
        }

        @Override
        public LinearInclusionDependencies<P> build() {
            return new LinearInclusionDependenciesImpl(this.coreUtilsFactory, this.atomFactory, this.homomorphismFactory, this.builder.build());
        }
    }

    public static final class LinearInclusionDependency<P extends AtomPredicate> {
        private final DataAtom<P> head;
        private final DataAtom<P> body;

        private LinearInclusionDependency(DataAtom<P> head, DataAtom<P> body) {
            this.head = head;
            this.body = body;
        }

        public DataAtom<P> getHead() {
            return this.head;
        }

        public DataAtom<P> getBody() {
            return this.body;
        }

        public String toString() {
            return this.head + " :- " + this.body;
        }
    }
}

