/*
 * Decompiled with CFR 0.152.
 */
package it.unibz.inf.ontop.constraints.impl;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.inject.Inject;
import it.unibz.inf.ontop.constraints.Homomorphism;
import it.unibz.inf.ontop.constraints.HomomorphismFactory;
import it.unibz.inf.ontop.constraints.ImmutableCQContainmentCheck;
import it.unibz.inf.ontop.constraints.LinearInclusionDependencies;
import it.unibz.inf.ontop.constraints.impl.FullLinearInclusionDependenciesImpl;
import it.unibz.inf.ontop.constraints.impl.HomomorphismImpl;
import it.unibz.inf.ontop.constraints.impl.HomomorphismIteratorImpl;
import it.unibz.inf.ontop.constraints.impl.ImmutableCQContainmentCheckUnderLIDs;
import it.unibz.inf.ontop.constraints.impl.LinearInclusionDependenciesImpl;
import it.unibz.inf.ontop.model.atom.AtomFactory;
import it.unibz.inf.ontop.model.atom.AtomPredicate;
import it.unibz.inf.ontop.model.atom.DataAtom;
import it.unibz.inf.ontop.utils.CoreUtilsFactory;
import java.util.Iterator;

public class HomomorphismFactoryImpl
implements HomomorphismFactory {
    private final CoreUtilsFactory coreUtilsFactory;
    private final AtomFactory atomFactory;

    @Inject
    public HomomorphismFactoryImpl(CoreUtilsFactory coreUtilsFactory, AtomFactory atomFactory) {
        this.coreUtilsFactory = coreUtilsFactory;
        this.atomFactory = atomFactory;
    }

    @Override
    public Homomorphism.Builder getHomomorphismBuilder() {
        return new HomomorphismImpl.BuilderImpl();
    }

    @Override
    public <P extends AtomPredicate> Iterator<Homomorphism> getHomomorphismIterator(Homomorphism baseHomomorphism, ImmutableList<DataAtom<P>> from, ImmutableCollection<DataAtom<P>> to) {
        return new HomomorphismIteratorImpl<P>(baseHomomorphism, from, to);
    }

    @Override
    public <P extends AtomPredicate> LinearInclusionDependencies.Builder<P> getLinearInclusionDependenciesBuilder() {
        return new LinearInclusionDependenciesImpl.Builder(this.coreUtilsFactory, this.atomFactory, this);
    }

    @Override
    public <P extends AtomPredicate> LinearInclusionDependencies.Builder<P> getFullLinearInclusionDependenciesBuilder() {
        return new FullLinearInclusionDependenciesImpl.Builder(this.coreUtilsFactory, this.atomFactory, this);
    }

    @Override
    public <P extends AtomPredicate> ImmutableCQContainmentCheck<P> getCQContainmentCheck(LinearInclusionDependencies<P> dependencies) {
        return new ImmutableCQContainmentCheckUnderLIDs<P>(this, dependencies);
    }
}

