/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.trree.plugin.externalsync.impl.retrieval;

import com.ontotext.trree.plugin.externalsync.ExternalSyncPlugin;
import com.ontotext.trree.plugin.externalsync.ExternalSyncRequestContext;
import com.ontotext.trree.plugin.externalsync.api.ConnectorException;
import com.ontotext.trree.plugin.externalsync.api.ConnectorServerException;
import com.ontotext.trree.plugin.externalsync.api.ExternalRetrieve;
import com.ontotext.trree.plugin.externalsync.api.ExternalStore;
import com.ontotext.trree.plugin.externalsync.api.SyncDocument;
import com.ontotext.trree.plugin.externalsync.config.Options;
import com.ontotext.trree.plugin.externalsync.impl.AbstractExternalStore;
import com.ontotext.trree.plugin.externalsync.impl.Property;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalDriver;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalFieldValue;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalPlugin;
import com.ontotext.trree.plugin.externalsync.impl.retrieval.RetrievalRetrieve;
import com.ontotext.trree.plugin.externalsync.iterators.master.MasterResultIterator;
import com.ontotext.trree.plugin.externalsync.util.EntitiesUtil;
import com.ontotext.trree.sdk.ClientErrorException;
import com.ontotext.trree.sdk.Entities;
import com.ontotext.trree.sdk.HealthResult;
import com.ontotext.trree.sdk.PluginConnection;
import com.ontotext.trree.sdk.ServerErrorException;
import com.ontotext.trree.sdk.Statements;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.Nonnull;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Value;
import org.jetbrains.annotations.Nullable;
import org.json.simple.JSONObject;

public class RetrievalStore
extends AbstractExternalStore<Map<String, RetrievalFieldValue>> {
    private static final String OUT_OF_SYNC_KEY = "outOfSync";
    private RetrievalDriver driver;
    private final AtomicBoolean outOfSync = new AtomicBoolean();
    private Map<Property, String> fieldTextPrefixes;

    private RetrievalStore(String storeName, Options storeOptions, boolean wasJustCreated, long initialFingerprint, RetrievalPlugin retrievalPlugin, PluginConnection pluginConnection, Entities entities) {
        super(storeName, storeOptions, wasJustCreated, initialFingerprint, (ExternalSyncPlugin)retrievalPlugin, pluginConnection, entities);
    }

    static ExternalStore open(String storeName, Options storeOptions, RetrievalPlugin retrievalPlugin, PluginConnection pluginConnection) {
        return new RetrievalStore(storeName, storeOptions, false, 0L, retrievalPlugin, pluginConnection, pluginConnection.getEntities());
    }

    public static ExternalStore create(String storeName, Options options, RetrievalPlugin retrievalPlugin, PluginConnection pluginConnection, Entities entitiesForCreation) {
        RetrievalStore retrievalStore = new RetrievalStore(storeName, options, true, 0L, retrievalPlugin, pluginConnection, entitiesForCreation);
        retrievalStore.createIndex(true);
        return retrievalStore;
    }

    protected void createIndex(boolean cleanupAfterFailure) {
        try {
            this.init();
        }
        catch (Exception e) {
            if (cleanupAfterFailure) {
                try {
                    this.remove(true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (e instanceof ConnectorException) {
                throw e;
            }
            throw new ConnectorServerException("Unable to create connector: " + e.getMessage(), (Throwable)e);
        }
    }

    protected void deleteEntity(long subject, Value subjectValue) {
        this.driver.delete(EntitiesUtil.valueToString((Value)subjectValue));
    }

    protected boolean syncEntity(long subject, long predicate, long context, SyncDocument<Map<String, RetrievalFieldValue>> syncDoc, List<Property> propertiesToSync, Entities entities, Statements statements, boolean skip) {
        try {
            boolean anyProperty = this.syncEntityToDocument(syncDoc, subject, predicate, context, propertiesToSync, entities, statements);
            if (anyProperty && this.convertSyncDocumentToNativeDocument(syncDoc, propertiesToSync)) {
                if (!skip) {
                    return this.driver.index(EntitiesUtil.valueToString((Value)entities.get(subject)), (Map)syncDoc.nativeDocument);
                }
                return true;
            }
            return false;
        }
        catch (Exception e) {
            throw new ServerErrorException("Couldn't index entity " + String.valueOf(entities.get(subject)), (Throwable)e);
        }
    }

    protected boolean writePropertyValueToNativeDocument(Map<String, RetrievalFieldValue> doc, Property property, String fieldName, Value value) {
        String objValue = EntitiesUtil.valueToString((Value)value);
        this.setRetrievalStoreFieldValue(property, doc, fieldName, objValue);
        this.logger.debug("[{}] Indexing: '{}' = '{}'", new Object[]{this.name, fieldName, value});
        return true;
    }

    protected void addNativeNestedDocument(Map<String, RetrievalFieldValue> doc, Property property, Map<String, RetrievalFieldValue> nestedDoc) {
        this.setRetrievalStoreFieldValue(property, doc, property.getFieldNameWithoutSuffix(), nestedDoc);
    }

    protected Map<String, RetrievalFieldValue> newNativeDocument() {
        return new LinkedHashMap<String, RetrievalFieldValue>();
    }

    private void setRetrievalStoreFieldValue(Property property, Map<String, RetrievalFieldValue> doc, String key, Object value) {
        if (property.isMultivalued()) {
            RetrievalFieldValue oldValue = doc.get(key);
            boolean isMetadata = property.getFieldName().fullyQualifiedNameWithoutSuffix.startsWith("metadata.");
            if (oldValue == null) {
                doc.put(key, new RetrievalFieldValue(key, property.isArray() && isMetadata ? new ArrayList<Object>(Collections.singletonList(value)) : value, this.fieldTextPrefixes.get(property), property.isIndexed()));
            } else if (isMetadata && !property.isArray()) {
                this.logger.warn("[{}] Ignoring additional value for metadata field '{}': '{}'; the sole indexed value is '{}'", new Object[]{this.name, property.getFieldName().fieldNameWithoutSuffix, value, oldValue.value});
            } else {
                oldValue.addValue(value);
            }
        } else {
            doc.put(key, new RetrievalFieldValue(key, value, this.fieldTextPrefixes.get(property), property.isIndexed()));
        }
    }

    protected boolean isValidFieldNameImplementation(String fieldName, boolean isTopField) {
        return true;
    }

    public ExternalRetrieve createRetrieve(MasterResultIterator mri, ExternalSyncRequestContext requestContext) {
        this.init();
        return new RetrievalRetrieve(this.logger, this, mri, requestContext, this.driver);
    }

    public void transactionStarted(PluginConnection pluginConnection) {
        super.transactionStarted(pluginConnection);
        if (this.initialised.get()) {
            this.driver.begin();
        }
    }

    public boolean transactionCompleted(PluginConnection pluginConnection) {
        if (this.initialised.get()) {
            this.driver.commit();
        }
        return super.transactionCompleted(pluginConnection);
    }

    public void rollbackCurrent(PluginConnection pluginConnection) throws IOException {
        super.rollbackCurrent(pluginConnection);
        if (this.initialised.get()) {
            this.driver.rollback();
        }
    }

    public void rollbackLastCommitted(PluginConnection pluginConnection) throws IOException {
        if (this.driver.getNumberOfDocumentsInTransaction() > 0L) {
            this.outOfSync.set(true);
            this.dynamicOptionsUpdated = true;
        }
        super.rollbackLastCommitted(pluginConnection);
    }

    @Nonnull
    public List<String> getSyncedFields() {
        return Collections.emptyList();
    }

    public void closeNetworkResources() {
        try {
            if (this.driver != null) {
                this.driver.close();
            }
        }
        catch (Exception e) {
            this.logger.warn("[" + this.name + "] Error closing driver.", (Throwable)e);
        }
    }

    protected String getNativeTypeFromDatatype(IRI datatype, boolean multivalued) {
        return null;
    }

    public void removeAllEntities() {
        this.init();
        this.driver.deleteAll();
        super.removeAllEntities();
    }

    protected void validateProperties() {
        Boolean[] result = new Boolean[]{false, false};
        this.checkDotsAndNestedProperties(null, this.getProperties(), result);
        if (result[0].booleanValue() && result[1].booleanValue()) {
            throw new ClientErrorException("Field names with dots and nested objects may not be used together.");
        }
        this.validateNativeSettings(this.getProperties());
    }

    protected void initImpl() {
        this.driver = new RetrievalDriver((RetrievalPlugin)this.plugin, this, this.name, this.options);
    }

    private void checkDotsAndNestedProperties(@javax.annotation.Nullable Property parent, List<Property> properties, Boolean[] result) {
        for (Property p : properties) {
            boolean hasNested = !p.getObject().isEmpty();
            Boolean[] booleanArray = result;
            Boolean.valueOf(booleanArray[0] | p.getFieldNameWithSuffix().contains("."));
            booleanArray = result;
            Boolean.valueOf(booleanArray[1] | hasNested);
            String fieldName = p.getFieldNameWithoutSuffix();
            if (parent != null && !this.isValidFieldName(fieldName, false)) {
                throw new ClientErrorException(String.format("Nested field name '%s' with parent '%s' may not be used.", fieldName, parent.getFieldNameWithoutSuffix()));
            }
            this.checkDotsAndNestedProperties(p, p.getObject(), result);
        }
    }

    private void validateNativeSettings(List<Property> properties) {
        for (Property property : properties) {
            Map nativeSettings = property.getNativeSettings();
            if (!(nativeSettings.isEmpty() || property.getNativeType() != null && property.getXsdType() == null)) {
                throw new ClientErrorException("Native field settings require an explicit native datatype");
            }
            this.validateNativeSettings(property.getObject());
        }
    }

    public HealthResult runHealthCheckInternal() {
        return this.driver.runHealthCheck();
    }

    public void updateOptions(Options newOptions) {
        Options updatedOptions = this.getOptions().copy();
        updatedOptions.updateOptions(newOptions, (Iterable)this.plugin.getAllOptions());
        this.driver.updateOptions(updatedOptions);
        super.updateOptions(newOptions);
    }

    void updateOptionsNoPropagate(Options newOptions) {
        super.updateOptions(newOptions);
    }

    protected void applyUpdatedOptions() {
    }

    public JSONObject getSettingsAsJSON() {
        JSONObject settings = super.getSettingsAsJSON();
        settings.put((Object)OUT_OF_SYNC_KEY, (Object)this.outOfSync.get());
        return settings;
    }

    public void setSettingsFromJSON(JSONObject json) {
        super.setSettingsFromJSON(json);
        Object outOfSyncObj = json.get((Object)OUT_OF_SYNC_KEY);
        if (outOfSyncObj instanceof Boolean) {
            this.outOfSync.set((Boolean)outOfSyncObj);
        }
    }

    protected Property getPropertyFromElement(Object o, Entities entities, @Nullable Property parentProperty) {
        Property p = super.getPropertyFromElement(o, entities, parentProperty);
        String fieldTextPrefix = ((Map)o).getOrDefault("fieldTextPrefix", "has {}");
        if (this.fieldTextPrefixes == null) {
            this.fieldTextPrefixes = new HashMap<Property, String>();
        }
        this.fieldTextPrefixes.put(p, fieldTextPrefix);
        return p;
    }
}

