/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sql.view;

import com.google.common.annotations.VisibleForTesting;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.security.utils.SecurityUtils;
import com.ontotext.forest.sql.view.ColumnSuggestion;
import com.ontotext.forest.sql.view.SqlColumn;
import com.ontotext.forest.sql.view.SqlView;
import com.ontotext.graphdb.jdbc.GraphDBFieldType;
import com.ontotext.graphdb.jdbc.GraphDBJdbcUtils;
import com.ontotext.graphdb.jdbc.GraphDBTableMetadata;
import com.ontotext.graphdb.jdbc.RepositoryManagerModelProperties;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.update.SqlViewUpdate;
import com.ontotext.raft.update.SystemUpdate;
import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServletResponse;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.UUID;
import org.apache.calcite.util.Source;
import org.apache.calcite.util.Sources;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.query.BindingSet;
import org.eclipse.rdf4j.query.MalformedQueryException;
import org.eclipse.rdf4j.query.TupleQuery;
import org.eclipse.rdf4j.query.TupleQueryResult;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.query.impl.ListBindingSet;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultFormat;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriter;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterFactory;
import org.eclipse.rdf4j.query.resultio.TupleQueryResultWriterRegistry;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.RepositoryConnection;
import org.eclipse.rdf4j.repository.manager.LocalRepositoryManager;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SqlViewsService {
    private static final String SQL_VIEW_FILE_EXTENSION = ".rq";
    private static final String UNKNOWN_SQL_TYPE = "unknown";
    private static final String IRI_SQL_TYPE = GraphDBFieldType.IRI.getSimpleName();
    private static final String SQL_PREVIEW_TEMPLATE = "SELECT * FROM \"{{repoId}}\".\"{{table_name}}\" LIMIT {{limit}}";
    @Autowired
    private SemanticDataManagement dataManagement;

    public Set<String> getAllSqlViewsNames() {
        File sqlViewDir = this.getSqlViewDirectory();
        return this.getSqlViewsFromDir(sqlViewDir);
    }

    public SqlView getSqlView(String name) {
        File sqlViewFile = this.buildSqlViewFileDir(name);
        if (this.sqlViewFileExists(sqlViewFile)) {
            try {
                GraphDBTableMetadata metadata = new GraphDBTableMetadata(this.dataManagement.getCurrentRepositoryOrThrow().getRepository(), Sources.of((File)sqlViewFile));
                return this.parseDataToSqlView(metadata, name);
            }
            catch (Exception e) {
                throw new GraphDBWorkbenchException("Unable to fetch SQL view from repository", (Throwable)e);
            }
        }
        return null;
    }

    public boolean createSqlView(SqlView sqlView) {
        this.validateColumnsExist(sqlView);
        File sqlViewFile = this.buildSqlViewFileDir(sqlView.getName());
        if (this.sqlViewFileExists(sqlViewFile)) {
            return false;
        }
        GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster != null) {
            this.validateLeadership(replicationCluster);
            if (this.saveSqlViewFile(sqlView, sqlViewFile)) {
                block7: {
                    try {
                        if (this.replicateSqlViewOperation(replicationCluster, sqlView.getName(), GraphDBJdbcUtils.getSqlViewFromFile((Source)Sources.of((File)sqlViewFile)), SqlViewUpdate.OperationType.CREATE)) break block7;
                        try {
                            Files.delete(sqlViewFile.toPath());
                        }
                        catch (IOException e) {
                            throw new GraphDBWorkbenchException("Unsuccessful rollback operation. Unable to delete SQL view", (Throwable)e);
                        }
                        throw new GraphDBWorkbenchException("Unable to create SQL view with name \"" + sqlView.getName() + "\". Rolling back operation.");
                    }
                    catch (IOException e) {
                        throw new GraphDBWorkbenchException("Unsuccessful SQL view replication.", (Throwable)e);
                    }
                }
                return true;
            }
            return false;
        }
        return this.saveSqlViewFile(sqlView, sqlViewFile);
    }

    public boolean updateSqlView(SqlView sqlView) {
        block5: {
            this.validateColumnsExist(sqlView);
            File sqlViewFile = this.buildSqlViewFileDir(sqlView.getName());
            if (!this.sqlViewFileExists(sqlViewFile)) {
                return false;
            }
            GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
            if (replicationCluster != null) {
                this.validateLeadership(replicationCluster);
                try {
                    String oldSqlViewFromFile = GraphDBJdbcUtils.getSqlViewFromFile((Source)Sources.of((File)sqlViewFile));
                    String sqlViewQuery = this.validateSqlViewQuery(sqlView).getQuery();
                    this.writeViewToFile(sqlViewQuery, sqlViewFile);
                    if (!this.replicateSqlViewOperation(replicationCluster, sqlView.getName(), sqlViewQuery, SqlViewUpdate.OperationType.UPDATE)) {
                        this.writeViewToFile(oldSqlViewFromFile, sqlViewFile);
                        throw new GraphDBWorkbenchException("Unable to update SQL view with name \"" + sqlView.getName() + "\". Rolling back operation.");
                    }
                    break block5;
                }
                catch (IOException e) {
                    throw new GraphDBWorkbenchException("Unsuccessful rollback operation. Unable to restore SQL view content", (Throwable)e);
                }
            }
            this.writeViewToFile(this.validateSqlViewQuery(sqlView).getQuery(), sqlViewFile);
        }
        return true;
    }

    public boolean deleteSqlView(String viewName) {
        block7: {
            File sqlViewFile = this.buildSqlViewFileDir(viewName);
            GraphDBReplicationCluster replicationCluster = this.dataManagement.getCurrentLocationOrThrow().getReplicationCluster();
            if (replicationCluster != null) {
                this.validateLeadership(replicationCluster);
                try {
                    String oldSqlViewFromFile = GraphDBJdbcUtils.getSqlViewFromFile((Source)Sources.of((File)sqlViewFile));
                    Files.delete(sqlViewFile.toPath());
                    if (!this.replicateSqlViewOperation(replicationCluster, viewName, null, SqlViewUpdate.OperationType.DELETE)) {
                        this.writeViewToFile(oldSqlViewFromFile, this.buildSqlViewFileDir(viewName));
                        throw new GraphDBWorkbenchException("Unable to delete SQL view with name \"" + viewName + "\". Rolling back operation.");
                    }
                    break block7;
                }
                catch (IOException e) {
                    throw new GraphDBWorkbenchException("Unsuccessful rollback operation. Unable to create SQL view", (Throwable)e);
                }
            }
            try {
                Files.delete(sqlViewFile.toPath());
                return true;
            }
            catch (NoSuchFileException e) {
                return false;
            }
            catch (IOException e) {
                throw new GraphDBWorkbenchException("Unable to delete SQL view", (Throwable)e);
            }
        }
        return true;
    }

    public void writePreviewResultInResponseBody(SqlView sqlView, String limit, boolean isTmpView, HttpServletResponse response) {
        try {
            if (isTmpView) {
                sqlView.setName("tmp" + String.valueOf(UUID.randomUUID()));
                if (!this.createSqlView(sqlView)) {
                    throw new GraphDBWorkbenchException(String.format("Unable to create temporary SQL view %s", sqlView.getName()));
                }
            }
            this.validateSqlViewQuery(sqlView);
            List<BindingSet> bindings = this.getSqlTablePreview(sqlView, limit);
            response.setContentType("application/sparql-results+json");
            try (ServletOutputStream os = response.getOutputStream();){
                Optional tupleQueryResultWriterFactory = TupleQueryResultWriterRegistry.getInstance().get((Object)TupleQueryResultFormat.JSON);
                if (!tupleQueryResultWriterFactory.isPresent()) {
                    throw new GraphDBWorkbenchException("Could not get TupleQueryResultWriterFactory");
                }
                TupleQueryResultWriter tqrWriter = ((TupleQueryResultWriterFactory)tupleQueryResultWriterFactory.get()).getWriter((OutputStream)os);
                ArrayList bindingNames = !bindings.isEmpty() ? new ArrayList(bindings.get(0).getBindingNames()) : Collections.emptyList();
                tqrWriter.startQueryResult((List)bindingNames);
                for (BindingSet bs : bindings) {
                    tqrWriter.handleSolution(bs);
                }
                tqrWriter.endQueryResult();
            }
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Could not write result of preview in response body", (Throwable)e);
        }
        finally {
            if (isTmpView) {
                this.deleteSqlView(sqlView.getName());
            }
        }
    }

    public Collection<String> getSuggestedColumnNames(String sparqlQuery) {
        return this.validateSqlViewQuery(new SqlView("", sparqlQuery, Collections.emptyList())).getPossibleColumns();
    }

    public Map<String, ColumnSuggestion> getSuggestedColumnTypes(String sparqlQuery, Set<String> columnNames, int limit) {
        try (RepositoryConnection connection = this.dataManagement.getCurrentRepositoryOrThrow().getConnection();){
            TupleQuery query = connection.prepareTupleQuery(sparqlQuery);
            Map<String, ColumnSuggestion> map = this.recordQueryColumnTypeSuggestions(query, columnNames, limit);
            return map;
        }
    }

    private boolean replicateSqlViewOperation(GraphDBReplicationCluster replicationCluster, String sqlViewName, String sqlViewQuery, SqlViewUpdate.OperationType operation) {
        return replicationCluster.replicateSystemUpdate((SystemUpdate)new SqlViewUpdate(this.dataManagement.getCurrentRepositoryOrThrow().getRepositoryID(), sqlViewName, sqlViewQuery, operation)) >= 1L;
    }

    private void validateLeadership(GraphDBReplicationCluster replicationCluster) {
        try {
            replicationCluster.validateLeadership();
        }
        catch (UpdateExecutionException e) {
            throw new GraphDBWorkbenchException(e.getMessage());
        }
        if (!replicationCluster.isPrimaryCluster()) {
            throw new GraphDBWorkbenchException("Unable to execute operation as node is in secondary cluster mode.");
        }
    }

    private Map<String, ColumnSuggestion> recordQueryColumnTypeSuggestions(TupleQuery query, Set<String> columnNames, int limit) {
        HashMap<String, Map<String, Integer>> bindingValueTypeMap = new HashMap<String, Map<String, Integer>>();
        int counter = 0;
        try (TupleQueryResult result = query.evaluate();){
            while (result.hasNext() && counter < limit) {
                BindingSet bindingSet = (BindingSet)result.next();
                ++counter;
                for (String binding : result.getBindingNames()) {
                    if (!columnNames.contains(binding)) continue;
                    this.recordOccurrence(bindingValueTypeMap, binding, bindingSet.getValue(binding));
                }
            }
        }
        return this.getSuggestedColumnsFromOccurrences(bindingValueTypeMap, columnNames, counter);
    }

    private void recordOccurrence(Map<String, Map<String, Integer>> bindingValueTypeMap, String binding, Value value) {
        bindingValueTypeMap.putIfAbsent(binding, new HashMap());
        if (value instanceof Literal) {
            this.recordLiteralOccurrenceInMap(bindingValueTypeMap.get(binding), value);
        } else if (value instanceof IRI) {
            this.recordOccurrenceInMap(bindingValueTypeMap.get(binding), IRI_SQL_TYPE);
        } else if (value != null) {
            this.recordOccurrenceInMap(bindingValueTypeMap.get(binding), UNKNOWN_SQL_TYPE);
        }
    }

    private void recordLiteralOccurrenceInMap(Map<String, Integer> typeOccurrenceMap, Value value) {
        Object literal = Literals.isLanguageLiteral((Literal)((Literal)value)) ? "@" + (String)((Literal)value).getLanguage().get() : ((Literal)value).getDatatype().stringValue();
        this.recordOccurrenceInMap(typeOccurrenceMap, (String)literal);
    }

    private void recordOccurrenceInMap(Map<String, Integer> typeOccurrenceMap, String type) {
        typeOccurrenceMap.compute(type, (d, v) -> {
            if (v == null) {
                v = 1;
            } else {
                Integer n = v;
                v = v + 1;
            }
            return v;
        });
    }

    private Map<String, ColumnSuggestion> getSuggestedColumnsFromOccurrences(Map<String, Map<String, Integer>> bindingValueTypeMap, Set<String> columnNames, int total) {
        HashMap<String, ColumnSuggestion> columns = new HashMap<String, ColumnSuggestion>();
        for (String columnName : columnNames) {
            Map<String, Integer> valueOccurrences = bindingValueTypeMap.get(columnName);
            if (valueOccurrences != null && !valueOccurrences.isEmpty()) {
                String maxCountValue = (String)Collections.max(valueOccurrences.entrySet(), Map.Entry.comparingByValue()).getKey();
                int confidence = Math.round((float)valueOccurrences.get(maxCountValue).intValue() / (float)total * 100.0f);
                columns.put(columnName, this.createColumnSuggestion(maxCountValue, confidence));
                continue;
            }
            columns.put(columnName, this.unknownColumnSuggestion());
        }
        return columns;
    }

    private ColumnSuggestion createColumnSuggestion(String sparqlValue, int confidence) {
        String sqlValue = this.convertToSQLValue(this.mapSparqlType(sparqlValue)).toLowerCase();
        if (sqlValue.equals(IRI_SQL_TYPE)) {
            return new ColumnSuggestion(sqlValue, confidence, null);
        }
        if (XSD.STRING.stringValue().equals(sparqlValue)) {
            sparqlValue = null;
        }
        return new ColumnSuggestion(sqlValue, confidence, sparqlValue);
    }

    private ColumnSuggestion unknownColumnSuggestion() {
        return new ColumnSuggestion(UNKNOWN_SQL_TYPE, 100, null);
    }

    private String convertToSQLValue(String rdfValue) {
        if (rdfValue.startsWith("@")) {
            return GraphDBFieldType.STRING.getSimpleName();
        }
        if (rdfValue.equals(UNKNOWN_SQL_TYPE)) {
            return GraphDBFieldType.STRING.getSimpleName();
        }
        if (rdfValue.equals(IRI_SQL_TYPE)) {
            return rdfValue;
        }
        Optional<GraphDBFieldType> graphDBFieldType = Arrays.stream(GraphDBFieldType.values()).filter(fieldType -> fieldType.getDefaultSparqlType().stringValue().equals(rdfValue) && !fieldType.name().equalsIgnoreCase("char")).findFirst();
        return graphDBFieldType.map(Enum::name).orElse(UNKNOWN_SQL_TYPE);
    }

    private boolean sqlViewFileExists(File sqlView) {
        return sqlView.exists() && sqlView.isFile();
    }

    private boolean saveSqlViewFile(SqlView view, File viewFile) {
        try {
            String sqlViewQuery = this.validateSqlViewQuery(view).getQuery();
            if (viewFile.createNewFile()) {
                this.writeViewToFile(sqlViewQuery, viewFile);
                return true;
            }
            return false;
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Unable to create SQL view", (Throwable)e);
        }
    }

    private void writeViewToFile(String sqlViewString, File sqlViewFile) {
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(sqlViewFile));){
            writer.write(sqlViewString);
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Unable to create SQL view file", (Throwable)e);
        }
    }

    private File getSqlViewDirectory() {
        Repository repository = this.dataManagement.getCurrentRepositoryOrThrow().getRepository();
        File sqlViewDir = new File(repository.getDataDir(), "sql");
        if (!(sqlViewDir.exists() && sqlViewDir.isDirectory() || sqlViewDir.mkdir())) {
            throw new GraphDBWorkbenchException("Unable to create SQL directory");
        }
        return sqlViewDir;
    }

    private File buildSqlViewFileDir(String viewName) {
        return new File(this.getSqlViewDirectory(), viewName + SQL_VIEW_FILE_EXTENSION);
    }

    private Set<String> getSqlViewsFromDir(File directory) {
        TreeSet<String> sqlViews = new TreeSet<String>();
        File[] files = directory.listFiles((dir, name) -> name.endsWith(SQL_VIEW_FILE_EXTENSION));
        if (files != null) {
            for (File file : files) {
                if (!file.isFile()) continue;
                sqlViews.add(file.getName().substring(0, file.getName().length() - SQL_VIEW_FILE_EXTENSION.length()));
            }
        }
        return sqlViews;
    }

    @VisibleForTesting
    SqlView parseDataToSqlView(GraphDBTableMetadata sqlViewData, String name) {
        ArrayList<SqlColumn> sqlColumns = new ArrayList<SqlColumn>();
        for (String columnName : sqlViewData.getColumns()) {
            sqlColumns.add(this.createColumnFromMetadata(columnName, sqlViewData));
        }
        SqlView sqlView = new SqlView(name, sqlViewData.getSparqlQuery(), sqlColumns);
        this.validateColumnsExist(sqlView);
        return sqlView;
    }

    private SqlColumn createColumnFromMetadata(String columnName, GraphDBTableMetadata sqlViewData) {
        GraphDBFieldType fieldType;
        String sparqlType = sqlViewData.getSparqlType(columnName).stringValue();
        String sqlType = sqlViewData.getSqlType(columnName);
        SqlColumn column = new SqlColumn(columnName, sqlType, null, null, sqlViewData.isNullable(columnName), null);
        if (sqlViewData.getSqlPrecision(columnName) > -1) {
            column.setSqlTypePrecision(sqlViewData.getSqlPrecision(columnName));
        }
        if (sqlViewData.getSqlScale(columnName) > -1) {
            column.setSqlTypeScale(sqlViewData.getSqlScale(columnName));
        }
        if ((fieldType = GraphDBFieldType.of((String)sqlType)).hasSparqlType() && (fieldType != GraphDBFieldType.STRING || !fieldType.getDefaultSparqlType().stringValue().equals(sparqlType))) {
            if (sparqlType.equals(XSD.LANGUAGE.toString())) {
                column.setSparqlType("@" + sqlViewData.getLanguageTag(columnName));
            } else {
                column.setSparqlType(sparqlType);
            }
        }
        return column;
    }

    private GraphDBTableMetadata validateSqlViewQuery(SqlView sqlView) {
        try {
            return new GraphDBTableMetadata(this.dataManagement.getCurrentRepositoryOrThrow().getRepository(), sqlView.toString());
        }
        catch (Exception e) {
            if (e instanceof MalformedQueryException) {
                throw new GraphDBWorkbenchException("Syntax error in query: ", (Throwable)e);
            }
            throw new GraphDBWorkbenchException("Invalid SQL View: ", (Throwable)e);
        }
    }

    private void validateColumnsExist(SqlView sqlView) {
        if (sqlView.getColumns().isEmpty()) {
            throw new GraphDBWorkbenchException("At least one SQL column must be defined");
        }
    }

    private boolean isSparqlTypeDefault(String sqlType, String sparqlType) {
        return sparqlType.equals(GraphDBFieldType.of((String)sqlType).getDefaultSparqlType().stringValue());
    }

    /*
     * Exception decompiling
     */
    private List<BindingSet> getSqlTablePreview(SqlView sqlView, String limit) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private List<BindingSet> convertResultSet(ResultSet rs) throws SQLException {
        SimpleValueFactory vf = SimpleValueFactory.getInstance();
        ArrayList<BindingSet> bindings = new ArrayList<BindingSet>();
        while (rs.next()) {
            int colCount = rs.getMetaData().getColumnCount();
            ArrayList<String> names = new ArrayList<String>();
            ArrayList<Literal> values = new ArrayList<Literal>();
            for (int index = 1; index <= colCount; ++index) {
                Object objectResult = rs.getObject(index);
                String columnName = rs.getMetaData().getColumnName(index);
                names.add(columnName);
                Literal value = null;
                if (objectResult != null) {
                    value = vf.createLiteral(objectResult.toString());
                }
                values.add(value);
            }
            bindings.add((BindingSet)new ListBindingSet(names, values));
        }
        return bindings;
    }

    private Connection getSQLConnection(String repoId) throws SQLException {
        RepositoryManager repositoryManager = this.dataManagement.getCurrentLocationOrThrow().sesameManager();
        if (!(repositoryManager instanceof LocalRepositoryManager)) {
            throw new GraphDBWorkbenchException("Current repository manager is not local");
        }
        return DriverManager.getConnection("jdbc:graphdb:internal:", (Properties)new RepositoryManagerModelProperties((LocalRepositoryManager)repositoryManager, repo -> repo.equals(repoId) && SecurityUtils.hasRepositoryAccess((String)repo, (boolean)false)));
    }

    private String mapSparqlType(String type) {
        if (XSD.INTEGER.stringValue().equals(type)) {
            return XSD.LONG.stringValue();
        }
        return type;
    }

    public SemanticDataManagement getDataManagement() {
        return this.dataManagement;
    }
}

