/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sql.view;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.forest.sql.view.SqlColumn;
import io.swagger.v3.oas.annotations.Parameter;
import java.util.List;

public class SqlView {
    public static final String NAME_PARAMETER_DESCRIPTION = "The name of the SQL view";
    public static final String QUERY_PARAMETER_DESCRIPTION = "The SPARQL Select Query for the SQL View";
    public static final String SQL_COLUMN_LIST_PARAMETER_DESCRIPTION = "The list of SQL Column Metadata Configurations";
    @Parameter(description="The name of the SQL view")
    private String name;
    @Parameter(description="The SPARQL Select Query for the SQL View")
    private String query;
    @Parameter(description="The list of SQL Column Metadata Configurations")
    private List<SqlColumn> columns;

    SqlView() {
    }

    public SqlView(String name, String query, List<SqlColumn> columns) {
        this.name = name;
        this.query = query;
        this.columns = columns;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="query")
    public String getQuery() {
        return this.query;
    }

    @JsonProperty(value="columns")
    public List<SqlColumn> getColumns() {
        return this.columns;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="query")
    public void setQuery(String query) {
        this.query = query;
    }

    @JsonProperty(value="columns")
    public void setColumns(List<SqlColumn> columns) {
        this.columns = columns;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        for (SqlColumn column : this.columns) {
            builder.append(column.toString()).append("\n");
        }
        builder.append(this.query);
        return builder.toString();
    }
}

