/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.sql.view;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.Parameter;
import jakarta.annotation.Nullable;
import org.springframework.util.StringUtils;

public class SqlColumn {
    public static final String COLUMN_NAME_PARAMETER_DESCRIPTION = "The name of the SQL column";
    public static final String SQL_TYPE_PARAMETER_DESCRIPTION = "The SQL type of the column";
    public static final String SQL_TYPE_PRECISION_PARAMETER_DESCRIPTION = "The SQL type precision of the column";
    public static final String SQL_TYPE_SCALE_PARAMETER_DESCRIPTION = "The SQL type scale of the column";
    public static final String SQL_TYPE_NULLABILITY_PARAMETER_DESCRIPTION = "The SQL type nullability of the column";
    public static final String SPARQL_TYPE_PARAMETER_DESCRIPTION = "The SPARQL type of the column";
    @Parameter(description="The name of the SQL column")
    private String columnName;
    @Parameter(description="The SQL type of the column")
    private String columnType;
    @Parameter(description="The SQL type precision of the column", example="10")
    @Nullable
    private Integer sqlTypePrecision;
    @Parameter(description="The SQL type scale of the column", example="5")
    @Nullable
    private Integer sqlTypeScale;
    @Parameter(description="The SQL type nullability of the column")
    @Nullable
    private Boolean nullable;
    @Parameter(description="The SPARQL type of the column")
    @Nullable
    private String sparqlType;

    SqlColumn() {
    }

    public SqlColumn(String columnName, String columnType, @Nullable Integer sqlTypePrecision, @Nullable Integer sqlTypeScale, @Nullable Boolean nullable, @Nullable String sparqlType) {
        this.columnName = columnName;
        this.columnType = columnType;
        this.sqlTypePrecision = sqlTypePrecision;
        this.sqlTypeScale = sqlTypeScale;
        this.nullable = nullable;
        this.sparqlType = sparqlType;
    }

    @JsonProperty(value="column_name")
    public String getColumnName() {
        return this.columnName;
    }

    @JsonProperty(value="column_type")
    public String getColumnType() {
        return this.columnType;
    }

    @Nullable
    @JsonProperty(value="sql_type_precision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getSqlTypePrecision() {
        return this.sqlTypePrecision;
    }

    @Nullable
    @JsonProperty(value="sql_type_scale")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public Integer getSqlTypeScale() {
        return this.sqlTypeScale;
    }

    @Nullable
    @JsonProperty(value="nullable")
    public Boolean getNullable() {
        return this.nullable;
    }

    @Nullable
    @JsonProperty(value="sparql_type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public String getSparqlType() {
        return this.sparqlType;
    }

    @JsonProperty(value="column_name")
    public void setColumnName(String columnName) {
        this.columnName = columnName;
    }

    @JsonProperty(value="column_type")
    public void setColumnType(String columnType) {
        this.columnType = columnType;
    }

    @JsonProperty(value="sql_type_precision")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public void setSqlTypePrecision(@Nullable Integer sqlTypePrecision) {
        this.sqlTypePrecision = sqlTypePrecision;
    }

    @JsonProperty(value="sql_type_scale")
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public void setSqlTypeScale(@Nullable Integer sqlTypeScale) {
        this.sqlTypeScale = sqlTypeScale;
    }

    @JsonProperty(value="nullable")
    public void setNullable(@Nullable Boolean nullable) {
        this.nullable = nullable;
    }

    @JsonProperty(value="sparql_type")
    @JsonInclude(value=JsonInclude.Include.NON_EMPTY)
    public void setSparqlType(@Nullable String sparqlType) {
        this.sparqlType = sparqlType;
    }

    public String toString() {
        return "# !column : " + this.columnName + " : " + this.columnType + this.appendOptionals();
    }

    private String appendOptionals() {
        StringBuilder builder = new StringBuilder();
        if (this.isPrecisionSelected() && this.isScaleSelected()) {
            builder.append(" (").append(this.sqlTypePrecision).append(",").append(this.sqlTypeScale).append(")");
        } else if (this.isPrecisionSelected()) {
            builder.append(" (").append(this.sqlTypePrecision).append(")");
        } else if (this.isScaleSelected()) {
            builder.append(" (").append(this.sqlTypeScale).append(")");
        }
        if (this.nullable != null && !this.nullable.booleanValue()) {
            builder.append(" not null ");
        }
        if (this.isSparqlTypeSelected()) {
            builder.append(" : ").append(this.sparqlType);
        }
        return builder.toString();
    }

    private boolean isPrecisionSelected() {
        return this.sqlTypePrecision != null && this.sqlTypePrecision > -1;
    }

    private boolean isScaleSelected() {
        return this.sqlTypeScale != null && this.sqlTypeScale > -1;
    }

    private boolean isSparqlTypeSelected() {
        return !StringUtils.isEmpty((Object)this.sparqlType);
    }
}

