const JsUtils = Java.type('com.ontotext.script.model.JsUtils');
// cash the now() value in the curren execution context
let nowValue;

/**
 * Js function that generates a UUID version 4 string
 * @returns uuid string
 */
function uuid() {
    return JsUtils.uuid();
}

/**
 * Returns the current time as JsValue instance. If a pattern is present that pattern will be
 * applied to the value as well.
 *
 * @param pattern the pattern to apply
 * @returns JsValue representing the current time at the moment of the call.
 */
function now(pattern) {
    if (!nowValue) {
        nowValue = JsUtils.now(null);
    }
    return nowValue.copy().format(pattern);
}

/**
 * Resolves the passed prefix by using the '_prefix' binding to get the IRI of the prefix.
 *
 * @param namespace of the prefix
 * @returns the IRI of the prefix as a string
 */
function resolvePrefix(namespace) {
    return _prefix[namespace];
}
