/**
 * OntoFooter component for rendering the footer of the application.
 * This component displays information about GraphDB, RDF4J, Connectors, and Workbench versions,
 * as well as copyright information.
 */
export declare class OntoFooter {
    /** State variable to store product information */
    private productInfo;
    /** State variable determining weather to show the cookie consent component */
    private shouldShowCookieConsent;
    /** List of subscriptions to manage component lifecycle */
    private readonly subscriptions;
    /** Current year for copyright display */
    private readonly currentYear;
    private readonly securityContextService;
    private readonly licenseContextService;
    private readonly cookieService;
    handleConsentGiven(): void;
    render(): any;
    connectedCallback(): void;
    disconnectedCallback(): void;
    private subscribeToProductInfoChange;
    private isTrackingAllowed;
    private subscribeToUserChange;
    private setCookieConsentVisibility;
    private subscribeToLicenseChange;
}
