import{Host,h}from"@stencil/core";import{ServiceProvider,RepositoryContextService,UriUtil}from"../../../../../api/dist/ontotext-workbench-api";import{DropdownItemAlignment}from"../../models/dropdown/dropdown-item-alignment";import{RepositorySelection}from"./repository-selection";import{TranslationService}from"../../services/translation.service";import{OntoTooltipPlacement}from"../onto-tooltip/models/onto-tooltip-placement";export class OntoRepositorySelector{constructor(){this.repositoryContextService=ServiceProvider.get(RepositoryContextService),this.subscriptions=[]}onItemsChanged(t){(null==t?void 0:t.length)?this.dropdownItems=this.attachTooltipsToItems(this.items):this.dropdownItems=[]}connectedCallback(){var t;this.subscriptions.push(...this.subscribeToTranslationChanged()),(null===(t=this.items)||void 0===t?void 0:t.length)?this.dropdownItems=this.attachTooltipsToItems(this.items):this.dropdownItems=[]}disconnectedCallback(){this.subscriptions.forEach(t=>t())}render(){const t=h(RepositorySelection,{key:"bf5de32d81929056bbdf4c16a228cbe3dd7d2cdf",repository:this.currentRepository,defaultToggleButtonName:this.getButtonLabel(),location:this.getLocation()});return h(Host,{key:"ad2c4f2fee7b98d840bf0881ec571d7279dcdea5"},h("onto-dropdown",Object.assign({key:"442ac676b56db755c45caf45fd0216ed050334ba",class:"onto-repository-selector","data-test":"onto-repository-selector",onValueChanged:this.onValueChanged(),dropdownButtonName:t,dropdownButtonTooltip:this.createTooltipFunctionForRepository(this.currentRepository)},this.currentRepository?{dropdownButtonGuideSelector:`repository-id-${this.currentRepository.id}`}:{},{dropdownTooltipTrigger:"mouseenter focus",dropdownAlignment:DropdownItemAlignment.RIGHT,tooltipPlacement:this.tooltipAlignment,tooltipTheme:"light-border",items:this.dropdownItems,"auto-close":!0})))}attachTooltipsToItems(t){return t?t.map(t=>t.setTooltip(this.createTooltipFunctionForRepository(t.value))):[]}tooltipAlignment(t){return t?OntoTooltipPlacement.LEFT:OntoTooltipPlacement.BOTTOM}onValueChanged(){return t=>this.onRepositoryChanged(t.detail)}createTooltipFunctionForRepository(t){return async()=>{if(!t)return"";const o=await this.repositorySizeInfoFetcher(t);return this.buildRepositoryTooltipHtml(t,o)}}buildRepositoryTooltipHtml(t,o){let e=`\n    <div class="repository-tooltip-title">\n      <span class="label">${TranslationService.translate("repository-selector.tooltip.repository")}</span>\n      <span class="value">${t.id}</span>\n    </div>\n    <div class="repository-tooltip-content">\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.location")}:</div>\n        <div class="value">${t.location?t.location:TranslationService.translate("repository-selector.tooltip.local")}</div>\n      </div>\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.type")}:</div>\n        <div class="value">${TranslationService.translate("repository-selector.tooltip.types."+(t.type||"unknown"))}</div>\n      </div>\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.access")}:</div>\n        <div class="value">${TranslationService.translate(this.canWriteRepo(t)?"repository-selector.tooltip.accesses.read_write":"repository-selector.tooltip.accesses.read")}</div>\n      </div>`;return e+=this.buildRepositorySizeInfoHtml(o),e+="</div>",e}buildRepositorySizeInfoHtml(t){if(!t||t.total<0)return"";let o=`\n    <div class="repository-tooltip-row total">\n      <div class="label">${TranslationService.translate("repository-selector.tooltip.repository-size.total")}:</div>\n      <div class="value">${this.totalTripletsFormatter.format(t.total)}</div>\n    </div>`;if(t.explicit>=0&&(o+=`\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.repository-size.explicit")}:</div>\n        <div class="value">${this.totalTripletsFormatter.format(t.explicit)}</div>\n      </div>`),t.inferred>=0&&(o+=`\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.repository-size.inferred")}:</div>\n        <div class="value">${this.totalTripletsFormatter.format(t.inferred)}</div>\n      </div>`),t.total>=0){let e="-";t.explicit>0&&(e=this.totalTripletsFormatter.format(t.total/t.explicit)),o+=`\n      <div class="repository-tooltip-row">\n        <div class="label">${TranslationService.translate("repository-selector.tooltip.repository-size.expansion_ratio")}:</div>\n        <div class="value">${e}</div>\n      </div>`}return o}subscribeToTranslationChanged(){return[TranslationService.onTranslate("repository-selector.btn.toggle",[],t=>{this.defaultToggleButtonName=t}),TranslationService.onTranslate("repository-selector.btn.no_repositories",[],t=>{this.noRepositoriesButtonMessage=t})]}onRepositoryChanged(t){this.repositoryContextService.updateSelectedRepository(t)}getLocation(){var t;return(null===(t=this.currentRepository)||void 0===t?void 0:t.location)?`@${UriUtil.shortenIri(this.currentRepository.location)}`:""}getButtonLabel(){var t;return(null===(t=this.items)||void 0===t?void 0:t.length)?this.defaultToggleButtonName:this.noRepositoriesButtonMessage}static get is(){return"onto-repository-selector"}static get originalStyleUrls(){return{$:["onto-repository-selector.scss"]}}static get styleUrls(){return{$:["onto-repository-selector.css"]}}static get properties(){return{currentRepository:{type:"unknown",attribute:"current-repository",mutable:!1,complexType:{original:"Repository",resolved:"Repository",references:{Repository:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::Repository"}}},required:!1,optional:!1,docs:{tags:[],text:"The currently selected repository."},getter:!1,setter:!1},items:{type:"unknown",attribute:"items",mutable:!1,complexType:{original:"DropdownItem<Repository>[]",resolved:"DropdownItem<Repository>[]",references:{DropdownItem:{location:"import",path:"../../models/dropdown/dropdown-item",id:"src/models/dropdown/dropdown-item.ts::DropdownItem"},Repository:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::Repository"}}},required:!1,optional:!1,docs:{tags:[],text:"The list of repositories to show in the dropdown."},getter:!1,setter:!1},repositorySizeInfoFetcher:{type:"unknown",attribute:"repository-size-info-fetcher",mutable:!1,complexType:{original:"(repo: Repository) => Promise<RepositorySizeInfo>",resolved:"(repo: Repository) => Promise<RepositorySizeInfo>",references:{Repository:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::Repository"},Promise:{location:"global",id:"global::Promise"},RepositorySizeInfo:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::RepositorySizeInfo"}}},required:!1,optional:!1,docs:{tags:[],text:"Fetches repository size info used to build tooltips."},getter:!1,setter:!1},totalTripletsFormatter:{type:"unknown",attribute:"total-triplets-formatter",mutable:!1,complexType:{original:"Intl.NumberFormat",resolved:"NumberFormat",references:{Intl:{location:"global",id:"global::Intl"}}},required:!1,optional:!1,docs:{tags:[],text:"Formatter for numeric values in tooltips."},getter:!1,setter:!1},canWriteRepo:{type:"unknown",attribute:"can-write-repo",mutable:!1,complexType:{original:"(repo: Repository) => boolean",resolved:"(repo: Repository) => boolean",references:{Repository:{location:"import",path:"@ontotext/workbench-api",id:"../api/dist/ontotext-workbench-api.d.ts::Repository"}}},required:!1,optional:!1,docs:{tags:[],text:"Determines whether the current user has write access to the repository."},getter:!1,setter:!1}}}static get states(){return{defaultToggleButtonName:{},noRepositoriesButtonMessage:{}}}static get watchers(){return[{propName:"items",methodName:"onItemsChanged"}]}}