import { LocalStorageService } from '../storage';
import { RepositoryReference } from '../../models/repositories';
/**
 * Service that handles the repository related properties in the local storage.
 */
export declare class RepositoryStorageService extends LocalStorageService {
    readonly NAMESPACE = "repository";
    private readonly logger;
    /** Key under which the selected repository reference is stored. */
    readonly SELECTED_REPOSITORY = "selectedRepository";
    /**
     * Sets a value in local storage for the given key. If the value is falsy, the key is removed instead.
     *
     * @param {string} key - The key under which to store the value.
     * @param {string} value - The value to store. If falsy, the key will be removed.
     */
    set(key: string, value: string | null): void;
    /**
     * Serializes and stores a RepositoryReference in local storage.
     *
     * @param {RepositoryReference} repositoryReference - The repository reference to store.
     */
    setRepositoryReference(repositoryReference: RepositoryReference): void;
    /**
     * Retrieves and deserializes the stored RepositoryReference from local storage.
     *
     * @returns {RepositoryReference | undefined} The deserialized repository reference, or undefined if not found.
     */
    getRepositoryReference(): RepositoryReference | undefined;
    /**
     * Removes the stored RepositoryReference from local storage.
     */
    removeRepositoryReference(): void;
    private serializeRepositoryReference;
    private deserializeRepositoryReference;
}
