import { SuggestionList } from '../../../models/rdf-search/suggestion-list';
import { Mapper } from '../../../providers/mapper/mapper';
import { SuggestionResponse } from '../../../models/rdf-search/api/suggestion-response';
/**
 * Mapper class for converting an array of Suggestion objects to a SuggestionList model.
 */
export declare class SuggestionListMapper extends Mapper<SuggestionList> {
    /**
     * Maps an array of SuggestionResponse objects to a SuggestionList model.
     *
     * @param data - An array of SuggestionResponse objects to be converted into a SuggestionList.
     * @returns A new SuggestionList instance containing the provided Suggestion objects.
     */
    mapToModel(data: SuggestionResponse[]): SuggestionList;
}
