import { License } from '../../models/license';
import { Service } from '../../providers/service/service';
/**
 * Service class for handling license-related operations.
 */
export declare class LicenseService implements Service {
    private readonly licenseRestService;
    private readonly licenseMapper;
    private readonly trackableProductTypes;
    private readonly trackableTypesOfUse;
    /**
     * Retrieves the current license information.
     *
     * This function fetches the current license data from the license REST service
     * and maps the response to a License model object.
     *
     * @returns {Promise<License>} A Promise that resolves to a License object representing the current license.
     */
    getLicense(): Promise<License>;
    /**
     * Determines if the current license can be tracked.
     *
     * This function checks the product type and type of use of the current license
     * to determine if it's a trackable license. A license is considered trackable if:
     * - A license is not present, or
     * - The product type is 'free', or
     * - The product type is `sandbox`, or
     * - The type of use is `evaluation` (case-insensitive), or
     * - The type of use is `this is an evaluation license` (case-insensitive)
     *
     * @returns {boolean} True if the license is a free license, false otherwise.
     */
    isTrackableLicense(): boolean;
}
