export declare const HTTP_REQUEST_DONE_EVENT = "http-request-done-event";
/**
 * A service class for performing HTTP requests.
 */
export declare class HttpService {
    private readonly interceptorService;
    private readonly eventEmitter;
    /**
     * Performs an HTTP GET request.
     *
     * @param url     The URL to send the request to.
     * @param params  (Optional) An object containing query parameters as key-value pairs.
     * @param headers (Optional) An object containing request headers as key-value pairs.
     * @returns A Promise that resolves to the response data of type `T`.
     */
    get<T>(url: string, params?: Record<string, string | number>, headers?: Record<string, string>): Promise<T>;
    /**
     * Performs an HTTP POST request.
     *
     * @param url     The URL to send the request to.
     * @param body    (Optional) The body of the request.
     * @param headers (Optional) An object containing request headers as key-value pairs.
     * @returns A Promise that resolves to the response data of type `T`.
     */
    post<T>(url: string, body?: unknown, headers?: Record<string, string>): Promise<T>;
    /**
     * Performs an HTTP PUT request.
     *
     * @param url     The URL to send the request to.
     * @param body    (Optional) The body of the request.
     * @param headers (Optional) An object containing request headers as key-value pairs.
     * @returns A Promise that resolves to the response data of type `T`.
     */
    put<T>(url: string, body?: unknown, headers?: Record<string, string>): Promise<T>;
    /**
     * Performs an HTTP DELETE request.
     *
     * @param url     The URL to send the request to.
     * @param headers (Optional) An object containing request headers as key-value pairs.
     * @returns A Promise that resolves to the response data of type `T`.
     */
    delete<T>(url: string, headers?: Record<string, string>): Promise<T>;
    /**
     * Performs an HTTP PATCH request.
     *
     * @param url     The URL to send the request to.
     * @param body    (Optional) The body of the request.
     * @param headers (Optional) An object containing request headers as key-value pairs.
     * @returns A Promise that resolves to the response data of type `T`.
     */
    patch<T>(url: string, body?: unknown, headers?: Record<string, string>): Promise<T>;
    /**
     * Path string variable can contain characters which encodeURIComponent() can have problems encoding.
     * These characters are replaced in this method.
     * @param str - a component of URI
     * @returns {string} The provided string encoded as a URI component.
     */
    protected encodeURIComponentStrict(str: string): string;
    /**
     * Performs an HTTP request with the specified method and options.
     *
     * @param url     The URL to send the request to.
     * @param method  The HTTP method to use (GET, POST, PUT, DELETE).
     * @param options (Optional) An object containing the request options, including:
     *                 - `params`: Query parameters as key-value pairs.
     *                 - `headers`: Request headers as key-value pairs.
     *                 - `body`: The request body.
     * @returns A Promise that resolves with the response data of type T, or is rejected with an error if the request fails.
     */
    private request;
    private hasValidJson;
    /**
     * Builds a query string from an object of parameters.
     *
     * @param params An object containing query parameters as key-value pairs.
     * @returns A query string suitable for appending to a URL.
     */
    private buildQueryParams;
}
