/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.ontotext.config.RepositoryTemplateParameters;
import com.ontotext.forest.repositories.OwlimParameter;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBRuleset;
import com.ontotext.trree.monitorRepository.MonitorRepositoryConfig;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Pattern;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.impl.TreeModel;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.repository.config.DelegatingRepositoryImplConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryImplConfig;
import org.eclipse.rdf4j.sail.config.SailConfigException;

@Schema
@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class RepositoryConfigBean {
    private static Map<String, String> sailType2Type = new HashMap<String, String>();
    @Pattern(regexp="[a-zA-z0-9_-]*", message="Only letters, numbers and hyphens are allowed in a repository name.")
    private @Pattern(regexp="[a-zA-z0-9_-]*", message="Only letters, numbers and hyphens are allowed in a repository name.") String id;
    private String title;
    private String type;
    private String sesameType;
    private String location;
    private Map<String, OwlimParameter> params;

    public RepositoryConfigBean() {
    }

    public RepositoryConfigBean(RepositoryConfig repoConfig) {
        this.id = repoConfig.getID();
        this.title = repoConfig.getTitle();
        this.sesameType = repoConfig.getRepositoryImplConfig().getType();
        this.type = sailType2Type.get(this.sesameType);
        this.params = new HashMap<String, OwlimParameter>();
        OwlimParameter shaclParameter = new OwlimParameter("isShacl", "false");
        this.params.put(shaclParameter.getName(), shaclParameter);
        RepositoryImplConfig repositoryImplConfig = repoConfig.getRepositoryImplConfig();
        if (repositoryImplConfig instanceof DelegatingRepositoryImplConfig) {
            repositoryImplConfig = ((DelegatingRepositoryImplConfig)repositoryImplConfig).getDelegate();
        }
        if (repositoryImplConfig instanceof MonitorRepositoryConfig && "rdf4j:ShaclSail".equals(((MonitorRepositoryConfig)repositoryImplConfig).getSailImplConfig().getType())) {
            shaclParameter.setValue("true");
            this.params.put(shaclParameter.getName(), shaclParameter);
        }
        TreeModel configImpl = new TreeModel();
        repoConfig.export((Model)configImpl);
        RepositoryTemplateParameters.getPredicatesMap().forEach((arg_0, arg_1) -> this.lambda$new$0((Model)configImpl, arg_0, arg_1));
    }

    public Map<String, String> toConfigParameters() {
        HashMap<String, String> setParameters = new HashMap<String, String>();
        setParameters.put(RepositoryTemplateParameters.getLabel((String)"id"), this.id);
        setParameters.put(RepositoryTemplateParameters.getLabel((String)"title"), this.title);
        for (OwlimParameter parameter : this.params.values()) {
            if (parameter.getName().equals("id") || parameter.getName().equals("title")) continue;
            if (parameter.getName().equals("member")) {
                StringBuilder newValue = new StringBuilder();
                List allMembers = (List)parameter.getValue();
                int numberOfMembers = allMembers.size();
                for (int i = 0; i < numberOfMembers; ++i) {
                    newValue.append("[");
                    Map member = (Map)allMembers.get(i);
                    Iterator currentParamIterator = member.entrySet().iterator();
                    while (currentParamIterator.hasNext()) {
                        Map.Entry entry = currentParamIterator.next();
                        if (((String)entry.getKey()).equals("endpoint")) {
                            newValue.append("sd:").append((String)entry.getKey()).append(" \"").append((String)entry.getValue()).append("\"").append(currentParamIterator.hasNext() ? ";" : "]");
                            continue;
                        }
                        newValue.append("fedx:").append((String)entry.getKey()).append(" \"").append((String)entry.getValue()).append("\"").append(currentParamIterator.hasNext() ? ";" : "]");
                    }
                    newValue.append(i != numberOfMembers - 1 ? "," : "");
                }
                setParameters.put(parameter.getLabel(), newValue.toString());
                continue;
            }
            if (parameter.getName().equals("ruleset")) {
                String value = parameter.getValueString();
                if (!GraphDBRuleset.contains((String)value) && value.startsWith(Config.getDataDirectory())) {
                    value = this.relativizePathToCustomRuleset(value);
                }
                setParameters.put(parameter.getLabel(), value.replaceAll("\\\\", "/"));
                continue;
            }
            setParameters.put(parameter.getLabel(), parameter.getValueString());
        }
        return setParameters;
    }

    private String relativizePathToCustomRuleset(String path) {
        Path abs = Path.of(path, new String[0]);
        Path base = Path.of(Config.getDataDirectory(), new String[0]);
        return base.relativize(abs).toString();
    }

    public String getType() {
        return this.type;
    }

    public void setType(String repositoryType) {
        this.type = repositoryType;
    }

    public String getId() {
        return this.id;
    }

    public void setSesameType(String sesameType) {
        this.sesameType = sesameType;
    }

    public String getSesameType() {
        return this.sesameType;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Map<String, OwlimParameter> getParams() {
        return this.params;
    }

    public void setParams(Map<String, OwlimParameter> params) {
        this.params = params;
    }

    public String getLocation() {
        return this.location;
    }

    public void setLocation(String location) {
        this.location = location;
    }

    public void setMissingDefaults(Map<String, OwlimParameter> defaultsForType) {
        for (Map.Entry<String, OwlimParameter> e : defaultsForType.entrySet()) {
            String key = e.getKey();
            if ("title".equals(key) || "id".equals(key) || this.params.containsKey(key)) continue;
            this.params.put(key, e.getValue());
        }
    }

    private /* synthetic */ void lambda$new$0(Model configImpl, IRI predicate, String name) {
        if (!name.equals("id") && !name.equals("title")) {
            RepositoryTemplateParameters.ValueType valueType = RepositoryTemplateParameters.getValueType((String)name);
            Object convertedValue = null;
            switch (valueType) {
                case LEGACY: {
                    Optional value = Models.objectLiteral((Model)configImpl.filter(null, predicate, null, new Resource[0]));
                    if (value.isPresent()) {
                        convertedValue = ((Literal)value.get()).getLabel();
                        break;
                    }
                    if (!name.equals("member")) break;
                    Model members = configImpl.filter(null, predicate, null, new Resource[0]);
                    ArrayList membersParamValue = new ArrayList();
                    for (Statement st : members) {
                        LinkedHashMap<String, String> currentMember = new LinkedHashMap<String, String>();
                        BNode memberNode = (BNode)st.getObject();
                        Model memberAllParameters = configImpl.filter((Resource)memberNode, null, null, new Resource[0]);
                        for (Statement p : memberAllParameters) {
                            currentMember.put(p.getPredicate().getLocalName(), p.getObject().stringValue());
                        }
                        membersParamValue.add(currentMember);
                    }
                    convertedValue = membersParamValue;
                    break;
                }
                case LITERAL: 
                case IRI: {
                    convertedValue = RepositoryTemplateParameters.extractSingleValueForPredicate((Model)configImpl, (IRI)predicate);
                    break;
                }
                case MULTIPLE_LITERAL: {
                    convertedValue = RepositoryTemplateParameters.extractMultipleValuesForPredicate((Model)configImpl, (IRI)predicate, Literal.class);
                    break;
                }
                case MULTIPLE_IRI: {
                    convertedValue = RepositoryTemplateParameters.extractMultipleValuesForPredicate((Model)configImpl, (IRI)predicate, IRI.class);
                    break;
                }
                case RDF_LIST_LITERAL: {
                    convertedValue = RepositoryTemplateParameters.extractRDFListForPredicate((Model)configImpl, (IRI)predicate, Literal.class);
                    break;
                }
                case RDF_LIST_IRI: {
                    convertedValue = RepositoryTemplateParameters.extractRDFListForPredicate((Model)configImpl, (IRI)predicate, IRI.class);
                    break;
                }
                default: {
                    throw new SailConfigException("Unknown value type: " + String.valueOf(valueType));
                }
            }
            if (convertedValue != null) {
                OwlimParameter param = new OwlimParameter(name, convertedValue);
                this.params.put(param.getName(), param);
            }
        }
    }

    static {
        sailType2Type.put("openrdf:SystemRepository", "openrdf-system");
        sailType2Type.put("graphdb:OntopRepository", "ontop");
        sailType2Type.put("graphdb:FedXRepository", "fedx");
        sailType2Type.put("graphdb:SailRepository", "graphdb");
    }
}

