/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ontotext.config.RepositoryTemplateParameters;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.rdf4j.repository.config.ConfigTemplate;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.ANY)
public class OwlimParameter {
    private final String label;
    private final String name;
    private Object value;

    public static List<OwlimParameter> loadFromConfigTemplate(ConfigTemplate configTemplate) {
        Map variableMap = configTemplate.getVariableMap();
        ArrayList<OwlimParameter> parameters = new ArrayList<OwlimParameter>(variableMap.size());
        for (Map.Entry variable : variableMap.entrySet()) {
            String templateLabel = (String)variable.getKey();
            List templateDefaultValues = (List)variable.getValue();
            String name = RepositoryTemplateParameters.getName((String)templateLabel);
            if (name == null) {
                throw new IllegalStateException(String.format("Unknown repository config parameter was found in config template: '%s'", templateLabel));
            }
            OwlimParameter parameter = new OwlimParameter(name, templateLabel, templateDefaultValues.isEmpty() ? "" : templateDefaultValues.get(0));
            parameters.add(parameter);
        }
        parameters.add(new OwlimParameter("isShacl", "false"));
        return parameters;
    }

    @JsonCreator
    OwlimParameter(@JsonProperty(value="name") String name, @JsonProperty(value="label") String label, @JsonProperty(value="value") Object value) {
        this.name = name;
        this.label = label;
        this.value = value;
    }

    public OwlimParameter(String name, Object value) {
        this(name, RepositoryTemplateParameters.getLabel((String)name), value);
    }

    public String getLabel() {
        return this.label;
    }

    public String getName() {
        return this.name;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @JsonIgnore
    public String getValueString() {
        return RepositoryTemplateParameters.convertValueStringToTemplateValue((String)this.name, (String)this.getValue().toString());
    }

    @JsonIgnore
    public OwlimParameter copyOf() {
        return new OwlimParameter(this.name, this.label, this.value);
    }
}

