/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.semantic.LocationPingResult;
import com.ontotext.forest.core.semantic.LocationType;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.location.LocationService;
import com.ontotext.forest.core.semantic.location.SemanticLocationAuth;
import com.ontotext.graphdb.security.AuthType;
import io.swagger.v3.oas.annotations.Hidden;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.tags.Tag;
import jakarta.annotation.Nonnull;
import jakarta.annotation.Nullable;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.rdf4j.repository.RepositoryException;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@RequestMapping(value={"/rest/locations"})
@Controller
@Tag(name="Location Management", description="Manage locations within the system")
public class LocationManagementController {
    private static final Logger LOG = LoggerFactory.getLogger(LocationManagementController.class);
    private static final String URI_PARAM_DOC = "The GraphDB location URL";
    private static final String USERNAME_PARAM_DOC = "Username for the new location if any. This parameter only makes sense for remote locations";
    private static final String PASSWORD_PARAM_DOC = "Password for the new location if any. This parameter only makes sense for remote locations";
    private static final String AUTH_TYPE_PARAM_DOC = "Authentication type";
    private static final String LOCATION_TYPE_PARAM_DOC = "Remote location type";
    private static final String DEFAULT_REPOSITORY_PARAM_DOC = "Default repository for the location.";
    @Autowired
    private LocationService locationService;

    @Operation(summary="Connect to a remote GraphDB location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={""}, produces={"text/plain"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<String> addLocation(@RequestBody Location location) {
        try {
            String locUri = location.getUri();
            if (new File(locUri).isAbsolute()) {
                throw new IllegalArgumentException("Support for multiple local locations has been removed in GraphDB 8.");
            }
            if (!this.locationService.addLocation(location.getUri(), location.getAuthType(), location.getLocationType(), location.getUsername(), location.getPassword(), location.getDefaultRepository())) {
                return new ResponseEntity((Object)("Location '" + locUri + "' already connected"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
            }
            return new ResponseEntity((Object)"Successfully connected new GraphDB location.", (HttpStatusCode)HttpStatus.OK);
        }
        catch (GraphDBWorkbenchException | IllegalArgumentException e) {
            LOG.error("Couldn't connect to the new location", e);
            return new ResponseEntity((Object)("Couldn't connect to the new location. " + e.getMessage()), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
    }

    @Hidden
    @GetMapping(value={"/id"})
    public ResponseEntity<String> getLocationId(HttpServletResponse httpServletResponse) {
        httpServletResponse.setHeader(SemanticLocation.HAS_ACTIVE_LOCATION_HEADER, Boolean.toString(this.locationService.getCurrentLocation() != null));
        return new ResponseEntity((Object)this.locationService.getUniqueLocationId(), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Modify settings for a connected GraphDB location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PutMapping(value={""}, produces={"text/plain"}, consumes={"application/json"})
    @ResponseBody
    public ResponseEntity<String> changeLocation(@RequestBody UpdatedLocation location) {
        if (!this.locationService.updateLocation(location.getUri(), location.getAuthType(), location.getLocationType(), location.getUsername(), location.getPassword(), location.getDefaultRepository())) {
            return new ResponseEntity((Object)("Location '" + location.getUri() + "' does not exist!"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        return new ResponseEntity((Object)("Successfully changed location settings for '" + location.getUri() + "'"), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Set default repository for active GraphDB location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @PostMapping(value={"/active/default-repository"}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> setDefaultRepository(@RequestBody DefaultRepositoryLocation defaultRepositoryLocation) throws GraphDBWorkbenchException {
        String repository = defaultRepositoryLocation.getDefaultRepository();
        if ("SYSTEM".equals(repository)) {
            return new ResponseEntity((Object)"SYSTEM repository may not be set as default.", (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        SemanticLocation semanticLocation = this.locationService.getCurrentLocationOrThrow();
        this.locationService.updateLocation(semanticLocation.getLocation(), semanticLocation.getAuthType(), semanticLocation.getLocationType(), semanticLocation.getUsername(), semanticLocation.getPassword(), repository);
        return new ResponseEntity((Object)("Changed default repository for location '" + semanticLocation.getLabel() + "'"), (HttpStatusCode)HttpStatus.OK);
    }

    @Operation(summary="Disconnect a GraphDB location", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="400", description="Bad Request", content={@Content(mediaType="text/plain", schema=@Schema(implementation=String.class))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content}), @ApiResponse(responseCode="403", description="Forbidden", content={@Content})})
    @DeleteMapping(value={""}, produces={"text/plain"})
    @ResponseBody
    public ResponseEntity<String> deleteLocation(@Parameter(description="The GraphDB location URL") @RequestParam(value="uri") String location) throws RepositoryException {
        if (this.locationService.deleteLocation(location)) {
            return new ResponseEntity((Object)("Successfully removed location '" + location + "'"), (HttpStatusCode)HttpStatus.OK);
        }
        return new ResponseEntity((Object)("Location '" + location + "' does not exist or is the system one!"), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    @Operation(summary="Get all connected GraphDB locations", responses={@ApiResponse(responseCode="200", description="OK", content={@Content(mediaType="application/json", array=@ArraySchema(schema=@Schema(implementation=Location.class)))}), @ApiResponse(responseCode="401", description="Unauthorized", content={@Content})})
    @GetMapping(produces={"application/json"})
    @ResponseBody
    public List<Location> getAll() {
        return this.getLocations(this.locationService.getCurrentLocationOrThrow(), this.locationService.getLocations());
    }

    @Operation(summary="Get active connected GraphDB location")
    @GetMapping(value={"/active"}, produces={"application/json"})
    @ResponseBody
    public Location getActiveLocation() {
        SemanticLocation current = this.locationService.getCurrentLocation();
        Location location = null;
        if (current != null) {
            current.initializeAsNeeded();
            location = new Location();
            location.setUri(current.getLocation());
            location.setLabel(current.getLabel());
            location.setUsername(current.getUsername());
            location.setPassword(current.getPassword());
            location.setLocal(current.isLocal());
            location.setSystem(current.isSystem());
            location.setErrorMsg(current.getErrorMsg());
            location.setActive(true);
            location.setDefaultRepository(current.getDefaultRepository());
        }
        return location;
    }

    @Hidden
    @GetMapping(value={"/ping-location"})
    @ResponseBody
    public ResponseEntity<?> pingLocation(@Nullable @RequestParam(value="url") String nodeExternalURL, @RequestParam(defaultValue="false") boolean sendURL) throws RepositoryException {
        if (nodeExternalURL == null) {
            return new ResponseEntity((HttpStatusCode)HttpStatus.OK);
        }
        SemanticLocation currentLocation = this.locationService.getCurrentLocationOrThrow();
        LocationPingResult locationPingResult = currentLocation.pingLocationWithSigningHttpClient(nodeExternalURL, sendURL);
        return ResponseEntity.status((int)locationPingResult.getStatusCode()).body((Object)locationPingResult.getMessage());
    }

    @NotNull
    private List<Location> getLocations(SemanticLocation current, Collection<SemanticLocationAuth> locations) {
        ArrayList<Location> result = new ArrayList<Location>();
        for (SemanticLocationAuth semanticLocationAuth : locations) {
            semanticLocationAuth.initializeAsNeeded();
            Location location = new Location();
            location.setUri(semanticLocationAuth.getLocation());
            location.setLabel(semanticLocationAuth.getLabel());
            location.setUsername(semanticLocationAuth.getUsername());
            location.setAuthType(semanticLocationAuth.getAuthType());
            location.setLocationType(semanticLocationAuth.getLocationType());
            location.setLocal(semanticLocationAuth.isLocal());
            location.setSystem(semanticLocationAuth.isSystem());
            location.setErrorMsg(semanticLocationAuth.getErrorMsg());
            location.setDefaultRepository(semanticLocationAuth.getDefaultRepository());
            result.add(location);
            if (semanticLocationAuth != current) continue;
            location.setActive(true);
        }
        return result;
    }

    @Schema
    public static class Location {
        @Schema(description="The GraphDB location URL")
        @Nonnull
        private String uri;
        @Schema(description="Human readable label")
        private String label;
        @Schema(description="Username for the new location if any. This parameter only makes sense for remote locations")
        private String username;
        @Schema(description="Password for the new location if any. This parameter only makes sense for remote locations")
        private String password;
        @Schema(description="Authentication type")
        private AuthType authType;
        @Schema(description="Remote location type")
        private LocationType locationType;
        @Schema(description="True if the location is the currently active one")
        private boolean active;
        @Schema(description="True if the location is local (on the same machine as the workbench)")
        private boolean local;
        @Schema(description="True if the location is the system location")
        private boolean system;
        @Schema(description="Error message, if there was an error connecting to this location")
        private String errorMsg;
        @Schema(description="Default repository for the location.")
        private String defaultRepository;

        public String getUri() {
            return this.uri;
        }

        public void setUri(String uri) {
            this.uri = uri;
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public AuthType getAuthType() {
            return this.authType;
        }

        public void setAuthType(AuthType authType) {
            this.authType = authType;
        }

        public LocationType getLocationType() {
            return this.locationType;
        }

        public void setLocationType(LocationType locationType) {
            this.locationType = locationType;
        }

        public void setActive(boolean active) {
            this.active = active;
        }

        public boolean isActive() {
            return this.active;
        }

        public void setLocal(boolean local) {
            this.local = local;
        }

        public boolean isLocal() {
            return this.local;
        }

        public void setSystem(boolean system) {
            this.system = system;
        }

        public boolean isSystem() {
            return this.system;
        }

        public void setErrorMsg(String errorMsg) {
            this.errorMsg = errorMsg;
        }

        public String getErrorMsg() {
            return this.errorMsg;
        }

        public String getDefaultRepository() {
            return this.defaultRepository;
        }

        public void setDefaultRepository(String defaultRepository) {
            this.defaultRepository = defaultRepository;
        }
    }

    @Schema
    public static class UpdatedLocation {
        @Schema(description="The GraphDB location URL")
        @Nonnull
        private String uri;
        @Schema(description="Username for the new location if any. This parameter only makes sense for remote locations")
        private String username;
        @Schema(description="Password for the new location if any. This parameter only makes sense for remote locations")
        private String password;
        @Schema(description="Authentication type")
        private AuthType authType;
        @Schema(description="Remote location type")
        private LocationType locationType;
        @Schema(description="Default repository for the location.")
        private String defaultRepository;

        @Nonnull
        public String getUri() {
            return this.uri;
        }

        public void setUri(@Nonnull String uri) {
            this.uri = uri;
        }

        public String getUsername() {
            return this.username;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setPassword(String password) {
            this.password = password;
        }

        public AuthType getAuthType() {
            return this.authType;
        }

        public void setAuthType(AuthType authType) {
            this.authType = authType;
        }

        public LocationType getLocationType() {
            return this.locationType;
        }

        public void setLocationType(LocationType locationType) {
            this.locationType = locationType;
        }

        public String getDefaultRepository() {
            return this.defaultRepository;
        }

        public void setDefaultRepository(String defaultRepository) {
            this.defaultRepository = defaultRepository;
        }
    }

    public static class DefaultRepositoryLocation {
        @Schema(description="Default repository for the location.")
        private String defaultRepository;

        public String getDefaultRepository() {
            return this.defaultRepository;
        }

        public void setDefaultRepository(String defaultRepository) {
            this.defaultRepository = defaultRepository;
        }
    }

    public static class LocationUri {
        @Schema(description="The GraphDB location URL")
        @Nonnull
        private String uri;

        @Nonnull
        public String getUri() {
            return this.uri;
        }

        public void setUri(@Nonnull String uri) {
            this.uri = uri;
        }
    }
}

