/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.repositories;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Charsets;
import com.google.common.io.Resources;
import com.ontotext.config.RepositoryTemplateParameters;
import com.ontotext.forest.core.error.GraphDBWorkbenchException;
import com.ontotext.forest.core.graphdb.RepositorySizeInfo;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.semantic.repository.RepositorySysInfoOptions;
import com.ontotext.forest.core.semantic.repository.SemanticRepository;
import com.ontotext.forest.repositories.OwlimParameter;
import com.ontotext.forest.repositories.RepositoryConfigBean;
import com.ontotext.forest.repositories.UploadFileResult;
import com.ontotext.forest.repositories.ontop.JDBCPropertiesFileBean;
import com.ontotext.forest.repositories.ontop.JdbcDriver;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.ontop.GraphDBJDBCDriverUtil;
import com.ontotext.trree.OwlimSchemaRepository;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.rdf4j.common.transaction.IsolationLevel;
import org.eclipse.rdf4j.common.transaction.IsolationLevels;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.model.impl.LinkedHashModel;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.model.util.Configurations;
import org.eclipse.rdf4j.model.vocabulary.CONFIG;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.base.RepositoryWrapper;
import org.eclipse.rdf4j.repository.config.ConfigTemplate;
import org.eclipse.rdf4j.repository.config.RepositoryConfig;
import org.eclipse.rdf4j.repository.config.RepositoryConfigException;
import org.eclipse.rdf4j.repository.config.RepositoryConfigSchema;
import org.eclipse.rdf4j.repository.http.HTTPRepository;
import org.eclipse.rdf4j.repository.sail.SailRepository;
import org.eclipse.rdf4j.repository.sail.SailRepositoryConnection;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RDFParseException;
import org.eclipse.rdf4j.rio.RDFParser;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.eclipse.rdf4j.sail.Sail;
import org.eclipse.rdf4j.sail.helpers.SailWrapper;
import org.eclipse.rdf4j.sail.memory.MemoryStore;
import org.eclipse.rdf4j.sail.shacl.ShaclValidator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class GraphDBRepositoriesService {
    private static final Logger logger = LoggerFactory.getLogger(GraphDBRepositoriesService.class);
    private static final Pattern TOKEN_PATTERN = Pattern.compile("\\{%[\\p{Print}&&[^\\}]]+%\\}");
    public static final String SHACL_SUFFIX = "-shacl";
    public static final String GRAPHDB_REPO_TYPE = "graphdb";
    public static final String FEDX_REPO_TYPE = "fedx";
    public static final String ONTOP_REPO_TYPE = "ontop";
    public static final String JDBC_HOSTNAME = "hostName";
    public static final String JDBC_PORT = "port";
    public static final String JDBC_DATABASE_NAME = "databaseName";
    private static final String ONTOP_PROPERTIES_PREFIX = "jdbc.";
    private static final String ONTOP_URL_PROPERTY = "jdbc.url";
    private static final String ONTOP_DRIVER_PROPERTY = "jdbc.driver";
    private static final String ONTOP_USER_PROPERTY = "jdbc.user";
    private static final String ONTOP_PASS_PROPERTY = "jdbc.password";
    private static final String ONTOP_PROPERTIES_SEPARATOR = "=";
    private final Map<String, Map<String, OwlimParameter>> cachedParameters = new HashMap<String, Map<String, OwlimParameter>>(4);
    private Sail sail;

    public GraphDBRepositoriesService() throws Exception {
        this.cachedParameters.put(ONTOP_REPO_TYPE, this.loadParametersForType(ONTOP_REPO_TYPE));
        this.cachedParameters.put(FEDX_REPO_TYPE, this.loadParametersForType(FEDX_REPO_TYPE));
        this.cachedParameters.put(GRAPHDB_REPO_TYPE, this.loadParametersForType("graphdb-shacl"));
    }

    public Map<String, OwlimParameter> getParametersForType(String type) {
        Map params = this.cachedParameters.get(type);
        return params != null ? params : Collections.EMPTY_MAP;
    }

    public RepositoryConfig getRepositoryConfig(RepositoryConfigBean repoConfigBean) throws RepositoryConfigException {
        String repositoryType = repoConfigBean.getType();
        Map<String, String> params = repoConfigBean.toConfigParameters();
        switch (repositoryType) {
            case "graphdb": 
            case "ontop": 
            case "fedx": {
                return this.getConfigForRepositoryType(params, repositoryType);
            }
        }
        throw new IllegalArgumentException("Invalid repository type specified!");
    }

    public String getTurtleRepositoryConfiguration(Map<String, String> setParameters, String repoType) {
        String template;
        boolean isShacl = false;
        if ("true".equalsIgnoreCase(setParameters.get(RepositoryTemplateParameters.getLabel((String)"isShacl")))) {
            isShacl = true;
        }
        try {
            template = Resources.toString((URL)Resources.getResource((String)(repoType + (isShacl ? SHACL_SUFFIX : "") + ".ttl")), (Charset)Charsets.UTF_8);
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't find the template for the specified repository type!", e);
        }
        return this.render(template, setParameters);
    }

    public String render(String templateWithParameters, Map<String, String> valueMap) {
        StringBuffer result = new StringBuffer(templateWithParameters.length());
        Matcher matcher = TOKEN_PATTERN.matcher(templateWithParameters);
        while (matcher.find()) {
            String group = matcher.group();
            String[] tokensArray = group.substring(2, group.length() - 2).split("\\|");
            String var = tokensArray[0].trim();
            String value = valueMap.get(var);
            if (StringUtils.isEmpty((CharSequence)value) && !"Repository description".equals(var) && tokensArray.length > 1) {
                String convertedDefaultValue = this.convertMultiValueParam(var, tokensArray[1].trim());
                matcher.appendReplacement(result, Matcher.quoteReplacement(convertedDefaultValue));
                continue;
            }
            if (value == null) {
                throw new IllegalStateException("Missing parameter " + var);
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(result);
        return result.toString().replaceAll("\"\\[", "[").replaceAll("]\"", "]");
    }

    /*
     * Enabled aggressive block sorting
     */
    public RepositorySizeInfo getRepositorySizeInfo(SemanticLocation semanticLocation, String repositoryID) {
        OwlimSchemaRepository schemaRepository;
        SemanticRepository semanticRepository = semanticLocation.getRepository(repositoryID);
        Repository repository = semanticRepository.getRepository();
        if (repository instanceof RepositoryWrapper) {
            repository = ((RepositoryWrapper)repository).getDelegate();
        }
        if (repository instanceof HTTPRepository) {
            Map remoteRepoSysInfoMap = semanticRepository.getSysInfoMapRemotely();
            Literal allStatements = (Literal)remoteRepoSysInfoMap.get(RepositorySysInfoOptions.NUMBER_OF_TRIPLES);
            Literal explicitStatements = (Literal)remoteRepoSysInfoMap.get(RepositorySysInfoOptions.NUMBER_OF_EXPLICIT_TRIPLES);
            if (allStatements != null && explicitStatements != null) {
                long total = allStatements.longValue();
                long explicit = explicitStatements.longValue();
                return new RepositorySizeInfo(total, total - explicit, explicit);
            }
            return new RepositorySizeInfo();
        }
        if (repository instanceof OwlimSchemaRepository) {
            schemaRepository = (OwlimSchemaRepository)repository;
        } else {
            if (!(repository instanceof SailRepository)) {
                logger.error("Couldn't get sail repository. " + String.valueOf(repository.getClass()));
                return new RepositorySizeInfo();
            }
            this.sail = ((SailRepository)repository).getSail();
            while (this.sail instanceof SailWrapper) {
                this.sail = ((SailWrapper)this.sail).getBaseSail();
            }
            if (!(this.sail instanceof OwlimSchemaRepository)) {
                logger.error("Couldn't get size from sail repository. " + String.valueOf(this.sail.getClass()));
                return new RepositorySizeInfo();
            }
            schemaRepository = (OwlimSchemaRepository)this.sail;
        }
        if (schemaRepository.getRepository() != null) {
            return new RepositorySizeInfo(schemaRepository.getRepository());
        }
        logger.error("Couldn't get size from repository. " + String.valueOf(repository.getClass()));
        return new RepositorySizeInfo();
    }

    public Model validateRepository(SemanticLocation semanticLocation, String dataRepositoryID, String shapesRepositoryID) {
        Sail shapesSail = GraphDBRepositoriesService.getSailForValidation(semanticLocation, shapesRepositoryID);
        Sail dataSail = GraphDBRepositoriesService.getSailForValidation(semanticLocation, dataRepositoryID);
        return ShaclValidator.validate((Sail)dataSail, (Sail)shapesSail).asModel();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model validateRepository(SemanticLocation semanticLocation, String dataRepositoryID, String shapes, RDFFormat rdfFormat) {
        Sail dataSail = GraphDBRepositoriesService.getSailForValidation(semanticLocation, dataRepositoryID);
        SailRepository shapesRepo = new SailRepository((Sail)new MemoryStore());
        try {
            try (SailRepositoryConnection connection = shapesRepo.getConnection();){
                connection.begin((IsolationLevel)IsolationLevels.NONE);
                connection.add((Reader)new StringReader(shapes), rdfFormat, new Resource[0]);
                connection.commit();
            }
            catch (IOException e) {
                throw new IllegalStateException("This should never happen because we are using a StringReader", e);
            }
            Model model = ShaclValidator.validate((Sail)dataSail, (Sail)shapesRepo.getSail()).asModel();
            return model;
        }
        finally {
            shapesRepo.shutDown();
        }
    }

    public void validateOntopConnectionProperties(OwlimParameter ontopProperties) throws SQLException {
        Properties properties = this.getOntopConnectionProperties(ontopProperties.getValueString());
        if (!properties.containsKey("url")) {
            throw new GraphDBWorkbenchException("Missing URL property");
        }
        this.attemptConnectToDatabase(properties);
    }

    public void validateAdditionalProperties(Properties defaultProperties, String additionalPropertiesString) throws IOException {
        if (additionalPropertiesString == null) {
            return;
        }
        Properties additionalPropsToValidate = new Properties();
        additionalPropsToValidate.load(new StringReader(additionalPropertiesString));
        boolean isWrongFormatted = false;
        for (Map.Entry<Object, Object> entry : additionalPropsToValidate.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (defaultProperties.containsKey(key)) continue;
            if (!value.isEmpty()) {
                additionalPropsToValidate.remove(key);
                continue;
            }
            isWrongFormatted = true;
        }
        int invalidPropertiesCount = additionalPropsToValidate.size();
        if (invalidPropertiesCount == 1) {
            throw new GraphDBWorkbenchException("Property '" + additionalPropsToValidate.keySet().iterator().next().toString() + (isWrongFormatted ? "' isn't properly formatted." : "' already exists in the JDBC properties file."));
        }
        if (invalidPropertiesCount > 1) {
            throw new GraphDBWorkbenchException("Properties '" + String.join((CharSequence)", ", additionalPropsToValidate.keySet().stream().map(Object::toString).collect(Collectors.toSet())) + (isWrongFormatted ? "' aren't properly formatted." : "' already exist in the JDBC properties file."));
        }
    }

    public UploadFileResult storeOntopProperties(File destFile, JDBCPropertiesFileBean bean, boolean isGenericDriver) throws IOException {
        Properties defaultProperties = new Properties();
        defaultProperties.setProperty(ONTOP_URL_PROPERTY, bean.getUrl());
        defaultProperties.setProperty(ONTOP_DRIVER_PROPERTY, bean.getDriverClass());
        defaultProperties.setProperty(ONTOP_USER_PROPERTY, bean.getUserName());
        defaultProperties.setProperty(ONTOP_PASS_PROPERTY, bean.getPassword());
        String comments = null;
        String lineSeparator = System.lineSeparator();
        if (!isGenericDriver) {
            comments = this.createPropertiesFileComment(bean, lineSeparator);
        }
        this.validateAdditionalProperties(defaultProperties, bean.getAdditionalProperties());
        try (FileOutputStream outputStream = new FileOutputStream(destFile);){
            defaultProperties.store(outputStream, comments);
            String additionalProperties = bean.getAdditionalProperties();
            if (additionalProperties != null) {
                ((OutputStream)outputStream).write((lineSeparator + "### ADDITIONAL PROPERTIES ###" + lineSeparator + additionalProperties).getBytes());
            }
            UploadFileResult uploadFileResult = new UploadFileResult(true, "", destFile.getAbsolutePath());
            return uploadFileResult;
        }
    }

    public JDBCPropertiesFileBean readOntopProperties(File propertiesFile) throws IOException {
        JDBCPropertiesFileBean bean = new JDBCPropertiesFileBean();
        StringBuilder sb = new StringBuilder();
        try (BufferedReader br = new BufferedReader(new FileReader(propertiesFile));){
            String line;
            String key = "";
            String value = "";
            block23: while ((line = br.readLine()) != null) {
                int index = (line = line.replace("#", "")).indexOf(ONTOP_PROPERTIES_SEPARATOR);
                if (index <= -1) continue;
                key = line.substring(0, index);
                value = line.substring(index + 1);
                switch (key) {
                    case "hostName": {
                        bean.setHostName(value);
                        continue block23;
                    }
                    case "port": {
                        bean.setPort(value);
                        continue block23;
                    }
                    case "databaseName": {
                        bean.setDatabaseName(value);
                        continue block23;
                    }
                    case "jdbc.url": {
                        bean.setUrl(value.replace("\\", ""));
                        continue block23;
                    }
                    case "jdbc.user": {
                        bean.setUserName(value);
                        continue block23;
                    }
                    case "jdbc.password": {
                        bean.setPassword(value);
                        continue block23;
                    }
                    case "jdbc.driver": {
                        bean.setDriverClass(value);
                        continue block23;
                    }
                }
                sb.append(key).append(ONTOP_PROPERTIES_SEPARATOR).append(value).append(System.lineSeparator());
            }
        }
        bean.setAdditionalProperties(sb.toString());
        return bean;
    }

    public List<JdbcDriver> readDriversData() {
        try {
            List jdbcDrivers = (List)new ObjectMapper().readValue(GraphDBRepositoriesService.class.getResource("/supported-drivers-data.json"), (TypeReference)new TypeReference<List<JdbcDriver>>(this){});
            jdbcDrivers.forEach(d -> {
                if (!StringUtils.isEmpty((CharSequence)d.getDriverClass())) {
                    d.setClassAvailable(this.isClassAvailable(d.getDriverClass()));
                }
            });
            return jdbcDrivers;
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Could not get default drivers data", (Throwable)e);
        }
    }

    private static Sail getSailForValidation(SemanticLocation semanticLocation, String dataRepositoryID) {
        OwlimSchemaRepository sail;
        SemanticRepository semanticRepository = semanticLocation.getRepository(dataRepositoryID);
        Repository repository = semanticRepository.getRepository();
        if (repository instanceof RepositoryWrapper) {
            repository = ((RepositoryWrapper)repository).getDelegate();
        }
        if (repository instanceof HTTPRepository) {
            throw new IllegalArgumentException("SHACL validation does not support HTTPRepository");
        }
        if (repository instanceof OwlimSchemaRepository) {
            sail = (OwlimSchemaRepository)repository;
        } else if (repository instanceof SailRepository) {
            sail = ((SailRepository)repository).getSail();
        } else {
            throw new IllegalArgumentException("SHACL validation does not support " + String.valueOf(repository.getClass()));
        }
        return sail;
    }

    private Map<String, OwlimParameter> loadParametersForType(String type) throws Exception {
        String templateContent = Resources.toString((URL)Resources.getResource((String)(type + ".ttl")), (Charset)Charsets.UTF_8);
        ConfigTemplate configTemplate = new ConfigTemplate(templateContent);
        return OwlimParameter.loadFromConfigTemplate(configTemplate).stream().collect(Collectors.toMap(OwlimParameter::getName, Function.identity()));
    }

    private String convertMultiValueParam(String var, String value) {
        RepositoryTemplateParameters.ValueType valueType = RepositoryTemplateParameters.getValueType((String)RepositoryTemplateParameters.getName((String)var));
        if (valueType == RepositoryTemplateParameters.ValueType.RDF_LIST_LITERAL && value.contains(",")) {
            return "(\"" + String.join((CharSequence)"\" \"", value.split("[,\\s]+")) + "\")";
        }
        return value;
    }

    private RepositoryConfig getConfigForRepositoryType(Map<String, String> setParameters, String repoType) throws RepositoryConfigException {
        String ttl = this.getTurtleRepositoryConfiguration(setParameters, repoType);
        return this.createConfig(ttl);
    }

    private RepositoryConfig createConfig(String ttl) throws RepositoryConfigException {
        LinkedHashModel graph = new LinkedHashModel();
        RDFParser rdfParser = Rio.createParser((RDFFormat)RDFFormat.TURTLE, (ValueFactory)SimpleValueFactory.getInstance());
        rdfParser.setRDFHandler((RDFHandler)new StatementCollector((Collection)graph));
        try {
            rdfParser.parse((Reader)new StringReader(ttl), "tag:rdf4j.org,2023:config/");
        }
        catch (IOException e) {
            throw new IllegalStateException("Couldn't read the turtle content!", e);
        }
        catch (RDFParseException e) {
            throw new IllegalStateException("Invalid turtle generated!", e);
        }
        catch (RDFHandlerException e) {
            throw new IllegalStateException("Couldn't collect the statements from the tutle file", e);
        }
        Resource repositoryNode = (Resource)Configurations.getSubjectByType((Model)graph, (IRI)CONFIG.Rep.Repository, (IRI)RepositoryConfigSchema.REPOSITORY).get();
        if (repositoryNode == null) {
            throw new IllegalStateException("Invalid configuration graph!");
        }
        RepositoryConfig repoConfig = RepositoryConfig.create((Model)graph, (Resource)repositoryNode);
        repoConfig.validate();
        return repoConfig;
    }

    private Properties getOntopConnectionProperties(String propertiesPath) {
        Properties properties;
        Properties defaultProperties = new Properties();
        Properties updatedProperties = new Properties();
        FileInputStream inputStream = new FileInputStream(propertiesPath);
        try {
            defaultProperties.load(inputStream);
            defaultProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> updatedProperties.put(k.toString().replace(ONTOP_PROPERTIES_PREFIX, ""), v)));
            properties = updatedProperties;
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new GraphDBWorkbenchException("Unable to access Ontop Properties file: ", (Throwable)e);
            }
        }
        inputStream.close();
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void attemptConnectToDatabase(Properties properties) throws SQLException {
        DriverManager.setLoginTimeout(10);
        String driverClass = properties.getProperty("driver");
        String url = properties.getProperty("url");
        Optional<String> user = Optional.ofNullable(properties.getProperty("user"));
        Optional<String> password = Optional.ofNullable(properties.getProperty("password"));
        try {
            Connection connection = GraphDBJDBCDriverUtil.createConnection((String)driverClass, (String)url, user, password);
            if (connection != null) {
                connection.close();
            }
        }
        finally {
            DriverManager.setLoginTimeout(0);
        }
    }

    private String createPropertiesFileComment(JDBCPropertiesFileBean bean, String lineSeparator) {
        StringBuilder sb = new StringBuilder("The following commented properties are used when editing this config file in the Workbench");
        sb.append(lineSeparator).append(JDBC_HOSTNAME).append(ONTOP_PROPERTIES_SEPARATOR).append(bean.getHostName()).append(lineSeparator).append(JDBC_PORT).append(ONTOP_PROPERTIES_SEPARATOR).append(bean.getPort()).append(lineSeparator).append(JDBC_DATABASE_NAME).append(ONTOP_PROPERTIES_SEPARATOR).append(bean.getDatabaseName());
        return sb.toString();
    }

    /*
     * Loose catch block
     * Enabled aggressive exception aggregation
     */
    boolean isClassAvailable(String driverClass) {
        try {
            Path distPath = Paths.get(Config.getDistDirectory(), new String[0]);
            Path lib = distPath.resolve(Config.getProperty((String)"graphdb.ontop.jdbc.path", (String)"lib/jdbc"));
            try (Stream stream = GraphDBJDBCDriverUtil.listJars((Path)lib);){
                URL[] urls = (URL[])stream.toArray(URL[]::new);
                if (urls.length == 0) {
                    try {
                        Class.forName(driverClass, false, this.getClass().getClassLoader());
                        boolean bl = true;
                        return bl;
                    }
                    catch (ClassNotFoundException secondException) {
                        boolean bl;
                        block14: {
                            bl = false;
                            if (stream == null) break block14;
                            stream.close();
                        }
                        return bl;
                    }
                }
                URLClassLoader classLoader = new URLClassLoader(urls);
                Class.forName(driverClass, false, classLoader);
                boolean bl = true;
                return bl;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        catch (IOException e) {
            throw new GraphDBWorkbenchException("Could not get default drivers data", (Throwable)e);
        }
    }
}

