/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rio;

import java.io.BufferedWriter;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collection;
import java.util.Objects;
import javax.annotation.Nullable;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.impl.SimpleValueFactory;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandler;
import org.eclipse.rdf4j.rio.RDFWriter;
import org.eclipse.rdf4j.rio.Rio;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.UnsupportedRDFormatException;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.JSONLDSettings;
import org.eclipse.rdf4j.rio.helpers.JSONSettings;
import org.eclipse.rdf4j.rio.helpers.NTriplesWriterSettings;
import org.eclipse.rdf4j.rio.helpers.StatementCollector;
import org.semanticweb.owlapi.formats.RioRDFDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormatFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLRuntimeException;
import org.semanticweb.owlapi.rio.RioRenderer;
import org.semanticweb.owlapi.util.AbstractOWLStorer;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;

public class RioStorer
extends AbstractOWLStorer {
    private final OWLDocumentFormatFactory ontFormat;
    private final Resource[] contexts;
    @Nullable
    private transient RDFHandler rioHandler;

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, RDFHandler rioHandler, Resource ... contexts) {
        this(ontologyFormat, contexts);
        this.rioHandler = rioHandler;
    }

    public RioStorer(OWLDocumentFormatFactory ontologyFormat, Resource ... contexts) {
        Objects.requireNonNull(contexts, "contexts argument may not be null; either the value should be cast to Resource or an empty array should be supplied");
        this.ontFormat = ontologyFormat;
        this.contexts = contexts;
    }

    protected static RDFHandler getRDFHandlerForOutputStream(@Nullable RDFFormat format, OutputStream outputStream, @Nullable String baseIRI) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return RioStorer.getWriter(format, outputStream, baseIRI);
        }
        catch (URISyntaxException | UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    protected RDFWriter getWriter(RDFFormat format, Writer writer, @Nullable String baseIRI) throws URISyntaxException {
        if (baseIRI == null || format.equals((Object)RDFFormat.RDFXML)) {
            return Rio.createWriter((RDFFormat)format, (Writer)writer);
        }
        return Rio.createWriter((RDFFormat)format, (Writer)writer, (String)baseIRI);
    }

    protected static RDFWriter getWriter(RDFFormat format, OutputStream writer, @Nullable String baseIRI) throws URISyntaxException {
        if (baseIRI == null || format.equals((Object)RDFFormat.RDFXML)) {
            return Rio.createWriter((RDFFormat)format, (OutputStream)writer);
        }
        return Rio.createWriter((RDFFormat)format, (OutputStream)writer, (String)baseIRI);
    }

    public boolean canStoreOntology(OWLDocumentFormat ontologyFormat) {
        return this.ontFormat.createFormat().equals((Object)ontologyFormat);
    }

    protected RDFHandler getRDFHandlerForWriter(@Nullable RDFFormat format, Writer writer, @Nullable String baseIRI) throws OWLOntologyStorageException {
        if (format == null) {
            return new StatementCollector();
        }
        try {
            return this.getWriter(format, writer, baseIRI);
        }
        catch (URISyntaxException | UnsupportedRDFormatException e) {
            throw new OWLOntologyStorageException(e);
        }
    }

    @Nullable
    public RDFHandler getRioHandler() {
        return this.rioHandler;
    }

    public void setRioHandler(RDFHandler rioHandler) {
        this.rioHandler = rioHandler;
    }

    protected void storeOntology(OWLOntology ontology, PrintWriter writer, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + String.valueOf(format));
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLDocumentFormat() ? format.asPrefixOWLDocumentFormat().getDefaultPrefix() : null);
            } else {
                throw new OWLOntologyStorageException("Unable to use storeOntology with a Writer as the desired format is not textual. Format was " + String.valueOf(format));
            }
        }
        try {
            this.addSettingsIfPresent(format);
            RioRenderer ren = new RioRenderer(ontology, (RDFHandler)OWLAPIPreconditions.verifyNotNull((Object)this.rioHandler), format, this.contexts(ontology, format));
            ren.render();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }

    protected void storeOntology(OWLOntology ontology, OutputStream outputStream, OWLDocumentFormat format) throws OWLOntologyStorageException {
        if (this.rioHandler == null) {
            if (!(format instanceof RioRDFDocumentFormat)) {
                throw new OWLOntologyStorageException("Unable to use RioOntologyStorer to store this format as it is not recognised as a RioRDFOntologyFormat: " + String.valueOf(format));
            }
            RioRDFDocumentFormat rioFormat = (RioRDFDocumentFormat)format;
            if (format.isTextual()) {
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(outputStream, StandardCharsets.UTF_8));
                this.rioHandler = this.getRDFHandlerForWriter(rioFormat.getRioFormat(), writer, format.isPrefixOWLDocumentFormat() ? format.asPrefixOWLDocumentFormat().getDefaultPrefix() : null);
            } else {
                this.rioHandler = RioStorer.getRDFHandlerForOutputStream(rioFormat.getRioFormat(), outputStream, format.isPrefixOWLDocumentFormat() ? format.asPrefixOWLDocumentFormat().getDefaultPrefix() : null);
            }
        }
        try {
            this.addSettingsIfPresent(format);
            RioRenderer ren = new RioRenderer(ontology, (RDFHandler)OWLAPIPreconditions.verifyNotNull((Object)this.rioHandler), format, this.contexts(ontology, format));
            ren.render();
        }
        catch (OWLRuntimeException e) {
            throw new OWLOntologyStorageException((Throwable)e);
        }
    }

    private Resource[] contexts(OWLOntology o, OWLDocumentFormat d) {
        Object namedGraphOverride;
        boolean shouldUseOntologyIRI = o.getOWLOntologyManager().getOntologyWriterConfiguration().shouldOutputNamedGraphIRI();
        String namedGraph = null;
        if (shouldUseOntologyIRI) {
            namedGraph = o.getOntologyID().getOntologyIRI().map(Object::toString).orElse(null);
        }
        if ((namedGraphOverride = d.getParameter((Serializable)((Object)"namedGraphOverride"), namedGraph)) != null) {
            IRI context = SimpleValueFactory.getInstance().createIRI(namedGraphOverride.toString());
            if (this.contexts.length == 0) {
                return new Resource[]{context};
            }
            Resource[] toReturn = new Resource[this.contexts.length + 1];
            System.arraycopy(this.contexts, 0, toReturn, 0, this.contexts.length);
            toReturn[this.contexts.length] = context;
            return toReturn;
        }
        return this.contexts;
    }

    protected void addSettingsIfPresent(OWLDocumentFormat format) {
        if (this.rioHandler instanceof RDFWriter) {
            RDFWriter w = (RDFWriter)this.rioHandler;
            Collection<RioSetting<?>> supportedSettings = this.knownSettings(w);
            for (RioSetting<?> r : supportedSettings) {
                Serializable v = (Serializable)format.getParameter(r, null);
                if (v == null) continue;
                w.getWriterConfig().set(r, (Object)v);
            }
        }
    }

    protected Collection<RioSetting<?>> knownSettings(RDFWriter w) {
        try {
            return w.getSupportedSettings();
        }
        catch (UnsupportedOperationException e) {
            LOGGER.debug("Bug in RIO means this exception is thrown in some formats where an unmodifiable class is modified.  As a workaround, OWLAPI will try all the known settings - relying on the caller to only use supported settings.", (Throwable)e);
            return Arrays.asList(JSONSettings.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, JSONSettings.ALLOW_COMMENTS, JSONSettings.ALLOW_NON_NUMERIC_NUMBERS, JSONSettings.ALLOW_NUMERIC_LEADING_ZEROS, JSONSettings.ALLOW_SINGLE_QUOTES, JSONSettings.ALLOW_TRAILING_COMMA, JSONSettings.ALLOW_UNQUOTED_CONTROL_CHARS, JSONSettings.ALLOW_UNQUOTED_FIELD_NAMES, JSONSettings.ALLOW_YAML_COMMENTS, JSONSettings.INCLUDE_SOURCE_IN_LOCATION, JSONSettings.STRICT_DUPLICATE_DETECTION, JSONLDSettings.COMPACT_ARRAYS, JSONLDSettings.DOCUMENT_LOADER, JSONLDSettings.HIERARCHICAL_VIEW, JSONLDSettings.JSONLD_MODE, JSONLDSettings.OPTIMIZE, JSONLDSettings.PRODUCE_GENERALIZED_RDF, JSONLDSettings.USE_NATIVE_TYPES, JSONLDSettings.USE_RDF_TYPE, JSONLDSettings.EXCEPTION_ON_WARNING, BasicWriterSettings.BASE_DIRECTIVE, BasicWriterSettings.CONVERT_RDF_STAR_TO_REIFICATION, BasicWriterSettings.ENCODE_RDF_STAR, BasicWriterSettings.INLINE_BLANK_NODES, BasicWriterSettings.PRETTY_PRINT, BasicWriterSettings.RDF_LANGSTRING_TO_LANG_LITERAL, BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL, NTriplesWriterSettings.ESCAPE_UNICODE);
        }
    }
}

