/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterproxy;

import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.http.ClusterAddressResolver;
import com.ontotext.graphdb.http.HttpClientProvider;
import com.ontotext.graphdb.http.ServletProxy;
import jakarta.annotation.Nullable;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.function.BinaryOperator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ClusterFilterBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static ClusterFilterBean instance;
    private final ServletProxy servletProxy;
    private final ClusterAddressResolver clusterAddressResolver;
    private final HttpClientProvider clientProvider;

    @Autowired
    public ClusterFilterBean(ServletProxy servletProxy, ClusterAddressResolver clusterAddressResolver, HttpClientProvider clientProvider) {
        this.servletProxy = servletProxy;
        this.clusterAddressResolver = clusterAddressResolver;
        this.clientProvider = clientProvider;
        ClusterFilterBean.setInstanceIfNeeded(this);
    }

    private static void setInstanceIfNeeded(ClusterFilterBean instance) {
        if (ClusterFilterBean.instance == null) {
            ClusterFilterBean.instance = instance;
        }
    }

    public static ClusterFilterBean getInstance() {
        return instance;
    }

    protected void doFilter(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        if (this.clusterAddressResolver.isLeader() || this.clusterAddressResolver.getCustomFilter().canHandleByFollower(request)) {
            LOGGER.trace("Accept request {} as a leader or can handle request", (Object)request.getRequestURL());
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String proxyUri = this.getResolveTargetUri(request);
        if (proxyUri == null) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        LOGGER.debug("Redirecting request {} {}", (Object)request.getMethod(), (Object)proxyUri);
        BinaryOperator transactionHeaderReWriter = this.servletProxy.transactionHeaderReWriter(request, servletRequest -> Config.getExternalUrl((String)servletRequest.getHeader("Referer")));
        this.servletProxy.proxyRequestWithAuthentication(request, response, proxyUri, this.clientProvider.getHttpClient(), transactionHeaderReWriter);
    }

    @Nullable
    private String getResolveTargetUri(HttpServletRequest request) {
        String transactionUri = this.servletProxy.extractProxiedTransactionUri(request);
        if (transactionUri != null) {
            return transactionUri;
        }
        URI writeNode = this.clusterAddressResolver.resolveWriteNode();
        if (writeNode == null) {
            return null;
        }
        return writeNode.resolve(request.getRequestURI()).toString();
    }
}

