/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterobserver;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.NullValue;
import com.google.protobuf.util.FieldMaskUtil;
import com.ontotext.forest.clusterobserver.ObserverService;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterListenerGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterUpdate;
import com.ontotext.graphdb.cluster.observer.grpc.ClusterUpdateAcknowledgment;
import com.ontotext.graphdb.cluster.observer.grpc.Node;
import com.ontotext.graphdb.cluster.observer.grpc.NodeUpdate;
import com.ontotext.graphdb.cluster.observer.grpc.NullableNode;
import com.ontotext.graphdb.cluster.observer.grpc.ObserverRegistration;
import com.ontotext.graphdb.cluster.observer.grpc.Status;
import com.ontotext.graphdb.cluster.observer.grpc.StatusUpdate;
import com.ontotext.graphdb.cluster.observer.grpc.TermUpdate;
import com.ontotext.graphdb.raft.NodeState;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.node.ClusterFactory;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterConfigService;
import common.GraphDBMDCExecutorBuilder;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.collections.api.map.primitive.MutableLongObjectMap;
import org.eclipse.collections.impl.factory.primitive.LongObjectMaps;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class RemoteRaftObserver
implements RaftObserver,
Closeable,
ApplicationListener<PropertyChangedEvent> {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final int OBSERVER_NOT_ACCESSIBLE_DURATION_MINUTES = Config.getPropertyAsInt((String)"graphdb.cluster.observers.autoUnregisterAfterMinutes", (int)15);
    private List<ObserverRegistration> observerRegistrations;
    private ScheduledExecutorService executorService;
    private AtomicBoolean isShutdown = new AtomicBoolean();
    private Map<String, ObserverClient> clients = new ConcurrentHashMap<String, ObserverClient>();
    private final SemanticDataManagement semanticDataManagement;
    private final ObserverService observerService;
    private AtomicReference<NodeState> state = new AtomicReference<NodeState>(NodeState.NO_CLUSTER);
    private AtomicReference<Node> currentLeader = new AtomicReference();
    private Node currentNode;
    private final ResendFailedUpdates resendFailedUpdates = new ResendFailedUpdates();
    private ScheduledFuture<?> resendFailedUpdatesFuture;
    private ClusterConfigService configService;

    @Autowired
    public RemoteRaftObserver(SemanticDataManagement semanticDataManagement, ObserverService observerService) {
        this.semanticDataManagement = semanticDataManagement;
        this.observerService = observerService;
    }

    @PostConstruct
    public void init() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(2, new ThreadFactoryBuilder().setDaemon(true).setPriority(4).setNameFormat("raft-observer-client-%d").build());
        executor.setKeepAliveTime(10L, TimeUnit.SECONDS);
        executor.allowCoreThreadTimeOut(true);
        this.executorService = GraphDBMDCExecutorBuilder.build((ScheduledExecutorService)executor);
    }

    public void update(NodeState state) {
        if (this.isShutdown(state)) {
            return;
        }
        this.state.set(state);
        try {
            this.sendState(this.getObserverRegistrations(), state);
        }
        finally {
            if (state == NodeState.NO_CLUSTER) {
                this.shutdownClients();
            } else if (this.resendFailedUpdatesFuture == null) {
                this.resendFailedUpdatesFuture = this.executorService.scheduleAtFixedRate(this.resendFailedUpdates, 5L, 5L, TimeUnit.SECONDS);
                this.isShutdown.set(false);
            }
        }
    }

    public boolean isShutdown(NodeState state) {
        return this.isShutdown.get() && state == NodeState.NO_CLUSTER;
    }

    private void sendState(List<ObserverRegistration> registrations, NodeState state) {
        List<String> addresses = this.getRegistrationsByFeature(registrations, ObserverRegistration.Features.STATE_UPDATES);
        LOGGER.info("Node sending its state as {} to: {}", (Object)state.name(), addresses);
        try {
            if (!addresses.isEmpty()) {
                ClusterUpdate.Builder clusterUpdate = this.createUpdateRequest(3).setStatusUpdate(StatusUpdate.newBuilder().setStatus(Status.valueOf((String)state.name())).setNode(Node.newBuilder((Node)this.getCurrentNode())));
                this.callObservers(addresses, clusterUpdate);
            }
        }
        catch (Exception e) {
            this.resendFailedUpdatesFuture = this.executorService.scheduleAtFixedRate(this.resendFailedUpdates, 5L, 5L, TimeUnit.SECONDS);
        }
    }

    public void update(@Nullable String leaderRpcAddress, String leaderHttpAddress) {
        if (this.isShutdown(this.state.get())) {
            return;
        }
        if (leaderRpcAddress == null && leaderHttpAddress == null) {
            this.currentLeader.set(null);
        } else {
            this.currentLeader.set(Node.newBuilder().setRpcAddress(leaderRpcAddress).setHttpAddress(leaderHttpAddress).build());
        }
        if (!this.isLeader()) {
            return;
        }
        this.sendLeaderUpdate(this.getObserverRegistrations());
    }

    private void sendLeaderUpdate(List<ObserverRegistration> registrations) {
        List<String> addresses = this.getRegistrationsByFeature(registrations, ObserverRegistration.Features.LEADER_UPDATES);
        if (!addresses.isEmpty()) {
            ClusterUpdate.Builder clusterUpdate = this.createUpdateRequest(4).setLeaderNode(this.toNullableNodeUpdate(this.currentLeader.get()));
            this.callObservers(addresses, clusterUpdate);
        }
    }

    public void update(long term) {
        if (!this.isLeader() || this.isShutdown(this.state.get())) {
            return;
        }
        List<String> addresses = this.getRegistrationsByFeature(this.getObserverRegistrations(), ObserverRegistration.Features.TERM_UPDATES);
        if (!addresses.isEmpty()) {
            ClusterUpdate.Builder clusterUpdate = this.createUpdateRequest(2).setTermUpdate(TermUpdate.newBuilder().setTerm(term).setNode(Node.newBuilder((Node)this.getCurrentNode())));
            this.callObservers(addresses, clusterUpdate);
        }
    }

    public void nodeAdded(String rpcAddress, String httpAddress) {
        if (!this.isLeader() || this.isShutdown(this.state.get())) {
            return;
        }
        List<String> addresses = this.getRegistrationsByFeature(this.getObserverRegistrations(), ObserverRegistration.Features.NODE_CHANGES);
        if (!addresses.isEmpty()) {
            ClusterUpdate.Builder clusterUpdate = this.createUpdateRequest(5).setNodeUpdate(NodeUpdate.newBuilder().setNode(Node.newBuilder().setRpcAddress(rpcAddress).setHttpAddress(httpAddress)).setOperation(NodeUpdate.Operation.ADD));
            this.callObservers(addresses, clusterUpdate);
        }
    }

    public void nodeRemoved(String rpcAddress, String httpAddress) {
        if (this.isShutdown(this.state.get())) {
            return;
        }
        List<String> addresses = this.getRegistrationsByFeature(this.getObserverRegistrations(), ObserverRegistration.Features.NODE_CHANGES);
        if (!addresses.isEmpty()) {
            ClusterUpdate.Builder clusterUpdate = this.createUpdateRequest(5).setNodeUpdate(NodeUpdate.newBuilder().setNode(Node.newBuilder().setRpcAddress(rpcAddress).setHttpAddress(httpAddress)).setOperation(NodeUpdate.Operation.REMOVE));
            this.callObservers(addresses, clusterUpdate);
        }
    }

    @NotNull
    private List<String> getRegistrationsByFeature(List<ObserverRegistration> registrations, ObserverRegistration.Features feature) {
        return registrations.stream().filter(registration -> registration.getFeaturesValueList().contains(feature.getNumber())).map(ObserverRegistration::getRpcAddress).collect(Collectors.toList());
    }

    private NullableNode toNullableNodeUpdate(Node node) {
        if (node == null) {
            return NullableNode.newBuilder().setNull(NullValue.NULL_VALUE).build();
        }
        return NullableNode.newBuilder().setNode(node).build();
    }

    private List<ObserverRegistration> getObserverRegistrations() {
        if (this.observerRegistrations == null) {
            this.loadRegistrations();
            LOGGER.info("Loaded observer registrations: {}", this.observerRegistrations);
        }
        return this.observerRegistrations;
    }

    private void loadRegistrations() {
        ClusterConfig clusterConfig = this.getClusterConfigService().fetchClusterConfig();
        assert (clusterConfig != null);
        this.observerRegistrations = new ArrayList<ObserverRegistration>(clusterConfig.getObserverRegistrations());
    }

    private Node getCurrentNode() {
        if (this.currentNode == null) {
            NodeInfo info = this.getClusterConfigService().fetchClusterConfig().getExternalAddress();
            this.currentNode = Node.newBuilder().setRpcAddress(info.getRpcAddress()).setHttpAddress(info.getHttpAddress()).build();
        }
        return this.currentNode;
    }

    public void callObservers(List<String> addresses, ClusterUpdate.Builder clusterUpdate) {
        for (String address : addresses) {
            ObserverClient client = this.clients.computeIfAbsent(address, adr -> new ObserverClient((String)adr, this.executorService));
            try {
                client.sendUpdate(clusterUpdate);
            }
            catch (Exception re) {
                client.onRequestFailure(re);
            }
        }
    }

    private boolean isLeader() {
        return this.state.get() == NodeState.LEADER;
    }

    @Override
    public void close() {
        try {
            if (this.state.get() != NodeState.NO_CLUSTER) {
                this.update(NodeState.NO_CLUSTER);
            }
        }
        catch (RuntimeException re) {
            LOGGER.warn("Could not notify all observers on shutdown", (Throwable)re);
        }
        this.shutdownClients();
        this.executorService.shutdown();
        try {
            this.executorService.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Interrupted while waiting for shutdown");
            Thread.currentThread().interrupt();
        }
    }

    private void shutdownClients() {
        if (this.isShutdown.compareAndSet(false, true)) {
            if (this.resendFailedUpdatesFuture != null) {
                this.resendFailedUpdatesFuture.cancel(true);
                this.resendFailedUpdatesFuture = null;
            }
            if (!this.clients.isEmpty()) {
                LOGGER.info("Shutting down the observer connections to {}", this.clients.keySet());
                this.clients.values().forEach(ObserverClient::shutdown);
                LOGGER.info("Successfully shutdown the observer connections");
                this.clients.clear();
            }
            this.observerRegistrations = null;
        }
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("cluster_observer_registrations_changed".equals(event.getKey()) && !this.isShutdown.get()) {
            this.loadRegistrations();
            String rpcAddress = event.getValue();
            if (StringUtils.isNotBlank((CharSequence)rpcAddress)) {
                this.executorService.submit(Context.current().fork().wrap(() -> this.getObserverRegistrations().stream().filter(registration -> rpcAddress.equals(registration.getRpcAddress())).findAny().ifPresent(registration -> {
                    if (this.isShutdown(this.state.get())) {
                        return;
                    }
                    if (this.state.get() != NodeState.NO_CLUSTER) {
                        this.sendState(List.of(registration), this.state.get());
                        if (this.currentLeader.get() != null && this.isLeader()) {
                            this.sendLeaderUpdate(List.of(registration));
                        }
                    }
                })));
            }
        }
    }

    private ClusterUpdate.Builder createUpdateRequest(int updateProperty) {
        return ClusterUpdate.newBuilder().setFieldMask(FieldMaskUtil.fromFieldNumbers(ClusterUpdate.class, (int[])new int[]{updateProperty}));
    }

    public ClusterConfigService getClusterConfigService() {
        if (this.configService == null) {
            this.configService = this.semanticDataManagement.getCurrentLocationOrThrow().getClusterConfigService();
        }
        return this.configService;
    }

    private class ResendFailedUpdates
    implements Runnable {
        private ResendFailedUpdates() {
        }

        @Override
        public void run() {
            block0: for (ObserverClient client : RemoteRaftObserver.this.clients.values()) {
                if (Thread.currentThread().isInterrupted()) break;
                List<UpdateWithTimestamp> entries = client.getStaleEntries(5000L);
                for (UpdateWithTimestamp update : entries) {
                    if (Thread.currentThread().isInterrupted()) continue block0;
                    this.notifyClient(client, update);
                }
            }
        }

        private void notifyClient(ObserverClient client, UpdateWithTimestamp update) {
            try {
                LOGGER.info("Sending update notifying client...");
                client.sendUpdateInternal(ClusterUpdate.newBuilder((ClusterUpdate)update.update).build());
            }
            catch (Exception re) {
                client.onRequestFailure(re);
            }
        }
    }

    private class ObserverClient {
        private volatile ManagedChannel channel;
        private ClusterListenerGrpc.ClusterListenerStub stub;
        private final ExecutorService executorService;
        private final String address;
        private final AtomicLong index = new AtomicLong();
        private volatile long communicationFailed = -1L;
        private final Lock failedUpdatesLock = new ReentrantLock();
        private final MutableLongObjectMap<UpdateWithTimestamp> failedUpdates = LongObjectMaps.mutable.empty();

        private ObserverClient(String address, ExecutorService executorService) {
            this.address = address;
            this.executorService = executorService;
        }

        private void openChannel() {
            if (this.channel == null) {
                LOGGER.info("Opening channel to send updates to remote observer at {}", (Object)this.address);
                this.channel = ClusterFactory.createChannelTo((String)this.address).executor((Executor)this.executorService).build();
                this.stub = ClusterListenerGrpc.newStub((Channel)this.channel);
            }
        }

        void sendUpdate(ClusterUpdate.Builder clusterUpdate) {
            clusterUpdate.setIndex(this.index.getAndIncrement());
            ClusterUpdate update = clusterUpdate.build();
            this.sendUpdateInternal(update);
        }

        private void sendUpdateInternal(final ClusterUpdate update) {
            this.openChannel();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Sending update to {} with payload: {}", (Object)this.address, (Object)update);
            }
            this.stub.onClusterUpdate(update, (StreamObserver)new StreamObserver<ClusterUpdateAcknowledgment>(){

                public void onNext(ClusterUpdateAcknowledgment acknowledgment) {
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("Got acknowledgment from {} : {}", (Object)ObserverClient.this.address, (Object)acknowledgment);
                    }
                    if (ObserverClient.this.communicationFailed > 0L) {
                        LOGGER.info("Observer at {} is now available", (Object)ObserverClient.this.address);
                        ObserverClient.this.communicationFailed = -1L;
                    }
                }

                public void onError(Throwable t) {
                    LOGGER.warn("Observer at {} is not available!", (Object)ObserverClient.this.address);
                    boolean shouldTryToRecover = ObserverClient.this.onRequestFailure(t);
                    ObserverClient.this.failedUpdatesLock.lock();
                    try {
                        if (shouldTryToRecover) {
                            ObserverClient.this.failedUpdates.values().removeIf(oldUpdate -> oldUpdate.getUpdate().getFieldMask().equals((Object)update.getFieldMask()));
                            ObserverClient.this.failedUpdates.put(update.getIndex(), (Object)new UpdateWithTimestamp(update));
                        } else {
                            ObserverClient.this.failedUpdates.clear();
                        }
                    }
                    finally {
                        ObserverClient.this.failedUpdatesLock.unlock();
                    }
                }

                public void onCompleted() {
                    ObserverClient.this.failedUpdatesLock.lock();
                    try {
                        ObserverClient.this.failedUpdates.values().removeIf(oldUpdate -> oldUpdate.getUpdate().getFieldMask().equals((Object)update.getFieldMask()));
                    }
                    finally {
                        ObserverClient.this.failedUpdatesLock.unlock();
                    }
                }
            });
        }

        void shutdown() {
            if (this.channel == null) {
                return;
            }
            LOGGER.debug("Shutting down channel to: {}", (Object)this.address);
            try {
                this.channel.shutdown().awaitTermination(2L, TimeUnit.MINUTES);
            }
            catch (RuntimeException re) {
                LOGGER.warn("Shutting down channel to: {} failed", (Object)this.address, (Object)re);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            this.channel = null;
        }

        boolean onRequestFailure(Throwable t) {
            boolean shouldUnregister;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Observer {} failed to accept update due to failure", (Object)this.address, (Object)t);
            }
            if (shouldUnregister = this.markFailed()) {
                LOGGER.warn("Observer {} didn't accept an update in the last 15 minutes. Unregistering it!", (Object)this.address);
                RemoteRaftObserver.this.clients.remove(this.address);
                this.executorService.submit(() -> RemoteRaftObserver.this.observerService.unregister(this.address));
            }
            this.shutdown();
            return !shouldUnregister;
        }

        private boolean markFailed() {
            if (this.communicationFailed < 0L) {
                this.communicationFailed = System.currentTimeMillis();
                return false;
            }
            return TimeUnit.MILLISECONDS.toSeconds(System.currentTimeMillis() - this.communicationFailed) > TimeUnit.MINUTES.toSeconds(OBSERVER_NOT_ACCESSIBLE_DURATION_MINUTES);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<UpdateWithTimestamp> getStaleEntries(long staleThreshold) {
            this.failedUpdatesLock.lock();
            try {
                List<UpdateWithTimestamp> list = this.failedUpdates.values().stream().filter(message -> message.getElapseTime() > staleThreshold).collect(Collectors.toList());
                return list;
            }
            finally {
                this.failedUpdatesLock.unlock();
            }
        }
    }

    private static class UpdateWithTimestamp {
        private final ClusterUpdate update;
        private final long timestamp;

        UpdateWithTimestamp(ClusterUpdate update) {
            this.update = update;
            this.timestamp = System.currentTimeMillis();
        }

        ClusterUpdate getUpdate() {
            return this.update;
        }

        long getElapseTime() {
            return System.currentTimeMillis() - this.timestamp;
        }
    }
}

