/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clusterobserver;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.protobuf.NoopStreamObserver;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.cluster.observer.grpc.ObserverRegistration;
import com.ontotext.graphdb.cluster.observer.grpc.PingRequest;
import com.ontotext.graphdb.cluster.observer.grpc.PingServiceGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.RaftObserverServiceGrpc;
import com.ontotext.graphdb.cluster.observer.grpc.RegistrationAcknowledgment;
import com.ontotext.graphdb.raft.node.ClusterFactory;
import com.ontotext.raft.RpcMulticastService;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterConfigService;
import io.grpc.Channel;
import io.grpc.Context;
import io.grpc.ManagedChannel;
import io.grpc.Status;
import io.grpc.StatusException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.PostConstruct;
import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Predicate;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class ObserverService
extends RaftObserverServiceGrpc.RaftObserverServiceImplBase
implements ApplicationEventPublisherAware,
ApplicationListener<PropertyChangedEvent>,
Closeable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String OBSERVER_REGISTRATIONS_CHANGED = "cluster_observer_registrations_changed";
    private static final long OBSERVER_TIMEOUT_SECONDS = Config.getPropertyAsLong((String)"graphdb.cluster.observer.timeoutS", (long)60L);
    private RpcMulticastService<RaftObserverServiceGrpc.RaftObserverServiceFutureStub> multicastService;
    private ApplicationEventPublisher applicationEventPublisher;
    private final SemanticDataManagement semanticDataManagement;
    private final Lock configLock = new ReentrantLock(true);
    private volatile boolean serverInitialized;

    @Autowired
    public ObserverService(SemanticDataManagement semanticDataManagement) {
        this.semanticDataManagement = semanticDataManagement;
    }

    @PostConstruct
    public void init() {
        this.multicastService = RpcMulticastService.builder().setThreadPattern("raft-observer-%d").setLogger(LOGGER).setClusterConfigServiceProvider(this::getClusterConfigService).build(RaftObserverServiceGrpc::newFutureStub);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerObserver(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        try {
            if (this.checkRegistrationPreconditions(registration, responseObserver)) {
                LOGGER.info("Cluster failed on registration preconditions.");
                return;
            }
        }
        catch (Exception e) {
            LOGGER.info("Cluster failed on registration preconditions due to: {}.", (Object)e.getMessage());
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Cluster failed on registration preconditions."));
            responseObserver.onCompleted();
            return;
        }
        LOGGER.info("Node received register observer task");
        ClusterConfigService clusterConfigService = this.getClusterConfigService();
        ClusterConfig clusterConfig = clusterConfigService.fetchClusterConfig();
        assert (clusterConfig != null);
        String rpcAddress = registration.getRpcAddress();
        if (clusterConfig.getObserverRegistrations().stream().anyMatch(Predicate.isEqual(registration))) {
            Context.current().fork().run(() -> this.recursiveCallPeers(registration));
            LOGGER.info("Observer refreshed it's registration: {}", (Object)registration);
            responseObserver.onNext((Object)this.acknowledgeWithSuccess());
            responseObserver.onCompleted();
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, OBSERVER_REGISTRATIONS_CHANGED, rpcAddress));
            return;
        }
        this.configLock.lock();
        try {
            clusterConfig = clusterConfigService.fetchClusterConfig();
            assert (clusterConfig != null);
            ClusterConfig backupConfig = clusterConfig.copy();
            boolean removedAny = clusterConfig.replaceObserverRegistration(registration);
            LOGGER.info(removedAny ? "Observer updated it's registration: {}" : "New remote observer registration: {}", (Object)registration);
            clusterConfigService.recordClusterGroup(clusterConfig);
            this.replicateRegistrationInternal(registration, responseObserver, backupConfig);
        }
        finally {
            this.configLock.unlock();
        }
    }

    private void recursiveCallPeers(ObserverRegistration registration) {
        Map futures = this.multicastService.callPeers(stub -> ((RaftObserverServiceGrpc.RaftObserverServiceFutureStub)stub.withDeadlineAfter(OBSERVER_TIMEOUT_SECONDS, TimeUnit.SECONDS)).replicateRegistration(registration));
        this.handleRecursiveCallPeersResponses(registration, futures);
    }

    private void recursiveCallPeers(ObserverRegistration registration, List<String> addresses) {
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
        Map futures = this.multicastService.callNodes(addresses, stub -> ((RaftObserverServiceGrpc.RaftObserverServiceFutureStub)stub.withDeadlineAfter(OBSERVER_TIMEOUT_SECONDS, TimeUnit.SECONDS)).replicateRegistration(registration));
        this.handleRecursiveCallPeersResponses(registration, futures);
    }

    private void handleRecursiveCallPeersResponses(ObserverRegistration registration, Map<String, ListenableFuture<RegistrationAcknowledgment>> futures) {
        futures.forEach((address, future) -> future.addListener(() -> {
            try {
                if (!((RegistrationAcknowledgment)Futures.getDone((Future)future)).getSuccess()) {
                    LOGGER.warn("{}: Failed to replicate registration, will retry.", address);
                    this.recursiveCallPeers(registration, Collections.singletonList(address));
                } else {
                    LOGGER.warn("{}: successfully replicated registration, will not retry.", address);
                }
            }
            catch (ExecutionException e) {
                LOGGER.warn("{}: Failed to replicate registration due to: {}", address, (Object)e.getCause().getMessage());
                this.recursiveCallPeers(registration, Collections.singletonList(address));
            }
        }, (Executor)this.multicastService.getExecutorService()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void replicateRegistrationInternal(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver, ClusterConfig backupConfig) {
        ArrayList failureMessages = new ArrayList();
        try {
            this.multicastService.callPeersBlocking(stub -> ((RaftObserverServiceGrpc.RaftObserverServiceFutureStub)stub.withDeadlineAfter(OBSERVER_TIMEOUT_SECONDS, TimeUnit.SECONDS)).replicateRegistration(registration), futures -> {
                futures.forEach((address, future) -> {
                    try {
                        RegistrationAcknowledgment acknowledgment = (RegistrationAcknowledgment)Futures.getDone((Future)future);
                        if (!acknowledgment.getSuccess()) {
                            failureMessages.add(acknowledgment.getMessage());
                        }
                    }
                    catch (ExecutionException e) {
                        failureMessages.add(e.getCause().getMessage());
                    }
                });
                return null;
            });
        }
        finally {
            if (!failureMessages.isEmpty()) {
                LOGGER.info("Failed to replicate registration.");
                responseObserver.onNext((Object)this.acknowledgeWithFailure(String.join((CharSequence)", ", failureMessages)));
                responseObserver.onCompleted();
                this.getClusterConfigService().recordClusterGroup(backupConfig);
            } else {
                LOGGER.info("Successfully replicated registration.");
                responseObserver.onNext((Object)this.acknowledgeWithSuccess());
                responseObserver.onCompleted();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, OBSERVER_REGISTRATIONS_CHANGED, registration.getRpcAddress()));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replicateRegistration(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        try {
            if (this.checkRegistrationPreconditions(registration, responseObserver)) {
                LOGGER.info("Failed on checking registration preconditions, will retry registration");
                return;
            }
        }
        catch (Exception e) {
            LOGGER.info("Failed on registration preconditions due to: {}.", (Object)e.getMessage());
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Failed on registration preconditions."));
            responseObserver.onCompleted();
            return;
        }
        ClusterConfigService clusterConfigService = this.getClusterConfigService();
        ClusterConfig clusterConfig = clusterConfigService.fetchClusterConfig();
        assert (clusterConfig != null);
        String rpcAddress = registration.getRpcAddress();
        try {
            if (clusterConfig.getObserverRegistrations().stream().anyMatch(Predicate.isEqual(registration))) {
                LOGGER.info("[Node {}] Observer registration updated: {}", (Object)registration.getRpcAddress(), (Object)this.formatRegistrationFeaturesList(registration.getFeaturesList()));
                responseObserver.onNext((Object)this.acknowledgeWithSuccess());
                responseObserver.onCompleted();
                this.applicationEventPublisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, OBSERVER_REGISTRATIONS_CHANGED, rpcAddress));
                return;
            }
        }
        catch (Exception e) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure(e.getMessage()));
            responseObserver.onCompleted();
        }
        this.configLock.lock();
        try {
            clusterConfig = clusterConfigService.fetchClusterConfig();
            assert (clusterConfig != null);
            clusterConfig.replaceObserverRegistration(registration);
            LOGGER.info("Replicated new remote observer registration: {}", (Object)registration);
            clusterConfigService.recordClusterGroup(clusterConfig);
            responseObserver.onNext((Object)this.acknowledgeWithSuccess());
            responseObserver.onCompleted();
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, OBSERVER_REGISTRATIONS_CHANGED, rpcAddress));
        }
        finally {
            this.configLock.unlock();
        }
    }

    private boolean checkRegistrationPreconditions(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        if (!this.serverInitialized) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Not initialized"));
            responseObserver.onCompleted();
            return true;
        }
        ClusterConfigService clusterConfigService = this.getClusterConfigService();
        if (!clusterConfigService.isClusterEnabled()) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Cluster not created"));
            responseObserver.onCompleted();
            return true;
        }
        if (this.checkFeatures(registration, responseObserver)) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Invalid features in registration."));
            responseObserver.onCompleted();
            return true;
        }
        if (!this.isRemoteAddressAccessible(registration.getRpcAddress(), responseObserver)) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Remote address is not accessible."));
            responseObserver.onCompleted();
            return true;
        }
        return false;
    }

    private boolean checkFeatures(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        if (registration.getFeaturesCount() == 0) {
            responseObserver.onError((Throwable)new StatusException(Status.FAILED_PRECONDITION.withDescription("At least one feature must be enabled")));
            return true;
        }
        return false;
    }

    private boolean isRemoteAddressAccessible(String rpcAddress, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        AtomicReference exception = new AtomicReference();
        Context.current().fork().run(() -> {
            ManagedChannel channel = ClusterFactory.createChannelTo((String)rpcAddress).build();
            try {
                ((PingServiceGrpc.PingServiceBlockingStub)PingServiceGrpc.newBlockingStub((Channel)channel).withDeadlineAfter(OBSERVER_TIMEOUT_SECONDS, TimeUnit.SECONDS)).ping(PingRequest.newBuilder().build());
            }
            catch (Exception ex) {
                LOGGER.warn("Observer at {} is not accessible!", (Object)rpcAddress, (Object)ex);
                exception.set(ex);
            }
            finally {
                channel.shutdown();
            }
        });
        if (exception.get() != null) {
            responseObserver.onError((Throwable)new StatusException(Status.FAILED_PRECONDITION.withDescription("The observer is not accessible at: " + rpcAddress).withCause((Throwable)exception.get())));
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(ObserverRegistration registration, StreamObserver<RegistrationAcknowledgment> responseObserver) {
        boolean removedSuccessfully;
        ClusterConfigService clusterConfigService = this.getClusterConfigService();
        if (!clusterConfigService.isClusterEnabled()) {
            responseObserver.onNext((Object)this.acknowledgeWithFailure("Cluster not enabled"));
            responseObserver.onCompleted();
            return;
        }
        this.configLock.lock();
        try {
            ClusterConfig clusterConfig = clusterConfigService.fetchClusterConfig();
            assert (clusterConfig != null);
            removedSuccessfully = clusterConfig.remoteObserverRegistration(registration);
            if (removedSuccessfully) {
                LOGGER.info("Unregistering remote observer: {}", (Object)registration.getRpcAddress());
                clusterConfigService.recordClusterGroup(clusterConfig);
            }
        }
        finally {
            this.configLock.unlock();
        }
        responseObserver.onNext((Object)this.acknowledgeWithSuccess());
        responseObserver.onCompleted();
        if (removedSuccessfully) {
            Context.current().fork().run(() -> this.multicastService.callPeers(stub -> stub.unregister(registration)));
            this.applicationEventPublisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, OBSERVER_REGISTRATIONS_CHANGED, ""));
        }
    }

    @NotNull
    private RegistrationAcknowledgment acknowledgeWithSuccess() {
        return RegistrationAcknowledgment.newBuilder().setSuccess(true).build();
    }

    @NotNull
    private RegistrationAcknowledgment acknowledgeWithFailure(String message) {
        return RegistrationAcknowledgment.newBuilder().setSuccess(false).setMessage(message).build();
    }

    public void unregister(String address) {
        this.unregister(ObserverRegistration.newBuilder().setRpcAddress(address).build(), (StreamObserver<RegistrationAcknowledgment>)NoopStreamObserver.instance());
    }

    @VisibleForTesting
    SemanticDataManagement getSemanticDataManagement() {
        return this.semanticDataManagement;
    }

    ClusterConfigService getClusterConfigService() {
        SemanticLocation currentLocation = this.semanticDataManagement.getCurrentLocation();
        if (currentLocation == null) {
            return ClusterConfigService.defaultService();
        }
        return currentLocation.getClusterConfigService();
    }

    public void setApplicationEventPublisher(@NotNull ApplicationEventPublisher applicationEventPublisher) {
        this.applicationEventPublisher = applicationEventPublisher;
    }

    @VisibleForTesting
    ApplicationEventPublisher getApplicationEventPublisher() {
        return this.applicationEventPublisher;
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
        }
    }

    @Override
    public void close() {
        this.serverInitialized = false;
        this.multicastService.shutdown();
    }

    public String formatRegistrationFeaturesList(List<ObserverRegistration.Features> features) {
        StringBuilder featuresBuilder = new StringBuilder();
        for (ObserverRegistration.Features feature : features) {
            featuresBuilder.append("features: ").append(feature).append(" ");
        }
        return featuresBuilder.toString();
    }
}

