/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.ontotext.forest.recovery.RecoveryService;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.grpc.SnapshotResponse;
import com.ontotext.graphdb.recovery.BackupException;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotReplicationObserver
implements StreamObserver<SnapshotData> {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotReplicationObserver.class);
    private final RecoveryService recoveryService;
    private final StreamObserver<SnapshotResponse> responseObserver;
    private final Supplier<String> fingerprintSupplier;
    private final AtomicBoolean isInit;
    private volatile File snapshotFile;
    private volatile RandomAccessFile snapshotStream;
    private volatile boolean requireFingerprint;
    private volatile SnapshotOptions snapshotOptions;

    public SnapshotReplicationObserver(RecoveryService recoveryService, StreamObserver<SnapshotResponse> responseObserver, Supplier<String> fingerprintSupplier) {
        this.recoveryService = recoveryService;
        this.responseObserver = responseObserver;
        this.fingerprintSupplier = fingerprintSupplier;
        this.isInit = new AtomicBoolean(false);
    }

    public void onNext(SnapshotData value) {
        try {
            if (this.isInit.compareAndSet(false, true)) {
                SnapshotData.NullableSnapshotMeta.KindCase kindCase = value.getMeta().getKindCase();
                if (kindCase != SnapshotData.NullableSnapshotMeta.KindCase.METADATA) {
                    this.responseObserver.onError((Throwable)new StatusRuntimeException(Status.FAILED_PRECONDITION.withDescription("Snapshot metadata is required in the first message")));
                    return;
                }
                SnapshotData.SnapshotMeta metadata = value.getMeta().getMetadata();
                this.requireFingerprint = metadata.getRequireFingerprint();
                this.snapshotOptions = new SnapshotOptions().setWithRepositoryData(metadata.getApplyRepositoriesData()).setWithSystemData(metadata.getApplySystemData()).setWithClusterData(metadata.getApplyClusterData()).setCleanDataDir(metadata.getCleanData()).setRemoveCluster(metadata.getCleanClusterData());
                this.snapshotFile = new File(this.recoveryService.getSnapshotDir(), String.valueOf(UUID.randomUUID()) + metadata.getFormat());
                long availableMemory = this.snapshotFile.getParentFile().getFreeSpace();
                if (metadata.getSize() >= availableMemory) {
                    logger.error("Cannot record snapshot with size {} due to insufficient available disk space {}", (Object)metadata.getSize(), (Object)availableMemory);
                    this.responseObserver.onError((Throwable)new BackupException("Cannot record snapshot due to insufficient disk space"));
                    return;
                }
                if (!this.snapshotFile.createNewFile()) {
                    logger.error("Unable to create snapshot file in directory {}", (Object)this.snapshotFile.getParentFile());
                    this.responseObserver.onError((Throwable)new BackupException("Unable to create snapshot file"));
                    return;
                }
                logger.info("Recording temporary snapshot file {}", (Object)this.snapshotFile);
                this.snapshotStream = new RandomAccessFile(this.snapshotFile, "rw");
            }
            if (!value.getData().isEmpty()) {
                this.snapshotStream.getChannel().write(value.getData().asReadOnlyByteBuffer());
            } else if (value.getSuccess()) {
                this.snapshotStream.close();
                String snapshotFileName = this.snapshotFile.getName();
                String name = snapshotFileName.substring(0, snapshotFileName.indexOf("."));
                this.recoveryService.applySnapshot(name, this.snapshotOptions);
                this.responseObserver.onNext((Object)SnapshotResponse.newBuilder().setStatus(SnapshotResponse.Status.HAS_SNAPSHOT).setFingerprint(this.requireFingerprint ? this.fingerprintSupplier.get() : "").build());
            }
        }
        catch (Exception e) {
            logger.error("Exception occurred during replication", (Throwable)e);
            this.responseObserver.onError((Throwable)e);
        }
    }

    public void onError(Throwable t) {
        logger.error("Error occurred during state replication: ", t);
        if (this.isInit.get()) {
            if (this.snapshotStream != null) {
                try {
                    this.snapshotStream.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if (this.snapshotFile != null && this.snapshotFile.exists()) {
                this.snapshotFile.delete();
            }
        }
    }

    public void onCompleted() {
        if (this.snapshotFile != null && this.snapshotFile.exists()) {
            String name = this.snapshotFile.getName();
            this.snapshotFile.delete();
            logger.info("Cleaned up temporary snapshot file {}", (Object)name);
        }
        this.responseObserver.onCompleted();
    }
}

