/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.google.protobuf.ByteString;
import com.google.protobuf.NullValue;
import com.ontotext.forest.recovery.SnapshotReplicationRequest;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.ConfigServiceGrpc;
import com.ontotext.graphdb.raft.grpc.RaftRpcConnectionException;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.grpc.SnapshotResponse;
import com.ontotext.graphdb.raft.node.ClusterFactory;
import com.ontotext.graphdb.recovery.BackupException;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import common.GraphDBMDCExecutorBuilder;
import io.grpc.Channel;
import io.grpc.ManagedChannel;
import io.grpc.stub.ClientCallStreamObserver;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SnapshotCatchupService {
    private static final Logger logger = LoggerFactory.getLogger(SnapshotCatchupService.class);
    private static final int MESSAGE_CHUNK = 65536;
    private final ExecutorService executorService = GraphDBMDCExecutorBuilder.build((ExecutorService)Executors.newCachedThreadPool(new ThreadFactoryBuilder().setNameFormat("graphdb-state-catchup-%d").build()));

    public void shutdown() {
        this.executorService.shutdown();
    }

    public void replicateAndValidateSnapshot(Collection<String> nodes, SnapshotReplicationRequest replicationRequest, @Nullable String fingerprint) throws BackupException {
        HashMap<String, ManagedChannel> nodeMap = new HashMap<String, ManagedChannel>();
        try {
            for (String clientAddress : nodes) {
                nodeMap.put(clientAddress, ClusterFactory.createChannelTo((String)clientAddress).executor((Executor)this.executorService).build());
            }
            CompletableFuture[] responses = new CompletableFuture[nodeMap.size()];
            int i = 0;
            logger.info("Replicating snapshot to nodes {}", nodes);
            for (Map.Entry entry : nodeMap.entrySet()) {
                responses[i++] = CompletableFuture.supplyAsync(() -> this.sendSnapshot((String)entry.getKey(), (ManagedChannel)entry.getValue(), replicationRequest), this.executorService);
            }
            CompletableFuture.allOf(responses).get();
            for (CompletableFuture response : responses) {
                if (replicationRequest.isRequireFingerprint() && fingerprint != null && !((SnapshotResponse)response.get()).getFingerprint().equals(fingerprint)) {
                    logger.error("Mismatch in fingerprint with node " + ((SnapshotResponse)response.get()).getAddress() + " after replicating status");
                    throw new BackupException("Mismatch in fingerprint with node " + ((SnapshotResponse)response.get()).getAddress() + " after replicating status");
                }
                logger.info("Successfully replicated state to node {}", (Object)((SnapshotResponse)response.get()).getAddress());
            }
        }
        catch (InterruptedException | ExecutionException e) {
            logger.error("Unable to replicate snapshot to empty nodes due to: ", (Throwable)e);
            throw new BackupException((Throwable)e);
        }
        finally {
            for (ManagedChannel channel : nodeMap.values()) {
                channel.shutdown();
            }
        }
    }

    public SnapshotResponse sendSnapshot(String address, ManagedChannel channel, SnapshotReplicationRequest replicationRequest) {
        SnapshotResponse snapshotResponse;
        File snapshot = replicationRequest.getSnapshot();
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(snapshot), 65536);
        try {
            AtomicReference<SnapshotResponse> finalResponse = new AtomicReference<SnapshotResponse>();
            CountDownLatch finishLatch = new CountDownLatch(1);
            StreamObserver<SnapshotData> adder = this.fetchBackupStream(address, channel, finalResponse, finishLatch);
            this.propagateSnapshotData(adder, stream, snapshot.length(), finishLatch, replicationRequest);
            SnapshotResponse response = finalResponse.get();
            if (response == null) {
                throw new RaftRpcConnectionException("No response from node with address " + address);
            }
            snapshotResponse = SnapshotResponse.newBuilder((SnapshotResponse)response).setAddress(address).build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RaftRpcConnectionException((Throwable)e);
            }
        }
        stream.close();
        return snapshotResponse;
    }

    protected StreamObserver<SnapshotData> fetchBackupStream(String address, ManagedChannel channel, AtomicReference<SnapshotResponse> finalResponse, CountDownLatch finishLatch) {
        final StreamObserver observer = ConfigServiceGrpc.newStub((Channel)channel).replicateState(this.buildResponseObserver(address, finalResponse, finishLatch));
        if (observer instanceof ClientCallStreamObserver) {
            return new ClientCallStreamObserver<SnapshotData>(this){
                final ClientCallStreamObserver<SnapshotData> actualObserver;
                {
                    this.actualObserver = (ClientCallStreamObserver)observer;
                }

                public void cancel(@Nullable String message, @Nullable Throwable cause) {
                    this.actualObserver.cancel(message, cause);
                }

                public boolean isReady() {
                    return this.actualObserver.isReady();
                }

                public void setOnReadyHandler(Runnable onReadyHandler) {
                    this.actualObserver.setOnReadyHandler(onReadyHandler);
                }

                public void request(int count) {
                    this.actualObserver.request(count);
                }

                public void setMessageCompression(boolean enable) {
                    this.actualObserver.setMessageCompression(enable);
                }

                public void disableAutoInboundFlowControl() {
                    this.actualObserver.disableAutoInboundFlowControl();
                }

                public void onNext(SnapshotData value) {
                    while (!this.isReady() && !Thread.currentThread().isInterrupted()) {
                        Thread.onSpinWait();
                    }
                    this.actualObserver.onNext((Object)value);
                }

                public void onError(Throwable t) {
                    this.actualObserver.onError(t);
                }

                public void onCompleted() {
                    this.actualObserver.onCompleted();
                }
            };
        }
        return observer;
    }

    private StreamObserver<SnapshotResponse> buildResponseObserver(final String address, final AtomicReference<SnapshotResponse> finalResponse, final CountDownLatch latch) {
        return new StreamObserver<SnapshotResponse>(this){

            public void onNext(SnapshotResponse value) {
                finalResponse.set(value);
            }

            public void onError(Throwable t) {
                logger.error("Error occurred during snapshot replication: ", t);
                latch.countDown();
                throw new RaftException("Unable to send update to " + address, t);
            }

            public void onCompleted() {
                latch.countDown();
            }
        };
    }

    private void propagateSnapshotData(StreamObserver<SnapshotData> adder, InputStream stream, long snapshotSize, CountDownLatch finishLatch, SnapshotReplicationRequest replicationRequest) {
        try {
            byte[] buffer = new byte[65536];
            int size = 0;
            SnapshotOptions options = replicationRequest.getSnapshotOptions();
            SnapshotData.NullableSnapshotMeta.Builder noMetadata = SnapshotData.NullableSnapshotMeta.newBuilder().setNull(NullValue.NULL_VALUE);
            SnapshotData.NullableSnapshotMeta.Builder snapshotMeta = SnapshotData.NullableSnapshotMeta.newBuilder().setMetadata(SnapshotData.SnapshotMeta.newBuilder().setFormat(".tar").setSize(snapshotSize).setApplyRepositoriesData(options.isWithRepositoryData()).setApplySystemData(options.isWithSystemData()).setApplyClusterData(options.isWithClusterData()).setRequireFingerprint(replicationRequest.isRequireFingerprint()).setCleanData(options.isCleanDataDir()).setCleanClusterData(options.isRemoveCluster()));
            SnapshotData.Builder builder = SnapshotData.newBuilder().setSuccess(false);
            adder.onNext((Object)builder.setMeta(snapshotMeta).build());
            builder.setMeta(noMetadata);
            while ((size = stream.read(buffer)) > 0) {
                adder.onNext((Object)builder.setData(ByteString.copyFrom((byte[])buffer, (int)0, (int)size)).build());
            }
            adder.onNext((Object)SnapshotData.newBuilder().setSuccess(true).build());
            adder.onCompleted();
            finishLatch.await();
        }
        catch (IOException e) {
            logger.error("Error occurred during snapshot replication: ", (Throwable)e);
            finishLatch.countDown();
            adder.onError((Throwable)e);
            throw new RaftRpcConnectionException((Throwable)e);
        }
        catch (InterruptedException e) {
            logger.error("Error occurred during snapshot replication: ", (Throwable)e);
            Thread.currentThread().interrupt();
            finishLatch.countDown();
            adder.onError((Throwable)e);
            throw new RaftRpcConnectionException((Throwable)e);
        }
    }
}

