/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.clustermanagement;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.ontotext.forest.clustermanagement.ClusterStateException;
import com.ontotext.forest.clustermanagement.SnapshotCatchupService;
import com.ontotext.forest.clustermanagement.SnapshotReplicationObserver;
import com.ontotext.forest.core.semantic.SemanticDataManagement;
import com.ontotext.forest.core.semantic.SemanticLocation;
import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.recovery.RecoveryService;
import com.ontotext.forest.recovery.SnapshotReplicationRequest;
import com.ontotext.graphdb.Config;
import com.ontotext.graphdb.GraphDBHTTPContext;
import com.ontotext.graphdb.GraphDBRepositoryManager;
import com.ontotext.graphdb.cluster.observer.grpc.ObserverRegistration;
import com.ontotext.graphdb.raft.ClusterGroup;
import com.ontotext.graphdb.raft.RaftException;
import com.ontotext.graphdb.raft.grpc.AvailabilityRequest;
import com.ontotext.graphdb.raft.grpc.ClusterConfigOptions;
import com.ontotext.graphdb.raft.grpc.ConfigResponse;
import com.ontotext.graphdb.raft.grpc.ConfigServiceGrpc;
import com.ontotext.graphdb.raft.grpc.GroupConfig;
import com.ontotext.graphdb.raft.grpc.NodeInfo;
import com.ontotext.graphdb.raft.grpc.NodeInfoRequest;
import com.ontotext.graphdb.raft.grpc.RemoteNodeState;
import com.ontotext.graphdb.raft.grpc.ReplicateSnapshotRequest;
import com.ontotext.graphdb.raft.grpc.ReplicateSnapshotResponse;
import com.ontotext.graphdb.raft.grpc.RepositoryInfo;
import com.ontotext.graphdb.raft.grpc.RpcNodeClient;
import com.ontotext.graphdb.raft.grpc.SnapshotData;
import com.ontotext.graphdb.raft.grpc.SnapshotOptionsForNewNodes;
import com.ontotext.graphdb.raft.grpc.SnapshotResponse;
import com.ontotext.graphdb.raft.grpc.StatusResponse;
import com.ontotext.graphdb.raft.observe.RaftObserver;
import com.ontotext.graphdb.raft.storage.LogEntry;
import com.ontotext.graphdb.raft.storage.TransactionLog;
import com.ontotext.graphdb.recovery.BackupException;
import com.ontotext.graphdb.recovery.SnapshotOptions;
import com.ontotext.license.License;
import com.ontotext.license.LicenseRegistry;
import com.ontotext.raft.GraphDBReplicationCluster;
import com.ontotext.raft.NodeStatus;
import com.ontotext.raft.RpcMulticastService;
import com.ontotext.raft.config.ClusterConfig;
import com.ontotext.raft.config.ClusterConfigService;
import com.ontotext.raft.config.ClusterGroupProperties;
import com.ontotext.raft.config.ClusterRequest;
import com.ontotext.raft.config.ClusterSecondaryConfig;
import com.ontotext.trree.OwlimSchemaRepository;
import com.ontotext.trree.monitorRepository.MonitorRepository;
import com.ontotext.trree.sdk.impl.PluginManager;
import io.grpc.Deadline;
import io.grpc.Status;
import io.grpc.StatusRuntimeException;
import io.grpc.stub.StreamObserver;
import jakarta.annotation.Nullable;
import jakarta.annotation.PostConstruct;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.StringJoiner;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.tomcat.util.buf.HexUtils;
import org.eclipse.rdf4j.query.UpdateExecutionException;
import org.eclipse.rdf4j.repository.Repository;
import org.eclipse.rdf4j.repository.manager.RepositoryManager;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.ApplicationEvent;
import org.springframework.context.ApplicationEventPublisher;
import org.springframework.context.ApplicationEventPublisherAware;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Service;

@Service
public class ClusterService
extends ConfigServiceGrpc.ConfigServiceImplBase
implements ApplicationListener<PropertyChangedEvent>,
ApplicationContextAware,
ApplicationEventPublisherAware {
    private static final Logger logger = LoggerFactory.getLogger(ClusterService.class);
    public static final String CREATED_MESSAGE = "Cluster was successfully created.";
    public static final String DELETED_ON_NODE_MESSAGE = "Cluster was deleted on this node.";
    public static final String ALREADY_EXISTS_MESSAGE = "Cluster already exists. The operation cannot be executed.";
    public static final String NOT_CREATED_MESSAGE = "Cluster was not created.";
    public static final String NOT_DELETED_MESSAGE = "Cluster was not deleted.";
    public static final String ALREADY_IN_CLUSTER_MESSAGE = "Node is already part of another cluster. The operation cannot be executed.";
    public static final String OUTDATED_TX_LOG_CLUSTER_MESSAGE = "Node has outdated transaction log and could not be added to the cluster. Please remove the transaction log.";
    public static final String NO_CONNECTION_MESSAGE = "There is no connection to the current node. The operation cannot be executed.";
    public static final String RESTRICTED_MESSAGE = "There is no license set on the current node. The operation cannot be executed.";
    public static final String NO_CLUSTER_MESSAGE = "Node is not part of the cluster. The operation cannot be executed.";
    public static final String CAN_NOT_DELETE_CLUSTER_MESSAGE = "Node is processing another transaction log operation. Cluster was not deleted.";
    public static final String NODE_SUCCESSFULLY_ADDED_MESSAGE = "Node was successfully added in the cluster.";
    public static final String NODE_SUCCESSFULLY_REMOVED_MESSAGE = "Node was successfully removed from the cluster.";
    public static final String NODE_SUCCESSFULLY_REMOVED_NO_CONNECTION_MESSAGE = "Node was successfully removed from the cluster, but its cluster config file was not deleted locally as there is no connection to it.";
    private static final long CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS = Config.getPropertyAsLong((String)"graphdb.cluster.sync.timeoutS", (long)TimeUnit.MINUTES.toSeconds(10L));
    private static final long CATCH_UP_NEW_NODES_TIMEOUT_SECONDS = Config.getPropertyAsLong((String)"graphdb.cluster.catchup.snapshot.replication.timeoutS", (long)TimeUnit.HOURS.toSeconds(3L));
    private static final long CATCH_UP_FOLLOWER_SYNC_TIMEOUT_SECONDS = Config.getPropertyAsLong((String)"graphdb.cluster.catchup.follower.sync.timeoutS", (long)TimeUnit.MINUTES.toSeconds(30L));
    private static final float TRANSACTION_LOG_THRESHOLD_MIN_SIZE = Config.getPropertyAsFloat((String)"graphdb.cluster.transaction.log.threshold.min.size", (float)1.0f);
    public static final int REPLICATION_TIMEOUT_MS = 20000;
    public static final String UNABLE_TO_CALL_PEER = "Unable to call peer node";
    public static final String FOLLOWER_FAILED_TO_REPLICATE_CATCHUP_SNAPSHOT = "Follower failed to replicate snapshot to the new nodes.";
    public static final String NOT_ALL_NODES_ARE_IN_SYNC_ERROR_MESSAGE = "Not all nodes are in sync to replicate config update.";
    public static final String HEARTBEAT_INTERVAL_GREATER_THAN_ELECTION_MIN_TIMEOUT_ERROR = "Heartbeat interval must be less than election min timeout.";
    public static final String HEARTBEAT_INTERVAL_SIZE_ERROR_MESSAGE = "Heartbeat interval must be at least 100 ms.";
    public static final String ELECTION_MIN_TIMEOUT_SIZE_ERROR_MESSAGE = "Election min timeout must be at least 1000 ms.";
    public static final String ELECTION_RANGE_TIMEOUT_SIZE_ERROR_MESSAGE = "Election range timeout must be at least 1000 ms.";
    public static final String MESSAGE_SIZE_LESS_THAN_1KB_ERROR_MESSAGE = "Message size must be must be at least 1 kb.";
    public static final String VERIFICATION_TIMEOUT_SIZE_ERROR_MESSAGE = "Verification timeout must be at least 100 ms.";
    public static final String TRANSACTION_LOG_MAXIMUM_SIZE_LESS_THAN_1GB_ERROR_MESSAGE = "Transaction log maximum size must be at least 1 GB or a negative number if we do not want to automatically trigger the truncation of the transaction log.";
    public static final String BATCH_UPDATE_LESS_THAN_100MS_ERROR_MESSAGE = "Batch update interval must be at least 100 ms.";
    public static final String REMOVING_TOO_MANY_NODES_ERROR_MESSAGE = "Removed nodes should be less than half of the nodes in the cluster group.";
    public static final String CLUSTER_GROUP_MIN_SIZE_ERROR_MESSAGE = "Cluster group must consist of at least two nodes.";
    public static final String UNIQUE_NODES_IN_NEW_GROUP = "Nodes in new config should be unique nodes.";
    public static final String LEADER_SHOULD_NOT_BE_ADDED = "Could not use leader node's address as added node's address.";
    public static final String FORBIDDEN_OPERATION_DELETE_MESSAGE = "Forbidden operation, this node was part of another cluster and needs to be replaced. You could forcefully delete the cluster group.";
    public static final String FORBIDDEN_OPERATION_REPLACE_NODES_MESSAGE = "Forbidden operation, this node was part of another cluster and needs to be replaced.";
    private final SemanticDataManagement semanticDataManagement;
    private final RecoveryService recoveryService;
    private RpcMulticastService<ConfigServiceGrpc.ConfigServiceFutureStub> rpcMulticastService;
    private SnapshotCatchupService catchupService;
    private volatile boolean serverInitialized = false;
    private final Set<RaftObserver> observers = new CopyOnWriteArraySet<RaftObserver>();
    private ApplicationEventPublisher publisher;

    @Autowired
    public ClusterService(SemanticDataManagement semanticDataManagement, RecoveryService recoveryService) {
        this.semanticDataManagement = semanticDataManagement;
        this.recoveryService = recoveryService;
    }

    @PostConstruct
    public void initialize() {
        this.rpcMulticastService = RpcMulticastService.builder().setLogger(logger).setThreadPattern("cluster-config-%d").setClusterConfigServiceProvider(this::getClusterConfigService).build(ConfigServiceGrpc::newFutureStub);
        this.catchupService = new SnapshotCatchupService();
    }

    public void shutdown() {
        this.rpcMulticastService.shutdown();
        this.catchupService.shutdown();
    }

    public boolean isClusterEnabled() {
        return this.getClusterConfigService().isClusterEnabled();
    }

    public ClusterState getClusterState() {
        if (!this.serverInitialized) {
            return ClusterState.UNKNOWN;
        }
        return this.semanticDataManagement.getCurrentLocation().getReplicationCluster() == null ? ClusterState.DISABLED : ClusterState.ENABLED;
    }

    @Nullable
    public ClusterConfig getClusterConfig() {
        if (!this.serverInitialized || !this.isClusterEnabled()) {
            return null;
        }
        return this.getClusterConfigService().fetchClusterConfig();
    }

    public StreamObserver<SnapshotData> replicateState(StreamObserver<SnapshotResponse> responseObserver) {
        logger.info("Replicating state before joining cluster group");
        return new SnapshotReplicationObserver(this.recoveryService, responseObserver, () -> this.computeNodeFingerprint(this.getBasicNodeInfo().build()));
    }

    public void truncateClusterLog() throws ClusterStateException {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        this.checkIfApplyingBackup(messages, "truncate cluster log");
        this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow().truncateLog();
    }

    public List<String> validateConfig(ClusterRequest clusterConfig) {
        LinkedList<String> messages = new LinkedList<String>();
        if (clusterConfig.getNodes() == null || clusterConfig.getNodes().size() < 2) {
            messages.add(CLUSTER_GROUP_MIN_SIZE_ERROR_MESSAGE);
        }
        if (clusterConfig.getNodes() != null && !clusterConfig.getNodes().contains(this.getCurrentRPCAddress())) {
            messages.add("The node which creates the group should be part of the group. This node's external RPC address is: " + this.getCurrentRPCAddress());
        }
        messages.addAll(this.validateGroupProperties(clusterConfig.getHeartbeatInterval(), clusterConfig.getElectionMinTimeout(), clusterConfig.getElectionRangeTimeout(), clusterConfig.getMessageSizeKB(), clusterConfig.getVerificationTimeout(), clusterConfig.getTransactionLogMaximumSizeGB(), clusterConfig.getBatchUpdateInterval()));
        if (new TreeSet(clusterConfig.getNodes()).size() < clusterConfig.getNodes().size()) {
            messages.add("Cluster group must consist of unique nodes.");
        }
        return messages;
    }

    public List<String> validateRemovedNodesExistInGroup(List<String> removedNodes, List<String> currentConfigNodes) {
        ArrayList<String> errorMessages = new ArrayList<String>();
        for (String removedNodeAddress : removedNodes) {
            if (currentConfigNodes.contains(removedNodeAddress)) continue;
            errorMessages.add("Node " + removedNodeAddress + " is not in the current cluster group");
        }
        return errorMessages;
    }

    public List<String> validateConfigGroupMembershipUpdate(ClusterConfig clusterConfig) throws ClusterStateException {
        LinkedList<String> messages = new LinkedList<String>();
        this.validateUniqueNodesInGroup(clusterConfig, messages);
        this.checkClusterConfigUpdateOnNodes(clusterConfig.streamRpcNodes().collect(Collectors.toList()));
        return messages;
    }

    public List<String> validateReplaceNodesConfigGroupMembershipUpdate(ClusterConfig currentConfig, ClusterConfig newConfig, List<String> removedNodes, List<String> addedNodes) throws ClusterStateException {
        LinkedList<String> messages = new LinkedList<String>();
        if ((long)removedNodes.size() >= Math.round((double)currentConfig.getNodes().size() / 2.0)) {
            messages.add(REMOVING_TOO_MANY_NODES_ERROR_MESSAGE);
        }
        this.validateUniqueNodesInGroup(newConfig, messages);
        this.validateLeaderReplacesItself(addedNodes, messages);
        this.checkClusterConfigUpdateOnReplaceNodes(currentConfig.streamRpcNodes().collect(Collectors.toList()));
        return messages;
    }

    private void validateLeaderReplacesItself(List<String> addedNodes, List<String> messages) {
        if (addedNodes.contains(this.getCurrentRPCAddress())) {
            messages.add(LEADER_SHOULD_NOT_BE_ADDED);
        }
    }

    private void validateUniqueNodesInGroup(ClusterConfig newConfig, List<String> messages) {
        Set uniqueNodesInNewConfig = newConfig.getNodes().stream().map(NodeInfo::getRpcAddress).collect(Collectors.toSet());
        if (uniqueNodesInNewConfig.size() < 2) {
            messages.add(CLUSTER_GROUP_MIN_SIZE_ERROR_MESSAGE);
        }
        if (uniqueNodesInNewConfig.size() < newConfig.getNodes().size()) {
            messages.add(UNIQUE_NODES_IN_NEW_GROUP);
        }
    }

    private void checkClusterConfigUpdateOnReplaceNodes(List<String> nodes) throws ClusterStateException {
        Map<String, StatusResponse> errorNodes;
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationClusterOrThrow();
        Map groupStatus = replicationCluster.getGroupStatus();
        TreeMap<String, String> messages = new TreeMap<String, String>();
        if (groupStatus.keySet().stream().anyMatch(address -> nodes.contains(address) && StatusResponse.Status.NO_CONNECTION == ((StatusResponse)groupStatus.get(address)).getStatus()) && (long)(errorNodes = ClusterService.filterNotConnectedNodes(groupStatus, messages)).size() >= Math.round((double)nodes.size() / 2.0)) {
            throw new ClusterStateException(messages);
        }
    }

    @NotNull
    private static Map<String, StatusResponse> filterNotConnectedNodes(Map<String, StatusResponse> groupStatus, Map<String, String> messages) {
        Map<String, StatusResponse> errorNodes = groupStatus.entrySet().stream().filter(e -> ((StatusResponse)e.getValue()).getStatus() == StatusResponse.Status.NO_CONNECTION).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        messages.putAll(errorNodes.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> NO_CONNECTION_MESSAGE)));
        return errorNodes;
    }

    public List<String> validateGroupProperties(int heartbeatInterval, int electionMinTimeout, int electionRangeTimeout, int messageSizeKB, int verificationTimeout, float transactionLogTruncationThreshold, int batchUpdateInterval) {
        ArrayList<String> messages = new ArrayList<String>();
        if (heartbeatInterval >= electionMinTimeout) {
            messages.add(HEARTBEAT_INTERVAL_GREATER_THAN_ELECTION_MIN_TIMEOUT_ERROR);
        }
        if (heartbeatInterval < 100) {
            messages.add(HEARTBEAT_INTERVAL_SIZE_ERROR_MESSAGE);
        }
        if (electionMinTimeout < 1000) {
            messages.add(ELECTION_MIN_TIMEOUT_SIZE_ERROR_MESSAGE);
        }
        if (electionRangeTimeout < 1000) {
            messages.add(ELECTION_RANGE_TIMEOUT_SIZE_ERROR_MESSAGE);
        }
        if (messageSizeKB < 1) {
            messages.add(MESSAGE_SIZE_LESS_THAN_1KB_ERROR_MESSAGE);
        }
        if (verificationTimeout < 100) {
            messages.add(VERIFICATION_TIMEOUT_SIZE_ERROR_MESSAGE);
        }
        if (transactionLogTruncationThreshold < TRANSACTION_LOG_THRESHOLD_MIN_SIZE && transactionLogTruncationThreshold >= 0.0f) {
            messages.add(TRANSACTION_LOG_MAXIMUM_SIZE_LESS_THAN_1GB_ERROR_MESSAGE);
        }
        if (batchUpdateInterval < 100) {
            messages.add(BATCH_UPDATE_LESS_THAN_100MS_ERROR_MESSAGE);
        }
        return messages;
    }

    public void checkClusterConfigUpdateOnNodes(List<String> nodes) throws ClusterStateException {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationClusterOrThrow();
        Map groupStatus = replicationCluster.getGroupStatus();
        TreeMap<String, String> messages = new TreeMap<String, String>();
        if (groupStatus.keySet().stream().anyMatch(address -> nodes.contains(address) && StatusResponse.Status.NO_CONNECTION == ((StatusResponse)groupStatus.get(address)).getStatus())) {
            ClusterService.filterNotConnectedNodes(groupStatus, messages);
            throw new ClusterStateException(messages);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> createCluster(ClusterConfig clusterConfig, boolean replicate) throws ClusterStateException {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        try {
            this.startClusterCreation(semanticLocation);
            TreeMap<String, String> messages = new TreeMap<String, String>();
            this.checkIfApplyingBackup(messages, "create cluster");
            this.managePluginOperations(true);
            this.initCheckSumIfNeeded(clusterConfig);
            Map<String, RemoteNodeState> nodesState = this.getNodesState(clusterConfig.streamRpcNodes().collect(Collectors.toList()));
            this.handleNoConnectionToNode(messages, nodesState, true);
            this.handleSecurityMismatch(nodesState);
            this.handleRestrictedNodes(messages, nodesState);
            this.updateRemoteHttpAddresses(clusterConfig, nodesState);
            this.handleMisconfiguredURLOnNode(messages, clusterConfig, nodesState);
            if (replicate) {
                this.semanticDataManagement.removeObsoleteClusterLocations(clusterConfig);
                HashMap<String, SnapshotOptions> replicationOptions = new HashMap<String, SnapshotOptions>();
                this.replicateSecuritySettings(nodesState, replicationOptions, Collections.emptyList());
                this.handleDifferentRepositories(messages, nodesState, true, replicationOptions);
                this.tryReplicateState(messages, replicationOptions);
            }
            this.handleDifferentRepositoriesMetadata(messages, nodesState, this.getClusterConfig(), true);
            this.handleClusterFoundOnNode(messages, nodesState, clusterConfig.getInitialStateChecksum());
            semanticLocation.createReplicationCluster(clusterConfig);
            this.setObservers(semanticLocation);
            this.recordRepositoryChannelsToConfig(clusterConfig);
            if (replicate) {
                Map<String, ConfigResponse> configResponse = this.replicateConfig(clusterConfig.streamRpcNodes().collect(Collectors.toList()), clusterConfig);
                messages.putAll(configResponse.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigResponse)e.getValue()).getMessage())));
                this.handleFailureToReplicateConfig(configResponse);
            }
            messages.put(this.getCurrentRPCAddress(), CREATED_MESSAGE);
            this.notifyClusterCreated();
            TreeMap<String, String> treeMap = messages;
            return treeMap;
        }
        finally {
            this.endClusterCreation(semanticLocation);
        }
    }

    private void handleMisconfiguredURLOnNode(Map<String, String> messages, ClusterConfig clusterConfig, Map<String, RemoteNodeState> nodesState) throws ClusterStateException {
        List<String> peersExternalUrls = nodesState.values().stream().map(remoteNodeState -> remoteNodeState.getNodeStatus().getEndpoint()).toList();
        List<String> nodesHttps = clusterConfig.getNodes().stream().map(NodeInfo::getHttpAddress).toList();
        if (Collections.frequency(nodesHttps, nodesHttps.getFirst()) == nodesHttps.size() && Config.getExternalUrl() == null) {
            return;
        }
        if (Collections.frequency(peersExternalUrls, peersExternalUrls.getFirst()) != nodesHttps.size()) {
            messages.putAll(this.callPeersByHttpAddress(peersExternalUrls));
        }
        if (!messages.isEmpty()) {
            logger.error(messages.toString());
            throw new ClusterStateException(messages);
        }
    }

    private Map<String, String> callPeersByHttpAddress(List<String> peersExternalUrls) {
        HashMap<String, String> messages = new HashMap<String, String>();
        HttpClient httpClient = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).connectTimeout(Duration.ofSeconds(60L)).build();
        for (String externalUrl : peersExternalUrls) {
            try {
                HttpRequest request = HttpRequest.newBuilder().uri(URI.create(externalUrl + "/protocol")).timeout(Duration.ofMinutes(1L)).header("Accept", "application/json").GET().build();
                ((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).get(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException | ExecutionException | TimeoutException e) {
                logger.error("Unable to call peer {}", (Object)externalUrl, (Object)e);
                messages.put(externalUrl, UNABLE_TO_CALL_PEER);
            }
        }
        return messages;
    }

    private void updateRemoteHttpAddresses(ClusterConfig clusterConfig, Map<String, RemoteNodeState> nodesState) {
        List nodes = clusterConfig.getNodes();
        Map nodeMapping = nodes.stream().collect(Collectors.toMap(NodeInfo::getRpcAddress, Function.identity()));
        nodeMapping.computeIfPresent(this.getCurrentRPCAddress(), (address, info) -> NodeInfo.newBuilder((NodeInfo)info).setHttpAddress(Config.getExternalUrl(null)).build());
        nodesState.forEach((rpcAddress, state) -> nodeMapping.computeIfPresent((String)rpcAddress, (address, info) -> NodeInfo.newBuilder((NodeInfo)info).setHttpAddress(state.getNodeStatus().getEndpoint()).build()));
        clusterConfig.setNodes(new ArrayList(nodeMapping.values()));
    }

    private void setObservers(SemanticLocation semanticLocation) {
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationClusterOrThrow();
        this.observers.forEach(arg_0 -> ((GraphDBReplicationCluster)replicationCluster).addClusterObserver(arg_0));
    }

    private void handleFailureToReplicateConfig(Map<String, ConfigResponse> replicateResponse) throws ClusterStateException {
        long failureCount = replicateResponse.values().stream().filter(configResponse -> !configResponse.getSuccess()).count();
        if (failureCount > 0L) {
            logger.warn("Cluster config replication failed for {} of {} nodes. Deleting cluster...", (Object)failureCount, (Object)(replicateResponse.size() + 1));
            this.deleteCluster(true, true);
            TreeMap<String, String> clusterDeletionCause = new TreeMap<String, String>(replicateResponse.entrySet().stream().filter(entrySet -> !((ConfigResponse)entrySet.getValue()).getSuccess()).collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigResponse)e.getValue()).getMessage())));
            logger.warn("Cluster removal completed with: {}", clusterDeletionCause);
            throw new ClusterStateException(clusterDeletionCause);
        }
    }

    private void handleDifferentRepositories(Map<String, String> messages, Map<String, RemoteNodeState> nodesState, boolean shouldDeleteClusterOnError, @Nullable Map<String, SnapshotOptions> replicationOptions) throws ClusterStateException {
        RemoteNodeState currentNodeInfo = this.getBasicNodeInfo().build();
        String currentNodeFingerprint = this.computeNodeFingerprint(currentNodeInfo);
        Map<String, String> nodeFingerprints = nodesState.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.computeNodeFingerprint((RemoteNodeState)entry.getValue())));
        boolean differentFingerprint = false;
        HashMap<String, String> emptyNodes = new HashMap<String, String>();
        for (Map.Entry<String, String> nodeEntry : nodeFingerprints.entrySet()) {
            if (currentNodeFingerprint.equals(nodeEntry.getValue())) continue;
            if (nodeEntry.getValue().isEmpty()) {
                emptyNodes.put(nodeEntry.getKey(), this.differentRepositoriesMessage(currentNodeInfo, nodesState.get(nodeEntry.getKey())));
                continue;
            }
            differentFingerprint = true;
            messages.put(nodeEntry.getKey(), this.differentRepositoriesMessage(currentNodeInfo, nodesState.get(nodeEntry.getKey())));
        }
        if (differentFingerprint || replicationOptions == null && !emptyNodes.isEmpty()) {
            if (shouldDeleteClusterOnError) {
                this.deleteCluster(false, false);
            }
            messages.putAll(emptyNodes);
            throw new ClusterStateException(messages);
        }
        if (!emptyNodes.isEmpty()) {
            for (String address : emptyNodes.keySet()) {
                replicationOptions.computeIfAbsent(address, k -> new SnapshotOptions()).setWithRepositoryData(true).setWithClusterData(true);
            }
        }
    }

    private String differentRepositoriesMessage(RemoteNodeState currentNodeInfo, RemoteNodeState remoteNodeInfo) {
        List currentNodeReposList = currentNodeInfo.getRepositoriesList();
        List remoteNodeReposList = remoteNodeInfo.getRepositoriesList();
        List mismatchedRepos = Stream.concat(currentNodeReposList.stream(), remoteNodeReposList.stream()).map(RepositoryInfo::getRepository).distinct().collect(Collectors.toList());
        return "Mismatching fingerprints with" + (mismatchedRepos.size() == 1 ? " repository " : " repositories ") + String.join((CharSequence)", ", mismatchedRepos) + ".";
    }

    @VisibleForTesting
    protected String computeNodeFingerprint(RemoteNodeState state) {
        List list = state.getRepositoriesList();
        return list.stream().sorted(Comparator.comparing(RepositoryInfo::getRepository)).map(info -> info.getRepository() + info.getFingerprint()).collect(Collectors.joining());
    }

    private void recordRepositoryChannelsToConfig(ClusterConfig config) throws ClusterStateException {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationCluster();
        if (replicationCluster == null) {
            throw new ClusterStateException(Collections.singletonMap(this.getCurrentRPCAddress(), NOT_CREATED_MESSAGE));
        }
        boolean updated = false;
        ClusterGroup clusterGroup = replicationCluster.getClusterGroup();
        TransactionLog transactionLog = clusterGroup.getTransactionLog();
        for (ClusterConfig.RepoInfo repoInfo : config.getInitialRepositories()) {
            if (repoInfo.getChannel() != null) continue;
            int channel = transactionLog.getChannelId(repoInfo.getRepositoryId());
            repoInfo.setChannel(Integer.valueOf(channel));
            updated = true;
        }
        if (updated) {
            this.getClusterConfigService().recordClusterGroup(config);
        }
    }

    @VisibleForTesting
    public void initCheckSumIfNeeded(ClusterConfig clusterConfig) {
        if (clusterConfig.getInitialStateChecksum() == null) {
            SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
            StringBuilder builder = new StringBuilder();
            TreeSet<NodeInfo> treeSet = new TreeSet<NodeInfo>(Comparator.comparing(NodeInfo::getRpcAddress));
            treeSet.addAll(clusterConfig.getNodes());
            builder.append(treeSet);
            semanticLocation.iterateRepositories((repoId, sail) -> {
                builder.append((String)repoId);
                if (sail != null && !sail.isShutDown() && !sail.isShuttingDown()) {
                    builder.append(sail.getFingerprint());
                }
                clusterConfig.getInitialRepositories().add(new ClusterConfig.RepoInfo().setRepositoryId(repoId));
            });
            MessageDigest digest = ClusterService.getHashedRepoInfo(builder.toString());
            clusterConfig.setInitialStateChecksum(HexUtils.toHexString((byte[])digest.digest()));
        }
    }

    private void handleClusterFoundOnNode(Map<String, String> messages, Map<String, RemoteNodeState> remoteNodeStates, String initialStateChecksum) throws ClusterStateException {
        String currentRPCAddress = this.getCurrentRPCAddress();
        if (remoteNodeStates.entrySet().stream().anyMatch(entry -> ((RemoteNodeState)entry.getValue()).getAlreadyInCluster() && !((String)entry.getKey()).equals(currentRPCAddress) && !Objects.equals(initialStateChecksum, ((RemoteNodeState)entry.getValue()).getClusterId()))) {
            for (Map.Entry<String, RemoteNodeState> nodeEntry : remoteNodeStates.entrySet()) {
                if (!nodeEntry.getValue().getAlreadyInCluster() || nodeEntry.getKey().equals(currentRPCAddress)) continue;
                messages.put(nodeEntry.getKey(), ALREADY_IN_CLUSTER_MESSAGE);
            }
            this.deleteCluster(false, false);
            throw new ClusterStateException(messages);
        }
    }

    private void handleNoConnectionToNode(Map<String, String> messages, Map<String, RemoteNodeState> groupStatus, boolean shouldDeleteClusterOnError) throws ClusterStateException {
        if (groupStatus.values().stream().anyMatch(statusResponse -> this.isNoConnectionToNode((RemoteNodeState)statusResponse) || this.hasBadPeerConnectivity((RemoteNodeState)statusResponse))) {
            messages.putAll(groupStatus.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.isNoConnectionToNode((RemoteNodeState)entry.getValue()) || this.hasBadPeerConnectivity((RemoteNodeState)entry.getValue()) ? NO_CONNECTION_MESSAGE : NOT_CREATED_MESSAGE)));
            if (shouldDeleteClusterOnError) {
                this.deleteCluster(false, false);
            } else {
                ClusterConfig currentConfig = Objects.requireNonNull(this.getClusterConfig());
                SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
                semanticLocation.updateReplicationCluster(currentConfig);
            }
            throw new ClusterStateException(messages);
        }
    }

    private void handleSecurityMismatch(Map<String, RemoteNodeState> nodesState) throws ClusterStateException {
        boolean isLocalSecured = Config.getPropertyAsBoolean((String)"security.enabled", (boolean)false);
        boolean hasMismatchingSecurity = false;
        HashMap<String, String> messages = new HashMap<String, String>();
        for (Map.Entry<String, RemoteNodeState> stateEntry : nodesState.entrySet()) {
            if (isLocalSecured != stateEntry.getValue().getIsSecured()) {
                hasMismatchingSecurity = true;
            }
            if (stateEntry.getValue().getIsSecured()) continue;
            messages.put(stateEntry.getKey(), "Mismatching security settings. Enable security on node");
        }
        if (hasMismatchingSecurity) {
            if (!isLocalSecured) {
                messages.put(this.getCurrentRPCAddress(), "Mismatching security settings. Enable security on node");
            }
            throw new ClusterStateException(messages);
        }
    }

    private boolean hasBadPeerConnectivity(RemoteNodeState statusResponse) {
        return statusResponse.getPeerAvailabilityCount() > 0 && statusResponse.getPeerAvailabilityList().stream().anyMatch(peerAvailabilityReport -> !peerAvailabilityReport.getAccessible());
    }

    private boolean isNoConnectionToNode(RemoteNodeState statusResponse) {
        return StatusResponse.Status.NO_CONNECTION.equals((Object)statusResponse.getNodeStatus().getStatus());
    }

    public Map<String, ConfigResponse> replicateConfig(List<String> destinationNodes, ClusterConfig config) {
        logger.info("Replicating cluster config to nodes: {}", destinationNodes);
        return (Map)this.rpcMulticastService.callPeersBlocking(destinationNodes, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadlineAfter(CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS, TimeUnit.SECONDS)).addConfig(this.buildConfigRequest(config)), this::getConfigResponses);
    }

    private GroupConfig buildConfigRequest(ClusterConfig config) {
        return GroupConfig.newBuilder().addAllNodes((Iterable)config.getNodes()).setClusterOptions(this.buildClusterOptions(config)).setInitChecksum(config.getInitialStateChecksum()).addAllRepositories((Iterable)config.getInitialRepositories().stream().map(this::toRepositoryInfo).collect(Collectors.toList())).addAllObserverRegistrations((Iterable)config.getObserverRegistrations().stream().map(registration -> ObserverRegistration.newBuilder((ObserverRegistration)registration).build()).collect(Collectors.toList())).build();
    }

    private GroupConfig buildConfigRequestToDeleteGroupOnRemovedNodes(ClusterConfig config, List<String> nodesToDeleteGroupFrom) {
        return GroupConfig.newBuilder().addAllNodes((Iterable)config.getNodes().stream().filter(nodeInfo -> nodesToDeleteGroupFrom.contains(nodeInfo.getRpcAddress())).collect(Collectors.toList())).setClusterOptions(this.buildClusterOptions(config)).setInitChecksum(config.getInitialStateChecksum()).addAllRepositories((Iterable)config.getInitialRepositories().stream().map(this::toRepositoryInfo).collect(Collectors.toList())).addAllObserverRegistrations((Iterable)config.getObserverRegistrations().stream().map(registration -> ObserverRegistration.newBuilder((ObserverRegistration)registration).build()).collect(Collectors.toList())).build();
    }

    private ClusterConfigOptions buildClusterOptions(ClusterConfig config) {
        return ClusterConfigOptions.newBuilder().setMessageSize(config.getMessageSizeKB()).setElectionMinTimeout(config.getElectionMinTimeout()).setElectionRangeTimeout(config.getElectionRangeTimeout()).setHeartBeatInterval(config.getHeartbeatInterval()).setVerificationMs(config.getVerificationTimeout()).setTransactionLogMaximumSize(config.getTransactionLogMaximumSizeGB()).setBatchUpdateInterval(config.getBatchUpdateInterval()).build();
    }

    @NotNull
    private RepositoryInfo toRepositoryInfo(ClusterConfig.RepoInfo repoInfo) {
        return RepositoryInfo.newBuilder().setRepository(repoInfo.getRepositoryId()).setChannel(repoInfo.getChannel() == null ? -3 : repoInfo.getChannel()).build();
    }

    @NotNull
    private Map<String, ConfigResponse> getConfigResponses(Map<String, ListenableFuture<ConfigResponse>> futures) {
        TreeMap<String, ConfigResponse> responseMap = new TreeMap<String, ConfigResponse>();
        futures.forEach((peerAddress, future) -> {
            try {
                ConfigResponse response = (ConfigResponse)Futures.getDone((Future)future);
                responseMap.put((String)peerAddress, response);
            }
            catch (ExecutionException ee) {
                Status status = Status.fromThrowable((Throwable)ee.getCause());
                String message = MoreObjects.toStringHelper((Object)status).add("code", (Object)status.getCode().name()).add("description", (Object)status.getDescription()).add("cause", status.getCause() != null ? status.getCause().getMessage() : null).toString();
                responseMap.put((String)peerAddress, this.buildFailureConfigResponse(message));
            }
        });
        return responseMap;
    }

    @NotNull
    private Map<String, String> getSnapshotReplicationToNewNodesResponses(Map<String, ListenableFuture<ReplicateSnapshotResponse>> futures) {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        futures.forEach((peerAddress, future) -> {
            try {
                ReplicateSnapshotResponse response = (ReplicateSnapshotResponse)Futures.getDone((Future)future);
                messages.putAll(response.getMessagesMap());
                logger.info("Snapshot replication to node {} succeeded.", peerAddress);
            }
            catch (ExecutionException ee) {
                messages.putAll(this.buildFailureReplicateSnapshotResponse((String)peerAddress, FOLLOWER_FAILED_TO_REPLICATE_CATCHUP_SNAPSHOT).getMessagesMap());
                logger.error("Snapshot replication to node {} failed: {}", peerAddress, (Object)ee.getCause().getMessage());
            }
        });
        return messages;
    }

    private void replicateSecuritySettings(Map<String, RemoteNodeState> nodesState, Map<String, SnapshotOptions> replicationOptions, List<String> nodesToSkip) {
        HashSet<String> otherNodes = new HashSet<String>(nodesState.keySet());
        otherNodes.remove(this.getCurrentRPCAddress());
        otherNodes.addAll(nodesToSkip);
        logger.info("Replicating users and settings to nodes {} before adding them to the cluster", otherNodes);
        otherNodes.forEach(nodeAddress -> replicationOptions.computeIfAbsent((String)nodeAddress, k -> new SnapshotOptions()).setWithSystemData(true));
    }

    public Map<String, String> deleteCluster(boolean replicate, boolean force) throws ClusterStateException {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        this.checkIfApplyingBackup(messages, "delete cluster");
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationCluster();
        if (this.isNodeNotInCurrentClusterConfig()) {
            return this.deleteClusterForcefullyIfNeeded(force, messages, semanticLocation);
        }
        this.verifyCurrentNodeTxLogIsNotLockedOrThrow(replicationCluster, messages);
        if (replicate) {
            Map<String, ConfigResponse> stringConfigResponseMap;
            this.checkIfNodeIsInClusterOrThrow(replicationCluster, messages);
            Map groupStatus = replicationCluster.getGroupStatus();
            this.handleDeleteWhenNodeNotReachable(force, messages, groupStatus);
            String leaderAddress = this.getLeaderAddress(groupStatus);
            if (StringUtils.isNotEmpty((CharSequence)leaderAddress) && !this.getCurrentRPCAddress().equals(leaderAddress)) {
                logger.info("Attempting to delete cluster");
                stringConfigResponseMap = this.replicateDeleteOnNodes(List.of(leaderAddress));
                messages.putAll(stringConfigResponseMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigResponse)e.getValue()).getMessage())));
                if (!force) {
                    for (ConfigResponse response : stringConfigResponseMap.values()) {
                        if (response.getSuccess()) continue;
                        throw new ClusterStateException(messages);
                    }
                }
            }
            stringConfigResponseMap = this.replicateDeleteOnNodes(this.excludeLeaderAddress(groupStatus, leaderAddress));
            messages.putAll(stringConfigResponseMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigResponse)e.getValue()).getMessage())));
        }
        semanticLocation.deleteReplicationCluster(true);
        messages.put(this.getCurrentRPCAddress(), DELETED_ON_NODE_MESSAGE);
        this.notifyClusterDeleted();
        return messages;
    }

    @NotNull
    private Map<String, String> deleteClusterForcefullyIfNeeded(boolean force, Map<String, String> messages, SemanticLocation semanticLocation) throws ClusterStateException {
        if (force) {
            semanticLocation.deleteReplicationCluster(true);
            messages.put(this.getCurrentRPCAddress(), DELETED_ON_NODE_MESSAGE);
            return messages;
        }
        messages.put(this.getCurrentRPCAddress(), FORBIDDEN_OPERATION_DELETE_MESSAGE);
        throw new ClusterStateException(messages);
    }

    public boolean isNodeNotInCurrentClusterConfig() {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocation();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationCluster();
        return replicationCluster != null && !replicationCluster.isNodeInConfig(this.getClusterConfig());
    }

    private void handleDeleteWhenNodeNotReachable(boolean force, Map<String, String> messages, Map<String, StatusResponse> groupStatus) throws ClusterStateException {
        if (!force && groupStatus.values().stream().anyMatch(statusResponse -> StatusResponse.Status.NO_CONNECTION.equals((Object)statusResponse.getStatus()))) {
            messages.putAll(groupStatus.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> StatusResponse.Status.NO_CONNECTION.equals((Object)((StatusResponse)e.getValue()).getStatus()) ? NO_CONNECTION_MESSAGE : NOT_DELETED_MESSAGE)));
            throw new ClusterStateException(messages);
        }
    }

    public List<NodeStatus> getGroupStatus() {
        if (!this.serverInitialized) {
            return Collections.singletonList(this.getNodeStatus());
        }
        LinkedList<NodeStatus> nodeStatusList = new LinkedList<NodeStatus>();
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        if (replicationCluster == null) {
            nodeStatusList.add(this.getNodeStatus());
        } else {
            boolean authenticatedFully = this.isAuthenticatedFully();
            replicationCluster.getGroupStatus().forEach((nodeAddress, statusResponse) -> {
                if (statusResponse != null) {
                    nodeStatusList.add(new NodeStatus(nodeAddress, statusResponse, authenticatedFully));
                }
            });
        }
        return nodeStatusList;
    }

    public NodeStatus getNodeStatus() {
        boolean authenticatedFully = this.isAuthenticatedFully();
        if (!this.serverInitialized) {
            return new NodeStatus(this.getCurrentRPCAddress(), StatusResponse.newBuilder().setEndpoint(Config.getExternalUrl(null)).setStatus(StatusResponse.Status.NO_CONNECTION).build(), authenticatedFully);
        }
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocationOrThrow().getReplicationCluster();
        StatusResponse nodeStatus = replicationCluster == null ? StatusResponse.newBuilder().setEndpoint(Config.getExternalUrl(null)).setStatus(StatusResponse.Status.NO_CLUSTER).build() : replicationCluster.getNodeStatus();
        return new NodeStatus(this.getCurrentRPCAddress(), nodeStatus, authenticatedFully);
    }

    public String getCurrentRPCAddress() {
        return Config.getRPCAddress();
    }

    public ClusterConfig generateNewConfig(ClusterGroupProperties updatePropertiesConfig, ClusterConfig currentConfig) {
        ClusterConfig newConfig = currentConfig.copy();
        if (updatePropertiesConfig.getElectionMinTimeout() != null) {
            newConfig.setElectionMinTimeout(updatePropertiesConfig.getElectionMinTimeout().intValue());
        }
        if (updatePropertiesConfig.getElectionRangeTimeout() != null) {
            newConfig.setElectionRangeTimeout(updatePropertiesConfig.getElectionRangeTimeout().intValue());
        }
        if (updatePropertiesConfig.getHeartbeatInterval() != null) {
            newConfig.setHeartbeatInterval(updatePropertiesConfig.getHeartbeatInterval().intValue());
        }
        if (updatePropertiesConfig.getMessageSizeKB() != null) {
            newConfig.setMessageSizeKB(updatePropertiesConfig.getMessageSizeKB().intValue());
        }
        if (updatePropertiesConfig.getVerificationTimeout() != null) {
            newConfig.setVerificationTimeout(updatePropertiesConfig.getVerificationTimeout().intValue());
        }
        if (updatePropertiesConfig.getTransactionLogMaximumSizeGB() != null) {
            newConfig.setTransactionLogMaximumSizeGB(updatePropertiesConfig.getTransactionLogMaximumSizeGB().floatValue());
        }
        if (updatePropertiesConfig.getBatchUpdateInterval() != null) {
            newConfig.setBatchUpdateInterval(updatePropertiesConfig.getBatchUpdateInterval().intValue());
        }
        return newConfig;
    }

    public void updateProperties(ClusterConfig newConfig) throws ClusterStateException {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        this.checkIfApplyingBackup(messages, "update cluster properties");
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocation();
        Map<String, RemoteNodeState> nodesState = this.getNodesState(newConfig.streamRpcNodes().collect(Collectors.toList()));
        this.handleNoConnectionToNode(messages, nodesState, false);
        this.handleRestrictedNodes(messages, nodesState);
        this.handleSecurityMismatch(nodesState);
        this.handleMisconfiguredURLOnNode(messages, newConfig, nodesState);
        this.handleDifferentRepositories(messages, nodesState, false, null);
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationCluster();
        if (replicationCluster != null) {
            long updatedProperties = replicationCluster.updateProperties(newConfig.getProperties());
            if (updatedProperties <= 0L) {
                logger.error("Failed to update cluster properties.");
                throw this.clusterConfigurationUpdateFailed();
            }
        } else {
            throw new ClusterStateException(messages);
        }
        semanticLocation.updateReplicationCluster(newConfig);
        logger.info("Cluster properties successfully updated.");
    }

    @NotNull
    private IllegalArgumentException clusterConfigurationUpdateFailed() {
        return new IllegalArgumentException("Cluster configuration update failed");
    }

    private void handleRestrictedNodes(Map<String, String> messages, Map<String, RemoteNodeState> groupStatus) throws ClusterStateException {
        if (groupStatus.values().stream().anyMatch(this::isNodeRestricted)) {
            messages.putAll(groupStatus.entrySet().stream().filter(entry -> this.isNodeRestricted((RemoteNodeState)entry.getValue())).collect(Collectors.toMap(Map.Entry::getKey, entry -> RESTRICTED_MESSAGE)));
            throw new ClusterStateException(messages);
        }
    }

    private boolean isNodeRestricted(RemoteNodeState statusResponse) {
        return StatusResponse.Status.RESTRICTED.equals((Object)statusResponse.getNodeStatus().getStatus());
    }

    public ClusterConfig generateNewConfigByAddingNodes(List<String> nodes, ClusterConfig currentConfig) throws ClusterStateException {
        ClusterConfig newConfig = currentConfig.copy();
        ArrayList<NodeInfo> newNodes = new ArrayList<NodeInfo>(newConfig.getNodes());
        newNodes.addAll(this.getNodeInfos(nodes));
        newConfig.setNodes(newNodes);
        return newConfig;
    }

    public Map<String, String> addNodes(List<String> newNodes, ClusterConfig currentConfig, ClusterConfig newConfig) throws ClusterStateException {
        this.throwIfNodeIsALocation(newConfig);
        List<NodeInfo> nodeInfos = this.createClusterOnNewNodes(newNodes, newConfig, true, Collections.emptyList());
        logger.info("Attempting to add nodes to the cluster. Nodes: {}", newNodes);
        long addedNodes = this.addNodesInCluster(nodeInfos);
        if (addedNodes < 0L) {
            logger.error("Failed to add nodes to cluster. Nodes: {}", newNodes);
            this.deleteClusterOnNodes(newNodes);
            this.semanticDataManagement.getCurrentLocation().updateReplicationCluster(currentConfig);
            throw this.clusterConfigurationUpdateFailed();
        }
        logger.info("Successfully added {} nodes to the cluster. Nodes: {}", (Object)addedNodes, newNodes);
        return this.generateMessagesForAddedNodes(newNodes);
    }

    private void throwIfNodeIsALocation(ClusterConfig newConfig) {
        List locationIds = this.semanticDataManagement.getGDBLocationsInstallationIds();
        Set nodeAddresses = newConfig.getNodes().stream().map(n -> this.semanticDataManagement.fetchInstallationIdFromLocation(n.getHttpAddress().toLowerCase(Locale.ROOT))).collect(Collectors.toSet());
        for (String locationId : locationIds) {
            if (!nodeAddresses.contains(locationId.toLowerCase(Locale.ROOT))) continue;
            throw new UpdateExecutionException(String.format("Trying to add a node that exist as a remote location. Remove the location %s and try again.", locationId));
        }
    }

    public void enableSecondaryClusterMode(ClusterSecondaryConfig config) {
        String primaryNode = config.getPrimaryNode();
        logger.info("Attempting to enable secondary mode cluster with primary nodes: {}", (Object)primaryNode);
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        this.verifyNodeIsNotPartFromTheCurrentClusterOrThrow(primaryNode, replicationCluster);
        long index = replicationCluster.enableSecondaryClusterMode(NodeInfo.newBuilder().setRpcAddress(primaryNode).build(), config.getTag());
        if (index < 1L) {
            throw new UpdateExecutionException("Could not enable cluster secondary mode");
        }
        logger.info("Successfully enabled secondary cluster mode");
    }

    public void disableSecondaryClusterMode() {
        logger.info("Attempting to disable secondary mode cluster");
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        long index = replicationCluster.disableSecondaryClusterMode();
        if (index < 1L) {
            throw new UpdateExecutionException("Could not disable cluster secondary mode");
        }
        logger.info("Successfully disabled secondary cluster mode");
    }

    public boolean addSecondaryTag(String tag) {
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        boolean added = replicationCluster.addTag(tag);
        if (added) {
            logger.info("Successfully added secondary cluster tag \"{}\"", (Object)tag);
        } else {
            logger.info("Failed to add secondary cluster tag \"{}\" as it already exists", (Object)tag);
        }
        return added;
    }

    public boolean removeSecondaryTag(String tag) {
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        boolean removed = replicationCluster.removeTag(tag);
        if (removed) {
            logger.info("Successfully removed secondary cluster tag \"{}\"", (Object)tag);
        } else {
            logger.info("Failed to remove secondary cluster tag \"{}\" as it doesn't exists", (Object)tag);
        }
        return removed;
    }

    private Map<String, String> generateMessagesForAddedNodes(List<String> nodes) {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        nodes.forEach(node -> messages.put((String)node, NODE_SUCCESSFULLY_ADDED_MESSAGE));
        return messages;
    }

    protected long addNodesInCluster(List<NodeInfo> addedNodes) {
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        return replicationCluster.addNodes(addedNodes);
    }

    @VisibleForTesting
    public List<NodeInfo> createClusterOnNewNodes(@Nullable List<String> addedNodes, ClusterConfig newConfig, boolean replication, @Nullable List<String> nodesToSkip) throws ClusterStateException {
        TreeMap<String, String> messages = new TreeMap<String, String>();
        this.checkIfApplyingBackup(messages, "create cluster on new nodes");
        this.managePluginOperations(true);
        this.initCheckSumIfNeeded(newConfig);
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        ClusterConfig currentConfig = this.getClusterConfig();
        this.createClusterIfNeeded(newConfig, currentConfig, semanticLocation);
        Map<String, RemoteNodeState> nodesState = this.getNodesState(newConfig.streamRpcNodes().collect(Collectors.toList()));
        Map<String, RemoteNodeState> newNodesState = this.filterNewNodes(nodesState, addedNodes);
        this.handleProblematicNodeStates(newConfig, replication, messages, nodesState);
        if (replication) {
            this.handleReplication(newNodesState, nodesState, newConfig, currentConfig, messages, nodesToSkip);
        } else {
            this.setObservers(semanticLocation);
        }
        if (replication && this.isCurrentNodePartOfTheNewClusterGroup(newConfig)) {
            semanticLocation.updateReplicationCluster(newConfig);
        }
        if (replication && addedNodes != null) {
            this.handleConfigReplication(addedNodes, newConfig, messages, currentConfig, semanticLocation);
        }
        List<NodeInfo> newNodeInfosFromConfig = this.getNewNodeInfosFromConfig(addedNodes, newConfig);
        this.notifyClusterCreated();
        return newNodeInfosFromConfig;
    }

    private Map<String, RemoteNodeState> filterNewNodes(Map<String, RemoteNodeState> nodesState, @Nullable List<String> addedNodes) {
        HashMap<String, RemoteNodeState> newNodesState = new HashMap<String, RemoteNodeState>(nodesState);
        if (addedNodes != null) {
            newNodesState.keySet().retainAll(addedNodes);
        }
        return newNodesState;
    }

    private void handleReplication(Map<String, RemoteNodeState> newNodesState, Map<String, RemoteNodeState> nodesState, ClusterConfig newConfig, ClusterConfig currentConfig, Map<String, String> messages, @Nullable List<String> nodesToSkip) throws ClusterStateException {
        HashMap<String, SnapshotOptions> replicationOptions = new HashMap<String, SnapshotOptions>();
        this.handleClusterFoundOnReplacingNode(messages, nodesState, newConfig.getInitialStateChecksum());
        this.validateFingerprintsOnNewNodes(messages, newNodesState, replicationOptions, nodesToSkip);
        boolean isReplicatingRepoData = !replicationOptions.isEmpty();
        this.replicateSecuritySettings(newNodesState, replicationOptions, nodesToSkip);
        this.tryReplicateSnapshotFromFollowerOnNewNodes(messages, currentConfig, nodesState, replicationOptions, newConfig.getNodes(), nodesToSkip);
        if (isReplicatingRepoData) {
            this.handleDifferentRepositoriesMetadata(messages, newNodesState, currentConfig, false);
        }
    }

    private void handleConfigReplication(List<String> addedNodes, ClusterConfig newConfig, Map<String, String> messages, ClusterConfig currentConfig, SemanticLocation semanticLocation) throws ClusterStateException {
        Map<String, ConfigResponse> configResponse = this.replicateConfigOnNewNodes(addedNodes, newConfig);
        messages.putAll(configResponse.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> ((ConfigResponse)e.getValue()).getMessage())));
        if (this.handleFailureToReplicateConfigOnAddedNodes(configResponse, addedNodes) && currentConfig != null) {
            semanticLocation.updateReplicationCluster(currentConfig);
            throw new ClusterStateException(messages);
        }
    }

    @NotNull
    private List<NodeInfo> getNewNodeInfosFromConfig(@Nullable List<String> addedNodes, ClusterConfig newConfig) {
        if (addedNodes != null) {
            List<NodeInfo> nodesToAdd = newConfig.getNodes().stream().filter(node -> addedNodes.contains(node.getRpcAddress())).collect(Collectors.toList());
            assert (nodesToAdd.stream().allMatch(node -> StringUtils.isNotBlank((CharSequence)node.getHttpAddress())));
            return nodesToAdd;
        }
        return Collections.emptyList();
    }

    private void handleProblematicNodeStates(ClusterConfig newConfig, boolean replication, Map<String, String> messages, Map<String, RemoteNodeState> nodesState) throws ClusterStateException {
        this.handleNoConnectionToNode(messages, nodesState, !replication);
        this.handleRestrictedNodes(messages, nodesState);
        this.handleSecurityMismatch(nodesState);
        this.updateRemoteHttpAddresses(newConfig, nodesState);
        this.handleMisconfiguredURLOnNode(messages, newConfig, nodesState);
    }

    private void createClusterIfNeeded(ClusterConfig newConfig, ClusterConfig currentConfig, SemanticLocation semanticLocation) throws ClusterStateException {
        if (currentConfig == null) {
            semanticLocation.createReplicationCluster(newConfig);
            this.recordRepositoryChannelsToConfig(newConfig);
            this.handleDifferentRepositoriesOnAddedNodes();
        }
    }

    private boolean isCurrentNodePartOfTheNewClusterGroup(ClusterConfig newConfig) {
        return newConfig.getNodes().stream().map(NodeInfo::getRpcAddress).collect(Collectors.toList()).contains(this.getCurrentRPCAddress());
    }

    @VisibleForTesting
    void validateFingerprintsOnNewNodes(Map<String, String> messages, Map<String, RemoteNodeState> newNodesState, Map<String, SnapshotOptions> replicationOptions, List<String> nodesToSkip) throws ClusterStateException {
        RemoteNodeState currentNodeInfo = this.getBasicNodeInfo().build();
        String currentNodeFingerprint = this.computeNodeFingerprint(currentNodeInfo);
        Map<String, String> nodeFingerPrints = newNodesState.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.computeNodeFingerprint((RemoteNodeState)entry.getValue())));
        ArrayList<String> nodesToRemove = new ArrayList<String>();
        HashMap<String, String> emptyNodes = new HashMap<String, String>();
        HashSet<String> noneEmptyNodes = new HashSet<String>();
        boolean hasDiffFingerprint = this.processNodeFingerprints(nodeFingerPrints, newNodesState, nodesToSkip, currentNodeInfo, currentNodeFingerprint, messages, nodesToRemove, emptyNodes, noneEmptyNodes);
        for (String nodeToRemove : nodesToRemove) {
            newNodesState.remove(nodeToRemove);
        }
        if (hasDiffFingerprint) {
            messages.putAll(emptyNodes);
            throw new ClusterStateException(messages);
        }
        if (!emptyNodes.isEmpty()) {
            for (String address : emptyNodes.keySet()) {
                replicationOptions.computeIfAbsent(address, k -> new SnapshotOptions()).setWithRepositoryData(true).setWithClusterData(true);
            }
        }
        if (!noneEmptyNodes.isEmpty()) {
            for (String address : noneEmptyNodes) {
                SnapshotOptions options = replicationOptions.computeIfAbsent(address, k -> new SnapshotOptions());
                options.setWithClusterData(true);
                assert (!options.isWithRepositoryData()) : "Not allowed to do data replication on none empty node: " + address;
            }
        }
    }

    private boolean processNodeFingerprints(Map<String, String> nodeFingerPrints, Map<String, RemoteNodeState> newNodesState, List<String> nodesToSkip, RemoteNodeState currentNodeInfo, String currentNodeFingerprint, Map<String, String> messages, List<String> nodesToRemove, Map<String, String> emptyNodes, Set<String> noneEmptyNodes) {
        boolean hasDiffFingerprint = false;
        for (Map.Entry<String, String> nodeEntry : nodeFingerPrints.entrySet()) {
            String nodeAddress = nodeEntry.getKey();
            String nodeFingerprint = nodeEntry.getValue();
            boolean isInCluster = newNodesState.get(nodeAddress).getAlreadyInCluster();
            boolean areFingerprintsEqual = this.checkIfFingerprintsAreEqual(currentNodeInfo, newNodesState.get(nodeAddress), currentNodeFingerprint, nodeFingerprint);
            if (nodesToSkip.contains(nodeAddress)) {
                if (!areFingerprintsEqual) {
                    messages.put(nodeAddress, this.differentRepositoriesMessage(currentNodeInfo, newNodesState.get(nodeAddress)));
                    logger.error("Node {} should be with same or empty data in order to replace it", (Object)nodeAddress);
                } else {
                    logger.warn("Node {} is already part of the cluster", (Object)nodeAddress);
                }
                nodesToRemove.add(nodeAddress);
            }
            if (!isInCluster && !hasDiffFingerprint && nodeFingerprint.isEmpty()) {
                emptyNodes.put(nodeAddress, this.differentRepositoriesMessage(currentNodeInfo, newNodesState.get(nodeAddress)));
                continue;
            }
            if (!areFingerprintsEqual) {
                hasDiffFingerprint = true;
                messages.put(nodeAddress, this.differentRepositoriesMessage(currentNodeInfo, newNodesState.get(nodeAddress)));
                continue;
            }
            if (currentNodeFingerprint.isEmpty() || !newNodesState.get(nodeAddress).getClusterId().isEmpty()) continue;
            noneEmptyNodes.add(nodeAddress);
        }
        return hasDiffFingerprint;
    }

    private boolean checkIfFingerprintsAreEqual(RemoteNodeState currentNodeInfo, RemoteNodeState remoteNodeState, String currentFingerprint, String remoteFingerprint) {
        if (remoteNodeState.getAlreadyInCluster()) {
            if (currentNodeInfo.getClusterId().equals(remoteNodeState.getClusterId())) {
                if (!currentFingerprint.equals(remoteFingerprint)) {
                    logger.warn("Fingerprint mismatch detected");
                    for (RepositoryInfo repoInfo : remoteNodeState.getRepositoriesList()) {
                        String fingerprintAtIndex;
                        LogEntry entryAtIndex = this.semanticDataManagement.getCurrentLocationOrThrow().getReplicationClusterOrThrow().getClusterGroup().getTransactionLog().fetchLogEntry(repoInfo.getLogIndex());
                        if (entryAtIndex == null || entryAtIndex.getChannel() == -4 || (fingerprintAtIndex = entryAtIndex.getFingerprint()).equals(repoInfo.getFingerprint())) continue;
                        String repoName = repoInfo.getRepository();
                        logger.warn("Fingerprint mismatch detected for repository {} ", (Object)repoName);
                        return false;
                    }
                }
                return true;
            }
        } else {
            return currentFingerprint.equals(remoteFingerprint);
        }
        return false;
    }

    public Map<String, String> replaceNodes(List<String> newNodes, List<String> oldNodes, ClusterConfig currentConfig, ClusterConfig newConfig) throws ClusterStateException {
        Map<String, String> deletedNodesMessages;
        TreeMap<String, String> messages = new TreeMap<String, String>();
        ArrayList<String> nodesToSkip = new ArrayList<String>();
        boolean sameNodes = this.isAddressSame(newNodes, oldNodes, nodesToSkip);
        if (oldNodes.isEmpty()) {
            return this.addNodes(newNodes, currentConfig, newConfig);
        }
        if (newNodes.isEmpty()) {
            return this.removeNodes(oldNodes, currentConfig, newConfig);
        }
        if (sameNodes) {
            oldNodes.removeAll(nodesToSkip);
        }
        if (this.isNodeNotInCurrentClusterConfig()) {
            messages.put(this.getCurrentRPCAddress(), FORBIDDEN_OPERATION_REPLACE_NODES_MESSAGE);
            throw new ClusterStateException(messages);
        }
        List<NodeInfo> newNodeInfos = this.createClusterOnNewNodes(newNodes, newConfig, true, nodesToSkip);
        try {
            List<NodeInfo> oldNodeInfos = this.getOldNodesInfos(oldNodes, currentConfig);
            logger.info("Starting node replacement process. Replacing {} nodes with {} new nodes.", (Object)this.formatNodeInfoList(oldNodeInfos, nodesToSkip), (Object)this.formatNodeInfoList(newNodeInfos, Collections.emptyList()));
            long replacedNodes = this.replaceNodesInCluster(oldNodeInfos, newNodeInfos, nodesToSkip);
            if (replacedNodes < 0L) {
                logger.error("Failed to update cluster configuration during node replacement.");
                this.deleteClusterOnNodes(newNodes);
                this.semanticDataManagement.getCurrentLocation().updateReplicationCluster(currentConfig);
                throw this.clusterConfigurationUpdateFailed();
            }
            deletedNodesMessages = this.deleteClusterOnNodes(oldNodes);
            if (oldNodes.contains(this.getCurrentRPCAddress())) {
                this.semanticDataManagement.getCurrentLocation().deleteReplicationCluster(false);
            }
        }
        catch (UpdateExecutionException e) {
            logger.error("Failed to replace nodes due to: ", (Throwable)e);
            this.deleteClusterOnNodes(newNodes);
            this.semanticDataManagement.getCurrentLocationOrThrow().updateReplicationCluster(currentConfig);
            throw e;
        }
        return this.generateMessagesForReplacedNodes(newNodes, deletedNodesMessages);
    }

    private Map<String, String> generateMessagesForReplacedNodes(List<String> newNodes, Map<String, String> deletedNodesMessages) {
        TreeMap<String, String> messages = new TreeMap<String, String>(deletedNodesMessages);
        newNodes.forEach(node -> messages.put((String)node, NODE_SUCCESSFULLY_ADDED_MESSAGE));
        return messages;
    }

    private List<NodeInfo> getOldNodesInfos(List<String> oldNodes, ClusterConfig currentConfig) {
        return currentConfig.getNodes().stream().filter(nodeInfo -> oldNodes.contains(nodeInfo.getRpcAddress())).collect(Collectors.toList());
    }

    private long replaceNodesInCluster(List<NodeInfo> oldNodesInfos, List<NodeInfo> newNodesInfos, List<String> nodesToSkip) {
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        long replacedNodes = replicationCluster.replaceNodes(oldNodesInfos, newNodesInfos);
        if (replacedNodes >= 0L) {
            logger.info("Successfully replaced {} nodes with {}.", (Object)this.formatNodeInfoList(oldNodesInfos, nodesToSkip), (Object)this.formatNodeInfoList(newNodesInfos, Collections.emptyList()));
        } else {
            logger.error("Failed to add nodes {} in the cluster. ", (Object)this.formatNodeInfoList(newNodesInfos, Collections.emptyList()));
        }
        return replacedNodes;
    }

    private void tryReplicateSnapshotFromFollowerOnNewNodes(Map<String, String> messages, ClusterConfig currentConfig, Map<String, RemoteNodeState> nodesState, Map<String, SnapshotOptions> replicationOptions, List<NodeInfo> newNodes, List<String> nodesToSkip) throws ClusterStateException {
        for (NodeInfo nodeInfo : currentConfig.getNodes()) {
            if (currentConfig.getExternalAddress().getRpcAddress().equals(nodeInfo.getRpcAddress()) || !nodesState.containsKey(nodeInfo.getRpcAddress())) continue;
            Map<String, String> messagesResponse = this.replicateSnapshotOnNewNodes(nodeInfo.getRpcAddress(), replicationOptions);
            this.handleExecutionException(messagesResponse);
            messages.putAll(messagesResponse);
            this.waitForNodeToGoInSync(nodeInfo.getRpcAddress(), newNodes, nodesToSkip);
            break;
        }
    }

    private void waitForNodeToGoInSync(String node, List<NodeInfo> remainingNodes, List<String> nodesToSkip) throws ClusterStateException {
        long deadline = System.currentTimeMillis() + TimeUnit.SECONDS.toMillis(CATCH_UP_FOLLOWER_SYNC_TIMEOUT_SECONDS);
        while (System.currentTimeMillis() < deadline) {
            Map<String, String> nodeStatuses;
            if (CollectionUtils.isNotEmpty(nodesToSkip)) {
                ArrayList<NodeInfo> copyConfig = new ArrayList<NodeInfo>(remainingNodes);
                copyConfig.removeIf(x -> nodesToSkip.contains(x.getRpcAddress()));
                nodeStatuses = this.getRemainingNodesStatuses(copyConfig);
                if (this.allNodesAreInSync(nodeStatuses)) {
                    return;
                }
            } else {
                nodeStatuses = this.getRemainingNodesStatuses(remainingNodes);
            }
            if (nodeStatuses.containsKey(node) && RpcNodeClient.Status.IN_SYNC.name().equals(nodeStatuses.get(node)) && this.allNodesAreInSync(nodeStatuses)) {
                return;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
        }
        HashMap<String, String> errorMessages = new HashMap<String, String>();
        errorMessages.put(node, NOT_ALL_NODES_ARE_IN_SYNC_ERROR_MESSAGE);
        throw new ClusterStateException(errorMessages);
    }

    private Map<String, String> getRemainingNodesStatuses(List<NodeInfo> remainingNodes) {
        Map allNodesStatuses = this.getNodeStatus().getSyncStatus();
        if (remainingNodes.isEmpty()) {
            return allNodesStatuses;
        }
        List addresses = remainingNodes.stream().map(NodeInfo::getRpcAddress).collect(Collectors.toList());
        return allNodesStatuses.entrySet().stream().filter(nodeStatus -> addresses.contains(nodeStatus.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private boolean allNodesAreInSync(Map<String, String> nodeStatuses) {
        return nodeStatuses.values().stream().allMatch(status -> RpcNodeClient.Status.IN_SYNC.name().equals(status));
    }

    private void handleExecutionException(Map<String, String> messagesResponse) throws ClusterStateException {
        for (String message : messagesResponse.values()) {
            if (!message.equals(FOLLOWER_FAILED_TO_REPLICATE_CATCHUP_SNAPSHOT)) continue;
            throw new ClusterStateException(messagesResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryReplicateState(Map<String, String> messages, Map<String, SnapshotOptions> replicationOptions) throws ClusterStateException {
        replicationOptions.forEach((address, options) -> options.setReplicationTimeoutMs(Integer.valueOf(20000)));
        Map groupedByOptions = replicationOptions.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        this.lockNode();
        try {
            for (Map.Entry entry : groupedByOptions.entrySet()) {
                File snapshot = null;
                try {
                    List<String> nodeAddresses = entry.getValue();
                    SnapshotOptions options2 = entry.getKey();
                    logger.info("Creating a temporary {} to {} before adding them to the cluster", (Object)options2.toHumanString(), nodeAddresses);
                    if (this.isClusterEnabled() && !this.areAllRepoInitialized()) {
                        this.managePluginOperations(false);
                    }
                    snapshot = this.getRecoveryService().createSnapshot(UUID.randomUUID().toString(), options2);
                    String expectedFingerprint = null;
                    if (options2.isWithRepositoryData()) {
                        RemoteNodeState currentNodeInfo = this.getBasicNodeInfo().build();
                        expectedFingerprint = this.computeNodeFingerprint(currentNodeInfo);
                    }
                    SnapshotReplicationRequest request = new SnapshotReplicationRequest(snapshot, options2).setRequireFingerprint(options2.isWithRepositoryData());
                    this.catchupService.replicateAndValidateSnapshot(nodeAddresses, request, expectedFingerprint);
                }
                catch (BackupException | IOException e) {
                    messages.putAll(entry.getValue().stream().collect(Collectors.toMap(Function.identity(), k -> "Could not replicate state")));
                    throw new ClusterStateException(messages, e);
                }
                finally {
                    if (snapshot == null || !snapshot.exists() || !snapshot.delete()) continue;
                    logger.info("Cleaned up temporary snapshot {}", (Object)snapshot);
                }
            }
        }
        finally {
            this.unlockNode();
        }
    }

    private void unlockNode() {
        if (this.semanticDataManagement.getCurrentLocation().getReplicationCluster() != null) {
            this.semanticDataManagement.getCurrentLocation().getReplicationCluster().getClusterGroup().unlockSnapshotBuild();
        }
    }

    private void lockNode() {
        if (this.semanticDataManagement.getCurrentLocation().getReplicationCluster() != null) {
            this.semanticDataManagement.getCurrentLocation().getReplicationCluster().getClusterGroup().lockSnapshotBuild();
        }
    }

    private void handleDifferentRepositoriesMetadata(Map<String, String> messages, Map<String, RemoteNodeState> nodesState, @Nullable ClusterConfig currentConfig, boolean isCreatingClusterOnInitNode) throws ClusterStateException {
        if (currentConfig == null && !isCreatingClusterOnInitNode) {
            return;
        }
        RemoteNodeState currentNodeInfo = this.getBasicNodeInfo().build();
        String currentNodeRepoMetadata = this.computeNodeRepoMetadata(currentNodeInfo);
        Map<String, String> nodesRepositoryMetadata = nodesState.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> this.computeNodeRepoMetadata((RemoteNodeState)entry.getValue())));
        if (nodesRepositoryMetadata.values().stream().anyMatch(Predicate.isEqual(currentNodeRepoMetadata).or(Predicate.isEqual("")).negate())) {
            nodesRepositoryMetadata.forEach((nodeEntry, metadata) -> {
                if (!currentNodeRepoMetadata.equals(metadata)) {
                    messages.put((String)nodeEntry, this.differentRepositoriesMetadataMessage(currentNodeInfo, (RemoteNodeState)nodesState.get(nodeEntry)));
                }
            });
            throw new ClusterStateException(messages);
        }
    }

    private String computeNodeRepoMetadata(RemoteNodeState state) {
        return state.getRepositoriesList().stream().sorted(Comparator.comparing(RepositoryInfo::getRepository)).map(RepositoryInfo::getMetadata).collect(Collectors.joining());
    }

    private String differentRepositoriesMetadataMessage(RemoteNodeState currentNodeInfo, RemoteNodeState remoteNodeInfo) {
        List mismatchedRepos = Stream.concat(currentNodeInfo.getRepositoriesList().stream(), remoteNodeInfo.getRepositoriesList().stream()).map(RepositoryInfo::getRepository).distinct().collect(Collectors.toList());
        String message = "Mismatching namespaces with" + (mismatchedRepos.size() == 1 ? " repository " : " repositories ") + String.join((CharSequence)", ", mismatchedRepos) + ".";
        logger.error("Found mismatched repository metadata: {}", (Object)message);
        return message;
    }

    private void handleDifferentRepositoriesOnAddedNodes() {
        List<String> repositoriesInCurrentLocation;
        RemoteNodeState currentNodeInfo = this.getBasicNodeInfo().build();
        GraphDBReplicationCluster replicationCluster = Objects.requireNonNull(this.semanticDataManagement.getCurrentLocationOrThrow().getReplicationCluster());
        TransactionLog transactionLog = replicationCluster.getClusterGroup().getTransactionLog();
        Map transactionLogRepositories = transactionLog.getChannelIds();
        if (this.areRepositoriesInTransactionLogPresentedInCurrentLocation(transactionLogRepositories, repositoriesInCurrentLocation = currentNodeInfo.getRepositoriesList().stream().map(RepositoryInfo::getRepository).collect(Collectors.toList()))) {
            logger.error(OUTDATED_TX_LOG_CLUSTER_MESSAGE);
            throw new RaftException(OUTDATED_TX_LOG_CLUSTER_MESSAGE);
        }
        Map<String, String> repositoriesFingerprints = currentNodeInfo.getRepositoriesList().stream().collect(Collectors.toMap(RepositoryInfo::getRepository, RepositoryInfo::getFingerprint));
        HashMap<String, Boolean> repositoryComparedFingerprint = new HashMap<String, Boolean>();
        transactionLog.verifyLastChannelEntries(logEntry -> {
            if (this.isRepositoryChannel(logEntry.getChannel())) {
                repositoryComparedFingerprint.put(logEntry.getRepository(), logEntry.getFingerprint().equals(repositoriesFingerprints.get(logEntry.getRepository())));
                if (!((Boolean)repositoryComparedFingerprint.get(logEntry.getRepository())).booleanValue()) {
                    logger.error("Fingerprint mismatch for repository {}", (Object)logEntry.getRepository());
                }
            }
        });
        if (this.hasRepositoriesWithDifferentFingerprints(repositoryComparedFingerprint)) {
            throw new RaftException(OUTDATED_TX_LOG_CLUSTER_MESSAGE);
        }
    }

    private boolean hasRepositoriesWithDifferentFingerprints(Map<String, Boolean> repositoryComparedFingerprint) {
        return repositoryComparedFingerprint.keySet().stream().anyMatch(repo -> (Boolean)repositoryComparedFingerprint.get(repo) == false);
    }

    private boolean areRepositoriesInTransactionLogPresentedInCurrentLocation(Map<String, Integer> transactionLogRepositories, List<String> repositoriesInCurrentLocation) {
        return transactionLogRepositories.keySet().stream().anyMatch(repo -> this.isRepositoryChannel((Integer)transactionLogRepositories.get(repo)) && !repositoriesInCurrentLocation.contains(repo));
    }

    private boolean isRepositoryChannel(Integer transactionLogChannel) {
        return transactionLogChannel > 0;
    }

    private boolean handleFailureToReplicateConfigOnAddedNodes(Map<String, ConfigResponse> replicateResponse, List<String> addedNodes) throws ClusterStateException {
        long failureCount = replicateResponse.values().stream().filter(configResponse -> !configResponse.getSuccess()).count();
        if (failureCount > 0L) {
            logger.warn("Cluster config replication failed for {} of {} nodes. Deleting cluster...", (Object)failureCount, (Object)(replicateResponse.size() + 1));
            Map<String, String> deleteResponse = this.deleteClusterOnNodes(addedNodes);
            logger.warn("Cluster removal completed with: {}", deleteResponse);
            return true;
        }
        return false;
    }

    public Map<String, String> deleteClusterOnNodes(List<String> destinationNodes) throws ClusterStateException {
        Map<String, String> messages = new TreeMap<String, String>();
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        this.checkIfNodeIsInClusterOrThrow(semanticLocation.getReplicationCluster(), messages);
        try {
            Map<String, ConfigResponse> stringConfigResponseMap = this.replicateDeleteOnNodes(destinationNodes);
            messages = this.generateMessagesFromResponseMap(stringConfigResponseMap);
            if (destinationNodes.contains(this.getCurrentRPCAddress())) {
                logger.info("Current node {} successfully removed from the cluster.", (Object)this.getCurrentRPCAddress());
                messages.put(this.getCurrentRPCAddress(), NODE_SUCCESSFULLY_REMOVED_MESSAGE);
            }
        }
        catch (Exception e) {
            logger.error("Failed to delete cluster on nodes.", (Throwable)e);
            throw new ClusterStateException(messages);
        }
        return messages;
    }

    private void handleClusterFoundOnReplacingNode(Map<String, String> messages, Map<String, RemoteNodeState> remoteNodeStates, String initialStateChecksum) throws ClusterStateException {
        String currentRPCAddress = this.getCurrentRPCAddress();
        if (remoteNodeStates.entrySet().stream().anyMatch(entry -> ((RemoteNodeState)entry.getValue()).getAlreadyInCluster() && !((String)entry.getKey()).equals(currentRPCAddress) && this.checkClusterGroupExists(initialStateChecksum, (RemoteNodeState)entry.getValue()))) {
            for (Map.Entry<String, RemoteNodeState> nodeEntry : remoteNodeStates.entrySet()) {
                if (!nodeEntry.getValue().getAlreadyInCluster() || nodeEntry.getKey().equals(currentRPCAddress) || !this.checkClusterGroupExists(initialStateChecksum, nodeEntry.getValue())) continue;
                messages.put(nodeEntry.getKey(), ALREADY_IN_CLUSTER_MESSAGE);
            }
            throw new ClusterStateException(messages);
        }
    }

    private boolean checkClusterGroupExists(String initialStateChecksum, RemoteNodeState state) {
        return !Objects.equals(initialStateChecksum, state.getClusterId());
    }

    public Map<String, ConfigResponse> replicateConfigOnNewNodes(List<String> destinationNodes, ClusterConfig config) {
        logger.info("Replicating cluster config to nodes: {}", destinationNodes);
        return (Map)this.rpcMulticastService.callPeersBlocking(destinationNodes, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadlineAfter(CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS, TimeUnit.SECONDS)).addConfigOnNewNodes(this.buildConfigRequest(config)), this::getConfigResponses);
    }

    public Map<String, String> replicateSnapshotOnNewNodes(String followerNode, Map<String, SnapshotOptions> snapshotOptions) {
        List<String> singletonFollower = Collections.singletonList(followerNode);
        logger.info("Calling follower {} to replicate snapshot to new nodes.", singletonFollower);
        return (Map)this.rpcMulticastService.callPeersBlocking(singletonFollower, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadlineAfter(CATCH_UP_NEW_NODES_TIMEOUT_SECONDS, TimeUnit.SECONDS)).replicateSnapshot(this.buildReplicateSnapshotRequest(snapshotOptions)), this::getSnapshotReplicationToNewNodesResponses);
    }

    private ReplicateSnapshotRequest buildReplicateSnapshotRequest(Map<String, SnapshotOptions> snapshotOptions) {
        HashMap<String, SnapshotOptionsForNewNodes> snapshotRequests = new HashMap<String, SnapshotOptionsForNewNodes>();
        for (String node : snapshotOptions.keySet()) {
            SnapshotOptions options = snapshotOptions.get(node);
            SnapshotOptionsForNewNodes.Builder snapshotOptionsBuilder = SnapshotOptionsForNewNodes.newBuilder().setCleanDataDir(options.isCleanDataDir()).setRemoveCluster(options.isRemoveCluster()).setWithClusterData(options.isWithClusterData()).setWithRepositoryData(options.isWithRepositoryData()).setWithSystemData(options.isWithSystemData());
            if (options.getRepositories() != null) {
                snapshotOptionsBuilder.addAllRepositories((Iterable)options.getRepositories());
            }
            if (options.getReplicationTimeoutMs() != null) {
                snapshotOptionsBuilder.setReplicationTimeoutMs(options.getReplicationTimeoutMs().intValue());
            }
            snapshotRequests.put(node, snapshotOptionsBuilder.build());
        }
        return ReplicateSnapshotRequest.newBuilder().putAllNodesSnapshotOptions(snapshotRequests).build();
    }

    public ClusterConfig generateNewConfigByRemovingNodes(List<String> nodes, ClusterConfig currentConfig) {
        ClusterConfig newConfig = currentConfig.copy();
        LinkedList<NodeInfo> newNodes = new LinkedList<NodeInfo>(newConfig.getNodes());
        newNodes.removeIf(node -> nodes.contains(node.getRpcAddress()));
        newConfig.setNodes(newNodes);
        return newConfig;
    }

    public Map<String, String> removeNodes(List<String> rpcAddressesToRemove, ClusterConfig currentConfig, ClusterConfig newConfig) throws ClusterStateException {
        Map<String, String> messages = new TreeMap<String, String>();
        this.checkIfApplyingBackup(messages, "remove nodes from cluster");
        List<NodeInfo> nodesToRemove = currentConfig.getNodes().stream().filter(node -> rpcAddressesToRemove.contains(node.getRpcAddress())).collect(Collectors.toList());
        if (nodesToRemove.size() != rpcAddressesToRemove.size()) {
            throw new AssertionError((Object)"Detected changes in the RPC address of the removed nodes");
        }
        this.handleRestrictedNodes(messages, this.getNodesState(newConfig.streamRpcNodes().collect(Collectors.toList())));
        if (this.removeNodesFromCluster(nodesToRemove) < 0L) {
            logger.error("Failed to remove nodes from the cluster.");
            throw this.clusterConfigurationUpdateFailed();
        }
        Map<String, ConfigResponse> stringConfigResponseMap = this.replicateDeleteOnNodes(rpcAddressesToRemove);
        messages = this.generateMessagesFromResponseMap(stringConfigResponseMap);
        if (rpcAddressesToRemove.contains(this.getCurrentRPCAddress())) {
            this.semanticDataManagement.getCurrentLocation().deleteReplicationCluster(false);
            logger.info("Current node {} has been removed from the cluster.", (Object)this.getCurrentRPCAddress());
            messages.put(this.getCurrentRPCAddress(), DELETED_ON_NODE_MESSAGE);
        } else {
            this.semanticDataManagement.getCurrentLocation().updateReplicationCluster(newConfig);
        }
        return messages;
    }

    private Map<String, String> generateMessagesFromResponseMap(Map<String, ConfigResponse> stringConfigResponseMap) {
        return new TreeMap<String, String>(stringConfigResponseMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            if (((ConfigResponse)e.getValue()).getMessage().contains("Connection refused")) {
                return NODE_SUCCESSFULLY_REMOVED_NO_CONNECTION_MESSAGE;
            }
            switch (((ConfigResponse)e.getValue()).getMessage()) {
                case "Cluster was deleted on this node.": {
                    return NODE_SUCCESSFULLY_REMOVED_MESSAGE;
                }
                case "There is no connection to the current node. The operation cannot be executed.": {
                    return NODE_SUCCESSFULLY_REMOVED_NO_CONNECTION_MESSAGE;
                }
            }
            return ((ConfigResponse)e.getValue()).getMessage();
        })));
    }

    protected long removeNodesFromCluster(List<NodeInfo> removedNodes) {
        GraphDBReplicationCluster replicationCluster = this.semanticDataManagement.getCurrentLocation().getReplicationClusterOrThrow();
        return replicationCluster.removeNodes(removedNodes);
    }

    public Map<String, ConfigResponse> replicateDeleteOnNodes(List<String> destinationNodes) {
        Map responses = (Map)this.rpcMulticastService.callPeersBlocking(destinationNodes, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadlineAfter(CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS, TimeUnit.SECONDS)).removeConfig(this.buildConfigRequestToDeleteGroupOnRemovedNodes(Objects.requireNonNull(this.getClusterConfig()), destinationNodes)), this::getConfigResponses);
        for (Map.Entry entry : responses.entrySet()) {
            String nodeAddress = (String)entry.getKey();
            ConfigResponse response = (ConfigResponse)entry.getValue();
            if (response.getSuccess()) {
                logger.info("Cluster deletion on node {} successful.", (Object)nodeAddress);
                continue;
            }
            logger.warn("Cluster deletion on node {} failed: {}", (Object)nodeAddress, (Object)response.getMessage());
        }
        return responses;
    }

    public void addConfig(GroupConfig request, StreamObserver<ConfigResponse> responseObserver) {
        if (this.getClusterConfigService().isClusterEnabled()) {
            responseObserver.onNext((Object)this.buildFailureConfigResponse(ALREADY_EXISTS_MESSAGE));
        } else {
            ClusterConfig clusterGroup = new ClusterConfig();
            clusterGroup.setNodes(request.getNodesList());
            this.setClusterGroupOptions(request, clusterGroup);
            try {
                this.createCluster(clusterGroup, false);
                responseObserver.onNext((Object)this.buildSuccessfulConfigResponse(CREATED_MESSAGE));
            }
            catch (Exception e) {
                logger.error("Cluster config cannot be created due to: ", (Throwable)e);
                Object message = e.getMessage() == null ? "Cluster config could not be created due to exception of type " + String.valueOf(e) : e.getMessage();
                responseObserver.onNext((Object)this.buildFailureConfigResponse((String)message));
            }
        }
        responseObserver.onCompleted();
    }

    public void addConfigOnNewNodes(GroupConfig request, StreamObserver<ConfigResponse> responseObserver) {
        if (this.getClusterConfigService().isClusterEnabled() && !request.getInitChecksum().equals(this.getClusterConfig().getInitialStateChecksum())) {
            responseObserver.onNext((Object)this.buildFailureConfigResponse(ALREADY_EXISTS_MESSAGE));
        } else {
            ClusterConfig clusterGroup = new ClusterConfig(request.getNodesList());
            this.setClusterGroupOptions(request, clusterGroup);
            if (request.getObserverRegistrationsCount() > 0) {
                clusterGroup.setObserverRegistrations(new ArrayList(request.getObserverRegistrationsList()));
            }
            try {
                this.createClusterOnNewNodes(null, clusterGroup, false, Collections.emptyList());
                responseObserver.onNext((Object)this.buildSuccessfulConfigResponse(CREATED_MESSAGE));
                responseObserver.onCompleted();
            }
            catch (RaftException e) {
                logger.error("Cluster could not be created on new nodes due to: ", (Throwable)e);
                responseObserver.onNext((Object)this.buildFailureConfigResponse(OUTDATED_TX_LOG_CLUSTER_MESSAGE));
                responseObserver.onCompleted();
            }
            catch (Exception e) {
                logger.error("Cluster config cannot be created due to: {}", (Object)e.getMessage());
                responseObserver.onNext((Object)this.buildFailureConfigResponse("Could not add node to current cluster due to: " + e.getMessage()));
                responseObserver.onCompleted();
            }
        }
    }

    private void setClusterGroupOptions(GroupConfig request, ClusterConfig clusterGroup) {
        clusterGroup.setVerificationTimeout(request.getClusterOptions().getVerificationMs());
        clusterGroup.setMessageSizeKB(request.getClusterOptions().getMessageSize());
        clusterGroup.setElectionRangeTimeout(request.getClusterOptions().getElectionRangeTimeout());
        clusterGroup.setElectionMinTimeout(request.getClusterOptions().getElectionMinTimeout());
        clusterGroup.setHeartbeatInterval(request.getClusterOptions().getHeartBeatInterval());
        clusterGroup.setTransactionLogMaximumSizeGB(request.getClusterOptions().getTransactionLogMaximumSize());
        if (request.getRepositoriesCount() > 0) {
            clusterGroup.setInitialRepositories(request.getRepositoriesList().stream().map(ClusterConfig.RepoInfo::new).collect(Collectors.toList()));
        }
        clusterGroup.setInitialStateChecksum(request.getInitChecksum());
    }

    private void verifyNodeIsNotPartFromTheCurrentClusterOrThrow(String node, GraphDBReplicationCluster replicationCluster) {
        if (replicationCluster.getClusterGroup().getNodeIds().contains(node)) {
            logger.error("Failed to enable secondary cluster mode. Node {} is already part from the current cluster.", (Object)node);
            throw new IllegalArgumentException("The cluster cannot function as both primary and secondary at the same time.");
        }
    }

    public void replicateSnapshot(ReplicateSnapshotRequest request, StreamObserver<ReplicateSnapshotResponse> response) {
        logger.info("Received request to replicate snapshot to new nodes.");
        TreeMap<String, String> messages = new TreeMap<String, String>();
        HashMap<String, SnapshotOptions> snapshotOptions = new HashMap<String, SnapshotOptions>();
        for (String req : request.getNodesSnapshotOptionsMap().keySet()) {
            snapshotOptions.put(req, this.generateSnapshotOptionFromRequest((SnapshotOptionsForNewNodes)request.getNodesSnapshotOptionsMap().get(req)));
        }
        try {
            this.tryReplicateState(messages, snapshotOptions);
            response.onNext((Object)ReplicateSnapshotResponse.newBuilder().putAllMessages(messages).build());
            response.onCompleted();
        }
        catch (ClusterStateException e) {
            response.onNext((Object)this.buildFailureReplicateSnapshotResponse(this.getCurrentRPCAddress(), FOLLOWER_FAILED_TO_REPLICATE_CATCHUP_SNAPSHOT));
            response.onCompleted();
        }
    }

    private SnapshotOptions generateSnapshotOptionFromRequest(SnapshotOptionsForNewNodes snapshotOptions) {
        return new SnapshotOptions().setRemoveCluster(snapshotOptions.getRemoveCluster()).setRepositories(new ArrayList(snapshotOptions.getRepositoriesList())).setWithClusterData(snapshotOptions.getWithClusterData()).setWithRepositoryData(snapshotOptions.getWithRepositoryData()).setWithSystemData(snapshotOptions.getWithSystemData()).setCleanDataDir(snapshotOptions.getCleanDataDir()).setReplicationTimeoutMs(Integer.valueOf(snapshotOptions.getReplicationTimeoutMs()));
    }

    public void removeConfig(GroupConfig configOnInitNode, StreamObserver<ConfigResponse> responseObserver) {
        try {
            if (this.getClusterConfig() == null) {
                responseObserver.onNext((Object)this.buildFailureConfigResponse(NO_CLUSTER_MESSAGE));
            } else {
                List<String> errors = this.validateRemovedNodesExistInGroup(this.getNodesListOnlyWithRpcAddresses(configOnInitNode.getNodesList()), this.getNodesListOnlyWithRpcAddresses(this.getClusterConfig().getNodes()));
                if (errors.isEmpty()) {
                    this.deleteCluster(false, false);
                    responseObserver.onNext((Object)this.buildSuccessfulConfigResponse(DELETED_ON_NODE_MESSAGE));
                } else {
                    responseObserver.onNext((Object)this.buildFailureConfigResponse(errors.toString()));
                }
            }
        }
        catch (Exception e) {
            logger.error("Cluster config cannot be deleted due to: {}", (Object)e.getMessage());
            responseObserver.onNext((Object)this.buildFailureConfigResponse(e.getMessage()));
        }
        responseObserver.onCompleted();
    }

    @NotNull
    private ConfigResponse buildSuccessfulConfigResponse(String successMessage) {
        return ConfigResponse.newBuilder().setSuccess(true).setMessage(successMessage).build();
    }

    @NotNull
    private ConfigResponse buildFailureConfigResponse(String failureMessage) {
        return ConfigResponse.newBuilder().setSuccess(false).setMessage(failureMessage).build();
    }

    @NotNull
    private ReplicateSnapshotResponse buildFailureReplicateSnapshotResponse(String peerAddress, String failureMessage) {
        HashMap<String, String> messages = new HashMap<String, String>();
        messages.put(peerAddress, failureMessage);
        return ReplicateSnapshotResponse.newBuilder().putAllMessages(messages).build();
    }

    @NotNull
    private List<String> getNodesListOnlyWithRpcAddresses(List<NodeInfo> nodesList) {
        return nodesList.stream().map(NodeInfo::getRpcAddress).collect(Collectors.toList());
    }

    public void getNodeInfo(NodeInfoRequest request, StreamObserver<NodeInfo> responseObserver) {
        logger.debug("Requested the node info of node {}", (Object)this.getCurrentRPCAddress());
        if (!this.serverInitialized) {
            logger.error("Location not initialized, yet!");
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withDescription("Not initialized, yet!")));
            return;
        }
        responseObserver.onNext((Object)NodeInfo.newBuilder().setRpcAddress(this.getCurrentRPCAddress()).setHttpAddress(Config.getExternalUrl(null)).build());
        responseObserver.onCompleted();
    }

    public void getNodeState(AvailabilityRequest request, StreamObserver<RemoteNodeState> responseObserver) {
        logger.debug("Requested the state of node {} to it's peers {}", (Object)this.getCurrentRPCAddress(), (Object)request.getPeerAddressList());
        if (!this.serverInitialized) {
            logger.error("Location not initialized, yet!");
            responseObserver.onError((Throwable)new StatusRuntimeException(Status.UNAVAILABLE.withDescription("Not initialized, yet!")));
            return;
        }
        responseObserver.onNext((Object)this.getNodeStateInternal((List<String>)request.getPeerAddressList()));
        responseObserver.onCompleted();
    }

    @NotNull
    private RemoteNodeState getNodeStateInternal(List<String> peerAddresses) {
        RemoteNodeState.Builder nodeState = this.getBasicNodeInfo();
        if (!peerAddresses.isEmpty()) {
            LinkedList<String> peerAddressList = new LinkedList<String>(peerAddresses);
            String currentRPCAddress = this.getCurrentRPCAddress();
            List<String> peersToCheck = peerAddressList.remove(currentRPCAddress) ? Collections.singletonList(currentRPCAddress) : Collections.emptyList();
            if (!peerAddressList.isEmpty()) {
                nodeState.addAllPeerAvailability(this.checkPeerConnectivity(peerAddressList, peersToCheck));
            }
        }
        return nodeState.build();
    }

    @NotNull
    protected synchronized RemoteNodeState.Builder getBasicNodeInfo() {
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocationOrThrow();
        RemoteNodeState.Builder nodeState = RemoteNodeState.newBuilder();
        GraphDBReplicationCluster replicationCluster = semanticLocation.getReplicationCluster();
        if (replicationCluster != null) {
            String checksum = this.getClusterConfigService().fetchClusterConfig().getInitialStateChecksum();
            nodeState.setAlreadyInCluster(true).setNodeStatus(replicationCluster.getNodeStatus()).setClusterId(checksum);
        } else {
            LicenseRegistry licenseRegistry = LicenseRegistry.getInstance();
            nodeState.setAlreadyInCluster(false).setNodeStatus(StatusResponse.newBuilder().setEndpoint(Config.getExternalUrl(null)).setStatus(licenseRegistry.hasCapability(License.Capability.CLUSTER) ? StatusResponse.Status.NO_CLUSTER : StatusResponse.Status.RESTRICTED).build());
        }
        nodeState.setIsSecured(Config.getPropertyAsBoolean((String)"security.enabled", (boolean)false));
        semanticLocation.iterateRepositories((id, sail) -> {
            GraphDBReplicationCluster cluster = semanticLocation.getReplicationCluster();
            RepositoryInfo.Builder info = RepositoryInfo.newBuilder().setRepository(id);
            if (sail != null && !sail.isShuttingDown() && !sail.isShutDown()) {
                info.setFingerprint(sail.getFingerprint());
                MessageDigest digest = ClusterService.getHashedRepoInfo(sail.getNamespaceMappings().toString());
                info.setMetadata(HexUtils.toHexString((byte[])digest.digest()));
                if (cluster != null) {
                    try {
                        cluster.getClusterGroup().getTransactionLog().verifyLastChannelEntries(logEntry -> {
                            if (logEntry.getRepository().equals(id)) {
                                info.setLogIndex(logEntry.getIndex());
                            }
                        });
                    }
                    catch (Exception e) {
                        logger.error("Error occured: {}", (Throwable)e);
                    }
                }
            }
            if (cluster != null) {
                info.setChannel(cluster.getClusterGroup().getTransactionLog().getChannelId(id));
            }
            nodeState.addRepositories(info);
        });
        return nodeState;
    }

    @NotNull
    private static MessageDigest getHashedRepoInfo(String info) {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IllegalStateException(e);
        }
        digest.update(info.getBytes(StandardCharsets.UTF_8));
        return digest;
    }

    public List<RemoteNodeState.PeerAvailabilityReport> checkPeerConnectivity(List<String> nodesToCall, List<String> peersToCheck) {
        return this.requestPeerStatus(nodesToCall, peersToCheck, this::getPeerAvailabilityReports);
    }

    @Nullable
    private <E> E requestPeerStatus(List<String> newNodes, List<String> peersToCheck, Function<Map<String, ListenableFuture<RemoteNodeState>>, E> resultTransformer) {
        return (E)this.rpcMulticastService.callPeersBlocking(newNodes, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadline(Deadline.after((long)CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS))).getNodeState(AvailabilityRequest.newBuilder().addAllPeerAddress((Iterable)peersToCheck).build()), resultTransformer);
    }

    @NotNull
    private List<RemoteNodeState.PeerAvailabilityReport> getPeerAvailabilityReports(Map<String, ListenableFuture<RemoteNodeState>> futures) {
        String currentRPCAddress = this.getCurrentRPCAddress();
        LinkedList<RemoteNodeState.PeerAvailabilityReport> availabilityReports = new LinkedList<RemoteNodeState.PeerAvailabilityReport>();
        futures.forEach((peerAddress, future) -> {
            RemoteNodeState.PeerAvailabilityReport.Builder builder = RemoteNodeState.PeerAvailabilityReport.newBuilder().setStartAddress(currentRPCAddress).setPeerAddress(peerAddress);
            try {
                RemoteNodeState state = (RemoteNodeState)Futures.getDone((Future)future);
                builder.setAccessible(true);
                if (state != null && state.getPeerAvailabilityCount() > 0) {
                    state.getPeerAvailabilityList().stream().map(RemoteNodeState.PeerAvailabilityReport::newBuilder).map(RemoteNodeState.PeerAvailabilityReport.Builder::build).forEach(availabilityReports::add);
                }
            }
            catch (ExecutionException ee) {
                builder.setAccessible(false);
                builder.addMessages(this.notAccessible((String)peerAddress, ee.getCause()));
            }
            availabilityReports.add(builder.build());
        });
        return availabilityReports;
    }

    public List<NodeInfo> getNodeInfos(List<String> newNodes) throws ClusterStateException {
        HashSet errorMappings = new HashSet();
        LinkedList<NodeInfo> nodeInfos = new LinkedList<NodeInfo>();
        this.requestNodesInfo(newNodes, futures -> {
            futures.forEach((peerAddress, future) -> {
                try {
                    nodeInfos.add((NodeInfo)Futures.getDone((Future)future));
                }
                catch (ExecutionException ee) {
                    logger.warn("Failed to get the node info from {}", peerAddress, (Object)ee);
                    errorMappings.add(peerAddress);
                }
            });
            return null;
        });
        if (errorMappings.isEmpty()) {
            return nodeInfos;
        }
        throw new ClusterStateException(errorMappings.stream().collect(Collectors.toMap(Function.identity(), address -> NO_CONNECTION_MESSAGE)));
    }

    @Nullable
    private <E> E requestNodesInfo(List<String> newNodes, Function<Map<String, ListenableFuture<NodeInfo>>, E> resultTransformer) {
        return (E)this.rpcMulticastService.callPeersBlocking(newNodes, stub -> ((ConfigServiceGrpc.ConfigServiceFutureStub)stub.withDeadline(Deadline.after((long)CREATE_CLUSTER_SYNC_TIMEOUT_SECONDS, (TimeUnit)TimeUnit.SECONDS))).getNodeInfo(NodeInfoRequest.newBuilder().build()), resultTransformer);
    }

    public Map<String, RemoteNodeState> getNodesState(List<String> nodesList) throws ClusterStateException {
        LinkedList<String> otherNodes = new LinkedList<String>(nodesList);
        otherNodes.remove(this.getCurrentRPCAddress());
        HashSet errorMappings = new HashSet();
        HashMap<String, RemoteNodeState> stateMapping = new HashMap<String, RemoteNodeState>();
        this.requestPeerStatus(nodesList, otherNodes, futures -> {
            futures.forEach((peerAddress, future) -> {
                try {
                    stateMapping.put((String)peerAddress, (RemoteNodeState)Futures.getDone((Future)future));
                }
                catch (ExecutionException ee) {
                    logger.warn("Failed to get the node state from {}", peerAddress, (Object)ee);
                    errorMappings.add(peerAddress);
                }
            });
            return null;
        });
        if (errorMappings.isEmpty()) {
            return stateMapping;
        }
        throw new ClusterStateException(errorMappings.stream().collect(Collectors.toMap(Function.identity(), address -> NO_CONNECTION_MESSAGE)));
    }

    private String notAccessible(String clientAddress, Throwable re) {
        String message = String.format("The %s is not accessible from %s. Failed with: %s", clientAddress, this.getCurrentRPCAddress(), re.getMessage());
        if (logger.isDebugEnabled()) {
            logger.debug(message, re);
        } else {
            logger.warn(message);
        }
        return message;
    }

    public ClusterConfigService getClusterConfigService() {
        return this.semanticDataManagement.getCurrentLocationOrThrow().getClusterConfigService();
    }

    public void onApplicationEvent(PropertyChangedEvent event) {
        if ("semantic.locations.initialized".equals(event.getKey())) {
            this.serverInitialized = true;
            if (!this.observers.isEmpty()) {
                this.attachObserversToClusterIfEnabled(this.observers);
            }
        }
    }

    public void addClusterObserver(RaftObserver observer) {
        this.observers.add(observer);
        if (this.serverInitialized) {
            this.attachObserversToClusterIfEnabled(List.of(observer));
        }
    }

    public Set<RaftObserver> getClusterObservers() {
        return Collections.unmodifiableSet(this.observers);
    }

    private void attachObserversToClusterIfEnabled(Collection<RaftObserver> raftObservers) {
        GraphDBReplicationCluster replicationCluster;
        SemanticLocation semanticLocation = this.semanticDataManagement.getCurrentLocation();
        if (semanticLocation != null && (replicationCluster = semanticLocation.getReplicationCluster()) != null) {
            raftObservers.forEach(arg_0 -> ((GraphDBReplicationCluster)replicationCluster).addClusterObserver(arg_0));
        }
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map beansOfType = applicationContext.getBeansOfType(RaftObserver.class);
        logger.debug("Registering raft observers: {}", beansOfType.keySet());
        beansOfType.values().forEach(this::addClusterObserver);
    }

    private boolean isAuthenticatedFully() {
        return GraphDBHTTPContext.getAuthenticatedUser().hasRole("ROLE_USER");
    }

    private void checkIfApplyingBackup(Map<String, String> messages, String operationName) throws ClusterStateException {
        RecoveryService.RecoveryStatus recoveryStatus = this.getRecoveryService().getRecoveryOperationInProgress();
        if (recoveryStatus != null) {
            messages.put(this.getCurrentRPCAddress(), String.format(recoveryStatus.getErrorMsg(), operationName));
            throw new ClusterStateException(messages);
        }
    }

    private void checkIfNodeIsInClusterOrThrow(@Nullable GraphDBReplicationCluster replicationCluster, Map<String, String> messages) throws ClusterStateException {
        if (replicationCluster == null) {
            messages.put(this.getCurrentRPCAddress(), NO_CLUSTER_MESSAGE);
            throw new ClusterStateException(messages);
        }
    }

    private void verifyCurrentNodeTxLogIsNotLockedOrThrow(@Nullable GraphDBReplicationCluster replicationCluster, Map<String, String> messages) throws ClusterStateException {
        boolean isLocked;
        boolean bl = isLocked = replicationCluster != null && replicationCluster.getClusterGroup().getTransactionLog().isLocked();
        if (isLocked) {
            messages.put(this.getCurrentRPCAddress(), CAN_NOT_DELETE_CLUSTER_MESSAGE);
            throw new ClusterStateException(messages);
        }
    }

    public RecoveryService getRecoveryService() {
        return this.recoveryService;
    }

    private String getLeaderAddress(Map<String, StatusResponse> groupStatus) {
        for (Map.Entry<String, StatusResponse> entry : groupStatus.entrySet()) {
            if (entry.getValue().getStatus() != StatusResponse.Status.LEADER) continue;
            return entry.getKey();
        }
        return null;
    }

    @NotNull
    private List<String> excludeLeaderAddress(Map<String, StatusResponse> groupStatus, @Nullable String leaderAddress) {
        return groupStatus.keySet().stream().filter(address -> !address.equals(leaderAddress)).collect(Collectors.toList());
    }

    public ClusterConfig generateNewConfigByReplacingNodes(List<String> newNodes, List<String> removeNodes, ClusterConfig currentConfig) throws ClusterStateException {
        ClusterConfig newConfig = currentConfig.copy();
        ArrayList<NodeInfo> nodesInNewGroup = new ArrayList<NodeInfo>();
        nodesInNewGroup.addAll(this.getNodeInfos(newNodes));
        newConfig.getNodes().stream().filter(nodeInfo -> !removeNodes.contains(nodeInfo.getRpcAddress())).forEach(nodesInNewGroup::add);
        newConfig.setNodes(nodesInNewGroup);
        return newConfig;
    }

    public List<String> getOldNodesAddressesOnReplace(List<String> addNodes, List<String> removeNodes) {
        ArrayList<String> nodesToAdd = new ArrayList<String>();
        block0: for (String addNode : addNodes) {
            for (String removeNode : removeNodes) {
                if (!addNode.equals(removeNode)) continue;
                nodesToAdd.add(removeNode);
                continue block0;
            }
        }
        if (!nodesToAdd.isEmpty()) {
            return nodesToAdd;
        }
        return removeNodes.stream().filter(node -> !addNodes.contains(node)).collect(Collectors.toList());
    }

    protected void managePluginOperations(boolean waitUninterruptibleWithTimeout) {
        RepositoryManager currentLocation = this.semanticDataManagement.getCurrentLocationOrThrow().sesameManager();
        if (!(currentLocation instanceof GraphDBRepositoryManager)) {
            throw new IllegalStateException("Current location is not a GraphDBRepositoryManager.");
        }
        GraphDBRepositoryManager graphDbManager = (GraphDBRepositoryManager)currentLocation;
        for (String repositoryId : graphDbManager.getRepositoryIDs()) {
            Repository repository = graphDbManager.getRepository(repositoryId);
            if (!(repository instanceof MonitorRepository)) continue;
            MonitorRepository monitorRepository = (MonitorRepository)repository;
            OwlimSchemaRepository owlimSchemaRepository = monitorRepository.getOwlimSail();
            PluginManager pluginManager = owlimSchemaRepository.getPluginManager();
            if (waitUninterruptibleWithTimeout) {
                pluginManager.waitPluginsUninterruptibleWithTimeout(owlimSchemaRepository.getOwlimConnection());
                continue;
            }
            pluginManager.waitForPluginsInitialization();
        }
    }

    private boolean areAllRepoInitialized() {
        int totalRepoCount;
        RepositoryManager repositoryManager = this.semanticDataManagement.getCurrentLocationOrThrow().sesameManager();
        int initializedRepoCount = repositoryManager.getInitializedRepositories().size();
        return initializedRepoCount == (totalRepoCount = repositoryManager.getAllRepositoryInfos().size());
    }

    private boolean isAddressSame(List<String> newNodes, List<String> oldNodes, List<String> nodesToSkip) {
        boolean sameNodes = false;
        for (String node : newNodes) {
            if (!oldNodes.contains(node)) continue;
            sameNodes = true;
            nodesToSkip.add(node);
        }
        return sameNodes;
    }

    public void startClusterCreation(SemanticLocation semanticLocation) {
        RepositoryManager locationManager = semanticLocation.sesameManager();
        if (locationManager instanceof GraphDBRepositoryManager) {
            GraphDBRepositoryManager manager = (GraphDBRepositoryManager)locationManager;
            manager.startClusterCreation();
            this.managePluginOperations(false);
            semanticLocation.notifyReposOfClusterCreation(true);
        }
    }

    public void endClusterCreation(SemanticLocation semanticLocation) {
        RepositoryManager locationManager = semanticLocation.sesameManager();
        if (locationManager instanceof GraphDBRepositoryManager) {
            GraphDBRepositoryManager manager = (GraphDBRepositoryManager)locationManager;
            manager.completeClusterCreation();
            semanticLocation.notifyReposOfClusterCreation(false);
        }
    }

    protected String formatNodeInfoList(List<NodeInfo> nodeList, List<String> nodesToSkip) {
        StringJoiner joiner = new StringJoiner(", ", "[", "]");
        for (NodeInfo node : nodeList) {
            String nodeInfo = String.format("rpcAddress: \"%s\"", node.getRpcAddress());
            joiner.add(nodeInfo);
        }
        if (!nodesToSkip.isEmpty()) {
            for (String nodeToSkip : nodesToSkip) {
                joiner.add(String.format("rpcAddress: \"%s\"", nodeToSkip));
            }
        }
        return joiner.toString();
    }

    public void setApplicationEventPublisher(ApplicationEventPublisher applicationEventPublisher) {
        this.publisher = applicationEventPublisher;
    }

    private void notifyClusterCreated() {
        if (this.publisher == null) {
            return;
        }
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, "cluster.created", "true"));
    }

    private void notifyClusterDeleted() {
        if (this.publisher == null) {
            return;
        }
        this.publisher.publishEvent((ApplicationEvent)new PropertyChangedEvent((Object)this, "cluster.deleted", "true"));
    }

    public static enum ClusterState {
        UNKNOWN,
        ENABLED,
        DISABLED;

    }
}

