/*
 * Decompiled with CFR 0.152.
 */
package com.ontotext.forest.accountmanagement;

import com.ontotext.forest.core.util.PropertyChangedEvent;
import com.ontotext.forest.security.SecurityConfig;
import com.ontotext.raft.update.SystemUpdate;
import com.ontotext.raft.update.SystemUpdateProcessor;
import java.nio.charset.StandardCharsets;

public class PropertyChangeUpdate
implements SystemUpdate {
    private final PropertyChangedEvent event;
    private final SecurityConfig securityConfig;

    public PropertyChangeUpdate(PropertyChangedEvent event, SecurityConfig securityConfig) {
        this.event = event;
        this.securityConfig = securityConfig;
    }

    public byte[] getBytes() {
        byte[][] components = new byte[3][];
        components[0] = this.getFingerprint().getBytes(StandardCharsets.UTF_8);
        components[1] = this.event.getKey().getBytes(StandardCharsets.UTF_8);
        switch (this.event.getKey()) {
            case "security.enabled.replicated": 
            case "security.free.access.replicated": {
                components[2] = this.serializeObject(Boolean.parseBoolean(this.event.getValue()));
                break;
            }
            case "security.free.access.authorities.replicated": {
                components[2] = this.serializeObject(this.securityConfig.getFreeAccessAuthorities());
                break;
            }
            case "security.free.access.settings.replicated": {
                components[2] = this.serializeObject(this.securityConfig.getFreeAccessSettings());
                break;
            }
            case "security.default.auth.settings.replicated": {
                components[2] = this.serializeObject(this.securityConfig.getOverrideAuthSettings());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected value: " + this.event.getKey());
            }
        }
        return this.serializeComponents(components);
    }

    public String getFingerprint() {
        return "prop";
    }

    public SystemUpdateProcessor.Type getType() {
        return SystemUpdateProcessor.Type.PROP_CHANGE;
    }
}

